/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.explorer.editors.cell;

import com.agentpp.mib.ObjectID;
import com.agentpp.snmp.types.ComparableIpAddress;
import com.klg.jclass.cell.editors.JCStringCellEditor;
import com.klg.jclass.cell.validate.JCValidateEvent;
import com.klg.jclass.cell.validate.JCValidateListener;
import java.net.InetAddress;

public class IpAddressCellEditor
extends JCStringCellEditor
implements JCValidateListener {
    public IpAddressCellEditor() {
        this.addValidateListener(this);
    }

    public Object getCellEditorValue() {
        String string = super.getCellEditorValue().toString();
        ComparableIpAddress comparableIpAddress = new ComparableIpAddress(string);
        if (!comparableIpAddress.isValid()) {
            try {
                InetAddress inetAddress = InetAddress.getByName(string);
                return new ComparableIpAddress(inetAddress.getHostAddress());
            }
            catch (Exception exception) {
                return new ComparableIpAddress("0.0.0.0");
            }
        }
        return comparableIpAddress;
    }

    public void stateIsInvalid(JCValidateEvent jCValidateEvent) {
    }

    public void valueChangedEnd(JCValidateEvent jCValidateEvent) {
    }

    public void valueChangedBegin(JCValidateEvent jCValidateEvent) {
        String string = jCValidateEvent.getValue().toString();
        ObjectID objectID = new ObjectID(string);
        if (objectID.isValid() && objectID.size() != 4) {
            jCValidateEvent.setBeep(true);
            jCValidateEvent.setValid(false);
        } else {
            try {
                InetAddress inetAddress = InetAddress.getByName(string);
                jCValidateEvent.setValue(inetAddress.getHostAddress());
            }
            catch (Exception exception) {
                jCValidateEvent.setBeep(true);
                jCValidateEvent.setValid(false);
            }
        }
    }
}

