/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.explorer.editors;

import com.agentpp.mib.MIBObject;
import java.util.StringTokenizer;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.UnsignedInteger32;

public class DisplayHint {
    String displayHint;

    public DisplayHint(String string) {
        this.displayHint = MIBObject.getUnquotedString(string);
    }

    public String formatValue(Object object) {
        if (object instanceof OctetString) {
            return this.formatString((OctetString)object);
        }
        if (object instanceof Integer32) {
            return this.formatLong(((Integer32)object).getValue());
        }
        if (object instanceof UnsignedInteger32) {
            return this.formatLong(((UnsignedInteger32)object).getValue());
        }
        return null;
    }

    public String formatLong(long l2) {
        String string = null;
        if (this.displayHint == null || this.displayHint.length() < 1) {
            return "" + l2;
        }
        char c2 = this.displayHint.charAt(0);
        switch (c2) {
            case 'd': {
                StringTokenizer stringTokenizer;
                int n2 = -1;
                if (this.displayHint.length() > 1 && (stringTokenizer = new StringTokenizer(this.displayHint, "-")).hasMoreTokens()) {
                    stringTokenizer.nextToken();
                    if (stringTokenizer.hasMoreTokens()) {
                        n2 = Integer.parseInt(stringTokenizer.nextToken());
                    }
                }
                string = "" + l2;
                if (n2 <= 0) break;
                int n3 = string.length() - n2;
                if (n3 <= 0) {
                    string = "." + string;
                    break;
                }
                string = string.substring(0, n3) + "." + string.substring(n3);
                break;
            }
            case 'b': {
                string = Long.toBinaryString(l2);
                break;
            }
            case 'o': {
                string = Long.toOctalString(l2);
                break;
            }
            case 'x': {
                string = Long.toHexString(l2);
            }
        }
        return string;
    }

    public String formatString(OctetString octetString) {
        if (this.displayHint == null) {
            return octetString.toString();
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        int n3 = 0;
        block6: while (n3 < octetString.length() && n2 < this.displayHint.length()) {
            int n4;
            int n5 = 1;
            Character c2 = null;
            Character c3 = null;
            if (this.displayHint.charAt(n2) == '*') {
                n5 = 0xFF & octetString.get(n3++);
            }
            for (n4 = ++n2; n4 < this.displayHint.length() && Character.isDigit(this.displayHint.charAt(n4)); ++n4) {
            }
            if (n4 == n2) {
                return octetString.toString();
            }
            String string = null;
            if (n4 >= this.displayHint.length()) {
                return octetString.toString();
            }
            string = this.displayHint.substring(n2, n4);
            int n6 = Integer.parseInt(string);
            n2 = n4;
            char c4 = this.displayHint.charAt(n2++);
            if (n2 < this.displayHint.length() && !Character.isDigit(this.displayHint.charAt(n2)) && this.displayHint.charAt(n2) != '*') {
                c2 = new Character(this.displayHint.charAt(n2));
                if (++n2 < this.displayHint.length() && !Character.isDigit(this.displayHint.charAt(n2)) && this.displayHint.charAt(n2) != '*') {
                    c3 = new Character(this.displayHint.charAt(n2));
                    ++n2;
                }
            }
            for (int i2 = 0; i2 < n5; ++i2) {
                if (n3 + n6 >= octetString.length()) {
                    n6 = octetString.length() - n3;
                }
                if (n6 > 0) {
                    if (n3 >= octetString.length()) continue block6;
                    byte[] byArray = new byte[n6];
                    System.arraycopy(octetString.getValue(), n3, byArray, 0, n6);
                    n3 += n6;
                    if (c4 == 'a') {
                        stringBuffer.append(byArray);
                    } else {
                        long l2 = 0L;
                        int n7 = byArray.length;
                        for (int i3 = 0; i3 < n7; ++i3) {
                            l2 = l2 * 256L + (long)(byArray[i3] & 0xFF);
                        }
                        switch (c4) {
                            case 'd': {
                                stringBuffer.append(Long.toString(l2));
                                break;
                            }
                            case 'b': {
                                stringBuffer.append(Long.toBinaryString(l2));
                                break;
                            }
                            case 'o': {
                                stringBuffer.append(Long.toOctalString(l2));
                                break;
                            }
                            case 'x': {
                                stringBuffer.append(Long.toHexString(l2));
                            }
                        }
                    }
                }
                if (c2 != null && n3 < octetString.length()) {
                    stringBuffer.append(c2);
                }
                if (i2 + 1 < n5) {
                    stringBuffer.append(c3);
                }
                if (n2 < this.displayHint.length()) continue;
                n2 = 0;
            }
        }
        return stringBuffer.toString();
    }

    public OctetString scanString(String string) {
        if (this.displayHint == null) {
            return new OctetString(string);
        }
        int n2 = 0;
        boolean bl = false;
        int n3 = 0;
        int n4 = 0;
        boolean bl2 = false;
        int n5 = 0;
        int n6 = 0;
        if (string == null || this.displayHint == null) {
            return null;
        }
        OctetString octetString = new OctetString();
        while (n3 < this.displayHint.length() && n2 < string.length()) {
            int n7;
            n4 = n3;
            bl2 = false;
            n5 = 0;
            while (n3 < this.displayHint.length() && Character.isDigit(this.displayHint.charAt(n3))) {
                n5 = n5 * 10 + this.displayHint.charAt(n3) - 48;
                bl2 = true;
                ++n3;
            }
            if (!bl2) {
                n5 = 1;
            }
            bl = false;
            switch (this.displayHint.charAt(n3)) {
                case 'a': {
                    if (n5 < string.length() - n2) {
                        octetString.append(string.substring(n2, n2 + n5));
                        n2 += n5;
                        break;
                    }
                    octetString.append(string.substring(n2));
                    n2 = string.length();
                    break;
                }
                case 'b': {
                    n6 = 0;
                    while (string.charAt(n2) == '0' || string.charAt(n2) == '1') {
                        bl = true;
                        n6 = n6 << 1 | string.charAt(n2) - 48;
                        ++n2;
                    }
                    break;
                }
                case 'd': {
                    n7 = n2;
                    while (n2 < string.length() && Character.isDigit(string.charAt(n2))) {
                        ++n2;
                    }
                    try {
                        n6 = Integer.parseInt(string.substring(n7, n2), 10);
                        bl = true;
                    }
                    catch (NumberFormatException numberFormatException) {
                        bl = false;
                    }
                    break;
                }
                case 'o': {
                    n7 = n2;
                    while (n2 < string.length() && string.charAt(n2) >= '0' && string.charAt(n2) <= '7') {
                        ++n2;
                    }
                    try {
                        n6 = Integer.parseInt(string.substring(n7, n2), 8);
                        bl = true;
                    }
                    catch (NumberFormatException numberFormatException) {
                        bl = false;
                    }
                    break;
                }
                case 'x': {
                    n7 = n2;
                    while (n2 < string.length() && (string.charAt(n2) >= '0' && string.charAt(n2) <= '9' || string.charAt(n2) >= 'A' && string.charAt(n2) <= 'F' || string.charAt(n2) >= 'a' && string.charAt(n2) <= 'f')) {
                        ++n2;
                    }
                    try {
                        n6 = Integer.parseInt(string.substring(n7, n2), 8);
                        bl = true;
                    }
                    catch (NumberFormatException numberFormatException) {
                        bl = false;
                    }
                    break;
                }
                default: {
                    return null;
                }
            }
            ++n3;
            if (bl) {
                while (n5 > 0) {
                    n7 = (byte)(n6 >> (n5 - 1) * 8 & 0xFF);
                    octetString.append((byte)n7);
                    --n5;
                }
            }
            if (n3 < this.displayHint.length() && this.displayHint.charAt(n3) != '*') {
                if (!Character.isDigit(this.displayHint.charAt(n3))) {
                    ++n3;
                }
                if (n2 < string.length() && !Character.isDigit(string.charAt(n2))) {
                    ++n2;
                }
            }
            if (n3 < this.displayHint.length() || n2 >= string.length()) continue;
            n3 = n4;
        }
        return octetString;
    }

    public static Long scanLong(String string, String string2) {
        if (string == null) {
            try {
                return new Long(string2);
            }
            catch (Exception exception) {
                return new Long(0L);
            }
        }
        Long l2 = null;
        long l3 = 0L;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        if ((string = MIBObject.getUnquotedString(string)) == null || string.length() < 1 || string2 == null || string2.length() < 1) {
            return null;
        }
        switch (string.charAt(0)) {
            case 'd': {
                if (string.length() < 2) {
                    return null;
                }
                if (string.charAt(1) != '-') break;
                if (Character.isDigit(string.charAt(2))) {
                    n3 = 0;
                    n4 = 0;
                    while (n4 + 2 < string.length() && Character.isDigit(string.charAt(2 + n4))) {
                        n3 = n3 * 10 + (string.charAt(2 + n4) - 48);
                        ++n4;
                    }
                }
                if (2 + n4 < string.length()) break;
                if (string2.charAt(0) == '-') {
                    bl = true;
                    ++n2;
                }
                int n5 = -1;
                l3 = 0L;
                while (n2 < string2.length() && (Character.isDigit(string2.charAt(n2)) || string2.charAt(n2) == '.')) {
                    if (string2.charAt(n2) == '.') {
                        if (n5 >= 0) break;
                        n5 = 0;
                    } else {
                        l3 = l3 * 10L + (long)(string2.charAt(n2) - 48);
                        if (n5 >= 0) {
                            ++n5;
                        }
                    }
                    ++n2;
                }
                if (n2 < string2.length()) break;
                while (n5 < n3) {
                    l3 *= 10L;
                    ++n5;
                }
                while (n5 > n3) {
                    l3 /= 10L;
                    --n5;
                }
                l2 = new Long(bl ? -1L * l3 : l3);
                break;
            }
            case 'x': {
                if (string.length() > 1) break;
                try {
                    l2 = new Long(Long.parseLong(string2, 16));
                }
                catch (NumberFormatException numberFormatException) {}
                break;
            }
            case 'o': {
                if (string.length() > 1) break;
                try {
                    l2 = new Long(Long.parseLong(string2, 8));
                }
                catch (NumberFormatException numberFormatException) {}
                break;
            }
            case 'b': {
                if (string.length() > 1) break;
                try {
                    l2 = new Long(Long.parseLong(string2, 2));
                }
                catch (NumberFormatException numberFormatException) {}
                break;
            }
        }
        return l2;
    }
}

