/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.explorer.cfg;

import com.agentpp.common.PreferencesItem;
import com.agentpp.util.UserConfigFile;
import com.klg.jclass.field.DataProperties;
import com.klg.jclass.field.JCInvalidInfo;
import com.klg.jclass.field.JCSpinField;
import com.klg.jclass.field.validate.JCIntegerValidator;
import com.klg.jclass.util.value.MutableValueModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ViewSettings
extends JPanel
implements PreferencesItem {
    public static final String[][] OS_DISPLAY_FORMATS = new String[][]{{"ASCII", "255a"}, {"Decimal", "1d."}, {"Hexadecimal", "1x:"}, {"Octal", "1o:"}, {"Binary", "1b:"}, {"MIB", null}};
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JLabel jLabelFontSize = new JLabel();
    JCSpinField fontSize = new JCSpinField();
    JCheckBox splitOrientation = new JCheckBox();
    JCheckBox resolveOIDs = new JCheckBox();
    JCheckBox browseWithRefresh = new JCheckBox();
    JCheckBox coloredSMIPreview = new JCheckBox();
    JCheckBox mibEditorSyntaxHighlighting = new JCheckBox();
    JLabel jLabelDefaultVBDisplayMode = new JLabel();
    JComboBox defaultOSDisplayMode = new JComboBox();
    JCheckBox autoColumnWidthSave = new JCheckBox();
    JCheckBox enableTableCellDeltaDisplay = new JCheckBox();

    public ViewSettings() {
        this._$37313();
        try {
            this._$5265();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.fontSize.setDataProperties(new DataProperties(new JCIntegerValidator(null, new Integer(1), new Integer(4), null, true, null, new Integer(1), "#,##0.###;-#,##0.###", false, false, false, null, new Integer(2)), new MutableValueModel(Integer.class, null), new JCInvalidInfo(true, 1, new Color(0, 0, 0, 255), new Color(255, 255, 255, 255))));
    }

    private void _$37313() {
        for (int i2 = 0; i2 < OS_DISPLAY_FORMATS.length; ++i2) {
            this.defaultOSDisplayMode.addItem(OS_DISPLAY_FORMATS[i2][0]);
        }
    }

    public static String getDisplayFormat(UserConfigFile userConfigFile) {
        return ViewSettings.getDisplayFormat(userConfigFile.get("mibexplorer.vb.display.mode", "MIB"));
    }

    public static String getDisplayFormat(String string) {
        for (int i2 = 0; i2 < OS_DISPLAY_FORMATS.length; ++i2) {
            if (!string.equals(OS_DISPLAY_FORMATS[i2][0])) continue;
            return OS_DISPLAY_FORMATS[i2][1];
        }
        return null;
    }

    private void _$5265() throws Exception {
        this.setLayout(this.gridBagLayout1);
        this.jLabelFontSize.setText("SMI Definition Font Size:");
        this.splitOrientation.setText("Split MIB tree and Tools pane horizontally");
        this.resolveOIDs.setText("Resolve OIDs to object names when feasible");
        this.browseWithRefresh.setText("Update Browse pane while retrieving instances (slow)");
        this.coloredSMIPreview.setText("Enable syntax highlighting for SMI Definition pane");
        this.mibEditorSyntaxHighlighting.setText("Enable syntax highlighting for MIB editor");
        this.jLabelDefaultVBDisplayMode.setText("Default OCTET-STRING Display Mode:");
        this.autoColumnWidthSave.setText("Enable auto-save (restore) of column width changes in Table view");
        this.enableTableCellDeltaDisplay.setText("Enable cell delta highlighting in Table view by default");
        this.add((Component)this.resolveOIDs, new GridBagConstraints(0, 5, 2, 1, 1.0, 0.0, 10, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.browseWithRefresh, new GridBagConstraints(0, 6, 2, 1, 1.0, 0.0, 10, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.enableTableCellDeltaDisplay, new GridBagConstraints(0, 7, 2, 1, 1.0, 0.0, 10, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.mibEditorSyntaxHighlighting, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 10, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.splitOrientation, new GridBagConstraints(0, 4, 2, 1, 1.0, 0.0, 10, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.coloredSMIPreview, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 10, 2, new Insets(20, 10, 10, 10), 0, 0));
        this.add((Component)this.jLabelDefaultVBDisplayMode, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.fontSize, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.1, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.jLabelFontSize, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.defaultOSDisplayMode, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 10, 10, 10), 0, 0));
        this.add((Component)this.autoColumnWidthSave, new GridBagConstraints(0, 8, 2, 1, 1.0, 1.0, 11, 2, new Insets(0, 10, 0, 10), 0, 0));
    }

    public JPanel getPanel() {
        return this;
    }

    public String getShortTitle() {
        return "View";
    }

    public String getTitle() {
        return "View Settings";
    }

    public String getDescription() {
        return "";
    }

    public String getTooltip() {
        return "";
    }

    public void saveProperties(UserConfigFile userConfigFile) {
        userConfigFile.putInteger("mibexplorer.NodeViewFontSize", ((Number)this.fontSize.getValue()).intValue());
        userConfigFile.putBoolean("mibexplorer.RefreshMode", this.browseWithRefresh.isSelected());
        userConfigFile.putBoolean("mibexplorer.VerticalSplit", this.splitOrientation.isSelected());
        userConfigFile.putBoolean("mibexplorer.ResolveOIDs", this.resolveOIDs.isSelected());
        userConfigFile.putBoolean("mibexplorer.ColoredSMI", this.coloredSMIPreview.isSelected());
        userConfigFile.putBoolean("agentpp.smi.editor.SyntaxHighlighting", this.mibEditorSyntaxHighlighting.isSelected());
        userConfigFile.put("mibexplorer.vb.display.mode", (String)this.defaultOSDisplayMode.getSelectedItem());
        userConfigFile.putBoolean("mibexplorer.table.colWidth.autosave", this.autoColumnWidthSave.isSelected());
        userConfigFile.putBoolean("mibexplorer.table.cellDeltaHighlighting", this.enableTableCellDeltaDisplay.isSelected());
    }

    public boolean isOK() {
        return true;
    }

    public void loadProperties(UserConfigFile userConfigFile) {
        this.fontSize.setValue(new Integer(userConfigFile.getInteger("mibexplorer.NodeViewFontSize", 2)));
        this.browseWithRefresh.setSelected(userConfigFile.getBoolean("mibexplorer.RefreshMode", false));
        this.splitOrientation.setSelected(userConfigFile.getBoolean("mibexplorer.VerticalSplit", true));
        this.resolveOIDs.setSelected(userConfigFile.getBoolean("mibexplorer.ResolveOIDs", true));
        this.coloredSMIPreview.setSelected(userConfigFile.getBoolean("mibexplorer.ColoredSMI", true));
        this.autoColumnWidthSave.setSelected(userConfigFile.getBoolean("mibexplorer.table.colWidth.autosave", true));
        this.mibEditorSyntaxHighlighting.setSelected(userConfigFile.getBoolean("agentpp.smi.editor.SyntaxHighlighting", true));
        this.enableTableCellDeltaDisplay.setSelected(userConfigFile.getBoolean("mibexplorer.table.cellDeltaHighlighting", true));
        this.defaultOSDisplayMode.setSelectedItem(userConfigFile.get("mibexplorer.vb.display.mode", "MIB"));
    }
}

