/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.explorer.cfg;

import com.agentpp.common.PreferencesItem;
import com.agentpp.explorer.cfg.Preferences;
import com.agentpp.explorer.cfg.TransportChangeEvent;
import com.agentpp.explorer.cfg.TransportChangeListener;
import com.agentpp.explorer.cfg.TransportProtocolSettings;
import com.agentpp.explorer.cfg.TransportSettings_applyUDP_actionAdapter;
import com.agentpp.explorer.cfg.TransportSettings_enabledUDP_itemAdapter;
import com.agentpp.util.UserConfigFile;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.snmp4j.smi.GenericAddress;
import org.snmp4j.smi.TcpAddress;
import org.snmp4j.smi.TlsAddress;
import org.snmp4j.smi.TransportIpAddress;
import org.snmp4j.smi.UdpAddress;

public class TransportSettings
extends JPanel
implements PreferencesItem,
ChangeListener {
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    Border border1 = BorderFactory.createMatteBorder(0, 0, 1, 0, SystemColor.controlText);
    TransportProtocolSettings transportProtocolSettingsUDP = new TransportProtocolSettings();
    TransportProtocolSettings transportProtocolSettingsTLS;
    JCheckBox enabledUDP = new JCheckBox();
    JButton applyUDP = new JButton();
    String addressType;
    transient Vector transportChangeListeners = new Vector(2);

    public TransportSettings() {
        this("udp");
    }

    public TransportSettings(String string) {
        this.addressType = string;
        try {
            this._$5265();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.transportProtocolSettingsUDP.addChangeListener(this);
    }

    public void setTitle(String string) {
    }

    private void _$5265() throws Exception {
        this.setLayout(this.gridBagLayout1);
        this.enabledUDP.setHorizontalTextPosition(10);
        this.enabledUDP.setText("Enabled:");
        this.enabledUDP.addItemListener(new TransportSettings_enabledUDP_itemAdapter(this));
        this.applyUDP.setText("Apply");
        this.applyUDP.addActionListener(new TransportSettings_applyUDP_actionAdapter(this));
        int n2 = 1;
        this.add((Component)this.enabledUDP, new GridBagConstraints(0, n2++, 1, 1, 1.0, 0.0, 17, 0, new Insets(10, 10, 10, 0), 0, 0));
        this.add((Component)this.transportProtocolSettingsUDP, new GridBagConstraints(0, n2++, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.applyUDP, new GridBagConstraints(0, n2++, 1, 1, 0.0, 1.0, 12, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.applyUDP.setEnabled(false);
    }

    public JPanel getPanel() {
        return this;
    }

    public String getShortTitle() {
        return this.addressType.toUpperCase();
    }

    public String getTitle() {
        return this.addressType.toUpperCase() + " Transport Protocol Preferences";
    }

    public String getDescription() {
        if (this.addressType.equals(Preferences.TRANSPORT_TYPES[0])) {
            return "The UDP transport mapping is the default transport mapping for SNMP. By default the wildcard IP address '0.0.0.0' with the wildcard port '0' will be used to send SNMP requests and receive responses. You may choose other values although ports below 1024 may require system administrator privileges on some operating systems.";
        }
        if (this.addressType.equals(Preferences.TRANSPORT_TYPES[1])) {
            return "The TCP transport mapping is a connection oriented transport mapping for SNMP. An increasing number of SNMP agents support TCP. If a target supports TCP, using this transport mapping can increase performance of bulk data retrieval.By default the wildcard IP address '0.0.0.0' with the wildcard port '0' can be used to send SNMP requests and receive responses via TCP. You may choose other values although ports below 1024 may require system administrator privileges on some operating systems.";
        }
        return "The TLS transport mapping is an alternative transport mapping for SNMP. Few SNMP agents support TLS. TLS simplifies security configuration by using well established SSL/TLS encryption algorithms and certificate infrastructure for authentication and privacy. Like TCP, TLS can increase performance of bulk data retrieval.By default the wildcard IP address '0.0.0.0' with the wildcard port '0' can be used to send SNMP requests and receive responses via TLS. You may choose other values although ports below 1024 may require system administrator privileges on some operating systems.";
    }

    public String getTooltip() {
        return "";
    }

    public void saveProperties(UserConfigFile userConfigFile) {
        if (this.enabledUDP.isSelected()) {
            String string = this.addressType + ":" + this.transportProtocolSettingsUDP.getAddress();
            userConfigFile.put("mibexplorer.transport.address." + this.addressType, string);
            userConfigFile.putInteger("mibexplorer.transport.inboundMsgSize." + this.addressType, this.transportProtocolSettingsUDP.getMaxInboundBufferSize());
        } else {
            userConfigFile.remove("mibexplorer.transport.address." + this.addressType);
            userConfigFile.remove("mibexplorer.transport.inboundMsgSize." + this.addressType);
        }
        userConfigFile.putBoolean("mibexplorer.transport.configured.", true);
        this._$27876();
    }

    public boolean isOK() {
        return true;
    }

    public boolean isEnabledEnabled() {
        return this.enabledUDP.isEnabled();
    }

    public boolean isEnabled() {
        return this.enabledUDP.isSelected();
    }

    public void setEnabledEnabled(boolean bl) {
        this.enabledUDP.setEnabled(bl);
        if (!bl) {
            this.enabledUDP.setSelected(true);
        }
    }

    public static TransportIpAddress getAddress(UserConfigFile userConfigFile, String string) {
        String string2 = userConfigFile.get("mibexplorer.transport.address." + string, null);
        if (string2 == null) {
            return null;
        }
        return (TransportIpAddress)GenericAddress.parse(string2);
    }

    public static int getMaxInboundBufferSize(UserConfigFile userConfigFile, String string) {
        return userConfigFile.getInteger("mibexplorer.transport.inboundMsgSize." + string, 65535);
    }

    public void loadProperties(UserConfigFile userConfigFile) {
        TransportIpAddress transportIpAddress = TransportSettings.getAddress(userConfigFile, this.getAddressType());
        if (transportIpAddress != null) {
            this.transportProtocolSettingsUDP.setAddress(transportIpAddress);
            this.enabledUDP.setSelected(true);
            this.transportProtocolSettingsUDP.setEnabled(true);
        } else if (userConfigFile.getBoolean("mibexplorer.transport.configured.", false)) {
            if (this.getAddressType().equals(Preferences.TRANSPORT_TYPES[0])) {
                this.transportProtocolSettingsUDP.setAddress(new UdpAddress("0.0.0.0/0"));
            } else if (this.getAddressType().equals(Preferences.TRANSPORT_TYPES[1])) {
                this.transportProtocolSettingsUDP.setAddress(new TcpAddress("0.0.0.0/0"));
            } else {
                this.transportProtocolSettingsUDP.setAddress(new TlsAddress("0.0.0.0/0"));
            }
        } else {
            this.enabledUDP.setSelected(false);
            this.transportProtocolSettingsUDP.setEnabled(false);
        }
        this.transportProtocolSettingsUDP.setMaxInboundBufferSize(TransportSettings.getMaxInboundBufferSize(userConfigFile, this.addressType));
    }

    private boolean _$27876() {
        TransportIpAddress transportIpAddress = null;
        if (this.isEnabled()) {
            transportIpAddress = this.transportProtocolSettingsUDP.getAddress();
        }
        TransportChangeEvent transportChangeEvent = new TransportChangeEvent(this, transportIpAddress, this.addressType, 0);
        this.fireTransportAddressChanged(transportChangeEvent);
        return transportChangeEvent.isAccepted();
    }

    public void applyUDP_actionPerformed(ActionEvent actionEvent) {
        if (!this._$27876()) {
            JOptionPane.showMessageDialog(this, new String[]{"Could not bind transport address " + this.transportProtocolSettingsUDP.getAddress() + "!", "May be another application is using it or MIB Explorer has insufficient", "rights to bind this transport socket."}, "Address Error", 0);
        } else {
            this.applyUDP.setEnabled(false);
        }
    }

    public synchronized void addTransportChangeListener(TransportChangeListener transportChangeListener) {
        this.transportChangeListeners.add(transportChangeListener);
    }

    public synchronized void removeTransportChangeListener(TransportChangeListener transportChangeListener) {
        this.transportChangeListeners.remove(transportChangeListener);
    }

    protected void fireTransportAddressChanged(TransportChangeEvent transportChangeEvent) {
        if (this.transportChangeListeners != null) {
            Vector vector = this.transportChangeListeners;
            int n2 = vector.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                ((TransportChangeListener)vector.elementAt(i2)).transportAddressChanged(transportChangeEvent);
            }
        }
    }

    public void setAddressType(String string) {
        this.addressType = string;
        this.transportProtocolSettingsUDP.setAddressType(string);
    }

    public String getAddressType() {
        return this.addressType;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.applyUDP.setEnabled(true);
    }

    public void enabledUDP_itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 2) {
            this.transportProtocolSettingsUDP.setEnabled(false);
        } else {
            this.transportProtocolSettingsUDP.setEnabled(true);
        }
    }
}

