/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.explorer.cfg;

import com.agentpp.common.PreferencesItem;
import com.agentpp.common.SortLabel;
import com.agentpp.common.TableSorter;
import com.agentpp.common.table.FlexListTable;
import com.agentpp.common.table.TableUtils;
import com.agentpp.explorer.editors.cell.OctetStringCellEditor;
import com.agentpp.util.UserConfigFile;
import com.borland.jbcl.layout.VerticalFlowLayout;
import com.klg.jclass.cell.editors.JCComboBoxCellEditor;
import com.klg.jclass.table.JCCellDisplayEvent;
import com.klg.jclass.table.JCCellDisplayListener;
import com.klg.jclass.table.JCCellPosition;
import com.klg.jclass.table.JCCellRange;
import com.klg.jclass.table.JCCellStyle;
import com.klg.jclass.table.JCSelectEvent;
import com.klg.jclass.table.JCSelectListener;
import com.klg.jclass.table.TablePopupMenu;
import com.klg.jclass.table.data.JCEditableVectorDataSource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.snmp4j.smi.OctetString;
import org.snmp4j.transport.tls.SecurityNameMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TlsSecurityNameMapping
extends JPanel
implements JCCellDisplayListener,
JCSelectListener,
PreferencesItem {
    private static final String[] _$1713 = new String[]{"Fingerprint", "Mapping Type", "Data", "Security Name"};
    static final String ACTION_ASCII = "Default";
    static final String ACTION_HEX = "Hexadecimal";
    static final String ACTION_DEC = "Decimal";
    private static OctetStringCellEditor[] _$1715 = new OctetStringCellEditor[_$1713.length];
    JMenu editMenu = new JMenu("Format");
    FlexListTable table = new FlexListTable(){

        public void cellDisplay(JCCellDisplayEvent jCCellDisplayEvent) {
            OctetString octetString;
            int n2 = jCCellDisplayEvent.getColumn();
            int n3 = jCCellDisplayEvent.getRow();
            if (n3 < 0) {
                return;
            }
            if (n2 >= 0 && n2 < _$1713.length && _$1715[n2] != null && _$1715[n2].getMode() != 0 && (octetString = (OctetString)jCCellDisplayEvent.getCellData()) != null) {
                jCCellDisplayEvent.setDisplayData(octetString.toString(':', _$1715[n2].getMode()));
            }
        }

        public boolean isPopupAllowed(int n2, int n3) {
            TablePopupMenu tablePopupMenu = super.getPopupMenu();
            JCCellPosition jCCellPosition = TlsSecurityNameMapping.this.table.XYToCell(n2, n3);
            if (jCCellPosition.column >= 0 && jCCellPosition.column < _$1713.length && _$1715[jCCellPosition.column] != null) {
                TlsSecurityNameMapping.this.editMenu.setEnabled(true);
            } else {
                TlsSecurityNameMapping.this.editMenu.setEnabled(false);
            }
            return true;
        }
    };
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanelButtons = new JPanel();
    JButton jButtonAdd = new JButton();
    JButton jButtonRemove = new JButton();
    private JCEditableVectorDataSource _$11754;
    private TableSorter _$5245;
    VerticalFlowLayout verticalFlowLayout1 = new VerticalFlowLayout();
    Border border2;

    public TlsSecurityNameMapping() {
        this.init();
        try {
            this._$5265();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        TablePopupMenu tablePopupMenu = this.table.getPopupMenu();
        tablePopupMenu.add(this.editMenu);
        JMenuItem jMenuItem = this.editMenu.add(new FormatAction(ACTION_ASCII));
        jMenuItem.setMnemonic('F');
        jMenuItem = this.editMenu.add(new FormatAction(ACTION_HEX));
        jMenuItem.setMnemonic('H');
        jMenuItem = this.editMenu.add(new FormatAction(ACTION_DEC));
        jMenuItem.setMnemonic('D');
        this.table.setRowHidden(0, true);
        this.table.setFrozenRows(1);
        this.table.addSelectListener(this);
        this.table.addCellDisplayListener(this);
    }

    @Override
    public void cellDisplay(JCCellDisplayEvent jCCellDisplayEvent) {
        OctetString octetString;
        int n2 = jCCellDisplayEvent.getColumn();
        int n3 = jCCellDisplayEvent.getRow();
        if (n3 < 0) {
            return;
        }
        if (n2 >= 0 && n2 < _$1713.length && _$1715[n2] != null && _$1715[n2].getMode() != 0 && (octetString = (OctetString)jCCellDisplayEvent.getCellData()) != null) {
            jCCellDisplayEvent.setDisplayData(octetString.toString(':', _$1715[n2].getMode()));
        }
    }

    public void init() {
        this._$11754 = new JCEditableVectorDataSource();
        this._$11754.setNumColumns(_$1713.length);
        this._$11754.setColumnLabels(_$1713);
        this._$5245 = new TableSorter(this.table, this._$11754);
        this.table.setDataSource(this._$11754);
        this.table.setRowHidden(0, true);
        this.table.setFrozenRows(1);
        this.table.setPixelWidth(-998, 33001);
        this.table.setVisibleColumns(-999);
        this.table.setVisibleRows(5);
        this.table.setRowLabelDisplay(false);
        this.table.setColumnLabelDisplay(true);
        this.table.setResizeEven(true);
        this.table.setSelectionPolicy(2);
        JCCellStyle jCCellStyle = new JCCellStyle(this.table.getCellStyle(0, 0));
        jCCellStyle.setEditable(true);
        TlsSecurityNameMapping._$1715[0] = new OctetStringCellEditor();
        jCCellStyle.setCellEditor(_$1715[0]);
        this.table.setCellStyle(-997, 0, jCCellStyle);
        jCCellStyle = new JCCellStyle(this.table.getCellStyle(0, 1));
        jCCellStyle.setEditable(true);
        JCComboBoxCellEditor jCComboBoxCellEditor = new JCComboBoxCellEditor((Object[])SecurityNameMapping.CertMappingType.values());
        jCCellStyle.setCellEditor(jCComboBoxCellEditor);
        this.table.setCellStyle(-997, 1, jCCellStyle);
        jCCellStyle = new JCCellStyle(this.table.getCellStyle(0, 2));
        jCCellStyle.setEditable(true);
        TlsSecurityNameMapping._$1715[2] = new OctetStringCellEditor();
        jCCellStyle.setCellEditor(_$1715[2]);
        this.table.setCellStyle(-997, 2, jCCellStyle);
        jCCellStyle = new JCCellStyle(this.table.getCellStyle(0, 3));
        jCCellStyle.setEditable(true);
        TlsSecurityNameMapping._$1715[3] = new OctetStringCellEditor();
        jCCellStyle.setCellEditor(_$1715[3]);
        this.table.setCellStyle(-997, 3, jCCellStyle);
        this._$5459(16, 0);
        this._$5459(0, 2);
        this.table.setPopupMenuEnabled(true);
        this._$14354();
    }

    private void _$5459(int n2, int n3) {
        String string = "";
        _$1715[n3].setMode(n2);
        switch (n2) {
            case 16: {
                string = " [HEX]";
                break;
            }
            case 10: {
                string = " [DEC]";
            }
        }
        SortLabel sortLabel = (SortLabel)this._$11754.getTableColumnLabel(n3);
        sortLabel.setLabel(_$1713[n3] + string);
        this._$11754.fireColumnLabelChanged(n3);
    }

    private void _$5265() throws Exception {
        this.border2 = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        this.setLayout(this.borderLayout1);
        this.jButtonAdd.setText("Add");
        this.jButtonAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TlsSecurityNameMapping.this.jButtonAdd_actionPerformed(actionEvent);
            }
        });
        this.jButtonRemove.setText("Remove");
        this.jButtonRemove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TlsSecurityNameMapping.this.jButtonRemove_actionPerformed(actionEvent);
            }
        });
        this.jPanelButtons.setLayout(this.verticalFlowLayout1);
        this.verticalFlowLayout1.setHgap(10);
        this.verticalFlowLayout1.setVgap(10);
        this.jPanelButtons.setBorder(this.border2);
        this.setBorder(null);
        this.add((Component)this.table, "Center");
        this.add((Component)this.jPanelButtons, "East");
        this.jPanelButtons.add((Component)this.jButtonAdd, null);
        this.jPanelButtons.add((Component)this.jButtonRemove, null);
    }

    void jButtonAdd_actionPerformed(ActionEvent actionEvent) {
        Vector<Object> vector = new Vector<Object>();
        vector.add(new OctetString());
        vector.add(SecurityNameMapping.CertMappingType.SANDNSName.toString());
        vector.add(new OctetString());
        this._$11754.addRow(Integer.MAX_VALUE, null, vector);
        this._$14354();
    }

    void jButtonRemove_actionPerformed(ActionEvent actionEvent) {
        Collection collection = this.table.getSelectedCells();
        if (collection == null) {
            return;
        }
        for (JCCellRange jCCellRange : collection) {
            TableUtils.setRangeAfterCopy(jCCellRange);
            this._$11754.deleteRows(jCCellRange.start_row, jCCellRange.end_row - jCCellRange.start_row + 1);
        }
        this._$14354();
    }

    public List<SecurityNameMapping> getMappings() {
        ArrayList<SecurityNameMapping> arrayList = new ArrayList<SecurityNameMapping>(this._$11754.getNumRows());
        for (int i2 = 1; i2 < this._$11754.getNumRows(); ++i2) {
            arrayList.add(new SecurityNameMapping((OctetString)this._$11754.getTableDataItem(i2, 0), (OctetString)this._$11754.getTableDataItem(i2, 2), (SecurityNameMapping.CertMappingType)((Object)this._$11754.getTableDataItem(i2, 1)), (OctetString)this._$11754.getTableDataItem(i2, 3)));
        }
        return arrayList;
    }

    public void setMappings(final List<SecurityNameMapping> list) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TlsSecurityNameMapping.this._$11754.setNumRows(0);
                TlsSecurityNameMapping.this._$11754.addRow(Integer.MAX_VALUE, null, null);
                for (SecurityNameMapping securityNameMapping : list) {
                    Vector<Object> vector = new Vector<Object>(3);
                    vector.add(securityNameMapping.getFingerprint());
                    vector.add(securityNameMapping.getType().toString());
                    vector.add(securityNameMapping.getData());
                    vector.add(securityNameMapping.getSecurityName());
                    TlsSecurityNameMapping.this._$11754.addRow(Integer.MAX_VALUE, null, vector);
                }
            }
        });
    }

    @Override
    public void beforeSelect(JCSelectEvent jCSelectEvent) {
        if (jCSelectEvent.getStartRow() == 0) {
            jCSelectEvent.setCancelled(true);
        }
    }

    @Override
    public void afterSelect(JCSelectEvent jCSelectEvent) {
        this._$14354();
    }

    @Override
    public void select(JCSelectEvent jCSelectEvent) {
    }

    private void _$14354() {
        this.jButtonRemove.setEnabled(this.table.getSelectedCells() != null && this._$11754.getNumRows() > 1);
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    @Override
    public String getShortTitle() {
        return "TLS Security Names";
    }

    @Override
    public String getTitle() {
        return "TLS Security Name Mapping";
    }

    @Override
    public String getDescription() {
        return "The TLS transport protocol does not exchange security information over the wire. Instead the security name used by the View Access Control Model (VACM) to authorize access to a SNMP entity, has to be derived from authentication identities. As those identities are certificates a mapping specification has to be provided that assigns a security name to a fingerprint, subject distinguished name (DN), issuer DN, and other attributes of a X509 certificate.\nThose mappings are used for notifications by MIB Explorer and can be specified here.";
    }

    @Override
    public String getTooltip() {
        return "";
    }

    @Override
    public void saveProperties(UserConfigFile userConfigFile) {
        ArrayList<String[]> arrayList = new ArrayList<String[]>(this._$11754.getNumRows());
        for (int i2 = 1; i2 < this._$11754.getNumRows(); ++i2) {
            String[] stringArray = new String[this._$11754.getNumColumns()];
            for (int i3 = 0; i3 < stringArray.length; ++i3) {
                Object object = this._$11754.getTableDataItem(i2, i3);
                if (object instanceof OctetString) {
                    object = ((OctetString)object).toHexString();
                }
                if (object == null) continue;
                stringArray[i3] = object.toString();
            }
            arrayList.add(stringArray);
        }
        userConfigFile.putTable(new String[]{"mibexplorer.transport.tls.securityNameMap.fingerprint", "mibexplorer.transport.tls.securityNameMap.type", "mibexplorer.transport.tls.securityNameMap.data", "mibexplorer.transport.tls.securityNameMap.securityName"}, arrayList);
    }

    @Override
    public boolean isOK() {
        return true;
    }

    @Override
    public void loadProperties(UserConfigFile userConfigFile) {
        if (this._$11754.getNumRows() > 1) {
            this._$11754.setNumRows(1);
        }
        List<String[]> list = userConfigFile.getTable(new String[]{"mibexplorer.transport.tls.securityNameMap.fingerprint", "mibexplorer.transport.tls.securityNameMap.type", "mibexplorer.transport.tls.securityNameMap.data", "mibexplorer.transport.tls.securityNameMap.securityName"});
        for (String[] stringArray : list) {
            Vector<Object> vector = new Vector<Object>(stringArray.length);
            vector.add(OctetString.fromHexString(stringArray[0] != null ? stringArray[0] : ""));
            vector.add((Object)SecurityNameMapping.CertMappingType.valueOf(stringArray[1]));
            vector.add(OctetString.fromHexString(stringArray[2] != null ? stringArray[2] : ""));
            vector.add(OctetString.fromHexString(stringArray[3] != null ? stringArray[3] : ""));
            this._$11754.addRow(Integer.MAX_VALUE, null, vector);
        }
    }

    class FormatAction
    extends AbstractAction {
        public FormatAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JCCellPosition jCCellPosition = TlsSecurityNameMapping.this.table.getPopupCellPosition();
            if (jCCellPosition.column >= 0 && jCCellPosition.column < _$1713.length) {
                if (actionEvent.getActionCommand().equals(TlsSecurityNameMapping.ACTION_ASCII)) {
                    TlsSecurityNameMapping.this._$5459(0, jCCellPosition.column);
                } else if (actionEvent.getActionCommand().equals(TlsSecurityNameMapping.ACTION_HEX)) {
                    TlsSecurityNameMapping.this._$5459(16, jCCellPosition.column);
                } else if (actionEvent.getActionCommand().equals(TlsSecurityNameMapping.ACTION_DEC)) {
                    TlsSecurityNameMapping.this._$5459(10, jCCellPosition.column);
                }
            }
        }
    }
}

