/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.explorer.cfg;

import com.agentpp.common.PreferencesItem;
import com.agentpp.common.TableSorter;
import com.agentpp.common.table.FlexListTable;
import com.agentpp.common.table.TableUtils;
import com.agentpp.util.UserConfigFile;
import com.borland.jbcl.layout.VerticalFlowLayout;
import com.klg.jclass.cell.editors.JCComboBoxCellEditor;
import com.klg.jclass.table.JCCellDisplayEvent;
import com.klg.jclass.table.JCCellDisplayListener;
import com.klg.jclass.table.JCCellRange;
import com.klg.jclass.table.JCCellStyle;
import com.klg.jclass.table.JCSelectEvent;
import com.klg.jclass.table.JCSelectListener;
import com.klg.jclass.table.data.JCEditableVectorDataSource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.snmp4j.smi.OctetString;
import org.snmp4j.transport.tls.SecurityNameMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TlsAcceptedDN
extends JPanel
implements JCCellDisplayListener,
JCSelectListener,
PreferencesItem {
    private DnType _$11609;
    private static final String[] _$1713 = new String[]{"Distinguished Name (DN)"};
    FlexListTable table = new FlexListTable(){

        public void cellDisplay(JCCellDisplayEvent jCCellDisplayEvent) {
        }

        public boolean isPopupAllowed(int n2, int n3) {
            return false;
        }
    };
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanelButtons = new JPanel();
    JButton jButtonAdd = new JButton();
    JButton jButtonRemove = new JButton();
    private JCEditableVectorDataSource _$11754;
    private TableSorter _$5245;
    VerticalFlowLayout verticalFlowLayout1 = new VerticalFlowLayout();
    Border border2;

    public TlsAcceptedDN() {
        this(Collections.emptyList(), DnType.SubjectDN);
    }

    public TlsAcceptedDN(List<String> list, DnType dnType) {
        this._$11609 = dnType;
        this.init(list);
        try {
            this._$5265();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.table.setRowHidden(0, true);
        this.table.setFrozenRows(1);
        this.table.addSelectListener(this);
    }

    @Override
    public void cellDisplay(JCCellDisplayEvent jCCellDisplayEvent) {
    }

    public void init(List<String> list) {
        this._$11754 = new JCEditableVectorDataSource();
        this._$11754.setNumColumns(_$1713.length);
        this._$11754.setColumnLabels(_$1713);
        this._$5245 = new TableSorter(this.table, this._$11754);
        this.table.setDataSource(this._$11754);
        this.table.setRowHidden(0, true);
        this.table.setFrozenRows(1);
        this.table.setPixelWidth(-998, 33001);
        this.table.setVisibleColumns(-999);
        this.table.setVisibleRows(5);
        this.table.setRowLabelDisplay(false);
        this.table.setColumnLabelDisplay(true);
        this.table.setResizeEven(true);
        this.table.setSelectionPolicy(2);
        JCCellStyle jCCellStyle = new JCCellStyle(this.table.getCellStyle(0, 0));
        jCCellStyle.setEditable(true);
        JCComboBoxCellEditor jCComboBoxCellEditor = new JCComboBoxCellEditor(list.toArray(new String[list.size()]));
        jCComboBoxCellEditor.setEditable(true);
        jCCellStyle.setCellEditor(jCComboBoxCellEditor);
        this.table.setCellStyle(-997, 0, jCCellStyle);
        this.table.setPopupMenuEnabled(true);
        this._$14354();
    }

    private void _$5265() throws Exception {
        this.border2 = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        this.setLayout(this.borderLayout1);
        this.jButtonAdd.setText("Add");
        this.jButtonAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TlsAcceptedDN.this.jButtonAdd_actionPerformed(actionEvent);
            }
        });
        this.jButtonRemove.setText("Remove");
        this.jButtonRemove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TlsAcceptedDN.this.jButtonRemove_actionPerformed(actionEvent);
            }
        });
        this.jPanelButtons.setLayout(this.verticalFlowLayout1);
        this.verticalFlowLayout1.setHgap(10);
        this.verticalFlowLayout1.setVgap(10);
        this.jPanelButtons.setBorder(this.border2);
        this.setBorder(null);
        this.add((Component)this.table, "Center");
        this.add((Component)this.jPanelButtons, "East");
        this.jPanelButtons.add((Component)this.jButtonAdd, null);
        this.jPanelButtons.add((Component)this.jButtonRemove, null);
    }

    void jButtonAdd_actionPerformed(ActionEvent actionEvent) {
        Vector<Object> vector = new Vector<Object>();
        vector.add(new OctetString());
        vector.add(SecurityNameMapping.CertMappingType.SANDNSName.toString());
        vector.add(new OctetString());
        this._$11754.addRow(Integer.MAX_VALUE, null, vector);
        this._$14354();
    }

    void jButtonRemove_actionPerformed(ActionEvent actionEvent) {
        Collection collection = this.table.getSelectedCells();
        if (collection == null) {
            return;
        }
        for (JCCellRange jCCellRange : collection) {
            TableUtils.setRangeAfterCopy(jCCellRange);
            this._$11754.deleteRows(jCCellRange.start_row, jCCellRange.end_row - jCCellRange.start_row + 1);
        }
        this._$14354();
    }

    public List<String> getDN() {
        ArrayList<String> arrayList = new ArrayList<String>(this._$11754.getNumRows());
        for (int i2 = 1; i2 < this._$11754.getNumRows(); ++i2) {
            arrayList.add((String)this._$11754.getTableDataItem(i2, 0));
        }
        return arrayList;
    }

    public void setMappings(final List<String> list) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TlsAcceptedDN.this._$11754.setNumRows(0);
                TlsAcceptedDN.this._$11754.addRow(Integer.MAX_VALUE, null, null);
                for (String string : list) {
                    Vector<String> vector = new Vector<String>(1);
                    vector.add(string);
                    TlsAcceptedDN.this._$11754.addRow(Integer.MAX_VALUE, null, vector);
                }
            }
        });
    }

    @Override
    public void beforeSelect(JCSelectEvent jCSelectEvent) {
        if (jCSelectEvent.getStartRow() == 0) {
            jCSelectEvent.setCancelled(true);
        }
    }

    @Override
    public void afterSelect(JCSelectEvent jCSelectEvent) {
        this._$14354();
    }

    @Override
    public void select(JCSelectEvent jCSelectEvent) {
    }

    private void _$14354() {
        this.jButtonRemove.setEnabled(this.table.getSelectedCells() != null && this._$11754.getNumRows() > 1);
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    @Override
    public String getShortTitle() {
        return "TLS Accepted " + this._$11609.toString();
    }

    @Override
    public String getTitle() {
        return "TLS Accepted " + this._$11609.toString() + "List";
    }

    @Override
    public String getDescription() {
        return "The TLS protocol requires client and server authentication by exchanging X509 certificates. The remote SNMP entity then needs to accept the presented certificate based on key attributes of the certificate. Such an attribute is either the subject distinguished name (DN) or the issuer DN of the certificate.\nYou can here specify a list of accepted certificate DNs.";
    }

    @Override
    public String getTooltip() {
        return "";
    }

    @Override
    public void saveProperties(UserConfigFile userConfigFile) {
        ArrayList<String[]> arrayList = new ArrayList<String[]>(this._$11754.getNumRows());
        for (int i2 = 1; i2 < this._$11754.getNumRows(); ++i2) {
            String[] stringArray = new String[this._$11754.getNumColumns()];
            for (int i3 = 0; i3 < stringArray.length; ++i3) {
                Object object = this._$11754.getTableDataItem(i2, i3);
                if (object instanceof OctetString) {
                    object = ((OctetString)object).toHexString();
                }
                if (object == null) continue;
                stringArray[i3] = object.toString();
            }
            arrayList.add(stringArray);
        }
        userConfigFile.putTable(new String[]{"mibexplorer.transport.tls.accepted." + this._$11609.toString()}, arrayList);
    }

    @Override
    public boolean isOK() {
        return true;
    }

    @Override
    public void loadProperties(UserConfigFile userConfigFile) {
        if (this._$11754.getNumRows() > 1) {
            this._$11754.setNumRows(1);
        }
        List<String[]> list = userConfigFile.getTable(new String[]{"mibexplorer.transport.tls.accepted." + this._$11609.toString()});
        for (String[] stringArray : list) {
            Vector<String> vector = new Vector<String>(stringArray.length);
            vector.add(stringArray[0] != null ? stringArray[0] : "");
            this._$11754.addRow(Integer.MAX_VALUE, null, vector);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DnType {
        SubjectDN,
        IssuerDN;

    }
}

