/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.explorer.cfg;

import com.agentpp.common.PreferencesItem;
import com.agentpp.commons.snmp.SecurityProtocolOidMappingEditor;
import com.agentpp.explorer.cfg.SNMPv3Settings_jButtonGenDefaultEngineID_actionAdapter;
import com.agentpp.explorer.editors.OctetTextField;
import com.agentpp.mib.MIBRepository;
import com.agentpp.util.UserConfigFile;
import com.klg.jclass.field.DataProperties;
import com.klg.jclass.field.JCInvalidInfo;
import com.klg.jclass.field.JCSpinField;
import com.klg.jclass.field.validate.JCIntegerValidator;
import com.klg.jclass.util.value.MutableValueModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.snmp4j.SNMP4JSettings;
import org.snmp4j.mp.SnmpConstants;
import org.snmp4j.security.AuthenticationProtocol;
import org.snmp4j.security.PrivAES192;
import org.snmp4j.security.PrivAES256;
import org.snmp4j.security.PrivacyProtocol;
import org.snmp4j.security.SecurityProtocol;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.security.nonstandard.NonStandardSecurityProtocol;
import org.snmp4j.security.nonstandard.PrivAES192With3DESKeyExtension;
import org.snmp4j.security.nonstandard.PrivAES256With3DESKeyExtension;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;

public class SNMPv3Settings
extends JPanel
implements PreferencesItem {
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JLabel jLabelAuthEngineID = new JLabel();
    OctetTextField authoritativeEngineID = new OctetTextField();
    JLabel jLabelEngineBoots = new JLabel();
    JCSpinField engineBoots = new JCSpinField();
    JLabel jLabelReportStrategy = new JLabel();
    JComboBox reportStrategy = new JComboBox();
    SecurityProtocolOidMappingEditor mappingEditor;
    private static final Object[][] _$37194 = new Object[][]{{"AES192", PrivAES192.class, SnmpConstants.oosnmpUsmAesCfb192Protocol}, {"AES256", PrivAES256.class, SnmpConstants.oosnmpUsmAesCfb256Protocol}, {"AES192-KeyExt3DES", PrivAES192With3DESKeyExtension.class, SnmpConstants.oosnmpUsmAesCfb192ProtocolWith3DESKeyExtension}, {"AES256-KeyExt3DES", PrivAES256With3DESKeyExtension.class, SnmpConstants.oosnmpUsmAesCfb256ProtocolWith3DESKeyExtension}};
    private static boolean _$37195 = false;
    JButton jButtonGenDefaultEngineID = new JButton();
    JLabel jLabelChanges = new JLabel();
    private boolean _$37198;

    public SNMPv3Settings(boolean bl, MIBRepository mIBRepository) {
        this._$37198 = bl;
        TreeMap<String, OID> treeMap = new TreeMap<String, OID>();
        for (Object[] objectArray : _$37194) {
            try {
                treeMap.put((String)objectArray[0], ((SecurityProtocol)((Class)objectArray[1]).newInstance()).getID());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.mappingEditor = new SecurityProtocolOidMappingEditor(mIBRepository, treeMap);
        for (Object[] objectArray : SNMP4JSettings.ReportSecurityLevelStrategy.values()) {
            this.reportStrategy.addItem(objectArray);
        }
        try {
            this._$5265();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void _$5265() throws Exception {
        this.setLayout(this.gridBagLayout1);
        this.jLabelAuthEngineID.setText("Authoritative Engine ID*:");
        this.jLabelEngineBoots.setText("Engine Boots*:");
        this.jLabelReportStrategy.setText("Report Security Level Strategy:");
        this.jButtonGenDefaultEngineID.setToolTipText("Generate default authoritative engine ID");
        this.jButtonGenDefaultEngineID.setText("Default");
        this.jButtonGenDefaultEngineID.addActionListener(new SNMPv3Settings_jButtonGenDefaultEngineID_actionAdapter(this));
        this.jLabelChanges.setFont(new Font("Dialog", 2, 11));
        this.jLabelChanges.setText("* Changes will take affect with next start of the application.");
        this.add((Component)this.jLabelAuthEngineID, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.jLabelEngineBoots, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.jLabelReportStrategy, new GridBagConstraints(0, 2, 1, 1, 0.0, 1.0, 18, 0, new Insets(10, 10, 0, 10), 0, 0));
        this.engineBoots.setDataProperties(new DataProperties(new JCIntegerValidator(null, new Integer(1), new Integer(Integer.MAX_VALUE), null, true, null, new Integer(1), "#,##0.###;-#,##0.###", false, false, false, null, new Integer(1)), new MutableValueModel(Integer.class, null), new JCInvalidInfo(true, 1, new Color(0, 0, 0, 255), new Color(255, 255, 255, 255))));
        this.add((Component)this.engineBoots, new GridBagConstraints(1, 1, 2, 2, 0.0, 1.0, 11, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.jButtonGenDefaultEngineID, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.authoritativeEngineID, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.reportStrategy, new GridBagConstraints(2, 2, 1, 1, 1.0, 0.0, 18, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.jLabelChanges, new GridBagConstraints(0, 4, 3, 1, 0.0, 0.0, 17, 2, new Insets(10, 10, 10, 10), 0, 0));
        if (this._$37198) {
            this.add((Component)this.mappingEditor.getPanel(), new GridBagConstraints(0, 3, 3, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
        }
    }

    public JPanel getPanel() {
        return this;
    }

    public String getShortTitle() {
        return "SNMPv3";
    }

    public String getTitle() {
        return "SNMPv3 Settings";
    }

    public String getDescription() {
        return "The SNMPv3 settings local engine ID and engine boots counter do not need to be changed manually in general. However, if you encounter connectivity problems then a probable cause might be an agent that is using the same engine ID as shown below. In this case, you should change the local engine ID to make it unique again.\nThe engine boots counter should be strictly monotonic increased. It is automatically increased by one on each restart of MIB Explorer." + (this._$37198 ? "\nThe security protocol object identifier mapping table defines OIDs for the non-standard security protocols, because each vendor might have used its own IDs for those protocols. AGENT++ uses the IDs defined in the OOSNMP-USM-MIB. Those OIDs can be overriden here. Define here the OIDs used by the target system(s) to be able to use the Edit->Create/Modify SNMPv3 User function. For any other operation, the mapping is not needed." : "");
    }

    public String getTooltip() {
        return "";
    }

    public static String getDefaultEngineID() {
        String string = "01:";
        OctetString octetString = new OctetString();
        try {
            octetString.setValue(InetAddress.getLocalHost().getAddress());
        }
        catch (UnknownHostException unknownHostException) {
            string = "04:";
            octetString.setValue("MIBExplorer".getBytes());
        }
        return "80:00:13:70:" + string + octetString.toHexString();
    }

    public static int getEngineBoots(UserConfigFile userConfigFile) {
        int n2 = userConfigFile.getInteger("mibexplorer.EngineBoots", 0);
        if (n2 < 0) {
            n2 = 0;
        }
        if (!_$37195) {
            n2 = n2 < 0 || n2 == Integer.MAX_VALUE ? 0 : ++n2;
            userConfigFile.putInteger("mibexplorer.EngineBoots", n2);
        }
        return n2;
    }

    public static OctetString getEngineID(UserConfigFile userConfigFile) {
        return OctetString.fromHexString(userConfigFile.get("mibexplorer.EngineID", SNMPv3Settings.getDefaultEngineID()));
    }

    public void saveProperties(UserConfigFile userConfigFile) {
        OctetString octetString = OctetTextField.getOctetString(this.authoritativeEngineID.getText());
        if (octetString == null || octetString.length() < 5 || octetString.length() > 32) {
            octetString = OctetTextField.getOctetString(SNMPv3Settings.getDefaultEngineID());
            userConfigFile.put("mibexplorer.EngineID", SNMPv3Settings.getDefaultEngineID());
        } else {
            userConfigFile.put("mibexplorer.EngineID", this.authoritativeEngineID.getText());
        }
        userConfigFile.putInteger("mibexplorer.EngineBoots", ((Number)this.engineBoots.getValue()).intValue());
        userConfigFile.put("mibexplorer.ReportStrategy", this.reportStrategy.getSelectedItem().toString());
        SNMP4JSettings.setReportSecurityLevelStrategy((SNMP4JSettings.ReportSecurityLevelStrategy)((Object)this.reportStrategy.getSelectedItem()));
        Map<String, OID> map = this.mappingEditor.getMapping();
        if (this._$37198) {
            for (Map.Entry<String, OID> entry : map.entrySet()) {
                if (entry.getValue() == null || entry.getValue().size() == 0) {
                    userConfigFile.remove("mibexplorer.snmpv3.security.protocol.mapping." + entry.getKey());
                    continue;
                }
                userConfigFile.put("mibexplorer.snmpv3.security.protocol.mapping." + entry.getKey(), entry.getValue().toDottedString());
            }
        }
    }

    public boolean isOK() {
        return true;
    }

    public void loadProperties(UserConfigFile userConfigFile) {
        this.authoritativeEngineID.setText(userConfigFile.get("mibexplorer.EngineID", SNMPv3Settings.getDefaultEngineID()));
        this.engineBoots.setValue(new Integer(SNMPv3Settings.getEngineBoots(userConfigFile)));
        this.reportStrategy.setSelectedItem((Object)SNMP4JSettings.ReportSecurityLevelStrategy.valueOf(userConfigFile.get("mibexplorer.ReportStrategy", "standard")));
    }

    public static void loadSecurityProtocolMappings(UserConfigFile userConfigFile) {
        for (Object[] objectArray : _$37194) {
            String string = (String)objectArray[0];
            String string2 = userConfigFile.get("mibexplorer.snmpv3.security.protocol.mapping." + string, null);
            if (string2 == null) continue;
            try {
                OID oID = new OID(string2);
                NonStandardSecurityProtocol nonStandardSecurityProtocol = (NonStandardSecurityProtocol)((Class)objectArray[1]).newInstance();
                nonStandardSecurityProtocol.setID(oID);
                if (nonStandardSecurityProtocol instanceof PrivacyProtocol) {
                    SecurityProtocols.getInstance().addPrivacyProtocol((PrivacyProtocol)((Object)nonStandardSecurityProtocol));
                    continue;
                }
                if (!(nonStandardSecurityProtocol instanceof AuthenticationProtocol)) continue;
                SecurityProtocols.getInstance().addAuthenticationProtocol((AuthenticationProtocol)((Object)nonStandardSecurityProtocol));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void jButtonGenDefaultEngineID_actionPerformed(ActionEvent actionEvent) {
        this.authoritativeEngineID.setText(SNMPv3Settings.getDefaultEngineID());
    }
}

