/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.explorer.cfg;

import com.agentpp.common.PreferencesItem;
import com.agentpp.util.UserConfigFile;
import com.klg.jclass.field.DataProperties;
import com.klg.jclass.field.JCInvalidInfo;
import com.klg.jclass.field.JCSpinField;
import com.klg.jclass.field.validate.JCIntegerValidator;
import com.klg.jclass.util.value.MutableValueModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SNMPSettings
extends JPanel
implements PreferencesItem {
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JLabel jLabelMaxRepetitions = new JLabel();
    JCSpinField maxRepetitions = new JCSpinField();
    JLabel jLabelMaxVBs = new JLabel();
    JCSpinField maxVBs = new JCSpinField();

    public SNMPSettings() {
        try {
            this._$5265();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void _$5265() throws Exception {
        this.setLayout(this.gridBagLayout1);
        this.jLabelMaxRepetitions.setText("Maximum GETBULK Repetitions:");
        this.jLabelMaxVBs.setText("Maximum Variable Bindings per Request PDU:");
        this.maxRepetitions.setDataProperties(new DataProperties(new JCIntegerValidator(null, new Integer(1), new Integer(Integer.MAX_VALUE), null, true, null, new Integer(1), "#,##0.###;-#,##0.###", false, false, false, null, new Integer(25)), new MutableValueModel(Integer.class, null), new JCInvalidInfo(true, 1, new Color(0, 0, 0, 255), new Color(255, 255, 255, 255))));
        this.maxVBs.setDataProperties(new DataProperties(new JCIntegerValidator(null, new Integer(1), new Integer(999), null, true, null, new Integer(1), "#,##0.###;-#,##0.###", false, false, false, null, new Integer(10)), new MutableValueModel(Integer.class, null), new JCInvalidInfo(true, 1, new Color(0, 0, 0, 255), new Color(255, 255, 255, 255))));
        this.add((Component)this.maxRepetitions, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.jLabelMaxRepetitions, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.maxVBs, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 11, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.jLabelMaxVBs, new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 18, 0, new Insets(10, 10, 10, 10), 0, 0));
    }

    public JPanel getPanel() {
        return this;
    }

    public String getShortTitle() {
        return "PDU Size";
    }

    public String getTitle() {
        return "PDU Size Restrictions";
    }

    public String getDescription() {
        return "Because of implementation specific restrictions such as message buffer sizes not all SNMP agents are able to process arbitrary sized SNMP mesages. Bigger values for the below parameters provide best performance but result in a higher risc of timeouts, because of non-responding agents.\nThe maximum VBs per PDU restriction limits the number of variable bindings sent in a PDU on behalf of table retrieval operations.\nThe maximum repetitions for GETBULK operations limits the number of 'rows' in a response PDUs to be sent by the target agent on behalf of table operations.";
    }

    public String getTooltip() {
        return null;
    }

    public void saveProperties(UserConfigFile userConfigFile) {
        userConfigFile.putInteger("mibexplorer.MaxVBS", ((Number)this.maxVBs.getValue()).intValue());
        userConfigFile.putInteger("mibexplorer.MaxRepetitions", ((Number)this.maxRepetitions.getValue()).intValue());
    }

    public boolean isOK() {
        return true;
    }

    public void loadProperties(UserConfigFile userConfigFile) {
        this.maxVBs.setValue(new Integer(userConfigFile.getInteger("mibexplorer.MaxVBS", 10)));
        this.maxRepetitions.setValue(new Integer(userConfigFile.getInteger("mibexplorer.MaxRepetitions", 25)));
    }
}

