/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.explorer.cfg;

import com.agentpp.common.PreferencesItem;
import com.agentpp.common.PreferencesPanel;
import com.agentpp.common.StandardDialog;
import com.agentpp.explorer.cfg.GeneralSettings;
import com.agentpp.explorer.cfg.HttpServerSettings;
import com.agentpp.explorer.cfg.JdbcDriverRegistration;
import com.agentpp.explorer.cfg.ListenTransportConfig;
import com.agentpp.explorer.cfg.LookAndFeelSettings;
import com.agentpp.explorer.cfg.MIBSettings;
import com.agentpp.explorer.cfg.MonitorSettings;
import com.agentpp.explorer.cfg.SNMPSettings;
import com.agentpp.explorer.cfg.SNMPv3Settings;
import com.agentpp.explorer.cfg.ServerSettings;
import com.agentpp.explorer.cfg.TlsAcceptedDN;
import com.agentpp.explorer.cfg.TlsSecurityNameMapping;
import com.agentpp.explorer.cfg.TransportChangeEvent;
import com.agentpp.explorer.cfg.TransportChangeListener;
import com.agentpp.explorer.cfg.TransportPreferences;
import com.agentpp.explorer.cfg.TransportProtocolSettingsTLS;
import com.agentpp.explorer.cfg.TransportSettings;
import com.agentpp.explorer.cfg.TrapPriorities;
import com.agentpp.explorer.cfg.TrapReceiverSettings;
import com.agentpp.explorer.cfg.ViewSettings;
import com.agentpp.explorer.traps.TrapProxy;
import com.agentpp.explorer.traps.TrapSelector;
import com.agentpp.mib.MIBRepository;
import com.agentpp.repository.DefaultRepositoryManager;
import com.agentpp.slimdao.jdbc.DriverLoader;
import com.agentpp.util.UserConfigFile;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.help.HelpBroker;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.snmp4j.Snmp;
import org.snmp4j.TransportMapping;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.GenericAddress;
import org.snmp4j.smi.TcpAddress;
import org.snmp4j.smi.TlsAddress;
import org.snmp4j.smi.TransportIpAddress;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.transport.AbstractTransportMapping;
import org.snmp4j.transport.DefaultTcpTransportMapping;
import org.snmp4j.transport.DefaultUdpTransportMapping;
import org.snmp4j.transport.TLSTM;
import org.snmp4j.transport.tls.DefaultTlsTmSecurityCallback;
import org.snmp4j.transport.tls.SecurityNameMapping;
import org.snmp4j.transport.tls.TlsTmSecurityCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Preferences
implements TransportChangeListener {
    public static String[] TRANSPORT_TYPES = new String[]{"udp", "tcp", "tls"};
    private TransportIpAddress[] _$34418 = null;
    private TransportMapping[] _$34419 = null;
    private TransportSettings[] _$34420 = new TransportSettings[TRANSPORT_TYPES.length];
    private ListenTransportConfig[] _$34421 = new ListenTransportConfig[TRANSPORT_TYPES.length];
    private TransportProtocolSettingsTLS _$34422;
    private TlsSecurityNameMapping _$34423;
    private TlsAcceptedDN _$34424;
    private TlsAcceptedDN _$34425;
    private Vector[] _$34426;
    private UserConfigFile _$5250;
    private Snmp _$14889;
    private TrapProxy _$31253;
    private MIBRepository _$20550;
    private DefaultRepositoryManager _$31188;
    private boolean _$34427;
    private DriverLoader _$14341;

    public Preferences(UserConfigFile userConfigFile, Snmp snmp, TrapProxy trapProxy, MIBRepository mIBRepository, DefaultRepositoryManager defaultRepositoryManager, boolean bl, DriverLoader driverLoader) {
        this._$5250 = userConfigFile;
        this._$14889 = snmp;
        this._$31253 = trapProxy;
        this._$20550 = mIBRepository;
        this._$31188 = defaultRepositoryManager;
        this._$34427 = bl;
        this._$14341 = driverLoader;
        this._$34428();
        for (int i2 = 0; i2 < TRANSPORT_TYPES.length; ++i2) {
            this._$34420[i2] = new TransportSettings();
            this._$34420[i2].setAddressType(TRANSPORT_TYPES[i2]);
            this._$34420[i2].addTransportChangeListener(this);
            this._$34421[i2] = new ListenTransportConfig();
            this._$34421[i2].setAddressType(TRANSPORT_TYPES[i2]);
            this._$34421[i2].addTransportChangeListener(this);
        }
        this._$34422 = new TransportProtocolSettingsTLS();
        this._$34422.loadProperties(userConfigFile);
        this._$34423 = new TlsSecurityNameMapping();
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        this._$34431(arrayList, arrayList2);
        this._$34424 = new TlsAcceptedDN(arrayList, TlsAcceptedDN.DnType.SubjectDN);
        this._$34425 = new TlsAcceptedDN(arrayList2, TlsAcceptedDN.DnType.IssuerDN);
    }

    public boolean edit(JFrame jFrame, final HelpBroker helpBroker) {
        StandardDialog standardDialog = new StandardDialog(jFrame, "Preferences", true, true, false, true){

            public void init() {
                helpBroker.enableHelpOnButton(this.jButtonHelp, "Preferences", null);
            }
        };
        PreferencesPanel preferencesPanel = this.createPreferencesPanel();
        standardDialog.setCenterPanel(preferencesPanel);
        standardDialog.setLocationRelativeTo(jFrame);
        standardDialog.setVisible(true);
        if (standardDialog.getResult() == 0) {
            preferencesPanel.save(this._$5250);
            this._$34428();
            return true;
        }
        return false;
    }

    public PreferencesPanel createPreferencesPanel() {
        Serializable serializable;
        Serializable serializable2;
        JPanel jPanel;
        PreferencesPanel preferencesPanel = new PreferencesPanel();
        preferencesPanel.addItem(new GeneralSettings(), null);
        preferencesPanel.addItem(new MIBSettings(), null);
        preferencesPanel.addItem(new SNMPSettings(), null);
        if (this._$34427) {
            jPanel = new ServerSettings();
            preferencesPanel.addItem((PreferencesItem)((Object)jPanel), null);
            preferencesPanel.addItem(new HttpServerSettings(), (PreferencesItem)((Object)jPanel));
        }
        preferencesPanel.addItem(new SNMPv3Settings(this._$34427, this._$20550), null);
        jPanel = new TransportPreferences();
        preferencesPanel.addItem((PreferencesItem)((Object)jPanel), null);
        preferencesPanel.addItem(this._$34420[0], (PreferencesItem)((Object)jPanel));
        preferencesPanel.addItem(this._$34420[1], (PreferencesItem)((Object)jPanel));
        if (this._$34427) {
            preferencesPanel.addItem(this._$34420[2], (PreferencesItem)((Object)jPanel));
            preferencesPanel.addItem(this._$34422, this._$34420[2]);
            preferencesPanel.addItem(this._$34423, this._$34420[2]);
            serializable2 = new ArrayList();
            serializable = new ArrayList<String>();
            this._$34431((List<String>)((Object)serializable2), (List<String>)((Object)serializable));
            this._$34424 = new TlsAcceptedDN((List<String>)((Object)serializable2), TlsAcceptedDN.DnType.SubjectDN);
            this._$34425 = new TlsAcceptedDN((List<String>)((Object)serializable), TlsAcceptedDN.DnType.IssuerDN);
            preferencesPanel.addItem(this._$34424, this._$34420[2]);
            preferencesPanel.addItem(this._$34425, this._$34420[2]);
        }
        serializable2 = new TrapReceiverSettings();
        preferencesPanel.addItem((PreferencesItem)((Object)serializable2), null);
        preferencesPanel.addItem(new TrapPriorities(this._$20550, this._$34427), (PreferencesItem)((Object)serializable2));
        preferencesPanel.addItem(this._$34421[0], (PreferencesItem)((Object)serializable2));
        preferencesPanel.addItem(this._$34421[1], (PreferencesItem)((Object)serializable2));
        if (this._$34427) {
            preferencesPanel.addItem(this._$34421[2], (PreferencesItem)((Object)serializable2));
        }
        serializable = new ViewSettings();
        preferencesPanel.addItem((PreferencesItem)((Object)serializable), null);
        preferencesPanel.addItem(new LookAndFeelSettings(), (PreferencesItem)((Object)serializable));
        if (this._$34427) {
            MonitorSettings monitorSettings = new MonitorSettings();
            JdbcDriverRegistration jdbcDriverRegistration = new JdbcDriverRegistration(this._$14341);
            preferencesPanel.addItem(monitorSettings, null);
            preferencesPanel.addItem(jdbcDriverRegistration, monitorSettings);
        }
        preferencesPanel.load(this._$5250);
        preferencesPanel.setSelectedItem((PreferencesItem)((Object)jPanel));
        return preferencesPanel;
    }

    private void _$34431(List<String> list, List<String> list2) {
        FileInputStream fileInputStream = null;
        try {
            KeyStore keyStore = KeyStore.getInstance("JKS");
            String string = this._$34422.getKeyStore();
            if (string == null) {
                return;
            }
            fileInputStream = new FileInputStream(string);
            keyStore.load(fileInputStream, this._$34422.getKeyStorePassword() != null ? this._$34422.getKeyStorePassword().toCharArray() : null);
            Enumeration<String> enumeration = keyStore.aliases();
            while (enumeration.hasMoreElements()) {
                String string2 = enumeration.nextElement();
                Certificate certificate = keyStore.getCertificate(string2);
                if (!(certificate instanceof X509Certificate)) continue;
                X509Certificate x509Certificate = (X509Certificate)certificate;
                Principal principal = x509Certificate.getSubjectDN();
                if (principal != null) {
                    list.add(principal.getName());
                }
                if ((principal = x509Certificate.getIssuerDN()) == null) continue;
                list2.add(principal.getName());
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (CertificateException certificateException) {
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (IOException iOException) {
        }
        catch (KeyStoreException keyStoreException) {
            // empty catch block
        }
    }

    public boolean initTransportMappings(JFrame jFrame) {
        int n2;
        this.getTransportAddresses();
        boolean bl = false;
        if (this._$34419 == null) {
            this._$34419 = new TransportMapping[TRANSPORT_TYPES.length];
            for (n2 = 0; n2 < TRANSPORT_TYPES.length; ++n2) {
                if (this._$34418[n2] == null) continue;
                try {
                    this._$34419[n2] = this._$34447(n2);
                    this._$14889.addTransportMapping(this._$34419[n2]);
                    this._$34419[n2].listen();
                    bl = true;
                    continue;
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(jFrame, new String[]{"Could not bind transport address '" + this._$34418[0] + "."}, "Binding Error", 0);
                }
            }
        }
        if (this._$34426 == null) {
            this._$34426 = new Vector[TRANSPORT_TYPES.length];
            for (n2 = 0; n2 < TRANSPORT_TYPES.length; ++n2) {
                this._$34426[n2] = ListenTransportConfig.getAddresses(this._$5250, TRANSPORT_TYPES[n2]);
                Vector<Address> vector = new Vector<Address>();
                for (int i2 = 0; i2 < this._$34426[n2].size(); ++i2) {
                    String string = (String)this._$34426[n2].get(i2);
                    try {
                        Address address = GenericAddress.parse(string);
                        if (address == null || !this._$14889.addNotificationListener(address, new TrapSelector(address.toString(), this._$31253))) continue;
                        vector.add(address);
                        continue;
                    }
                    catch (Exception exception) {
                        JOptionPane.showMessageDialog(jFrame, new String[]{"Could not bind transport address '" + string + "."}, "Binding Error", 0);
                    }
                }
                this._$34426[n2] = vector;
            }
        }
        return bl;
    }

    private TransportMapping _$34447(int n2) throws IOException {
        AbstractTransportMapping abstractTransportMapping = null;
        switch (n2) {
            case 0: {
                abstractTransportMapping = new DefaultUdpTransportMapping((UdpAddress)this._$34418[n2]);
                TransportSettings cfr_ignored_0 = this._$34420[n2];
                ((DefaultUdpTransportMapping)abstractTransportMapping).setMaxInboundMessageSize(TransportSettings.getMaxInboundBufferSize(this._$5250, TRANSPORT_TYPES[n2]));
                break;
            }
            case 1: {
                abstractTransportMapping = new DefaultTcpTransportMapping((TcpAddress)this._$34418[n2]);
                TransportSettings cfr_ignored_1 = this._$34420[n2];
                ((DefaultTcpTransportMapping)abstractTransportMapping).setMaxInboundMessageSize(TransportSettings.getMaxInboundBufferSize(this._$5250, TRANSPORT_TYPES[n2]));
                break;
            }
            case 2: {
                List<String> list;
                List<String> list2;
                Object object;
                Object object2;
                TLSTM tLSTM = new TLSTM((TlsAddress)this._$34418[n2]);
                TransportSettings cfr_ignored_2 = this._$34420[n2];
                tLSTM.setMaxInboundMessageSize(Math.min(TransportSettings.getMaxInboundBufferSize(this._$5250, TRANSPORT_TYPES[n2]), tLSTM.getMaxInboundMessageSize()));
                try {
                    if (Class.forName("javax.net.ssl.X509ExtendedTrustManager") != null) {
                        object2 = Class.forName("org.snmp4j.transport.tls.TLSTMExtendedTrustManagerFactory");
                        object = ((Class)object2).getConstructors()[0];
                        list2 = (TLSTM.TLSTMTrustManagerFactory)((Constructor)object).newInstance(tLSTM);
                        tLSTM.setTrustManagerFactory((TLSTM.TLSTMTrustManagerFactory)((Object)list2));
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    invocationTargetException.printStackTrace();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    illegalArgumentException.printStackTrace();
                }
                catch (IllegalAccessException illegalAccessException) {
                    illegalAccessException.printStackTrace();
                }
                catch (InstantiationException instantiationException) {
                    instantiationException.printStackTrace();
                }
                object2 = new DefaultTlsTmSecurityCallback();
                this._$34423.loadProperties(this._$5250);
                this._$34424.loadProperties(this._$5250);
                this._$34425.loadProperties(this._$5250);
                object = this._$34423.getMappings();
                list2 = object.iterator();
                while (list2.hasNext()) {
                    list = (SecurityNameMapping)list2.next();
                    ((DefaultTlsTmSecurityCallback)object2).addSecurityNameMapping(((SecurityNameMapping)((Object)list)).getFingerprint(), ((SecurityNameMapping)((Object)list)).getType(), ((SecurityNameMapping)((Object)list)).getData(), ((SecurityNameMapping)((Object)list)).getSecurityName());
                }
                list2 = this._$34424.getDN();
                for (String object3 : list2) {
                    ((DefaultTlsTmSecurityCallback)object2).addAcceptedSubjectDN(object3);
                }
                list = this._$34425.getDN();
                for (String string : list) {
                    ((DefaultTlsTmSecurityCallback)object2).addAcceptedIssuerDN(string);
                }
                tLSTM.setSecurityCallback((TlsTmSecurityCallback<X509Certificate>)object2);
                tLSTM.setKeyStore(this._$34422.getKeyStore());
                tLSTM.setKeyStorePassword(this._$34422.getKeyStorePassword());
                if (this._$34422.getTlsVersion() != null) {
                    tLSTM.setTlsProtocols(new String[]{this._$34422.getTlsVersion()});
                }
                abstractTransportMapping = tLSTM;
                break;
            }
        }
        return abstractTransportMapping;
    }

    private Address _$34467(String string) {
        Address address = TransportSettings.getAddress(this._$5250, string);
        if (address == null) {
            address = GenericAddress.parse(string + ":0.0.0.0/0");
        }
        return address;
    }

    public TransportIpAddress[] getTransportAddresses() {
        if (this._$34418 == null) {
            this._$34418 = new TransportIpAddress[TRANSPORT_TYPES.length];
            boolean bl = false;
            for (int i2 = 0; i2 < TRANSPORT_TYPES.length; ++i2) {
                this._$34418[i2] = TransportSettings.getAddress(this._$5250, TRANSPORT_TYPES[i2]);
                if (this._$34418[i2] == null) continue;
                bl = true;
            }
            if (!bl && !this._$5250.getBoolean("mibexplorer.transport.configured.", false)) {
                this._$5250.put("mibexplorer.transport.address." + TRANSPORT_TYPES[0], "0.0.0.0/0");
                this._$34418[0] = new UdpAddress("0.0.0.0/0");
            }
        }
        return this._$34418;
    }

    @Override
    public void transportAddressChanged(TransportChangeEvent transportChangeEvent) {
        Address address = transportChangeEvent.getAddress();
        transportChangeEvent.setAccepted(true);
        for (int i2 = 0; i2 < TRANSPORT_TYPES.length; ++i2) {
            if (!TRANSPORT_TYPES[i2].equals(transportChangeEvent.getAddressType())) continue;
            if (transportChangeEvent.getSource() instanceof TransportSettings) {
                this._$34469(transportChangeEvent, address, i2);
                continue;
            }
            if (!(transportChangeEvent.getSource() instanceof ListenTransportConfig)) continue;
            if (transportChangeEvent.getEventType() == 3) {
                if (this._$34426[i2].contains(transportChangeEvent.getAddress())) continue;
                transportChangeEvent.setAccepted(false);
                break;
            }
            this._$34470(transportChangeEvent, address, i2);
        }
    }

    private void _$34470(TransportChangeEvent transportChangeEvent, Address address, int n2) {
        switch (transportChangeEvent.getEventType()) {
            case 2: {
                transportChangeEvent.setAccepted(this._$14889.removeNotificationListener(address));
                this._$34426[n2].remove(transportChangeEvent.getAddress());
                break;
            }
            case 1: {
                transportChangeEvent.setAccepted(this._$14889.addNotificationListener(address, new TrapSelector(address.toString(), this._$31253)));
                if (!transportChangeEvent.isAccepted()) break;
                this._$34426[n2].add(transportChangeEvent.getAddress());
                break;
            }
            default: {
                transportChangeEvent.setAccepted(false);
            }
        }
    }

    public void enableTransport(String string) throws IOException {
        for (int i2 = 0; i2 < TRANSPORT_TYPES.length; ++i2) {
            if (!TRANSPORT_TYPES[i2].equals(string.toLowerCase())) continue;
            this._$34418[i2] = (TransportIpAddress)this._$34467(string);
            TransportMapping transportMapping = this._$34447(i2);
            this._$14889.addTransportMapping(transportMapping);
            transportMapping.listen();
            this._$5250.put("mibexplorer.transport.address." + string, this._$34418[i2].toString());
        }
    }

    private void _$34469(TransportChangeEvent transportChangeEvent, Address address, int n2) {
        if (address == null || transportChangeEvent.getEventType() == 2) {
            if (this._$34419[n2] != null) {
                this._$14889.removeTransportMapping(this._$34419[n2]);
                try {
                    this._$34419[n2].close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this._$34419[n2] = null;
            }
            return;
        }
        TransportIpAddress transportIpAddress = this._$34418[n2];
        if (transportIpAddress != null && transportIpAddress.equals(address)) {
            return;
        }
        this._$34418[n2] = (TransportIpAddress)address;
        try {
            TransportMapping transportMapping;
            if (this._$34419[n2] != null) {
                this._$14889.removeTransportMapping(this._$34419[n2]);
                this._$34419[n2].close();
            }
            this._$34419[n2] = transportMapping = this._$34447(n2);
            this._$14889.addTransportMapping(transportMapping);
            transportMapping.listen();
            transportChangeEvent.setAccepted(true);
        }
        catch (IOException iOException) {
            this._$34418[n2] = transportIpAddress;
            try {
                this._$34419[n2] = this._$34447(n2);
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            transportChangeEvent.setAccepted(false);
        }
    }

    private void _$34428() {
        this._$31188.setMaxErrors(this._$5250.getInteger("mibexplorer.compile.maxerrors", 20));
        this._$31188.setUseCompression(this._$5250.getBoolean("mibexplorer.compile.usecompression", true));
    }
}

