/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.explorer.cfg;

import com.agentpp.common.TableSorter;
import com.agentpp.common.table.FlexListTable;
import com.agentpp.common.table.TableUtils;
import com.agentpp.explorer.cfg.TransportChangeEvent;
import com.agentpp.explorer.cfg.TransportChangeListener;
import com.agentpp.explorer.traps.NewAddressPanel;
import com.borland.jbcl.layout.VerticalFlowLayout;
import com.klg.jclass.table.JCCellDisplayEvent;
import com.klg.jclass.table.JCCellDisplayListener;
import com.klg.jclass.table.JCCellRange;
import com.klg.jclass.table.JCSelectEvent;
import com.klg.jclass.table.JCSelectListener;
import com.klg.jclass.table.JCTable;
import com.klg.jclass.table.data.JCVectorDataSource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.snmp4j.smi.GenericAddress;

public class ListenTransportAddresses
extends JPanel
implements JCCellDisplayListener,
JCSelectListener {
    JCTable table = new FlexListTable();
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanelButtons = new JPanel();
    JButton jButtonAdd = new JButton();
    JButton jButtonRemove = new JButton();
    private JCVectorDataSource _$11754;
    private TableSorter _$5245;
    VerticalFlowLayout verticalFlowLayout1 = new VerticalFlowLayout();
    Border border2;
    private String _$14602 = "udp";
    transient Vector transportChangeListeners = new Vector(2);

    public ListenTransportAddresses() {
        this.init();
        try {
            this._$5265();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.table.addSelectListener(this);
        this.table.addCellDisplayListener(this);
    }

    public void init() {
        this._$11754 = new JCVectorDataSource();
        this._$11754.setNumColumns(2);
        this._$11754.setColumnLabel(0, "Listen Address");
        this._$11754.setColumnLabel(1, "Status");
        this._$5245 = new TableSorter(this.table, this._$11754);
        this.table.setDataSource(this._$11754);
        this.table.setRowHidden(0, true);
        this.table.setFrozenRows(1);
        this.table.setPixelWidth(-998, 33001);
        this.table.setVisibleColumns(-999);
        this.table.setVisibleRows(5);
        this.table.setRowLabelDisplay(false);
        this.table.setColumnLabelDisplay(true);
        this.table.setResizeEven(true);
        this.table.setSelectionPolicy(2);
        this._$14354();
    }

    private void _$5265() throws Exception {
        this.border2 = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        this.setLayout(this.borderLayout1);
        this.jButtonAdd.setText("Add");
        this.jButtonAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ListenTransportAddresses.this.jButtonAdd_actionPerformed(actionEvent);
            }
        });
        this.jButtonRemove.setText("Remove");
        this.jButtonRemove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ListenTransportAddresses.this.jButtonRemove_actionPerformed(actionEvent);
            }
        });
        this.jPanelButtons.setLayout(this.verticalFlowLayout1);
        this.verticalFlowLayout1.setHgap(10);
        this.verticalFlowLayout1.setVgap(10);
        this.jPanelButtons.setBorder(this.border2);
        this.setBorder(null);
        this.add((Component)this.table, "Center");
        this.add((Component)this.jPanelButtons, "East");
        this.jPanelButtons.add((Component)this.jButtonAdd, null);
        this.jPanelButtons.add((Component)this.jButtonRemove, null);
    }

    void jButtonAdd_actionPerformed(ActionEvent actionEvent) {
        NewAddressPanel newAddressPanel = new NewAddressPanel();
        if (JOptionPane.showOptionDialog(this, newAddressPanel, "New " + this._$14602 + " Listen Address", 2, -1, null, new String[]{"Add", "Cancel"}, "Add") == 0) {
            Vector<Object> vector = new Vector<Object>(2);
            String string = newAddressPanel.getAddress();
            if (string == null) {
                return;
            }
            try {
                string = this._$14602 + ":" + string.substring(string.indexOf("/") + 1) + "/" + newAddressPanel.getPort();
                for (int i2 = 1; i2 < this._$11754.getNumRows(); ++i2) {
                    if (!this._$11754.getTableDataItem(i2, 0).equals(string)) continue;
                    String[] stringArray = new String[]{"Address " + string + " is already configured!"};
                    JOptionPane.showMessageDialog(this, stringArray, "Duplicate Address", 0);
                    return;
                }
                TransportChangeEvent transportChangeEvent = new TransportChangeEvent(this, GenericAddress.parse(string), this._$14602, 1);
                this.fireTransportAddressChanged(transportChangeEvent);
                Boolean bl = new Boolean(transportChangeEvent.isAccepted());
                vector.addElement(string);
                vector.addElement(bl);
                this._$11754.addRow(Integer.MAX_VALUE, null, vector);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this._$14354();
    }

    void jButtonRemove_actionPerformed(ActionEvent actionEvent) {
        Collection collection = this.table.getSelectedCells();
        if (collection == null) {
            return;
        }
        for (JCCellRange jCCellRange : collection) {
            TableUtils.setRangeAfterCopy(jCCellRange);
            for (int i2 = jCCellRange.start_row; i2 <= jCCellRange.end_row; ++i2) {
                String string = this._$11754.getTableDataItem(i2, 0).toString();
                TransportChangeEvent transportChangeEvent = new TransportChangeEvent(this, GenericAddress.parse(string), this._$14602, 2);
                this.fireTransportAddressChanged(transportChangeEvent);
            }
            this._$11754.deleteRows(jCCellRange.start_row, jCCellRange.end_row - jCCellRange.start_row + 1);
        }
        this._$14354();
    }

    public Vector getAddresses() {
        Vector<Object> vector = new Vector<Object>();
        for (int i2 = 1; i2 < this._$11754.getNumRows(); ++i2) {
            vector.addElement(this._$11754.getTableDataItem(i2, 0));
        }
        return vector;
    }

    public void setAddresses(final Vector vector) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ListenTransportAddresses.this._$11754.setNumRows(0);
                ListenTransportAddresses.this._$11754.addRow(Integer.MAX_VALUE, null, null);
                for (int i2 = 0; i2 < vector.size(); ++i2) {
                    Vector vector2 = new Vector(2);
                    vector2.add(vector.get(i2));
                    TransportChangeEvent transportChangeEvent = new TransportChangeEvent(this, GenericAddress.parse((String)vector.get(i2)), ListenTransportAddresses.this._$14602, 3);
                    ListenTransportAddresses.this.fireTransportAddressChanged(transportChangeEvent);
                    vector2.add(new Boolean(transportChangeEvent.isAccepted()));
                    ListenTransportAddresses.this._$11754.addRow(Integer.MAX_VALUE, null, vector2);
                }
            }
        });
    }

    public void cellDisplay(JCCellDisplayEvent jCCellDisplayEvent) {
        if (jCCellDisplayEvent.getCellData() instanceof Boolean) {
            if (((Boolean)jCCellDisplayEvent.getCellData()).booleanValue()) {
                jCCellDisplayEvent.setDisplayData("Active");
            } else {
                jCCellDisplayEvent.setDisplayData("Unavailable");
            }
        }
    }

    public void beforeSelect(JCSelectEvent jCSelectEvent) {
        if (jCSelectEvent.getStartRow() == 0) {
            jCSelectEvent.setCancelled(true);
        }
    }

    public void afterSelect(JCSelectEvent jCSelectEvent) {
        this._$14354();
    }

    public void select(JCSelectEvent jCSelectEvent) {
    }

    private void _$14354() {
        this.jButtonRemove.setEnabled(this.table.getSelectedCells() != null && this._$11754.getNumRows() > 1);
    }

    public void setAddressType(String string) {
        this._$14602 = string;
    }

    public String getAddressType() {
        return this._$14602;
    }

    public synchronized void addTransportChangeListener(TransportChangeListener transportChangeListener) {
        this.transportChangeListeners.add(transportChangeListener);
    }

    public synchronized void removeTransportChangeListener(TransportChangeListener transportChangeListener) {
        this.transportChangeListeners.remove(transportChangeListener);
    }

    protected void fireTransportAddressChanged(TransportChangeEvent transportChangeEvent) {
        if (this.transportChangeListeners != null) {
            Vector vector = this.transportChangeListeners;
            int n2 = vector.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                ((TransportChangeListener)vector.elementAt(i2)).transportAddressChanged(transportChangeEvent);
            }
        }
    }
}

