/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.explorer.cfg;

import com.agentpp.common.FilePanel;
import com.agentpp.common.PreferencesItem;
import com.agentpp.explorer.cfg.HttpServerSettings_enableHTTPServer_itemAdapter;
import com.agentpp.util.UserConfigFile;
import com.klg.jclass.field.DataProperties;
import com.klg.jclass.field.JCInvalidInfo;
import com.klg.jclass.field.JCSpinField;
import com.klg.jclass.field.validate.JCIntegerValidator;
import com.klg.jclass.util.value.MutableValueModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class HttpServerSettings
extends JPanel
implements PreferencesItem {
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JCheckBox enableHTTPServer = new JCheckBox();
    JLabel jLabelPort = new JLabel();
    JCSpinField serverPort = new JCSpinField();
    FilePanel serverDirectory = new FilePanel();
    JLabel jLabel1 = new JLabel();
    JCheckBox dataEnabled = new JCheckBox();
    JCheckBox chartEnabled = new JCheckBox();
    JLabel jLabelDataTemplate = new JLabel();
    FilePanel dataTemplate = new FilePanel();
    JLabel jLabelScriptPath = new JLabel();
    FilePanel scriptDirectory = new FilePanel();
    JCheckBox scriptEnabled = new JCheckBox();

    public HttpServerSettings() {
        try {
            this._$5265();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void _$5265() throws Exception {
        this.setLayout(this.gridBagLayout1);
        this.enableHTTPServer.setToolTipText("Enables the built-in HTTP Server");
        this.enableHTTPServer.setText("Enable HTTP Server");
        this.enableHTTPServer.addItemListener(new HttpServerSettings_enableHTTPServer_itemAdapter(this));
        this.jLabelPort.setText("HTTP Server Port:");
        this.serverDirectory.setLabelText(null);
        this.serverDirectory.setToolTipText("The resource directory where static content for the HTTP server is located. If empty static content is disabled");
        this.jLabel1.setText("HTTP Server Content Directory:");
        this.dataEnabled.setToolTipText("Enable monitor data servlet");
        this.dataEnabled.setText("Data Servlet");
        this.chartEnabled.setText("Chart Servlet");
        this.jLabelDataTemplate.setText("Monitor Data Template:");
        this.jLabelScriptPath.setText("Script Directory:");
        this.scriptEnabled.setToolTipText("Enables the servlet for running MIB Explorer scripts to generate HTML output");
        this.scriptEnabled.setText("Script Servlet");
        this.add((Component)this.jLabelPort, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.enableHTTPServer, new GridBagConstraints(0, 0, 1, 2, 0.0, 0.0, 18, 2, new Insets(10, 10, 10, 0), 0, 0));
        this.add((Component)this.serverDirectory, new GridBagConstraints(1, 3, 3, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.jLabel1, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.jLabelDataTemplate, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.jLabelScriptPath, new GridBagConstraints(0, 5, 1, 1, 0.0, 1.0, 18, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.dataEnabled, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 10, 10, 0), 0, 0));
        this.add((Component)this.scriptEnabled, new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 10, 2, new Insets(5, 10, 10, 10), 0, 0));
        this.add((Component)this.chartEnabled, new GridBagConstraints(2, 0, 2, 1, 1.0, 0.0, 17, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.dataTemplate, new GridBagConstraints(1, 4, 3, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.scriptDirectory, new GridBagConstraints(1, 5, 3, 1, 1.0, 1.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.serverPort, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 10, 5, 10), 0, 0));
        this.serverPort.setDataProperties(new DataProperties(new JCIntegerValidator(null, new Integer(1), new Integer(65535), null, false, null, new Integer(1), "#,##0.###;-#,##0.###", false, false, false, null, new Integer(1)), new MutableValueModel(Integer.class, null), new JCInvalidInfo(true, 1, new Color(0, 0, 0, 255), new Color(255, 255, 255, 255))));
        this.serverDirectory.setSelectionMode(1);
        this.dataTemplate.setPathTextEnabled(true);
        this.dataTemplate.setLabelText(null);
        this.scriptDirectory.setLabelText(null);
        this.scriptDirectory.setSelectionMode(1);
    }

    public JPanel getPanel() {
        return this;
    }

    public String getShortTitle() {
        return "HTTP Server Settings";
    }

    public String getTitle() {
        return "HTTP-Server";
    }

    public String getDescription() {
        return "MIB Explorer's built-in HTTP server can be used to remotely access monitor data and charts, static content, and run scripts to produce while MIB Explorer or MIB Explorer Server is running. The HTTP server has three built-in servlets that dynamically generate chart images, data HTML for all running (loaded) monitors, and run scripts. The servlets can be individually enabled.\n\nBy providing a 'content directory' its content can be accessed under the 'html' root context. By leaving the 'content directory' empty, no static content is served.";
    }

    public String getTooltip() {
        return "";
    }

    public void saveProperties(UserConfigFile userConfigFile) {
        userConfigFile.putBoolean("mibexplorer.http.server.enabled", this.enableHTTPServer.isSelected());
        userConfigFile.putBoolean("mibexplorer.http.server.chart.enabled", this.chartEnabled.isSelected());
        userConfigFile.putBoolean("mibexplorer.http.server.data.enabled", this.dataEnabled.isSelected());
        userConfigFile.putBoolean("mibexplorer.http.server.script.enabled", this.scriptEnabled.isSelected());
        userConfigFile.put("mibexplorer.http.server.dir", this.serverDirectory.getPath());
        userConfigFile.put("mibexplorer.http.server.script.dir", this.scriptDirectory.getPath());
        userConfigFile.put("mibexplorer.http.server.data.template", this.dataTemplate.getPath());
        userConfigFile.putInteger("mibexplorer.http.server.port", ((Number)this.serverPort.getValue()).intValue());
    }

    public boolean isOK() {
        return true;
    }

    public void loadProperties(UserConfigFile userConfigFile) {
        this.enableHTTPServer.setSelected(userConfigFile.getBoolean("mibexplorer.http.server.enabled", false));
        this.chartEnabled.setSelected(userConfigFile.getBoolean("mibexplorer.http.server.chart.enabled", false));
        this.dataEnabled.setSelected(userConfigFile.getBoolean("mibexplorer.http.server.data.enabled", false));
        this.scriptEnabled.setSelected(userConfigFile.getBoolean("mibexplorer.http.server.script.enabled", false));
        this.serverDirectory.setPath(userConfigFile.get("mibexplorer.http.server.dir", ""));
        this.scriptDirectory.setPath(userConfigFile.get("mibexplorer.http.server.script.dir", ""));
        this.dataTemplate.setPath(userConfigFile.get("mibexplorer.http.server.data.template", ""));
        this.serverPort.setValue(new Integer(userConfigFile.getInteger("mibexplorer.http.server.port", 8080)));
        this._$44741(this.enableHTTPServer.isSelected());
    }

    public void enableHTTPServer_itemStateChanged(ItemEvent itemEvent) {
        boolean bl = itemEvent.getStateChange() == 1;
        this._$44741(bl);
    }

    private void _$44741(boolean bl) {
        this.dataEnabled.setEnabled(bl);
        this.chartEnabled.setEnabled(bl);
        this.scriptEnabled.setEnabled(bl);
        this.serverDirectory.setEnabled(bl);
        this.serverPort.setEnabled(bl);
        this.scriptDirectory.setEnabled(bl);
        this.dataTemplate.setEnabled(bl);
    }
}

