/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.explorer.ber;

import com.agentpp.common.FilePanel;
import com.agentpp.common.StringInputPanel;
import com.agentpp.common.TableSorter;
import com.agentpp.common.table.ExtendedListTable;
import com.agentpp.common.table.TableUtils;
import com.agentpp.explorer.MIBExplorerFrame;
import com.agentpp.explorer.ToolPanelPlugin;
import com.agentpp.explorer.ber.BERLogPanel_analyzeTextFile_actionAdapter;
import com.agentpp.explorer.ber.BERLogPanel_buttonEnable_itemAdapter;
import com.agentpp.explorer.ber.BERLogPanel_clearLog_actionAdapter;
import com.agentpp.explorer.ber.BERLogPanel_insertPacket_actionAdapter;
import com.agentpp.explorer.ber.BERLogPanel_openCaptureFile_actionAdapter;
import com.agentpp.explorer.ber.BERLogPanel_saveCaptureFile_actionAdapter;
import com.agentpp.explorer.ber.BERNode;
import com.agentpp.explorer.ber.BERTreeBuilder;
import com.agentpp.explorer.ber.BERTreeCellRenderer;
import com.agentpp.explorer.editors.OctetTextField;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.ObjectID;
import com.agentpp.mib.event.MIBObjectEvent;
import com.agentpp.mib.event.MIBObjectListener;
import com.agentpp.snmp.GenTarget;
import com.agentpp.util.ExampleFileFilter;
import com.agentpp.util.UserConfigFile;
import com.borland.jbcl.layout.VerticalFlowLayout;
import com.klg.jclass.table.JCCellDisplayEvent;
import com.klg.jclass.table.JCCellDisplayListener;
import com.klg.jclass.table.JCSelectEvent;
import com.klg.jclass.table.JCSelectListener;
import com.klg.jclass.table.data.JCVectorDataSource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.dom4j.DocumentFactory;
import org.dom4j.QName;
import org.dom4j.dom.DOMAttribute;
import org.dom4j.dom.DOMDocument;
import org.dom4j.dom.DOMDocumentFactory;
import org.dom4j.dom.DOMElement;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.snmp4j.TransportMapping;
import org.snmp4j.TransportStateReference;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TcpAddress;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.transport.TransportListener;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class BERLogPanel
extends JPanel
implements ToolPanelPlugin,
TransportListener,
JCSelectListener,
JCCellDisplayListener,
TreeSelectionListener,
ClipboardOwner {
    private static final String[] _$29657 = new String[]{"Transport", "Source", "Destination", "Size", "Message"};
    private static final int[] _$29658 = new int[]{6, 15, 15, 4};
    private static String _$29659 = "yyyy-MM-dd HH:mm:ss.SSS";
    private static final String _$29660 = "TCP";
    private static final String _$29661 = "UDP";
    private SimpleDateFormat _$20916 = new SimpleDateFormat(_$29659);
    private SimpleDateFormat _$29662 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
    private static final int _$29663 = 0;
    private static final int _$29664 = 1;
    private static final int _$15175 = 2;
    private static final int _$29665 = 4;
    BorderLayout borderLayout1 = new BorderLayout();
    BorderLayout borderLayoutText = new BorderLayout();
    JSplitPane jSplitPane1 = new JSplitPane();
    ExtendedListTable logTable = new ExtendedListTable();
    JSplitPane splitPaneMessage = new JSplitPane();
    JTextPane messageContent = new JTextPane();
    JScrollPane treeScrollPane = new JScrollPane();
    JScrollPane textScrollPane = new JScrollPane();
    JTree tree = new JTree();
    JPanel textPanel = new JPanel();
    TableSorter tableSorter;
    BERTreeCellRenderer cellRenderer = new BERTreeCellRenderer();
    private BERTreeBuilder _$29676 = new BERTreeBuilder();
    private boolean _$10360;
    private UserConfigFile _$5250;
    JCVectorDataSource logModel = new JCVectorDataSource();
    JPanel buttonPanel = new JPanel();
    DecimalFormat indexFormat = new DecimalFormat("000000");
    JToggleButton buttonEnable = new JToggleButton();
    JButton openCaptureFile = new JButton();
    VerticalFlowLayout verticalFlowLayout1 = new VerticalFlowLayout();
    JButton saveCaptureFile = new JButton();
    JButton clearLog = new JButton();
    JButton insertPacket = new JButton();
    JButton analyzeTextFile = new JButton();
    private boolean _$29686 = false;
    private RowAppender _$29688 = new RowAppender();
    private List<MIBObjectListener> _$29689 = new ArrayList<MIBObjectListener>(2);
    Clipboard systemClipboard = this.getToolkit().getSystemClipboard();

    public BERLogPanel() {
        try {
            this._$5265();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.logModel.setNumColumns(_$29657.length);
        this.logModel.setNumRows(0);
        this.logModel.setColumnLabels(_$29657);
        this.logTable.setDataSource(this.logModel);
        this.logTable.addCellDisplayListener(this);
        this.logTable.addSelectListener(this);
        this.logTable.setCharWidth(-1, 14);
        this.logTable.setPopupMenuEnabled(true);
        this.logTable.getPopupMenu().add(new RemoveAction("Remove Selected"));
        this.tree.addTreeSelectionListener(this);
        this.tree.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                TreePath treePath;
                if (mouseEvent.getClickCount() == 2 && (treePath = BERLogPanel.this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY())) != null) {
                    BERNode bERNode;
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                    DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)BERLogPanel.this.tree.getModel().getRoot();
                    if (defaultMutableTreeNode.getUserObject() instanceof BERNode && (bERNode = (BERNode)defaultMutableTreeNode.getUserObject()).getData() != null) {
                        BERLogPanel.this._$29694(((Object)bERNode.getData()).toString());
                    }
                }
            }

            public void mousePressed(MouseEvent mouseEvent) {
            }
        });
        this._$29695();
        this.buttonEnable.setSelected(false);
        this.tableSorter = new TableSorter(this.logTable, this.logModel);
        for (int i2 = 0; i2 < _$29658.length; ++i2) {
            this.logTable.setCharWidth(i2, _$29658[i2]);
        }
    }

    public BERLogPanel(UserConfigFile userConfigFile, boolean bl) {
        this();
        this._$5250 = userConfigFile;
        this._$29686 = bl;
        this._$29676.setDecryptPDUs(this._$29686);
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    private void _$29695() {
        this.tree.setModel(new DefaultTreeModel(new DefaultMutableTreeNode("No Packet Selected", false)));
    }

    private void _$5265() throws Exception {
        this.setLayout(this.borderLayout1);
        this.jSplitPane1.setOrientation(0);
        this.splitPaneMessage.setLeftComponent(this.treeScrollPane);
        this.splitPaneMessage.setOneTouchExpandable(true);
        this.messageContent.setFont(new Font("Monospaced", 0, 11));
        this.messageContent.setToolTipText("Displays selected SNMP message in HEX format - Octets represented by selected ASN.1 tree node are highlighted");
        this.tree.setToolTipText("ASN.1 (BER) Tree");
        this.logTable.setToolTipText("Select a message to show in ASN.1/BER tree panel");
        this.buttonEnable.setToolTipText("Capture SNMP packets received and sent in the packet log");
        this.buttonEnable.setHorizontalAlignment(2);
        this.buttonEnable.setText("Capture Packets");
        this.buttonEnable.addItemListener(new BERLogPanel_buttonEnable_itemAdapter(this));
        this.openCaptureFile.setToolTipText("Open capture file and replace log contents with file contents");
        this.openCaptureFile.setHorizontalAlignment(2);
        this.openCaptureFile.setText("Open...");
        this.openCaptureFile.setIcon(MIBExplorerFrame.imageOpen16);
        this.openCaptureFile.addActionListener(new BERLogPanel_openCaptureFile_actionAdapter(this));
        this.buttonPanel.setLayout(this.verticalFlowLayout1);
        this.saveCaptureFile.setToolTipText("Save captured packets into a XML file");
        this.saveCaptureFile.setHorizontalAlignment(2);
        this.saveCaptureFile.setIcon(MIBExplorerFrame.imageSaveAs16);
        this.saveCaptureFile.setText("Save as...");
        this.saveCaptureFile.addActionListener(new BERLogPanel_saveCaptureFile_actionAdapter(this));
        this.clearLog.setHorizontalAlignment(2);
        this.clearLog.setText("Clear");
        this.clearLog.setIcon(MIBExplorerFrame.imageDelete16);
        this.clearLog.addActionListener(new BERLogPanel_clearLog_actionAdapter(this));
        this.insertPacket.setHorizontalAlignment(2);
        this.insertPacket.setText("Analyse...");
        this.insertPacket.setIcon(MIBExplorerFrame.imageInfo16);
        this.insertPacket.setToolTipText("Analyse a SNMP message by entering their bytes");
        this.insertPacket.addActionListener(new BERLogPanel_insertPacket_actionAdapter(this));
        this.analyzeTextFile.setHorizontalAlignment(2);
        this.analyzeTextFile.setText("Analyse Log...");
        this.analyzeTextFile.setIcon(MIBExplorerFrame.imageInfo16);
        this.analyzeTextFile.setToolTipText("Analyse all SNMP message found as hex string in a text (log) file");
        this.analyzeTextFile.addActionListener(new BERLogPanel_analyzeTextFile_actionAdapter(this));
        this.add((Component)this.jSplitPane1, "Center");
        this.jSplitPane1.add((Component)this.logTable, "left");
        this.jSplitPane1.add((Component)this.splitPaneMessage, "right");
        this.jSplitPane1.setOneTouchExpandable(true);
        this.splitPaneMessage.add((Component)this.textScrollPane, "bottom");
        this.splitPaneMessage.add((Component)this.treeScrollPane, "top");
        this.treeScrollPane.getViewport().add(this.tree);
        this.textScrollPane.getViewport().add(this.textPanel);
        this.textPanel.setLayout(this.borderLayoutText);
        this.textPanel.add((Component)this.messageContent, "Center");
        this.add((Component)this.buttonPanel, "West");
        this.buttonPanel.add(this.buttonEnable);
        this.buttonPanel.add(this.clearLog);
        this.buttonPanel.add(this.openCaptureFile);
        this.buttonPanel.add(this.saveCaptureFile);
        this.buttonPanel.add(this.insertPacket);
        this.buttonPanel.add(this.analyzeTextFile);
        this.messageContent.setEditable(false);
        this.tree.setCellRenderer(this.cellRenderer);
    }

    public void initDividerLocations() {
        this.splitPaneMessage.setDividerLocation(0.4);
        this.jSplitPane1.setDividerLocation(0.5);
    }

    public void addMIBObjectListener(MIBObjectListener mIBObjectListener) {
        this._$29689.add(mIBObjectListener);
    }

    public void removeMIBObjectListener(MIBObjectListener mIBObjectListener) {
        this._$29689.remove(mIBObjectListener);
    }

    public void fireMIBObjectEvent(MIBObjectEvent mIBObjectEvent) {
        for (MIBObjectListener mIBObjectListener : this._$29689) {
            mIBObjectListener.changedMIBObject(mIBObjectEvent);
        }
    }

    public synchronized void addEntry(Address address, Address address2, byte[] byArray) {
        Vector<Object> vector = new Vector<Object>(_$29657.length);
        if (address instanceof TcpAddress) {
            vector.add(_$29660);
        } else {
            vector.add(_$29661);
        }
        vector.add(address);
        vector.add(address2);
        vector.add(new Integer(byArray.length));
        vector.add(new OctetString(byArray));
        if (this._$29688.addRow(new Date(), vector)) {
            SwingUtilities.invokeLater(this._$29688);
        }
    }

    private synchronized void _$18061(Date date, Address address, Address address2, OctetString octetString) {
        Vector<Object> vector = new Vector<Object>(_$29657.length);
        if (address instanceof TcpAddress) {
            vector.add(_$29660);
        } else {
            vector.add(_$29661);
        }
        vector.add(address);
        vector.add(address2);
        vector.add(new Integer(octetString.length()));
        vector.add(octetString);
        if (this._$29688.addRow(date, vector)) {
            SwingUtilities.invokeLater(this._$29688);
        }
    }

    public void setTarget(GenTarget genTarget) {
    }

    public void setTargets(Hashtable hashtable) {
    }

    public void processMessage(TransportMapping transportMapping, Address address, ByteBuffer byteBuffer, TransportStateReference transportStateReference) {
        if (this._$10360) {
            byte[] byArray = new byte[byteBuffer.remaining()];
            byteBuffer.get(byArray);
            byteBuffer.rewind();
            this.addEntry(address, (Address)transportMapping.getListenAddress(), byArray);
        }
    }

    public void processMessage(TransportMapping transportMapping, Address address, byte[] byArray, TransportStateReference transportStateReference) {
        if (this._$10360) {
            this.addEntry((Address)transportMapping.getListenAddress(), address, byArray);
        }
    }

    public void beforeSelect(JCSelectEvent jCSelectEvent) {
    }

    public void select(JCSelectEvent jCSelectEvent) {
    }

    public synchronized void afterSelect(JCSelectEvent jCSelectEvent) {
        int n2 = TableUtils.getFirstSelectedRow(this.logTable);
        if (n2 >= 0) {
            Address address = (Address)this.logModel.getTableDataItem(n2, 1);
            Address address2 = (Address)this.logModel.getTableDataItem(n2, 2);
            OctetString octetString = (OctetString)this.logModel.getTableDataItem(n2, 4);
            Date date = (Date)this.logModel.getTableRowLabel(n2);
            TreeModel treeModel = this._$29676.getTree(address, address2, octetString, date);
            this.tree.setModel(treeModel);
            this._$29718();
            this.messageContent.setText(this._$29719(octetString).toString());
            this.messageContent.setCaretPosition(0);
            this._$5284(this.messageContent);
        }
    }

    private void _$29694(String string) {
        StringSelection stringSelection = new StringSelection(string);
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            try {
                securityManager.checkSystemClipboardAccess();
                this.systemClipboard.setContents(stringSelection, this);
            }
            catch (SecurityException securityException) {}
        } else {
            this.systemClipboard.setContents(stringSelection, this);
        }
    }

    private void _$29718() {
        Enumeration<TreeNode> enumeration = ((DefaultMutableTreeNode)this.tree.getModel().getRoot()).depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
            this.tree.expandPath(new TreePath(defaultMutableTreeNode.getPath()));
        }
    }

    public void setEnabled(boolean bl) {
        this._$10360 = bl;
    }

    public boolean isEnabled() {
        return this._$10360;
    }

    public void cellDisplay(JCCellDisplayEvent jCCellDisplayEvent) {
        if (jCCellDisplayEvent.getRow() >= 0) {
            if (jCCellDisplayEvent.getColumn() == 4 && jCCellDisplayEvent.getCellData() != null) {
                jCCellDisplayEvent.setDisplayData(((OctetString)jCCellDisplayEvent.getCellData()).toHexString());
            } else if (jCCellDisplayEvent.getCellData() instanceof Date) {
                jCCellDisplayEvent.setDisplayData(this._$20916.format((Date)jCCellDisplayEvent.getCellData()));
            }
        }
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        TreePath treePath = treeSelectionEvent.getPath();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)this.tree.getModel().getRoot();
        if (defaultMutableTreeNode2.getUserObject() instanceof BERTreeBuilder.MessageNode) {
            Comparable<StringBuffer> comparable;
            Object object;
            Object object2;
            int n2 = -1;
            int n3 = 0;
            boolean bl = false;
            if (defaultMutableTreeNode != null && defaultMutableTreeNode.getUserObject() instanceof BERNode) {
                object2 = (BERNode)defaultMutableTreeNode.getUserObject();
                n2 = ((BERNode)object2).getPos();
                n3 = n2 + ((BERNode)object2).getLength();
                if (((BERNode)object2).isDecrypted()) {
                    bl = true;
                }
                if (((BERNode)object2).getData() instanceof OID) {
                    object = new ObjectID(((OID)((BERNode)object2).getData()).toDottedString());
                    while (object.size() > 0) {
                        comparable = new MIBObject((ObjectID)object, "");
                        MIBObjectEvent mIBObjectEvent = new MIBObjectEvent(this, (MIBObject)comparable, 0);
                        this.fireMIBObjectEvent(mIBObjectEvent);
                        if (mIBObjectEvent.isSuccess()) break;
                        object = object.trim();
                    }
                }
            }
            object2 = (BERTreeBuilder.MessageNode)defaultMutableTreeNode2.getUserObject();
            object = bl ? ((BERTreeBuilder.MessageNode)object2).getDecryptedMessage() : ((BERTreeBuilder.MessageNode)object2).getMessage();
            comparable = this._$29719((OctetString)object);
            this.messageContent.setText(comparable.toString());
            this._$5284(this.messageContent);
            this._$29725(this.messageContent, n2, n3);
        }
    }

    private StringBuffer _$29719(OctetString octetString) {
        StringBuffer stringBuffer = new StringBuffer(octetString.length() * 4);
        for (int i2 = 0; i2 < octetString.length(); i2 += 16) {
            stringBuffer.append(this.indexFormat.format(i2));
            stringBuffer.append(" ");
            for (int i3 = 0; i3 < 2; ++i3) {
                if (i2 + i3 * 8 < octetString.length()) {
                    stringBuffer.append(octetString.substring(i2 + i3 * 8, Math.min(i2 + i3 * 8 + 8, octetString.length())).toHexString(' '));
                    for (int i4 = 0; i4 < i2 + i3 * 8 + 8 - octetString.length(); ++i4) {
                        stringBuffer.append("   ");
                    }
                } else {
                    stringBuffer.append("                       ");
                }
                stringBuffer.append("  ");
            }
            stringBuffer.append(octetString.substring(i2, Math.min(octetString.length(), i2 + 16)).toASCII('.'));
            stringBuffer.append('\n');
        }
        return stringBuffer;
    }

    private int _$29726(int n2) {
        int n3 = n2 / 16;
        int n4 = n2 % 16;
        return 74 * n3 + 7 + n4 * 3 + n4 / 8;
    }

    private int _$29727(int n2) {
        int n3 = n2 / 16;
        int n4 = n2 % 16;
        return 74 * n3 + 7 + 48 + 2 + n4;
    }

    private void _$29725(JTextPane jTextPane, int n2, int n3) {
        if (n2 < 0 || n3 < n2) {
            return;
        }
        int n4 = n2 / 16;
        int n5 = n2 % 16;
        int n6 = n3 - n2;
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setBold(simpleAttributeSet, true);
        StyleConstants.setUnderline(simpleAttributeSet, true);
        int n7 = 0;
        for (int i2 = 0; i2 < (n5 + n6 + 1) / 16 + 1; ++i2) {
            int n8 = 0;
            int n9 = 16;
            if (i2 == 0) {
                n8 = n5;
                n9 = Math.min(16 - n8, n6);
            } else if (i2 + 1 >= (n5 + n6 + 1) / 16 + 1) {
                n9 = n3 % 16;
            }
            int n10 = n9 * 3;
            int n11 = this._$29726(n4 * 16 + i2 * 16 + n8);
            if (n7 == 0) {
                n7 = n11;
            }
            jTextPane.getStyledDocument().setCharacterAttributes(n11, n10, simpleAttributeSet, false);
            int n12 = n9;
            int n13 = this._$29727(n4 * 16 + i2 * 16 + n8);
            jTextPane.getStyledDocument().setCharacterAttributes(n13, n12, simpleAttributeSet, false);
        }
        try {
            jTextPane.setCaretPosition(n7);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void _$5284(JTextPane jTextPane) {
        jTextPane.getStyledDocument().setCharacterAttributes(0, jTextPane.getText().length(), new SimpleAttributeSet(), true);
    }

    public void buttonEnable_itemStateChanged(ItemEvent itemEvent) {
        this._$10360 = itemEvent.getStateChange() == 1;
    }

    public void clearLog_actionPerformed(ActionEvent actionEvent) {
        this._$29683();
    }

    private synchronized void _$29683() {
        if (this.logModel.getNumRows() > 0) {
            this.logModel.deleteRows(0, this.logModel.getNumRows());
            this._$29695();
        }
    }

    public void openCaptureFile_actionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser(this._$5250.get("mibexplorer.capture.dir", ""));
        jFileChooser.setDialogTitle("Open Capture File");
        jFileChooser.setFileSelectionMode(0);
        ExampleFileFilter exampleFileFilter = new ExampleFileFilter("xml", "XML Capture Files");
        jFileChooser.setFileFilter(exampleFileFilter);
        if (jFileChooser.showOpenDialog(this) == 0) {
            this._$5250.put("mibexplorer.capture.dir", jFileChooser.getSelectedFile().getParent());
            this._$29741(jFileChooser.getSelectedFile());
        }
    }

    public void saveCaptureFile_actionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser(this._$5250.get("mibexplorer.capture.dir", ""));
        jFileChooser.setDialogTitle("Save Capture File");
        jFileChooser.setFileSelectionMode(0);
        ExampleFileFilter exampleFileFilter = new ExampleFileFilter("xml", "XML Capture Files");
        jFileChooser.setFileFilter(exampleFileFilter);
        if (jFileChooser.showSaveDialog(this) == 0) {
            this._$5250.put("mibexplorer.capture.dir", jFileChooser.getSelectedFile().getParent());
            try {
                File file = jFileChooser.getSelectedFile();
                if (!file.getName().toUpperCase().endsWith(".XML")) {
                    file = new File(file.getParentFile(), file.getName() + ".xml");
                }
                if (file.exists() && JOptionPane.showConfirmDialog(this, "File '" + jFileChooser.getSelectedFile().getPath() + "' already exists! Overwrite it?", "Confirm Overwrite", 2, 3) == 2) {
                    return;
                }
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                DOMDocument dOMDocument = this._$29744();
                XMLWriter xMLWriter = new XMLWriter(fileOutputStream, new OutputFormat(" ", true));
                xMLWriter.write(dOMDocument);
                xMLWriter.flush();
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this, new String[]{"An error occurred while trying to write capture file: ", iOException.getMessage()}, "Capture File not Saved", 0);
                return;
            }
        }
    }

    private DOMDocument _$29744() {
        DOMDocument dOMDocument = new DOMDocument();
        DOMElement dOMElement = new DOMElement("Capture");
        DOMAttribute dOMAttribute = new DOMAttribute(new QName("xmlns:xsi"), "http://www.w3.org/2001/XMLSchema-instance");
        dOMElement.add(dOMAttribute);
        DOMAttribute dOMAttribute2 = new DOMAttribute(new QName("xsi:noNamespaceSchemaLocation"), "MIBExplorerCaptureFile.xsd");
        dOMElement.add(dOMAttribute2);
        for (int i2 = 0; i2 < this.logModel.getNumRows(); ++i2) {
            DOMElement dOMElement2 = new DOMElement("Packet");
            dOMElement2.addAttribute("time", this._$29662.format((Date)this.logModel.getTableRowLabel(i2)));
            dOMElement2.addAttribute("source", this.logModel.getTableDataItem(i2, 1).toString());
            dOMElement2.addAttribute("destination", this.logModel.getTableDataItem(i2, 2).toString());
            dOMElement2.addAttribute("transport", (String)this.logModel.getTableDataItem(i2, 0));
            OctetString octetString = (OctetString)this.logModel.getTableDataItem(i2, 4);
            dOMElement2.setText(octetString.toString(16).toUpperCase());
            dOMElement.add(dOMElement2);
        }
        dOMDocument.setRootElement(dOMElement);
        return dOMDocument;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _$29747(File file, String string) {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            this._$29749(fileInputStream, string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            JOptionPane.showMessageDialog(this, "Log file not found at " + file + ": " + fileNotFoundException.getMessage(), "File Not Found", 0);
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this, "Failed to load packets from " + file + ": " + iOException.getMessage(), "IO Error", 0);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void _$29749(InputStream inputStream, String string) throws IOException {
        int n2;
        UdpAddress udpAddress = new UdpAddress();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[65535];
        while ((n2 = bufferedInputStream.read(byArray, 0, byArray.length)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n2);
        }
        byteArrayOutputStream.flush();
        String string2 = new String(byteArrayOutputStream.toByteArray());
        int n3 = 0;
        SimpleDateFormat simpleDateFormat = (SimpleDateFormat)DateFormat.getDateTimeInstance();
        try {
            simpleDateFormat.applyPattern(string);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, "Invalid Date&Time format: " + exception.getMessage(), "Pattern Error", 0);
            return;
        }
        simpleDateFormat.setLenient(true);
        Date date = new Date(0L);
        while (n3 >= 0 && n3 < string2.length()) {
            int n4;
            if ((n3 = string2.indexOf("30:", n3)) < 0) continue;
            int n5 = string2.indexOf(":02:01:", n3);
            if (n3 + 10 < n5 || n5 < 0) {
                n3 += 3;
                continue;
            }
            int n6 = string2.length();
            for (int i2 = n3; i2 < string2.length(); ++i2) {
                n4 = string2.charAt(i2);
                if (Character.isDigit((char)n4) || n4 == 58 || n4 >= 65 && n4 <= 70 || n4 >= 97 && n4 <= 102) continue;
                n6 = i2;
                break;
            }
            String string3 = string2.substring(n3, n6);
            for (n4 = Math.max(0, string2.lastIndexOf("\n", n3) + 1); n4 < string2.length() && !Character.isDigit(string2.charAt(n4)); ++n4) {
            }
            Date date2 = simpleDateFormat.parse(string2, new ParsePosition(n4));
            if (date2 == null) {
                int n7 = 0;
                for (n7 = n4; n7 < string2.length() && Character.isDigit(string2.charAt(n7)); ++n7) {
                }
                if (n7 > n4) {
                    try {
                        long l2 = date.getTime() + Long.parseLong(string2.substring(n4, n7));
                        date2 = new Date(l2);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if (date2 == null) {
                date2 = date;
            }
            this._$18061(date2, udpAddress, udpAddress, OctetString.fromHexString(string3));
            n3 = n6 + 1;
        }
    }

    private void _$29741(File file) {
        try {
            DOMDocument dOMDocument = BERLogPanel._$23157(new FileInputStream(file), DOMDocumentFactory.getInstance());
            this._$29683();
            NodeList nodeList = dOMDocument.getElementsByTagName("Packet");
            for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
                Address address;
                Address address2;
                DOMElement dOMElement = (DOMElement)nodeList.item(i2);
                Date date = this._$29662.parse(dOMElement.attributeValue("time"));
                String string = dOMElement.attributeValue("transport");
                String string2 = dOMElement.attributeValue("source");
                String string3 = dOMElement.attributeValue("destination");
                if (string.equals(_$29660)) {
                    address2 = TcpAddress.parse(string2);
                    address = TcpAddress.parse(string3);
                } else {
                    address2 = UdpAddress.parse(string2);
                    address = UdpAddress.parse(string3);
                }
                OctetString octetString = OctetString.fromString(dOMElement.getText(), 16);
                this._$18061(date, address2, address, octetString);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            JOptionPane.showMessageDialog(this, new String[]{"File '" + file + "' is not a valid capture XML file.", "File cannot be loaded!"}, "Invalid Capture File", 0);
        }
    }

    private static DOMDocument _$23157(InputStream inputStream, DocumentFactory documentFactory) throws Exception {
        SAXReader sAXReader = new SAXReader(documentFactory, false);
        InputSource inputSource = new InputSource(inputStream);
        sAXReader.setFeature("http://xml.org/sax/features/validation", false);
        DOMDocument dOMDocument = (DOMDocument)sAXReader.read(inputSource);
        return dOMDocument;
    }

    void insertPacket_actionPerformed(ActionEvent actionEvent) {
        OctetTextField octetTextField = new OctetTextField(false);
        octetTextField.setColumns(40);
        JPanel jPanel = new JPanel(new VerticalFlowLayout());
        jPanel.add(new JLabel("Please enter packet to analyse as colon/space separated HEX string or hex stream: "));
        jPanel.add(octetTextField);
        if (JOptionPane.showConfirmDialog(this, jPanel, "Analyze SNMP Packet", 2, -1) == 0) {
            try {
                OctetString octetString = OctetTextField.getOctetString(octetTextField.getText());
                this.addEntry(new UdpAddress(), new UdpAddress(), octetString.getValue());
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, new String[]{"The entered value could not be interpreted", "as a hexdecimal string. Please use only '0'-'9' and 'a'-'f'", "and separate each byte with a ':' or space."}, "Format Error", 0);
            }
        }
    }

    public boolean onExit() {
        return false;
    }

    protected void analyzeTextFile_actionPerformed(ActionEvent actionEvent) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        FilePanel filePanel = new FilePanel();
        filePanel.setLabelText("Log File Path:");
        filePanel.setPath(this._$5250.get("mibexplorer.capture.log.path", this._$5250.get("mibexplorer.capture.dir", "")));
        filePanel.setSelectionMode(0);
        filePanel.setMode(0);
        jPanel.add((Component)filePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 400, 0));
        StringInputPanel stringInputPanel = new StringInputPanel("Time Format: ", this._$5250.get("mibexplorer.capture.log.time.format", _$29659));
        stringInputPanel.setToolTipText("Specifies the date and time format of the log file's time information at the beginning of each line (optional)");
        jPanel.add((Component)stringInputPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        if (JOptionPane.showConfirmDialog(this, jPanel, "Open Log File", 2) == 0) {
            this._$5250.put("mibexplorer.capture.log.path", filePanel.getPath());
            this._$5250.put("mibexplorer.capture.log.time.format", stringInputPanel.getTextValue());
            this._$29747(new File(filePanel.getPath()), stringInputPanel.getTextValue());
        }
    }

    class RowAppender
    implements Runnable {
        LinkedList rows;

        RowAppender() {
        }

        public synchronized boolean addRow(Object object, Object object2) {
            boolean bl = false;
            if (this.rows == null) {
                this.rows = new LinkedList();
                bl = true;
            }
            this.rows.add(new Object[]{object, object2});
            return bl;
        }

        public synchronized void run() {
            LinkedList linkedList = this.rows;
            this.rows = null;
            for (Object[] objectArray : linkedList) {
                BERLogPanel.this.logModel.addRow(Integer.MAX_VALUE, objectArray[0], (Vector)objectArray[1]);
            }
        }
    }

    class RemoveAction
    extends AbstractAction {
        public RemoveAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TableUtils.removeSelectedRows(BERLogPanel.this.logTable, BERLogPanel.this.logModel);
        }
    }
}

