/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.explorer;

import com.agentpp.common.SortLabel;
import com.agentpp.common.TableSorter;
import com.agentpp.common.table.PopupListTable;
import com.agentpp.common.table.TableUtils;
import com.agentpp.commons.snmp.UsmUserEditorPanel;
import com.agentpp.commons.ui.UIObjectUpdateListener;
import com.agentpp.explorer.UserConfigurationEvent;
import com.agentpp.explorer.UserConfigurationListener;
import com.agentpp.explorer.editors.OctetTextField;
import com.agentpp.explorer.editors.cell.OctetStringCellEditor;
import com.agentpp.snmp.UserProfile;
import com.agentpp.util.UserConfigFile;
import com.klg.jclass.cell.editors.JCCheckBoxCellEditor;
import com.klg.jclass.cell.editors.JCComboBoxCellEditor;
import com.klg.jclass.cell.editors.JCStringCellEditor;
import com.klg.jclass.cell.validate.JCValidateEvent;
import com.klg.jclass.cell.validate.JCValidateListener;
import com.klg.jclass.table.JCCellDisplayEvent;
import com.klg.jclass.table.JCCellDisplayListener;
import com.klg.jclass.table.JCCellPosition;
import com.klg.jclass.table.JCCellStyle;
import com.klg.jclass.table.JCEditCellEvent;
import com.klg.jclass.table.JCEditCellListener;
import com.klg.jclass.table.SortableDataViewModel;
import com.klg.jclass.table.TableDataModel;
import com.klg.jclass.table.TablePopupMenu;
import com.klg.jclass.table.data.JCEditableVectorDataSource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import org.snmp4j.security.AuthHMAC128SHA224;
import org.snmp4j.security.AuthHMAC192SHA256;
import org.snmp4j.security.AuthHMAC256SHA384;
import org.snmp4j.security.AuthHMAC384SHA512;
import org.snmp4j.security.AuthMD5;
import org.snmp4j.security.AuthSHA;
import org.snmp4j.security.Priv3DES;
import org.snmp4j.security.PrivAES128;
import org.snmp4j.security.PrivAES192;
import org.snmp4j.security.PrivAES256;
import org.snmp4j.security.PrivDES;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.security.UsmUser;
import org.snmp4j.security.nonstandard.PrivAES192With3DESKeyExtension;
import org.snmp4j.security.nonstandard.PrivAES256With3DESKeyExtension;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;

public class UserConfiguration
extends JPanel
implements ActionListener,
JCEditCellListener,
JCValidateListener,
JCCellDisplayListener {
    private static final int _$33920 = 1;
    private static final int _$35127 = 0;
    private static final int _$35128 = 2;
    private static final int _$35129 = 3;
    private static final int _$35130 = 4;
    private static final int _$35131 = 5;
    private static final int _$35132 = 6;
    private static final int _$35133 = 7;
    static final String ACTION_ADD = "Add User";
    static final String ACTION_EDIT = "Edit Name";
    static final String ACTION_REMOVE = "Remove User";
    static final String ACTION_LOCALIZE = "Localize User";
    static final String ACTION_DUPLICATE = "Duplicate User";
    private static final String _$1735 = "Default";
    private static final String _$1736 = "Hexadecimal";
    private static final String _$1737 = "Decimal";
    private static final String[] _$1713 = new String[]{"User Name", "Security Name", "Auth Protocol", "Auth Passphrase", "Priv Protocol", "Priv Passphrase", "Principal", "Localization Engine ID"};
    private static OctetStringCellEditor[] _$1715 = new OctetStringCellEditor[_$1713.length];
    private static final String[] _$2452 = new String[]{"", "MD5", "SHA-1", "SHA224", "SHA256", "SHA384", "SHA512"};
    private static final String[] _$2453 = new String[]{"", "DES", "3DES", "AES128", "AES192", "AES256", "AES192-KeyExt3DES", "AES256-KeyExt3DES"};
    BorderLayout borderLayout1 = new BorderLayout();
    JMenu editMenu = new JMenu("Format");
    int userNameEditableRow = 0;
    transient Vector userConfigurationListeners;
    PopupListTable table = new PopupListTable(){

        public boolean isEditable(int n2, int n3) {
            String string;
            n2 = UserConfiguration.this._$1241(n2);
            if (n3 == 0 ? n2 != UserConfiguration.this.userNameEditableRow : n3 > 2 && n3 < 6 && ((string = (String)UserConfiguration.this.userModel.getTableDataItem(n2, 2)) == null || string.length() == 0)) {
                return false;
            }
            if (n3 == 5) {
                string = (String)UserConfiguration.this.userModel.getTableDataItem(n2, 4);
                return string != null && string.length() > 0;
            }
            return true;
        }

        public boolean isPopupAllowed(int n2, int n3) {
            TablePopupMenu tablePopupMenu = super.getPopupMenu();
            JCCellPosition jCCellPosition = UserConfiguration.this.table.XYToCell(n2, n3);
            if (jCCellPosition.column >= 0 && jCCellPosition.column < _$1713.length && _$1715[jCCellPosition.column] != null) {
                UserConfiguration.this.editMenu.setEnabled(true);
            } else {
                UserConfiguration.this.editMenu.setEnabled(false);
            }
            return true;
        }

        public String getToolTipText(MouseEvent mouseEvent) {
            JCCellPosition jCCellPosition = this.XYToCell(mouseEvent.getX(), mouseEvent.getY());
            if (jCCellPosition.column < 0 || jCCellPosition.row < 0) {
                return null;
            }
            Object object = UserConfiguration.this.userModel.getTableDataItem(UserConfiguration.this._$1241(jCCellPosition.row), jCCellPosition.column);
            if (object != null) {
                return object.toString();
            }
            return null;
        }
    };
    JCEditableVectorDataSource userModel = new JCEditableVectorDataSource();
    JCComboBoxCellEditor authProtocolEditor = new JCComboBoxCellEditor(_$2452);
    JCComboBoxCellEditor privProtocolEditor = new JCComboBoxCellEditor(_$2453);
    JCStringCellEditor userNameEditor = new JCStringCellEditor();
    private OctetStringCellEditor _$35141 = new OctetStringCellEditor();
    private TableSorter _$5245;
    private UsmUserEditorPanel _$35142;
    private JSplitPane _$5248 = new JSplitPane(0);
    private UserConfigFile _$5250;

    public UserConfiguration(UserConfigFile userConfigFile) {
        this._$5250 = userConfigFile;
        this.userModel.setNumColumns(_$1713.length);
        this.userModel.setColumnLabels(_$1713);
        this.userModel.setNumRows(1);
        this._$35142 = new UsmUserEditorPanel();
        this._$35142.setUpdateListener(new UIObjectUpdateListener<UserProfile>(){

            @Override
            public boolean uiObjectUpdated(Object object, UserProfile userProfile) {
                if (UserConfiguration.this._$35143(userProfile.getName(), userProfile)) {
                    UserConfiguration.this._$35144(userProfile);
                    return true;
                }
                return false;
            }

            @Override
            public boolean uiObjectVerification(Object object, UserProfile userProfile, UserProfile userProfile2) {
                return UserConfiguration.this._$35143(userProfile.getName(), userProfile2);
            }
        });
        this.table.setDataSource(this.userModel);
        try {
            this._$5265();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this._$5268();
        this._$5245 = new TableSorter(this.table, this.userModel);
        this._$5245.addSortColumn(0);
        TablePopupMenu tablePopupMenu = this.table.getPopupMenu();
        tablePopupMenu.addItem(ACTION_ADD, this);
        tablePopupMenu.addItem(ACTION_EDIT, this);
        tablePopupMenu.addItem(ACTION_REMOVE, this);
        tablePopupMenu.addItem(ACTION_DUPLICATE, this);
        tablePopupMenu.add(new JSeparator());
        tablePopupMenu.addItem(ACTION_LOCALIZE, this);
        tablePopupMenu.add(new JSeparator());
        tablePopupMenu.add(this.editMenu);
        JMenuItem jMenuItem = this.editMenu.add(new FormatAction(_$1735));
        jMenuItem.setMnemonic('F');
        jMenuItem = this.editMenu.add(new FormatAction(_$1736));
        jMenuItem.setMnemonic('H');
        jMenuItem = this.editMenu.add(new FormatAction(_$1737));
        jMenuItem.setMnemonic('D');
        this.table.setFocusIndicator(4);
        this.table.addEditCellListener(this);
        this.table.addCellDisplayListener(this);
        ToolTipManager.sharedInstance().registerComponent(this.table);
    }

    public void clearSelection() {
        this.table.clearSelection();
        this._$35142.setUserProfile(null);
    }

    private void _$35144(UserProfile userProfile) {
        int n2 = TableUtils.getFirstSelectedRow(this.table);
        if (n2 > 0) {
            this.userModel.setRowLabel(n2, userProfile);
            Vector vector = this._$23143(userProfile);
            for (int i2 = 0; i2 < vector.size(); ++i2) {
                this.userModel.setTableDataItem(vector.get(i2), n2, i2);
            }
            this.userModel.fireRowChanged(n2);
        }
    }

    public static String getSecurityProtocolName(OID oID) {
        if (oID == null) {
            return "";
        }
        if (AuthMD5.ID.equals(oID)) {
            return "MD5";
        }
        if (AuthSHA.ID.equals(oID)) {
            return "SHA-1";
        }
        if (AuthHMAC128SHA224.ID.equals(oID)) {
            return "SHA224";
        }
        if (AuthHMAC192SHA256.ID.equals(oID)) {
            return "SHA256";
        }
        if (AuthHMAC256SHA384.ID.equals(oID)) {
            return "SHA384";
        }
        if (AuthHMAC384SHA512.ID.equals(oID)) {
            return "SHA512";
        }
        if (PrivDES.ID.equals(oID)) {
            return "DES";
        }
        if (Priv3DES.ID.equals(oID)) {
            return "3DES";
        }
        if (PrivAES128.ID.equals(oID)) {
            return "AES128";
        }
        if (PrivAES192.ID.equals(oID)) {
            return "AES192";
        }
        if (PrivAES256.ID.equals(oID)) {
            return "AES256";
        }
        if (PrivAES192With3DESKeyExtension.ID.equals(oID)) {
            return "AES192-KeyExt3DES";
        }
        if (PrivAES256With3DESKeyExtension.ID.equals(oID)) {
            return "AES256-KeyExt3DES";
        }
        return null;
    }

    public static OID getSecurityProtocol(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        if (string.equals("MD5")) {
            return AuthMD5.ID;
        }
        if (string.equals("SHA") || string.equals("SHA-1")) {
            return AuthSHA.ID;
        }
        if (string.equals("SHA224")) {
            return AuthHMAC128SHA224.ID;
        }
        if (string.equals("SHA256")) {
            return AuthHMAC192SHA256.ID;
        }
        if (string.equals("SHA384")) {
            return AuthHMAC256SHA384.ID;
        }
        if (string.equals("SHA512")) {
            return AuthHMAC384SHA512.ID;
        }
        if (string.equals("DES")) {
            return PrivDES.ID;
        }
        if (string.equals("3DES")) {
            return Priv3DES.ID;
        }
        if (string.equals("AES128")) {
            return PrivAES128.ID;
        }
        if (string.equals("AES192")) {
            return PrivAES192.ID;
        }
        if (string.equals("AES256")) {
            return PrivAES256.ID;
        }
        if (string.equals("AES192-KeyExt3DES")) {
            return PrivAES192With3DESKeyExtension.ID;
        }
        if (string.equals("AES256-KeyExt3DES")) {
            return PrivAES256With3DESKeyExtension.ID;
        }
        return null;
    }

    public void setUsers(Hashtable hashtable) {
        this.userModel.setNumRows(1);
        for (UserProfile userProfile : hashtable.values()) {
            Vector vector = this._$23143(userProfile);
            this.userModel.addRow(Integer.MAX_VALUE, userProfile, vector);
        }
        this._$5245.sort();
    }

    public void setSelectedUser(String string) {
        if (string != null) {
            SortableDataViewModel sortableDataViewModel = (SortableDataViewModel)this.table.getDataView();
            TableDataModel tableDataModel = sortableDataViewModel.getDataSource();
            for (int i2 = 0; i2 < this.table.getNumRows(); ++i2) {
                if (!string.equals(tableDataModel.getTableDataItem(i2, 0))) continue;
                this.table.setRowSelection(sortableDataViewModel.getViewRow(i2), sortableDataViewModel.getViewRow(i2));
                this._$35155(i2, false);
                break;
            }
            TableUtils.getFirstSelectedRow(this.table);
        } else {
            this._$35155(-1, false);
        }
    }

    private String _$5329(String string) {
        int n2 = 1;
        String string2 = string;
        for (int i2 = 1; i2 < this.userModel.getNumRows(); ++i2) {
            if (!this.userModel.getTableDataItem(i2, 0).equals(string2)) continue;
            string2 = string + " " + n2++;
            i2 = 0;
        }
        return string2;
    }

    private void _$35155(int n2, boolean bl) {
        if (n2 < 0 || !bl && TableUtils.getFirstSelectedRow(this.table) != n2) {
            this._$35142.setUserProfile(null);
            this._$35142.setEnabled(false);
            return;
        }
        this._$35142.setEnabled(true);
        UserProfile userProfile = this._$35157(n2);
        this._$35142.setUserProfile(userProfile);
    }

    public Hashtable getUsers() {
        Hashtable<String, UserProfile> hashtable = new Hashtable<String, UserProfile>(this.userModel.getNumRows() + 10);
        for (int i2 = 1; i2 < this.userModel.getNumRows(); ++i2) {
            UserProfile userProfile = this._$35157(i2);
            hashtable.put(userProfile.getName(), userProfile);
        }
        return hashtable;
    }

    public void save() {
        this._$5250.putInteger("mibexplorer.user.config.divider.location", this._$5248.getDividerLocation());
    }

    public void load() {
        int n2 = this._$5250.getInteger("mibexplorer.user.config.divider.location", -1);
        if (n2 >= 0) {
            this._$5248.setDividerLocation(n2);
        } else {
            this._$5248.setDividerLocation(0.5);
        }
    }

    public boolean checkInconsistentUSMUsers() {
        for (int i2 = 1; i2 < this.userModel.getNumRows(); ++i2) {
            String string = (String)this.userModel.getTableDataItem(i2, 0);
            OID oID = UserConfiguration.getSecurityProtocol((String)this.userModel.getTableDataItem(i2, 2));
            OctetString octetString = (OctetString)this.userModel.getTableDataItem(i2, 3);
            if (oID != null && (octetString == null || octetString.length() < 8)) {
                JOptionPane.showMessageDialog(this, new String[]{"The authentication passphrase provided for user", "'" + string + "' has not the required minimum", "length of eight characters. Authentication has been", "disabled for this user."}, "Invalid Authentication Passphrase", 2);
                this.userModel.setTableDataItem("", i2, 2);
            }
            OID oID2 = UserConfiguration.getSecurityProtocol((String)this.userModel.getTableDataItem(i2, 4));
            OctetString octetString2 = (OctetString)this.userModel.getTableDataItem(i2, 5);
            if (oID2 == null || octetString2 != null && octetString2.length() >= 8) continue;
            JOptionPane.showMessageDialog(this, new String[]{"The privacy passphrase provided for user", "'" + string + "' has not the required minimum", "length of eight characters. Privacy has been", "disabled for this user."}, "Invalid Privacy Passphrase", 2);
            this.userModel.setTableDataItem("", i2, 4);
        }
        return true;
    }

    private UserProfile _$35157(int n2) {
        UsmUser usmUser = this._$5358(n2);
        UserProfile userProfile = (UserProfile)this.userModel.getTableRowLabel(n2);
        userProfile.setName((String)this.userModel.getTableDataItem(n2, 0));
        userProfile.setUser(usmUser);
        userProfile.setPrincipal((Boolean)this.userModel.getTableDataItem(n2, 6));
        return userProfile;
    }

    private UsmUser _$5358(int n2) {
        if (n2 < 0) {
            return null;
        }
        OctetString octetString = (OctetString)this.userModel.getTableDataItem(n2, 7);
        UsmUser usmUser = new UsmUser((OctetString)this.userModel.getTableDataItem(n2, 1), UserConfiguration.getSecurityProtocol((String)this.userModel.getTableDataItem(n2, 2)), (OctetString)this.userModel.getTableDataItem(n2, 3), UserConfiguration.getSecurityProtocol((String)this.userModel.getTableDataItem(n2, 4)), (OctetString)this.userModel.getTableDataItem(n2, 5), octetString != null && octetString.length() > 0 ? octetString : null);
        return usmUser;
    }

    private void _$5265() throws Exception {
        this.setLayout(this.borderLayout1);
        this.add((Component)this._$5248, "Center");
        this._$5248.setOneTouchExpandable(true);
        this._$5248.add((Component)this.table, "top");
        this._$5248.add((Component)this._$35142.getPanel(), "bottom");
        this.table.setRowLabelDisplay(false);
        this.table.setRowHidden(0, true);
        this.table.setPopupMenuEnabled(true);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                UserConfiguration.this.load();
            }
        });
    }

    private void _$5268() {
        JCCellStyle jCCellStyle = new JCCellStyle(this.table.getDefaultCellStyle());
        jCCellStyle.setCellEditor(this.authProtocolEditor);
        this.table.setCellStyle(-997, 2, jCCellStyle);
        jCCellStyle = new JCCellStyle(this.table.getDefaultCellStyle());
        jCCellStyle.setCellEditor(this.privProtocolEditor);
        this.table.setCellStyle(-997, 4, jCCellStyle);
        jCCellStyle = new JCCellStyle(this.table.getDefaultCellStyle());
        this.userNameEditor.removeValidateListener(this);
        this.userNameEditor.addValidateListener(this);
        jCCellStyle.setCellEditor(this.userNameEditor);
        this.table.setCellStyle(-997, 0, jCCellStyle);
        this.table.setCellEditor(OctetString.class, this._$35141);
        this.table.setPixelWidth(-997, 33002);
        this.table.setCellEditor(Boolean.class, new JCCheckBoxCellEditor());
        this._$5391(3, 0);
        this._$5391(5, 0);
        this._$5391(1, 0);
        this._$5391(7, 16);
    }

    private void _$5391(int n2, int n3) {
        JCCellStyle jCCellStyle = new JCCellStyle(this.table.getDefaultCellStyle());
        UserConfiguration._$1715[n2] = new OctetStringCellEditor();
        _$1715[n2].setMode(n3);
        jCCellStyle.setCellEditor(_$1715[n2]);
        this.table.setCellStyle(-997, n2, jCCellStyle);
    }

    private Vector _$23143(UserProfile userProfile) {
        Vector<Object> vector = new Vector<Object>(_$1713.length);
        vector.add(userProfile.getName());
        vector.add(userProfile.getUser().getSecurityName());
        vector.add(UserConfiguration.getSecurityProtocolName(userProfile.getUser().getAuthenticationProtocol()));
        vector.add(userProfile.getUser().getAuthenticationPassphrase());
        vector.add(UserConfiguration.getSecurityProtocolName(userProfile.getUser().getPrivacyProtocol()));
        vector.add(userProfile.getUser().getPrivacyPassphrase());
        vector.add(new Boolean(userProfile.isPrincipal()));
        vector.add(userProfile.getUser().getLocalizationEngineID());
        return vector;
    }

    private int _$1241(int n2) {
        int n3 = n2;
        if (n3 < 0) {
            return n3;
        }
        if (this.table.getDataView() instanceof SortableDataViewModel) {
            n3 = ((SortableDataViewModel)this.table.getDataView()).getDataRow(n3);
        }
        return n3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals(ACTION_ADD)) {
            UsmUser usmUser = new UsmUser(new OctetString(), null, new OctetString(), null, new OctetString());
            UserProfile userProfile = new UserProfile(this._$5329("New User"), usmUser);
            this.userModel.addRow(Integer.MAX_VALUE, userProfile, this._$23143(userProfile));
            this.table.setRowSelection(this.table.getNumRows() - 1, 1);
            this.table.beginEdit(this.table.getNumRows() - 1, 0);
            return;
        } else if (actionEvent.getActionCommand().equals(ACTION_REMOVE)) {
            int[] nArray = TableUtils.getSelectedRows(this.table);
            Arrays.sort(nArray);
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                UserProfile userProfile = this._$35157(nArray[i2] - i2);
                UserConfigurationEvent userConfigurationEvent = new UserConfigurationEvent(this, userProfile, 1);
                this.fireUserConfigChanged(userConfigurationEvent);
                if (userConfigurationEvent.isCanceled()) {
                    JOptionPane.showMessageDialog(this, new String[]{"The USM user '" + userProfile.getName() + "' is still referenced by one or more targets.", "Please remove those references before deleting this user!"}, "USM User Still Referenced", 2);
                    break;
                }
                this.userModel.deleteRows(nArray[i2] - i2, 1);
            }
            this.table.clearSelection();
            this._$35142.setUserProfile(null);
            this._$5245.sort();
            return;
        } else {
            if (actionEvent.getActionCommand().equals(ACTION_DUPLICATE)) {
                int[] nArray = TableUtils.getSelectedRows(this.table);
                if (nArray.length == 0) {
                    return;
                }
                Arrays.sort(nArray);
                UserProfile userProfile = this._$35157(nArray[0]);
                UsmUser usmUser = userProfile.getUser();
                UserProfile userProfile2 = new UserProfile(userProfile.getName() + " Copy", new UsmUser(usmUser.getSecurityName(), usmUser.getAuthenticationProtocol(), usmUser.getAuthenticationPassphrase(), usmUser.getPrivacyProtocol(), usmUser.getPrivacyPassphrase(), usmUser.getLocalizationEngineID()));
                this.userModel.addRow(Integer.MAX_VALUE, userProfile2, this._$23143(userProfile2));
                if (!this.table.beginEdit(this.userModel.getNumRows() - 1, 0)) return;
            }
            if (actionEvent.getActionCommand().equals(ACTION_EDIT)) {
                int n2 = TableUtils.getFirstMarkedRow(this.table);
                if (n2 < 0) return;
                if (this.table.getDataView() instanceof SortableDataViewModel) {
                    n2 = ((SortableDataViewModel)this.table.getDataView()).getViewRow(n2);
                }
                this.userNameEditableRow = n2;
                this.table.beginEdit(n2, 0);
                return;
            } else {
                if (!actionEvent.getActionCommand().equals(ACTION_LOCALIZE)) return;
                this._$35164();
            }
        }
    }

    private void _$35164() throws HeadlessException {
        int n2 = TableUtils.getFirstMarkedRow(this.table);
        if (this.userModel.getTableDataItem(n2, 7) == null || ((OctetString)this.userModel.getTableDataItem(n2, 7)).length() == 0) {
            this.table.cancelEdit(true);
            OctetTextField octetTextField = new OctetTextField(false);
            octetTextField.setColumns(40);
            JPanel jPanel = new JPanel(new FlowLayout());
            jPanel.add(new JLabel("Target engine ID for localization: "));
            jPanel.add(octetTextField);
            if (JOptionPane.showConfirmDialog(this, jPanel, "Localization Engine ID", 2, -1) == 0) {
                OctetString octetString = OctetTextField.getOctetString(octetTextField.getText());
                UsmUser usmUser = this._$5358(n2);
                if (usmUser.getAuthenticationProtocol() != null) {
                    byte[] byArray = SecurityProtocols.getInstance().passwordToKey(usmUser.getAuthenticationProtocol(), usmUser.getAuthenticationPassphrase(), octetString.getValue());
                    this.userModel.setTableDataItem(new OctetString(byArray), n2, 3);
                    if (usmUser.getPrivacyProtocol() != null) {
                        byte[] byArray2 = SecurityProtocols.getInstance().passwordToKey(usmUser.getPrivacyProtocol(), usmUser.getAuthenticationProtocol(), usmUser.getPrivacyPassphrase(), octetString.getValue());
                        this.userModel.setTableDataItem(new OctetString(byArray2), n2, 5);
                    }
                    this.userModel.setTableDataItem(octetString, n2, 7);
                }
            }
        } else {
            JOptionPane.showMessageDialog(this, new String[]{"The selected user is already localized!", "To relocalize, delete the localization engine ID and", "reenter the (unlocalized) passphrases and then call ", "this function again."}, "Already Localized", 0);
        }
    }

    public void beforeEditCell(JCEditCellEvent jCEditCellEvent) {
    }

    public void editCell(JCEditCellEvent jCEditCellEvent) {
    }

    public void afterEditCell(JCEditCellEvent jCEditCellEvent) {
        String string;
        this.userNameEditableRow = 0;
        int n2 = this._$1241(jCEditCellEvent.getRow());
        if (jCEditCellEvent.getColumn() == 2) {
            String string2 = (String)this.userModel.getTableDataItem(n2, 2);
            if (string2 == null || string2.length() == 0) {
                this.userModel.setTableDataItem(new OctetString(), n2, 3);
                this.userModel.setTableDataItem("", n2, 4);
                this.userModel.setTableDataItem(new OctetString(), n2, 5);
            }
        } else if (jCEditCellEvent.getColumn() == 4 && ((string = (String)this.userModel.getTableDataItem(n2, 4)) == null || string.length() == 0)) {
            this.userModel.setTableDataItem(new OctetString(), n2, 5);
        }
        this._$35155(n2, true);
    }

    public void valueChangedBegin(JCValidateEvent jCValidateEvent) {
        Object object = jCValidateEvent.getOldValue();
        Object object2 = jCValidateEvent.getValue();
        if (jCValidateEvent.getSource().equals(this.userNameEditor)) {
            if (object2 == null) {
                jCValidateEvent.setValid(false);
                return;
            }
            if (object != null && !object.equals(object2) || object == null && object2 != null) {
                String string = (String)object2;
                jCValidateEvent.setValid(this._$35143(string, null));
            }
        }
    }

    private boolean _$35143(String string, UserProfile userProfile) {
        for (int i2 = 1; i2 < this.userModel.getNumRows(); ++i2) {
            if (!string.equals(this.userModel.getTableDataItem(i2, 0)) || userProfile != null && userProfile == this.userModel.getTableRowLabel(i2)) continue;
            return false;
        }
        return true;
    }

    public void valueChangedEnd(JCValidateEvent jCValidateEvent) {
    }

    public void stateIsInvalid(JCValidateEvent jCValidateEvent) {
    }

    private void _$5459(int n2, int n3) {
        String string = "";
        _$1715[n3].setMode(n2);
        switch (n2) {
            case 16: {
                string = " [HEX]";
                break;
            }
            case 10: {
                string = " [DEC]";
            }
        }
        SortLabel sortLabel = (SortLabel)this.userModel.getTableColumnLabel(n3);
        sortLabel.setLabel(_$1713[n3] + string);
        this.userModel.fireColumnLabelChanged(n3);
    }

    public void cellDisplay(JCCellDisplayEvent jCCellDisplayEvent) {
        OctetString octetString;
        int n2 = jCCellDisplayEvent.getColumn();
        int n3 = jCCellDisplayEvent.getRow();
        if (n3 < 0) {
            return;
        }
        this._$35155(TableUtils.getFirstSelectedRow(this.table), false);
        if (n2 >= 0 && n2 < _$1713.length && _$1715[n2] != null && _$1715[n2].getMode() != 0 && (octetString = (OctetString)jCCellDisplayEvent.getCellData()) != null) {
            jCCellDisplayEvent.setDisplayData(octetString.toString(':', _$1715[n2].getMode()));
        }
    }

    public synchronized void addUserConfigurationListener(UserConfigurationListener userConfigurationListener) {
        if (this.userConfigurationListeners == null) {
            this.userConfigurationListeners = new Vector(2);
        }
        this.userConfigurationListeners.add(userConfigurationListener);
    }

    public synchronized void removeUserConfigurationListener(UserConfigurationListener userConfigurationListener) {
        if (this.userConfigurationListeners != null) {
            this.userConfigurationListeners.remove(userConfigurationListener);
        }
    }

    protected void fireUserConfigChanged(UserConfigurationEvent userConfigurationEvent) {
        if (this.userConfigurationListeners != null) {
            Vector vector = this.userConfigurationListeners;
            int n2 = vector.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                ((UserConfigurationListener)vector.elementAt(i2)).userConfigChanged(userConfigurationEvent);
            }
        }
    }

    class FormatAction
    extends AbstractAction {
        public FormatAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JCCellPosition jCCellPosition = UserConfiguration.this.table.getPopupCellPosition();
            if (jCCellPosition.column >= 0 && jCCellPosition.column < _$1713.length) {
                if (actionEvent.getActionCommand().equals(UserConfiguration._$1735)) {
                    UserConfiguration.this._$5459(0, jCCellPosition.column);
                } else if (actionEvent.getActionCommand().equals(UserConfiguration._$1736)) {
                    UserConfiguration.this._$5459(16, jCCellPosition.column);
                } else if (actionEvent.getActionCommand().equals(UserConfiguration._$1737)) {
                    UserConfiguration.this._$5459(10, jCCellPosition.column);
                }
            }
        }
    }
}

