/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.explorer;

import com.agentpp.common.SortLabel;
import com.agentpp.common.TableSorter;
import com.agentpp.common.table.PopupListTable;
import com.agentpp.common.table.RowMove;
import com.agentpp.common.table.TableUtils;
import com.agentpp.commons.snmp.TargetEditorPanel;
import com.agentpp.commons.ui.UIObjectUpdateListener;
import com.agentpp.explorer.UserConfigurationEvent;
import com.agentpp.explorer.UserConfigurationListener;
import com.agentpp.explorer.cfg.MIBExplorerConfig;
import com.agentpp.explorer.editors.CheckboxIntegerCellEditor;
import com.agentpp.explorer.editors.CheckboxIntegerCellRenderer;
import com.agentpp.explorer.editors.cell.OctetStringCellEditor;
import com.agentpp.explorer.editors.cell.ValidatorValidationListener;
import com.agentpp.snmp.GenTarget;
import com.agentpp.snmp.GenTargetEvent;
import com.agentpp.snmp.GenTargetListener;
import com.agentpp.snmp.UserProfile;
import com.agentpp.util.PropertyEncrypter;
import com.agentpp.util.UserConfigFile;
import com.klg.jclass.cell.editors.JCComboBoxCellEditor;
import com.klg.jclass.cell.editors.JCIntegerCellEditor;
import com.klg.jclass.cell.editors.JCStringCellEditor;
import com.klg.jclass.cell.validate.JCValidateEvent;
import com.klg.jclass.cell.validate.JCValidateListener;
import com.klg.jclass.field.validate.JCIntegerValidator;
import com.klg.jclass.field.validate.JCStringValidator;
import com.klg.jclass.table.JCCellDisplayEvent;
import com.klg.jclass.table.JCCellDisplayListener;
import com.klg.jclass.table.JCCellPosition;
import com.klg.jclass.table.JCCellRange;
import com.klg.jclass.table.JCCellStyle;
import com.klg.jclass.table.JCEditCellEvent;
import com.klg.jclass.table.JCEditCellListener;
import com.klg.jclass.table.JCSelectEvent;
import com.klg.jclass.table.JCSelectListener;
import com.klg.jclass.table.JCTable;
import com.klg.jclass.table.JCTraverseCellEvent;
import com.klg.jclass.table.JCTraverseCellListener;
import com.klg.jclass.table.SortableDataViewModel;
import com.klg.jclass.table.TablePopupMenu;
import com.klg.jclass.table.data.JCEditableVectorDataSource;
import com.klg.jclass.table.data.JCVectorDataSource;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import org.snmp4j.PDU;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.security.UsmUser;
import org.snmp4j.security.UsmUserTable;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.GenericAddress;
import org.snmp4j.smi.IpAddress;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.smi.VariableBinding;

public class TargetConfiguration
extends JPanel
implements GenTargetListener,
ActionListener,
JCCellDisplayListener,
JCSelectListener,
JCTraverseCellListener,
JCEditCellListener,
JCValidateListener,
UserConfigurationListener {
    private static final int _$15175 = 1;
    private static final int _$15176 = 2;
    private static final int _$15177 = 3;
    private static final int _$15178 = 4;
    private static final int _$15179 = 5;
    private static final int _$15180 = 6;
    private static final int _$15181 = 8;
    private static final int _$15182 = 9;
    private static final int _$15183 = 7;
    private static final int _$15184 = 0;
    private static final int _$15185 = 10;
    private static final int _$15186 = 11;
    private static final int _$15187 = 12;
    private static final String[] _$1713 = new String[]{"Active", "Name", "Transport", "Address", "Version", "Timeout", "Retries", "MIB Set", "Community", "User", "Engine ID", "Context", "Context Engine ID"};
    private static OctetStringCellEditor[] _$1715 = new OctetStringCellEditor[_$1713.length];
    private static final int[] _$14676 = new int[]{20, 110, 60, 115, 50, 52, 48};
    private static final String[] _$15188 = new String[]{"SNMPv1", "SNMPv2c", "SNMPv3"};
    private static final int[] _$15189 = new int[]{0, 1, 3};
    private static final String[] _$15193 = new String[]{_$15188[0], _$15188[1], "SNMPv2p", _$15188[2]};
    private static final String[] _$15194 = new String[]{"UDP", "TCP", "TLS"};
    static final String ACTION_ADD = "Add Target";
    static final String ACTION_DELETE = "Delete Target";
    static final String ACTION_EDIT = "Edit Name";
    static final String ACTION_DUPLICATE = "Duplicate Target";
    static final String ACTION_TEST = "Test Connectivity";
    static final String ACTION_MOVE_UP = "Move up";
    static final String ACTION_MOVE_DOWN = "Move down";
    static final String ACTION_SET = "Set Active";
    static final String ACTION_STATISTICS = "Show Statistics";
    static final String ACTION_ENGINEID = "Discover Engine ID";
    static final String ACTION_USERS = "Edit Users...";
    static final String ACTION_ASCII = "Default";
    static final String ACTION_HEX = "Hexadecimal";
    static final String ACTION_DEC = "Decimal";
    BorderLayout borderLayout1 = new BorderLayout();
    int targetNameEditRow = 0;
    JMenu editMenu = new JMenu("Format");
    PropertyEncrypter propertyEncrypter;
    PopupListTable table = new PopupListTable(){

        public boolean isEditable(int n2, int n3) {
            if (n3 < 8) {
                return n3 != 1 || n2 == TargetConfiguration.this.targetNameEditRow;
            }
            if (super.getDataView().getTableDataItem(n2, 4) instanceof Number) {
                if (n3 == 8 && ((Number)super.getDataView().getTableDataItem(n2, 4)).intValue() < 3) {
                    return true;
                }
                if (n3 > 8 && ((Number)super.getDataView().getTableDataItem(n2, 4)).intValue() == 3) {
                    return true;
                }
            }
            return false;
        }

        public boolean isPopupAllowed(int n2, int n3) {
            TablePopupMenu tablePopupMenu = super.getPopupMenu();
            JCCellPosition jCCellPosition = TargetConfiguration.this.table.XYToCell(n2, n3);
            if (jCCellPosition.column >= 0 && jCCellPosition.column < _$1713.length && _$1715[jCCellPosition.column] != null) {
                TargetConfiguration.this.editMenu.setEnabled(true);
            } else {
                TargetConfiguration.this.editMenu.setEnabled(false);
            }
            return true;
        }

        public String getToolTipText(MouseEvent mouseEvent) {
            JCCellPosition jCCellPosition = this.XYToCell(mouseEvent.getX(), mouseEvent.getY());
            if (jCCellPosition.column < 0 || jCCellPosition.row < 0) {
                return null;
            }
            int n2 = TableUtils.getDataRows(TargetConfiguration.this.table, new int[]{jCCellPosition.row})[0];
            Object object = TargetConfiguration.this._$15205.getTableDataItem(n2, jCCellPosition.column);
            if (object != null) {
                switch (jCCellPosition.column) {
                    case 0: {
                        if ((Integer)object == 0) {
                            return "Active Target";
                        }
                        return "Inactive Target";
                    }
                }
                return object.toString();
            }
            return null;
        }
    };
    private UserConfigFile _$5250;
    private Hashtable<String, GenTarget> _$7365 = new Hashtable();
    private Hashtable _$5357 = new Hashtable();
    private JCEditableVectorDataSource _$15205;
    private CheckboxIntegerCellEditor _$15206 = new CheckboxIntegerCellEditor();
    private JCComboBoxCellEditor _$15207 = new JCComboBoxCellEditor();
    private JCComboBoxCellEditor _$15208 = new JCComboBoxCellEditor(_$15188, _$15189);
    private JCComboBoxCellEditor _$15209 = new JCComboBoxCellEditor(_$15194);
    private JCStringCellEditor _$15210 = new JCStringCellEditor();
    private JCStringCellEditor _$15211 = new JCStringCellEditor();
    private JCStringValidator _$15212 = new JCStringValidator(){

        public boolean validate(Object object) {
            boolean bl = super.validate(object);
            if (bl) {
                if (object == null) {
                    return false;
                }
                String string = (String)object;
                if (string.indexOf(47) >= 0 && string.indexOf(47) < 3 || string.indexOf(47) != string.lastIndexOf(47)) {
                    return false;
                }
            }
            return bl;
        }
    };
    private JCIntegerCellEditor _$15213 = new JCIntegerCellEditor();
    private JCIntegerValidator _$15214 = new JCIntegerValidator();
    private JCIntegerCellEditor _$15215 = new JCIntegerCellEditor();
    private JCIntegerValidator _$15216 = new JCIntegerValidator();
    private String[] _$15217 = new String[0];
    private JCComboBoxCellEditor _$15218 = new JCComboBoxCellEditor();
    private TableSorter _$5245;
    private Snmp _$14889;
    private TargetEditorPanel _$15219;
    private JSplitPane _$5248 = new JSplitPane(0);

    public TargetConfiguration(UserConfigFile userConfigFile, Snmp snmp) {
        this._$5250 = userConfigFile;
        this.propertyEncrypter = new PropertyEncrypter(userConfigFile);
        this._$14889 = snmp;
        this._$15219 = new TargetEditorPanel();
        this._$15219.setUpdateListener(new UIObjectUpdateListener<GenTarget>(){

            @Override
            public boolean uiObjectUpdated(Object object, GenTarget genTarget) {
                int n2 = 0;
                for (int i2 = 1; i2 < TargetConfiguration.this._$15205.getNumRows(); ++i2) {
                    if (TargetConfiguration.this._$15205.getTableRowLabel(i2) != genTarget) continue;
                    n2 = i2;
                    break;
                }
                if (TargetConfiguration.this._$15222(genTarget.getName(), n2)) {
                    TargetConfiguration.this._$15223(genTarget, n2);
                    return true;
                }
                return false;
            }

            @Override
            public boolean uiObjectVerification(Object object, GenTarget genTarget, GenTarget genTarget2) {
                if (genTarget.getAddressString() == null || genTarget.getAddressString().length() == 0) {
                    return false;
                }
                int n2 = 0;
                for (int i2 = 1; i2 < TargetConfiguration.this._$15205.getNumRows(); ++i2) {
                    if (TargetConfiguration.this._$15205.getTableRowLabel(i2) != genTarget2) continue;
                    n2 = i2;
                    break;
                }
                return TargetConfiguration.this._$15222(genTarget.getName(), n2);
            }
        });
        this._$15219.setTransportList(Arrays.asList(_$15194));
        this._$15219.addActionListener(this);
        this._$15205 = new JCEditableVectorDataSource();
        this._$15205.setNumColumns(_$1713.length);
        this._$15205.setNumRows(0);
        this._$15205.addRow(Integer.MAX_VALUE, null, this._$15227(new GenTarget("", new UdpAddress())));
        this._$15205.setColumnLabels(_$1713);
        try {
            this._$5265();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this._$15212.setInvalidChars("<>|\u00b0^!\"\u00a7$%&/()=?\\`\u00b4'#+~*;:,");
        this._$15214.setMin(1);
        this._$15214.setMax(99999);
        this._$15216.setMin(0);
        this._$15216.setMax(99);
        this._$15213.addValidateListener(new ValidatorValidationListener(this._$15214));
        this._$15215.addValidateListener(new ValidatorValidationListener(this._$15216));
        TablePopupMenu tablePopupMenu = this.table.getPopupMenu();
        tablePopupMenu.addItem(ACTION_SET, this);
        tablePopupMenu.add(new JSeparator());
        tablePopupMenu.addItem(ACTION_ADD, this);
        tablePopupMenu.addItem(ACTION_DUPLICATE, this);
        tablePopupMenu.addItem(ACTION_EDIT, this);
        tablePopupMenu.addItem(ACTION_DELETE, this);
        tablePopupMenu.add(new JSeparator());
        tablePopupMenu.addItem(ACTION_MOVE_UP, this);
        tablePopupMenu.addItem(ACTION_MOVE_DOWN, this);
        tablePopupMenu.add(new JSeparator());
        tablePopupMenu.addItem(ACTION_TEST, this);
        tablePopupMenu.addItem(ACTION_ENGINEID, this);
        tablePopupMenu.add(new JSeparator());
        tablePopupMenu.add(this.editMenu);
        JMenuItem jMenuItem = this.editMenu.add(new FormatAction(ACTION_ASCII));
        jMenuItem.setMnemonic('F');
        jMenuItem = this.editMenu.add(new FormatAction(ACTION_HEX));
        jMenuItem.setMnemonic('H');
        jMenuItem = this.editMenu.add(new FormatAction(ACTION_DEC));
        jMenuItem.setMnemonic('D');
        this.table.setRowHidden(0, true);
        this.table.setFrozenRows(1);
        this.table.addCellDisplayListener(this);
        this.table.addTraverseCellListener(this);
        this.table.addEditCellListener(this);
        this.table.addSelectListener(this);
        this._$5245 = new TableSorter((JCTable)this.table, (JCVectorDataSource)this._$15205, true);
        this._$5245.addSortColumn(1);
        for (int i2 = 0; i2 < _$14676.length; ++i2) {
            this.table.setPixelWidth(i2, _$14676[i2]);
        }
        this._$5268();
        this.setPreferredSize(MIBExplorerConfig.getStandardDialogDimension(userConfigFile));
        this.table.setFocusIndicator(4);
        ToolTipManager.sharedInstance().registerComponent(this.table);
    }

    private void _$15223(GenTarget genTarget, int n2) {
        if (n2 > 0) {
            Vector vector = this._$15227(genTarget);
            for (int i2 = 1; i2 < vector.size(); ++i2) {
                this._$15205.setTableDataItem(vector.get(i2), n2, i2);
            }
            this._$15205.fireRowChanged(n2);
        }
    }

    private int _$1241(int n2) {
        int n3 = n2;
        if (this.table.getDataView() instanceof SortableDataViewModel) {
            n3 = ((SortableDataViewModel)this.table.getDataView()).getViewRow(n3);
        }
        return n3;
    }

    private void _$5268() {
        JCCellStyle jCCellStyle = new JCCellStyle(this.table.getDefaultCellStyle());
        jCCellStyle.setCellEditor(this._$15207);
        this.table.setCellStyle(-997, 9, jCCellStyle);
        jCCellStyle = new JCCellStyle(this.table.getDefaultCellStyle());
        jCCellStyle.setCellEditor(this._$15208);
        this.table.setCellStyle(-997, 4, jCCellStyle);
        jCCellStyle = new JCCellStyle(this.table.getDefaultCellStyle());
        jCCellStyle.setCellEditor(this._$15209);
        this.table.setCellStyle(-997, 2, jCCellStyle);
        jCCellStyle = new JCCellStyle(this.table.getDefaultCellStyle());
        jCCellStyle.setCellEditor(this._$15218);
        this.table.setCellStyle(-997, 7, jCCellStyle);
        jCCellStyle = new JCCellStyle(this.table.getDefaultCellStyle());
        this._$15210.removeValidateListener(this);
        this._$15210.addValidateListener(this);
        jCCellStyle.setCellEditor(this._$15210);
        this.table.setCellStyle(-997, 1, jCCellStyle);
        jCCellStyle = new JCCellStyle(this.table.getDefaultCellStyle());
        this._$15211.removeValidateListener(this);
        this._$15211.addValidateListener(new ValidatorValidationListener(this._$15212));
        jCCellStyle.setCellEditor(this._$15211);
        this.table.setCellStyle(-997, 3, jCCellStyle);
        jCCellStyle = new JCCellStyle(this.table.getDefaultCellStyle());
        jCCellStyle.setCellEditor(this._$15213);
        this.table.setCellStyle(-997, 5, jCCellStyle);
        jCCellStyle = new JCCellStyle(this.table.getDefaultCellStyle());
        jCCellStyle.setCellEditor(this._$15215);
        this.table.setCellStyle(-997, 6, jCCellStyle);
        jCCellStyle = new JCCellStyle(this.table.getDefaultCellStyle());
        jCCellStyle.setCellEditor(this._$15206);
        jCCellStyle.setCellRenderer(new CheckboxIntegerCellRenderer());
        this.table.setCellStyle(-997, 0, jCCellStyle);
        this._$5391(8);
        this._$5391(10);
        this._$5391(12);
        this._$5391(11);
        this._$5459(16, 10);
        this._$5459(16, 12);
        this.table.setSelectedBackground(Color.lightGray);
        this.table.setSelectedForeground(Color.black);
    }

    private void _$5391(int n2) {
        JCCellStyle jCCellStyle = new JCCellStyle(this.table.getDefaultCellStyle());
        TargetConfiguration._$1715[n2] = new OctetStringCellEditor();
        jCCellStyle.setCellEditor(_$1715[n2]);
        this.table.setCellStyle(-997, n2, jCCellStyle);
    }

    public TargetConfiguration() {
        this(null, null);
    }

    private void _$5265() throws Exception {
        this.setLayout(this.borderLayout1);
        this.add((Component)this._$5248, "Center");
        this._$5248.setOneTouchExpandable(true);
        this._$5248.add((Component)this.table, "top");
        this._$5248.add((Component)this._$15219.getPanel(), "bottom");
        this.table.setDataSource(this._$15205);
        this.table.setFrozenRows(1);
        this.table.setRowLabelDisplay(false);
        this.table.setPopupMenuEnabled(true);
    }

    public void setMibSets(Vector vector) {
        Vector<String> vector2 = new Vector<String>(vector);
        vector2.add(0, "");
        this._$15217 = vector2.toArray(new String[vector2.size()]);
        this._$15218.setModel(new DefaultComboBoxModel<String>(this._$15217));
        this._$15219.setMibSetList(vector);
    }

    public Hashtable loadAllTargets(UserConfigFile userConfigFile) {
        String string;
        Hashtable<String, GenTarget> hashtable = new Hashtable<String, GenTarget>();
        int n2 = 0;
        GenTarget genTarget = null;
        while ((string = userConfigFile.get("mibexplorer.Target" + n2++, null)) != null && string.length() > 0) {
            genTarget = TargetConfiguration.loadTarget(userConfigFile, this.propertyEncrypter, string);
            hashtable.put(string, genTarget);
        }
        return hashtable;
    }

    private Vector _$15227(GenTarget genTarget) {
        Vector<Object> vector = new Vector<Object>(_$1713.length);
        vector.add(new Integer(1));
        vector.add(genTarget.getName());
        vector.add(genTarget.getAddressType());
        vector.add(genTarget.getAddressString());
        vector.add(new Integer(genTarget.getVersion()));
        vector.add(new Integer(genTarget.getTimeout()));
        vector.add(new Integer(genTarget.getRetries()));
        vector.add(genTarget.getMIBSet());
        vector.add(genTarget.getCommunity());
        vector.add(genTarget.getUser());
        vector.add(genTarget.getEngineID());
        vector.add(genTarget.getContext());
        vector.add(genTarget.getContextEngineID());
        return vector;
    }

    public boolean save() {
        this.table.commitEdit(true);
        this._$15248();
        List list = this._$15250();
        if (list.size() > 0) {
            JOptionPane.showMessageDialog(this, new String[]{"The following SNMPv3 targets do not have an USM user defined:", "" + list, "Please assign an user for each target before saving the configuration!"}, "SNMPv3 Targets without USM User", 0);
            return false;
        }
        List list2 = this._$15252();
        if (list2 != null && list2.size() > 0 && JOptionPane.showConfirmDialog(this, new String[]{"The following user profiles have ambigous security names: ", "" + list2 + ". ", "For correct authentication and encryption, it is highly recommended", "that two user profiles with the same security name have different", "localization engine IDs and at most one of them is not localized.", "Otherwise, it is not defined which user credentials are used.", "Do you want to save the target and user configuration anyway?"}, "Ambigous Security Names", 0, 2) == 1) {
            return false;
        }
        this.saveAllUser();
        this.saveAllTargets();
        this._$5250.putInteger("mibexplorer.target.config.divider.location", this._$5248.getDividerLocation());
        return true;
    }

    private List _$15250() {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        Vector vector = this.getUserNames();
        for (int i2 = 0; i2 < this._$15205.getNumRows(); ++i2) {
            UserProfile userProfile;
            Integer n2 = (Integer)this._$15205.getTableDataItem(i2, 4);
            if (n2 == null || n2 != 3 || (userProfile = (UserProfile)this._$15205.getTableDataItem(i2, 9)) != null && vector.contains(userProfile.getName())) continue;
            linkedList.add(this._$15205.getTableDataItem(i2, 1));
        }
        return linkedList;
    }

    private List _$15252() {
        HashSet<UserProfile> hashSet = new HashSet<UserProfile>();
        HashMap<UsmUserTable.UsmUserKey, UserProfile> hashMap = new HashMap<UsmUserTable.UsmUserKey, UserProfile>();
        Object object = this._$5357.elements();
        while (object.hasMoreElements()) {
            UserProfile userProfile = (UserProfile)object.nextElement();
            OctetString octetString = userProfile.getUser().getLocalizationEngineID();
            UsmUserTable.UsmUserKey usmUserKey = new UsmUserTable.UsmUserKey(octetString, userProfile.getUser().getSecurityName());
            UserProfile userProfile2 = (UserProfile)hashMap.get(usmUserKey);
            if (userProfile2 != null) {
                hashSet.add(userProfile);
                hashSet.add(userProfile2);
            }
            hashMap.put(usmUserKey, userProfile);
        }
        object = new ArrayList(hashSet);
        Collections.sort(object);
        return object;
    }

    public void load() {
        this.loadAllUser();
        this._$15237();
    }

    public void loadAllUser() {
        String string;
        this._$5357 = new Hashtable();
        this._$15207.removeAllItems();
        int n2 = 0;
        UserProfile userProfile = null;
        while ((string = this._$5250.get("mibexplorer.USMUser" + n2++, null)) != null && string.length() > 0) {
            userProfile = TargetConfiguration._$15264(this.propertyEncrypter, this._$5250, string);
            this._$5357.put(string, userProfile);
        }
        this._$15265();
    }

    private void _$15265() {
        this._$15207.removeAllItems();
        this._$15207.addItem(null);
        Vector vector = this.getUserNames();
        Collections.sort(vector);
        ArrayList<UserProfile> arrayList = new ArrayList<UserProfile>(vector.size());
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            UserProfile userProfile = (UserProfile)this._$5357.get(enumeration.nextElement());
            this._$15207.addItem(userProfile);
            arrayList.add(userProfile);
        }
        this._$15219.setUserList(arrayList);
    }

    private synchronized void _$15268(int n2) {
        if (this._$15205.getNumRows() <= 2) {
            return;
        }
        for (int i2 = 0; i2 < this._$15205.getNumRows(); ++i2) {
            this._$15205.setTableDataItem(new Integer(i2 == n2 ? 0 : 1), i2, 0);
        }
        this._$5245.sort();
    }

    private void _$15237() {
        String string;
        this._$7365 = new Hashtable();
        this._$15205.setNumRows(1);
        int n2 = 0;
        GenTarget genTarget = null;
        String string2 = this._$5250.get("mibexplorer.ActiveTarget", null);
        while ((string = this._$5250.get("mibexplorer.Target" + n2++, null)) != null && string.length() > 0) {
            genTarget = this.loadTarget(string);
            this._$7365.put(string, genTarget);
            this._$15205.addRow(Integer.MAX_VALUE, genTarget, this._$15227(genTarget));
        }
        GenTarget genTarget2 = null;
        if (string2 != null) {
            genTarget2 = this._$7365.get(string2);
        }
        if (genTarget2 != null) {
            this.setSelectedTarget(genTarget2);
        }
    }

    public Object[] getTargetIdentifiers() {
        Object[] objectArray = this._$7365.values().toArray();
        Arrays.sort(objectArray);
        return objectArray;
    }

    private static Address _$14578(UserConfigFile userConfigFile, String string) {
        String string2 = userConfigFile.get("mibexplorer.Address_" + string, "127.0.0.1/161");
        String string3 = userConfigFile.get("mibexplorer.TargetTransport_" + string, "udp");
        return GenericAddress.parse(string3 + ":" + string2);
    }

    private Address _$14578(String string) {
        return TargetConfiguration._$14578(this._$5250, string);
    }

    public GenTarget loadTarget(UserConfigFile userConfigFile, String string) {
        return TargetConfiguration.loadTarget(userConfigFile, this.propertyEncrypter, string);
    }

    public static GenTarget loadTarget(UserConfigFile userConfigFile, PropertyEncrypter propertyEncrypter, String string) {
        int n2 = TargetConfiguration._$15273(userConfigFile, string);
        String string2 = userConfigFile.get("mibexplorer.Address_" + string, "127.0.0.1/161");
        String string3 = userConfigFile.get("mibexplorer.TargetTransport_" + string, "udp");
        GenTarget genTarget = new GenTarget(string, string3, string2);
        if (n2 < 3) {
            genTarget.setCommunity(new OctetString(TargetConfiguration._$15244(userConfigFile, propertyEncrypter, string)));
        } else {
            genTarget.setUser(TargetConfiguration.getUser(userConfigFile, string));
        }
        genTarget.setAddressType(userConfigFile.get("mibexplorer.TargetTransport_" + string, "UDP"));
        genTarget.setAddressString(userConfigFile.get("mibexplorer.Address_" + string, "127.0.0.1/161"));
        genTarget.setVersion(n2);
        genTarget.setTimeout(TargetConfiguration._$15241(userConfigFile, string));
        genTarget.setRetries(TargetConfiguration._$15242(userConfigFile, string));
        String string4 = userConfigFile.get("mibexplorer.USMContext_" + string, "");
        String string5 = userConfigFile.get("mibexplorer.USMContextEngineID_" + string, null);
        String string6 = userConfigFile.get("mibexplorer.TargetEngineID_" + string, null);
        genTarget.setContext(OctetString.fromHexString(string4));
        if (string5 != null && string5.length() > 0) {
            genTarget.setContextEngineID(OctetString.fromHexString(string5));
        } else {
            genTarget.setContextEngineID(new OctetString());
        }
        if (string6 != null && string6.length() > 0) {
            genTarget.setEngineID(OctetString.fromHexString(string6));
        } else {
            genTarget.setEngineID(new OctetString());
        }
        genTarget.setMIBSet(userConfigFile.get("mibexplorer.TargetMIBSet_" + string, null));
        return genTarget;
    }

    public boolean isTarget(String string) {
        return this._$7365.get(string) != null;
    }

    private static OctetString _$15285(String string) {
        OctetString octetString = OctetString.fromHexString(string);
        while (octetString.length() < 8 && octetString.length() > 0) {
            octetString.append(octetString);
        }
        return octetString;
    }

    private void _$15287(UserProfile userProfile) {
        this._$5250.remove("mibexplorer.USMSecurityName_" + userProfile.getName());
        this._$5250.remove("mibexplorer.USMAuthProtocol_" + userProfile.getName());
        this._$5250.remove("mibexplorer.USMAuthPassphrase_" + userProfile.getName());
        this._$5250.remove("mibexplorer.USMPrivProtocol_" + userProfile.getName());
        this._$5250.remove("mibexplorer.USMPrivPassphrase_" + userProfile.getName());
    }

    private void _$15288(String string) {
        this._$5250.remove("mibexplorer.Community_" + string);
        this._$5250.remove("mibexplorer.SNMP_" + string);
        this._$5250.remove("mibexplorer.Retries_" + string);
        this._$5250.remove("mibexplorer.Timeout_" + string);
        this._$5250.remove("mibexplorer.TargetMIBSet_" + string);
        this._$5250.remove("mibexplorer.USMContextEngineID_" + string);
        this._$5250.remove("mibexplorer.USMContext_" + string);
        this._$5250.remove("mibexplorer.TargetEngineID_" + string);
        this._$7365.remove(string);
    }

    public UserProfile getUser(String string) {
        return TargetConfiguration.getUser(this._$5250, string);
    }

    public static UserProfile getUser(UserConfigFile userConfigFile, String string) {
        try {
            String string2 = userConfigFile.get("mibexplorer.USMActive_" + string, null);
            PropertyEncrypter propertyEncrypter = new PropertyEncrypter(userConfigFile);
            return TargetConfiguration._$15264(propertyEncrypter, userConfigFile, string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public boolean isUser(String string) {
        return this._$5357.containsKey(string);
    }

    public Hashtable getUsers() {
        return this._$5357;
    }

    public void setUsers(Hashtable hashtable) {
        this._$5357 = hashtable;
        this._$15265();
        for (int i2 = 1; i2 < this._$15205.getNumRows(); ++i2) {
            UserProfile userProfile;
            UserProfile userProfile2 = (UserProfile)this._$15205.getTableDataItem(i2, 9);
            if (userProfile2 != null && this._$5357.get(userProfile2.getName()) == null) {
                this._$15205.setTableDataItem(null, i2, 9);
                continue;
            }
            if (userProfile2 == null || userProfile2.getName() == null || (userProfile = (UserProfile)this._$5357.get(userProfile2.getName())) == null) continue;
            this._$15205.setTableDataItem(this._$5357.get(userProfile2.getName()), i2, 9);
        }
    }

    public Vector getUserNames() {
        Vector<String> vector = new Vector<String>(this._$5357.size() + 1);
        int n2 = 0;
        Enumeration enumeration = this._$5357.elements();
        while (enumeration.hasMoreElements()) {
            vector.add(((UserProfile)enumeration.nextElement()).getName());
            ++n2;
        }
        return vector;
    }

    public GenTarget getTarget(String string) {
        return this._$7365.get(string);
    }

    public Vector getTargetsForUser(String string) {
        Vector<GenTarget> vector = new Vector<GenTarget>();
        Enumeration<GenTarget> enumeration = this._$7365.elements();
        while (enumeration.hasMoreElements()) {
            GenTarget genTarget = enumeration.nextElement();
            if (genTarget.getUser() == null || !genTarget.getUser().getName().equals(string)) continue;
            vector.add(genTarget);
        }
        return vector;
    }

    public GenTarget loadTarget(String string) {
        UserProfile userProfile;
        GenTarget genTarget = TargetConfiguration.loadTarget(this._$5250, this.propertyEncrypter, string);
        if (genTarget.getUser() != null && (userProfile = (UserProfile)this._$5357.get(genTarget.getUser().getName())) != null) {
            genTarget.setUser(userProfile);
        }
        return genTarget;
    }

    public Target getTarget() {
        String string = this._$5250.get("mibexplorer.ActiveTarget", null);
        if (string == null) {
            return null;
        }
        GenTarget genTarget = this.loadTarget(string);
        if (genTarget != null) {
            return genTarget.getTarget();
        }
        return null;
    }

    public String getSelectedUserName() {
        int n2 = TableUtils.getFirstSelectedRow(this.table);
        UserProfile userProfile = (UserProfile)this._$15205.getTableDataItem(n2, 9);
        if (userProfile == null) {
            return null;
        }
        return userProfile.getName();
    }

    private static OctetString _$15244(UserConfigFile userConfigFile, PropertyEncrypter propertyEncrypter, String string) {
        String string2 = userConfigFile.get("mibexplorer.Community_" + string, null);
        if (string2 != null) {
            string2 = TargetConfiguration.decryptPassphraseToHexString(propertyEncrypter, userConfigFile, string2);
        }
        if (string2 == null) {
            return new OctetString();
        }
        return OctetString.fromHexString(string2);
    }

    private static int _$15242(UserConfigFile userConfigFile, String string) {
        return Integer.valueOf(userConfigFile.get("mibexplorer.Retries_" + string, "3"));
    }

    private static int _$15241(UserConfigFile userConfigFile, String string) {
        return Integer.valueOf(userConfigFile.get("mibexplorer.Timeout_" + string, "2000"));
    }

    private static int _$15273(UserConfigFile userConfigFile, String string) {
        return Integer.parseInt(userConfigFile.get("mibexplorer.SNMP_" + string, "2"));
    }

    private static UserProfile _$15264(PropertyEncrypter propertyEncrypter, UserConfigFile userConfigFile, String string) {
        try {
            String string2 = userConfigFile.get("mibexplorer.USMSecurityName_" + string, "");
            String string3 = userConfigFile.get("mibexplorer.USMAuthProtocol_" + string, null);
            String string4 = userConfigFile.get("mibexplorer.USMPrivProtocol_" + string, null);
            OID oID = string3 == null ? null : new OID(string3);
            OID oID2 = string4 == null ? null : new OID(string4);
            OctetString octetString = TargetConfiguration._$15285(TargetConfiguration.decryptPassphraseToHexString(propertyEncrypter, userConfigFile, userConfigFile.get("mibexplorer.USMAuthPassphrase_" + string, "")));
            OctetString octetString2 = TargetConfiguration._$15285(TargetConfiguration.decryptPassphraseToHexString(propertyEncrypter, userConfigFile, userConfigFile.get("mibexplorer.USMPrivPassphrase_" + string, "")));
            boolean bl = userConfigFile.getBoolean("mibexplorer.USMPrincipal_" + string, false);
            OctetString octetString3 = null;
            String string5 = userConfigFile.get("mibexplorer.USMLocalizationID_" + string, null);
            if (string5 != null && string5.length() > 0) {
                try {
                    octetString3 = OctetString.fromHexString(string5);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            UserProfile userProfile = new UserProfile(string, new UsmUser(OctetString.fromHexString(string2), octetString.length() == 0 ? null : oID, octetString, octetString2.length() == 0 ? null : oID2, octetString2, octetString3));
            userProfile.setPrincipal(bl);
            return userProfile;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static boolean isMasterPasswordValid(UserConfigFile userConfigFile) {
        boolean bl = TargetConfiguration.isMasterPasswordNeeded(userConfigFile) && userConfigFile.getMasterKey() != null && userConfigFile.getMasterKey().length >= 8;
        return bl;
    }

    public static boolean isMasterPasswordNeeded(UserConfigFile userConfigFile) {
        return userConfigFile.getBoolean("mibexplorer.MasterPasswordNeeded", false);
    }

    public static void setMasterPasswordNeeded(PropertyEncrypter propertyEncrypter, UserConfigFile userConfigFile, boolean bl) {
        userConfigFile.putBoolean("mibexplorer.MasterPasswordNeeded", bl);
        if (userConfigFile.getMasterKey() != null) {
            userConfigFile.put("mibexplorer.MasterPasswordCheck", TargetConfiguration.encryptPassphraseToHexString(propertyEncrypter, userConfigFile, new OctetString(userConfigFile.getMasterKey())));
        } else {
            userConfigFile.remove("mibexplorer.MasterPasswordCheck");
        }
    }

    public static boolean isMasterPasswordCorrect(PropertyEncrypter propertyEncrypter, UserConfigFile userConfigFile) {
        String string = TargetConfiguration.decryptPassphraseToHexString(propertyEncrypter, userConfigFile, userConfigFile.get("mibexplorer.MasterPasswordCheck", null));
        if (string == null) {
            return true;
        }
        if (string.contains("#")) {
            return false;
        }
        OctetString octetString = OctetString.fromHexString(string);
        return octetString.equalsValue(userConfigFile.getMasterKey());
    }

    public PropertyEncrypter getPropertyEncrypter() {
        return this.propertyEncrypter;
    }

    public static String decryptPassphraseToHexString(PropertyEncrypter propertyEncrypter, UserConfigFile userConfigFile, String string) {
        try {
            if (TargetConfiguration.isMasterPasswordValid(userConfigFile)) {
                int n2 = string.indexOf(35);
                if (n2 < 0) {
                    return string;
                }
                OctetString octetString = OctetString.fromHexString(string.substring(0, n2));
                byte[] byArray = OctetString.fromHexString(string.substring(n2 + 1)).toByteArray();
                byte[] byArray2 = propertyEncrypter.decrypt(byArray, octetString);
                return new OctetString(byArray2).toHexString();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (string != null && string.contains("#")) {
                return new OctetString("<decryption failed>").toHexString();
            }
            return string;
        }
        return string;
    }

    public static String encryptPassphraseToHexString(PropertyEncrypter propertyEncrypter, UserConfigFile userConfigFile, OctetString octetString) {
        if (TargetConfiguration.isMasterPasswordValid(userConfigFile) && octetString.length() > 0) {
            try {
                OctetString octetString2 = new OctetString();
                byte[] byArray = propertyEncrypter.encrypt(octetString.getValue(), octetString2, true);
                return octetString2.toHexString() + "#" + new OctetString(byArray).toHexString();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return octetString.toHexString();
            }
        }
        return octetString.toHexString();
    }

    public GenTarget getActiveTarget() {
        if (this._$15205.getNumRows() > 1) {
            for (int i2 = 1; i2 < this.table.getNumRows(); ++i2) {
                GenTarget genTarget = (GenTarget)this._$15205.getTableRowLabel(i2);
                Integer n2 = (Integer)this._$15205.getTableDataItem(i2, 0);
                if (n2 == null || n2 != 0) continue;
                this._$15312(i2, genTarget);
                return genTarget;
            }
            GenTarget genTarget = (GenTarget)this._$15205.getTableRowLabel(1);
            this._$15312(1, genTarget);
            return genTarget;
        }
        return null;
    }

    public Hashtable getTargets() {
        return this._$7365;
    }

    public void saveTarget(GenTarget genTarget, boolean bl) {
        String string = genTarget.getName();
        this._$5250.put("mibexplorer.Address_" + string, genTarget.getAddressString());
        this._$5250.put("mibexplorer.TargetTransport_" + string, genTarget.getAddressType());
        this._$5250.put("mibexplorer.Retries_" + string, "" + genTarget.getRetries());
        this._$5250.put("mibexplorer.Timeout_" + string, "" + genTarget.getTimeout());
        this._$5250.put("mibexplorer.SNMP_" + string, "" + genTarget.getVersion());
        this._$5250.put("mibexplorer.Community_" + string, genTarget.getCommunity() == null ? null : TargetConfiguration.encryptPassphraseToHexString(this.propertyEncrypter, this._$5250, genTarget.getCommunity()));
        this._$5250.put("mibexplorer.TargetMIBSet_" + string, genTarget.getMIBSet());
        if (genTarget.getUser() != null) {
            this._$5250.put("mibexplorer.USMActive_" + string, genTarget.getUser().getName());
        }
        this._$5250.put("mibexplorer.USMContext_" + string, genTarget.getContext() == null ? null : genTarget.getContext().toHexString());
        if (genTarget.getContextEngineID() != null) {
            this._$5250.put("mibexplorer.USMContextEngineID_" + string, new OctetString(genTarget.getContextEngineID()).toHexString());
        } else {
            this._$5250.put("mibexplorer.USMContextEngineID_" + string, null);
        }
        if (genTarget.getEngineID() != null) {
            this._$5250.put("mibexplorer.TargetEngineID_" + string, new OctetString(genTarget.getEngineID()).toHexString());
        } else {
            this._$5250.put("mibexplorer.TargetEngineID_" + string, null);
        }
        if (bl) {
            this.saveUser(genTarget.getUser());
        }
    }

    private void _$15248() {
        this._$7365.clear();
        for (int i2 = 1; i2 < this._$15205.getNumRows(); ++i2) {
            GenTarget genTarget = (GenTarget)this._$15205.getTableRowLabel(i2);
            this._$15312(i2, genTarget);
        }
    }

    private void _$15312(int n2, GenTarget genTarget) {
        genTarget.setAddress(null);
        genTarget.setName((String)this._$15205.getTableDataItem(n2, 1));
        genTarget.setAddressType((String)this._$15205.getTableDataItem(n2, 2));
        genTarget.setAddressString((String)this._$15205.getTableDataItem(n2, 3));
        genTarget.setVersion(((Number)this._$15205.getTableDataItem(n2, 4)).intValue());
        genTarget.setTimeout(((Number)this._$15205.getTableDataItem(n2, 5)).intValue());
        genTarget.setRetries(((Number)this._$15205.getTableDataItem(n2, 6)).intValue());
        genTarget.setCommunity((OctetString)this._$15205.getTableDataItem(n2, 8));
        genTarget.setContext((OctetString)this._$15205.getTableDataItem(n2, 11));
        genTarget.setEngineID((OctetString)this._$15205.getTableDataItem(n2, 10));
        genTarget.setContextEngineID((OctetString)this._$15205.getTableDataItem(n2, 12));
        genTarget.setMIBSet((String)this._$15205.getTableDataItem(n2, 7));
        UserProfile userProfile = (UserProfile)this._$15205.getTableDataItem(n2, 9);
        genTarget.setUser(userProfile);
        this._$7365.put(genTarget.getName(), genTarget);
    }

    public void saveAllTargets() {
        int n2 = 0;
        for (GenTarget genTarget : this._$7365.values()) {
            this.saveTarget(genTarget, true);
            this._$5250.put("mibexplorer.Target" + n2++, genTarget.getName());
        }
        this._$5250.put("mibexplorer.Target" + n2++, "");
        GenTarget genTarget = this.getActiveTarget();
        if (genTarget != null) {
            this._$5250.put("mibexplorer.ActiveTarget", genTarget.getName());
        } else {
            this._$5250.remove("mibexplorer.ActiveTarget");
        }
    }

    public void removeUser(String string) {
        this._$5357.remove(string);
        this._$5250.remove("mibexplorer.USMSecurityName_" + string);
        this._$5250.remove("mibexplorer.USMAuthProtocol_" + string);
        this._$5250.remove("mibexplorer.USMAuthPassphrase_" + string);
        this._$5250.remove("mibexplorer.USMPrivProtocol_" + string);
        this._$5250.remove("mibexplorer.USMPrivPassphrase_" + string);
        this._$5250.remove("mibexplorer.USMPrincipal_" + string);
        this._$15315();
    }

    public void saveUser(UserProfile userProfile) {
        String string;
        if (userProfile == null) {
            return;
        }
        this._$5250.put("mibexplorer.USMSecurityName_" + userProfile.getName(), userProfile.getUser().getSecurityName().toHexString());
        if (userProfile.getUser().getAuthenticationProtocol() == null) {
            this._$5250.put("mibexplorer.USMAuthProtocol_" + userProfile.getName(), "");
        } else {
            this._$5250.put("mibexplorer.USMAuthProtocol_" + userProfile.getName(), userProfile.getUser().getAuthenticationProtocol().toString());
        }
        String string2 = string = userProfile.getUser().getAuthenticationPassphrase() == null ? "" : userProfile.getUser().getAuthenticationPassphrase().toHexString();
        if (TargetConfiguration.isMasterPasswordValid(this._$5250)) {
            string = TargetConfiguration.encryptPassphraseToHexString(this.propertyEncrypter, this._$5250, userProfile.getUser().getAuthenticationPassphrase());
        }
        this._$5250.put("mibexplorer.USMAuthPassphrase_" + userProfile.getName(), string);
        if (userProfile.getUser().getPrivacyProtocol() == null) {
            this._$5250.put("mibexplorer.USMPrivProtocol_" + userProfile.getName(), "");
        } else {
            this._$5250.put("mibexplorer.USMPrivProtocol_" + userProfile.getName(), userProfile.getUser().getPrivacyProtocol().toString());
        }
        String string3 = string = userProfile.getUser().getPrivacyPassphrase() == null ? "" : userProfile.getUser().getPrivacyPassphrase().toHexString();
        if (TargetConfiguration.isMasterPasswordValid(this._$5250)) {
            string = TargetConfiguration.encryptPassphraseToHexString(this.propertyEncrypter, this._$5250, userProfile.getUser().getPrivacyPassphrase());
        }
        this._$5250.put("mibexplorer.USMPrivPassphrase_" + userProfile.getName(), string);
        this._$5250.putBoolean("mibexplorer.USMPrincipal_" + userProfile.getName(), userProfile.isPrincipal());
        if (userProfile.getUser().getLocalizationEngineID() == null) {
            this._$5250.put("mibexplorer.USMLocalizationID_" + userProfile.getName(), "");
        } else {
            this._$5250.put("mibexplorer.USMLocalizationID_" + userProfile.getName(), userProfile.getUser().getLocalizationEngineID().toHexString());
        }
    }

    private void _$15315() {
        ArrayList arrayList = new ArrayList(this._$5357.size() + 1);
        Iterator iterator = this._$5357.keySet().iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        this._$5250.putArray("mibexplorer.USMUser", arrayList);
    }

    public void saveAllUser() {
        Vector<String> vector = new Vector<String>(this._$5357.size() + 1);
        Enumeration enumeration = this._$5357.elements();
        while (enumeration.hasMoreElements()) {
            UserProfile userProfile = (UserProfile)enumeration.nextElement();
            this.saveUser(userProfile);
            vector.add(userProfile.getName());
        }
        this._$15315();
    }

    public void setSelectedTarget(GenTarget genTarget) {
        for (int i2 = 1; i2 < this._$15205.getNumRows(); ++i2) {
            if (!genTarget.getName().equals(((GenTarget)this._$15205.getTableRowLabel(i2)).getName())) continue;
            this._$15268(i2);
        }
    }

    public GenTarget getCurrentTarget(String string) {
        GenTarget genTarget = null;
        if (string == null) {
            genTarget = this.getActiveTarget();
        }
        if (string != null) {
            genTarget = this._$7365.get(string);
        }
        if (genTarget == null) {
            genTarget = new GenTarget(this._$5329(ACTION_ASCII), new UdpAddress("127.0.0.1/161"));
            genTarget.setAddressString("127.0.0.1/161");
            genTarget.setAddressType("UDP");
            genTarget.setVersion(0);
            genTarget.setCommunity(new OctetString("public"));
        }
        return genTarget;
    }

    private String _$5329(String string) {
        int n2 = 1;
        String string2 = string;
        for (int i2 = 1; i2 < this._$15205.getNumRows(); ++i2) {
            if (!string2.equals(((GenTarget)this._$15205.getTableRowLabel(i2)).getName()) && !string2.equals(this._$15205.getTableDataItem(i2, 1))) continue;
            string2 = string + " " + n2++;
            i2 = 0;
        }
        return string2;
    }

    public void addTarget(GenTarget genTarget) {
        Object object;
        if (this._$7365.containsKey(genTarget.getName())) {
            object = this._$5329(genTarget.getName());
            genTarget.setName((String)object);
        }
        object = this._$15227(genTarget);
        this._$15205.addRow(Integer.MAX_VALUE, genTarget, (Vector)object);
        this.saveTarget(genTarget, false);
        this._$5250.put("mibexplorer.Target" + this._$7365.size(), genTarget.getName());
        this._$7365.put(genTarget.getName(), genTarget);
    }

    public void targetChanged(GenTargetEvent genTargetEvent) {
    }

    public void addUser(UserProfile userProfile) {
        this._$5357.put(userProfile.getName(), userProfile);
        this.saveUser(userProfile);
        this._$15315();
    }

    public void updateUser(UserProfile userProfile) {
        this._$5357.put(userProfile.getName(), userProfile);
        for (int i2 = 0; i2 < this._$15205.getNumRows(); ++i2) {
            UserProfile userProfile2 = (UserProfile)this._$15205.getTableDataItem(i2, 9);
            if (userProfile2 == null || !userProfile2.getName().equals(userProfile.getName())) continue;
            this._$15205.setTableDataItem(userProfile, i2, 9);
        }
        this.saveUser(userProfile);
        this._$15315();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void actionPerformed(ActionEvent actionEvent) {
        Address address;
        if (actionEvent.getActionCommand().equals(ACTION_ADD)) {
            GenTarget genTarget = new GenTarget(this._$5329("New Target"), new UdpAddress("127.0.0.1/161"));
            genTarget.setAddressString("127.0.0.1/161");
            genTarget.setAddressType("UDP");
            genTarget.setVersion(1);
            genTarget.setCommunity(new OctetString("public"));
            genTarget.setRetries(1);
            genTarget.setTimeout(1000);
            this._$15205.addRow(Integer.MAX_VALUE, genTarget, this._$15227(genTarget));
            if (!this.table.beginEdit(this._$15205.getNumRows() - 1, 1)) return;
        }
        if (actionEvent.getActionCommand().equals(ACTION_MOVE_UP)) {
            int n2;
            Collection collection = this.table.getSelectedCells();
            if (collection == null || collection.size() == 0) {
                return;
            }
            JCCellRange[] jCCellRangeArray = new JCCellRange[collection.size()];
            collection.toArray(jCCellRangeArray);
            for (n2 = 0; n2 < jCCellRangeArray.length; ++n2) {
                TableUtils.setRangeAfterCopy(jCCellRangeArray[n2]);
            }
            for (n2 = 0; n2 < jCCellRangeArray.length; ++n2) {
                if (jCCellRangeArray[n2].start_row <= 1) continue;
                new RowMove(this.table, this._$15205, jCCellRangeArray[n2].start_row, jCCellRangeArray[n2].end_row - jCCellRangeArray[n2].start_row + 1, -1);
            }
            return;
        }
        if (actionEvent.getActionCommand().equals(ACTION_MOVE_DOWN)) {
            int n3;
            Collection collection = this.table.getSelectedCells();
            if (collection == null || collection.size() == 0) {
                return;
            }
            JCCellRange[] jCCellRangeArray = new JCCellRange[collection.size()];
            collection.toArray(jCCellRangeArray);
            for (n3 = 0; n3 < jCCellRangeArray.length; ++n3) {
                TableUtils.setRangeAfterCopy(jCCellRangeArray[n3]);
            }
            for (n3 = 0; n3 < jCCellRangeArray.length; ++n3) {
                if (jCCellRangeArray[n3].end_row == this._$15205.getNumRows() - 1) continue;
                new RowMove(this.table, this._$15205, jCCellRangeArray[n3].start_row, jCCellRangeArray[n3].end_row - jCCellRangeArray[n3].start_row + 1, 1);
            }
            return;
        }
        if (actionEvent.getActionCommand().equals(ACTION_DUPLICATE)) {
            int[] nArray = TableUtils.getSelectedRows(this.table);
            if (nArray.length == 0) {
                return;
            }
            Arrays.sort(nArray);
            String string = (String)this._$15205.getTableDataItem(nArray[0], 1);
            GenTarget genTarget = this.getCurrentTarget(string);
            GenTarget genTarget2 = new GenTarget(this._$5329(string), genTarget.getAddress());
            genTarget2.setAddressString(genTarget.getAddressString());
            genTarget2.setAddressType(genTarget.getAddressType());
            genTarget2.setVersion(genTarget.getVersion());
            genTarget2.setCommunity(genTarget.getCommunity());
            genTarget2.setRetries(genTarget.getRetries());
            genTarget2.setTimeout(genTarget.getTimeout());
            genTarget2.setUser(genTarget.getUser());
            genTarget2.setContext(genTarget.getContext());
            genTarget2.setContextEngineID(genTarget.getContextEngineID());
            genTarget2.setEngineID(genTarget.getEngineID());
            this._$15205.addRow(Integer.MAX_VALUE, genTarget2, this._$15227(genTarget2));
            if (!this.table.beginEdit(this._$15205.getNumRows() - 1, 1)) return;
        }
        if (actionEvent.getActionCommand().equals(ACTION_DELETE)) {
            int[] nArray = TableUtils.getSelectedRows(this.table);
            Arrays.sort(nArray);
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                String string = (String)this._$15205.getTableDataItem(nArray[i2] - i2, 1);
                this._$15288(string);
                this._$15205.deleteRows(nArray[i2] - i2, 1);
            }
            this.table.clearSelection();
            this._$15219.setTarget(null);
            this._$5245.sort();
            return;
        }
        if (actionEvent.getActionCommand().equals(ACTION_SET)) {
            if (this._$15205.getNumRows() <= 2) return;
            this._$15268(TableUtils.getFirstMarkedRow(this.table));
            return;
        }
        if (actionEvent.getActionCommand().equals(ACTION_ENGINEID)) {
            int n4 = TableUtils.getFirstMarkedRow(this.table);
            if (n4 < 0) return;
            this._$15325(n4);
            this._$15326(n4, true);
            return;
        }
        if (actionEvent.getActionCommand().equals(ACTION_EDIT)) {
            int n5 = TableUtils.getFirstMarkedRow(this.table);
            if (n5 < 0) return;
            if (this.table.getDataView() instanceof SortableDataViewModel) {
                n5 = ((SortableDataViewModel)this.table.getDataView()).getViewRow(n5);
            }
            this.targetNameEditRow = n5;
            this.table.beginEdit(n5, 1);
            return;
        }
        if (!actionEvent.getActionCommand().equals(ACTION_TEST)) return;
        int n6 = TableUtils.getFirstSelectedRow(this.table);
        if (n6 < 1) {
            JOptionPane.showMessageDialog(this, "Please select a target to test!", "No Target Selected", 0);
            return;
        }
        GenTarget genTarget = (GenTarget)this._$15205.getTableRowLabel(n6);
        if (genTarget == null) return;
        genTarget.setAddress(null);
        PDU pDU = genTarget.makePDU();
        pDU.add(new VariableBinding(new OID("1.3.6.1")));
        ResponseEvent responseEvent = null;
        try {
            responseEvent = this._$14889.getNext(pDU, genTarget.getTarget());
            if (responseEvent != null && responseEvent.getResponse() != null) {
                if (responseEvent.getResponse().getErrorStatus() == 0) {
                    JOptionPane.showMessageDialog(this, "Test success! Agent returned:\n" + responseEvent.getResponse().getVariableBindings().toString(), "Target '" + genTarget.getName() + "' Validated", 1);
                    return;
                } else {
                    JOptionPane.showMessageDialog(this, "Test failure! Agent unexpected error:\n" + responseEvent.getResponse().getErrorStatusText(), "Target '" + genTarget.getName() + "' Not SNMP Compliant", 2);
                }
                return;
            }
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this, "Invalid target. Test result:\n" + iOException.getMessage(), "Target Invalid", 0);
            return;
        }
        if (JOptionPane.showConfirmDialog(this, new String[]{"Test SNMP request timed out for target '" + genTarget.getName() + "'.", "Do you want to ping the address?"}, "Time Out", 2, 2) != 0 || !((address = genTarget.getAddress()) instanceof IpAddress)) return;
        try {
            InetAddress inetAddress = ((IpAddress)address).getInetAddress();
            boolean bl = inetAddress.isReachable(genTarget.getTimeout());
            JOptionPane.showMessageDialog(this, "Target '" + genTarget.getName() + "' is " + (!bl ? "not " : "") + "reachable.", "Ping Result", bl ? 1 : 2);
            return;
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this, "Ping on address '" + address + "' failed: " + iOException.getMessage(), "IO Failure", 0);
        }
        return;
    }

    public void cellDisplay(JCCellDisplayEvent jCCellDisplayEvent) {
        OctetString octetString;
        int n2 = jCCellDisplayEvent.getColumn();
        int n3 = jCCellDisplayEvent.getRow();
        if (n3 < 0) {
            return;
        }
        switch (n2) {
            case 4: {
                if (!(jCCellDisplayEvent.getCellData() instanceof Number)) break;
                int n4 = ((Number)jCCellDisplayEvent.getDisplayData()).intValue();
                jCCellDisplayEvent.setDisplayData(_$15193[n4]);
            }
        }
        if (n2 >= 0 && n2 < _$1713.length && _$1715[n2] != null && _$1715[n2].getMode() != 0 && (octetString = (OctetString)jCCellDisplayEvent.getCellData()) != null) {
            jCCellDisplayEvent.setDisplayData(octetString.toString(':', _$1715[n2].getMode()));
        }
    }

    private void _$15325(int n2) {
        GenTarget genTarget = (GenTarget)this._$15205.getTableRowLabel(n2);
        this._$15312(n2, genTarget);
        byte[] byArray = this._$14889.discoverAuthoritativeEngineID(genTarget.getAddress(), genTarget.getTimeout() * 10);
        if (byArray == null) {
            Toolkit.getDefaultToolkit().beep();
        } else {
            OctetString octetString = new OctetString(byArray);
            this._$15205.setTableDataItem(octetString, n2, 10);
            this._$15205.fireValueChanged(n2, 10);
        }
    }

    public void beforeSelect(JCSelectEvent jCSelectEvent) {
    }

    public void select(JCSelectEvent jCSelectEvent) {
    }

    public void clearSelection() {
        this.table.clearSelection();
        this._$15219.setTarget(null);
    }

    public void afterSelect(JCSelectEvent jCSelectEvent) {
        if (jCSelectEvent.getAction() == 4) {
            int n2 = TableUtils.getFirstSelectedRow(this.table);
            this._$15326(n2, false);
        }
    }

    private void _$15326(int n2, boolean bl) {
        if (n2 > 0 && (bl || TableUtils.getFirstSelectedRow(this.table) == n2)) {
            GenTarget genTarget = (GenTarget)this._$15205.getTableRowLabel(n2);
            if (bl) {
                this._$15312(n2, genTarget);
            }
            this._$15219.setTarget(genTarget);
        } else {
            this._$15219.setTarget(null);
        }
    }

    public void traverseCell(JCTraverseCellEvent jCTraverseCellEvent) {
    }

    public void afterTraverseCell(JCTraverseCellEvent jCTraverseCellEvent) {
    }

    public void beforeEditCell(JCEditCellEvent jCEditCellEvent) {
        switch (jCEditCellEvent.getColumn()) {
            case 0: {
                int n2 = jCEditCellEvent.getRow();
                int n3 = jCEditCellEvent.getColumn();
                Integer n4 = (Integer)this.table.getDataView().getDataSource().getTableDataItem(n2, n3);
                if (n4 == null || n4 != 0) break;
                jCEditCellEvent.setCancelled(true);
                break;
            }
            case 1: {
                String string = (String)this._$15205.getTableDataItem(jCEditCellEvent.getRow(), jCEditCellEvent.getColumn());
                if (string == null) {
                    jCEditCellEvent.setCancelled(true);
                    return;
                }
                jCEditCellEvent.setCancelled(!this._$15222(string, jCEditCellEvent.getRow()));
                break;
            }
        }
    }

    private boolean _$15222(String string, int n2) {
        for (int i2 = 1; i2 < this._$15205.getNumRows(); ++i2) {
            if (i2 == n2 || !string.equals(this._$15205.getTableDataItem(i2, 1))) continue;
            return false;
        }
        return true;
    }

    public void editCell(JCEditCellEvent jCEditCellEvent) {
    }

    public void afterEditCell(JCEditCellEvent jCEditCellEvent) {
        this.targetNameEditRow = 0;
        int n2 = jCEditCellEvent.getRow();
        n2 = TableUtils.getDataRows(this.table, new int[]{n2})[0];
        if (jCEditCellEvent.getColumn() == 0) {
            this._$15268(n2);
        }
        this._$15326(n2, true);
    }

    public void valueChangedBegin(JCValidateEvent jCValidateEvent) {
        Object object = jCValidateEvent.getOldValue();
        Object object2 = jCValidateEvent.getValue();
        if (object2 == null) {
            jCValidateEvent.setValid(false);
            return;
        }
        if (object != null && !object.equals(object2) || object == null && object2 != null) {
            String string = (String)object2;
            for (int i2 = 1; i2 < this._$15205.getNumRows(); ++i2) {
                if (!string.equals(this._$15205.getTableDataItem(i2, 1))) continue;
                jCValidateEvent.setValid(false);
                return;
            }
        }
    }

    public void valueChangedEnd(JCValidateEvent jCValidateEvent) {
    }

    public void stateIsInvalid(JCValidateEvent jCValidateEvent) {
    }

    private void _$5459(int n2, int n3) {
        String string = "";
        _$1715[n3].setMode(n2);
        switch (n2) {
            case 16: {
                string = " [HEX]";
                break;
            }
            case 10: {
                string = " [DEC]";
            }
        }
        SortLabel sortLabel = (SortLabel)this._$15205.getTableColumnLabel(n3);
        sortLabel.setLabel(_$1713[n3] + string);
        this._$15205.fireColumnLabelChanged(n3);
    }

    public void userConfigChanged(UserConfigurationEvent userConfigurationEvent) {
        if (userConfigurationEvent.getType() == 1) {
            String string = userConfigurationEvent.getUser().getName();
            for (int i2 = 1; i2 < this._$15205.getNumRows(); ++i2) {
                String string2;
                UserProfile userProfile = (UserProfile)this._$15205.getTableDataItem(i2, 9);
                if (userProfile == null || (string2 = userProfile.getName()) == null || !string.equals(string2)) continue;
                userConfigurationEvent.setCanceled(true);
                return;
            }
        }
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                int n2 = TargetConfiguration.this._$5250.getInteger("mibexplorer.target.config.divider.location", -1);
                if (n2 >= 0) {
                    TargetConfiguration.this._$5248.setDividerLocation(n2);
                } else {
                    TargetConfiguration.this._$5248.setDividerLocation(0.6);
                }
            }
        });
    }

    public boolean checkTargets() {
        for (int i2 = 1; i2 < this._$15205.getNumRows(); ++i2) {
            String string = (String)this._$15205.getTableDataItem(i2, 1);
            String string2 = (String)this._$15205.getTableDataItem(i2, 3);
            String string3 = (String)this._$15205.getTableDataItem(i2, 2);
            if (string2 != null && string3 != null) continue;
            JOptionPane.showMessageDialog(this, new String[]{"Address type and address has to be provided for target", "'" + string + "'. Please provide them now."}, "Invalid Address", 2);
            return false;
        }
        return true;
    }

    class FormatAction
    extends AbstractAction {
        public FormatAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JCCellPosition jCCellPosition = TargetConfiguration.this.table.getPopupCellPosition();
            if (jCCellPosition.column >= 0 && jCCellPosition.column < _$1713.length) {
                if (actionEvent.getActionCommand().equals(TargetConfiguration.ACTION_ASCII)) {
                    TargetConfiguration.this._$5459(0, jCCellPosition.column);
                } else if (actionEvent.getActionCommand().equals(TargetConfiguration.ACTION_HEX)) {
                    TargetConfiguration.this._$5459(16, jCCellPosition.column);
                } else if (actionEvent.getActionCommand().equals(TargetConfiguration.ACTION_DEC)) {
                    TargetConfiguration.this._$5459(10, jCCellPosition.column);
                }
            }
        }
    }
}

