/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.explorer;

import com.agentpp.explorer.NodeUpdater;
import com.agentpp.explorer.RequestObserver;
import com.agentpp.explorer.log.SnmpLogger;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBRepository;
import com.agentpp.snmp.GenTarget;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.snmp4j.PDU;
import org.snmp4j.Session;
import org.snmp4j.Target;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.VariableBinding;

public class ResponseListener
implements org.snmp4j.event.ResponseListener {
    protected Session session;
    protected MIBRepository repository;
    protected JTree tree;
    protected DefaultTreeModel model;
    protected DefaultMutableTreeNode node;
    protected Target target;
    protected GenTarget gtarget;
    protected OID root;
    protected RequestObserver observer;
    protected SnmpLogger logger;
    protected int maxInstances = 0;
    protected int instanceCount = 0;
    protected String displayFormat;

    public ResponseListener(RequestObserver requestObserver, Session session, Target target, GenTarget genTarget, MIBRepository mIBRepository, JTree jTree, DefaultTreeModel defaultTreeModel, DefaultMutableTreeNode defaultMutableTreeNode, String string) {
        this.observer = requestObserver;
        this.target = target;
        this.gtarget = genTarget;
        this.session = session;
        this.repository = mIBRepository;
        this.logger = new SnmpLogger(mIBRepository);
        this.tree = jTree;
        this.model = defaultTreeModel;
        this.node = defaultMutableTreeNode;
        this.displayFormat = string;
        this.root = new OID(((Object)((MIBObject)defaultMutableTreeNode.getUserObject()).getObjectID()).toString());
    }

    public void onResponse(ResponseEvent responseEvent) {
        this.session.cancel(responseEvent.getRequest(), this);
        if (this.observer.isRequestCanceled()) {
            return;
        }
        if (this.logger.logResponse(responseEvent, this.observer)) {
            VariableBinding[] variableBindingArray = responseEvent.getResponse().toArray();
            this.instanceCount += variableBindingArray.length;
            SwingUtilities.invokeLater(new NodeUpdater(this.repository, this.tree, this.model, this.node, this.displayFormat, variableBindingArray));
            if (responseEvent.getRequest().getType() != -93 && (this.maxInstances <= 0 || this.instanceCount < this.maxInstances)) {
                if (variableBindingArray.length > 0 && !variableBindingArray[variableBindingArray.length - 1].isException() && variableBindingArray[variableBindingArray.length - 1].getOid().leftMostCompare(this.root.size(), this.root) == 0) {
                    PDU pDU = responseEvent.getRequest();
                    pDU.clear();
                    VariableBinding[] variableBindingArray2 = new VariableBinding[]{new VariableBinding()};
                    variableBindingArray2[0].setOid(variableBindingArray[variableBindingArray.length - 1].getOid());
                    pDU.addAll(variableBindingArray2);
                    try {
                        this.observer.resendRequest(-91, pDU, this.gtarget, this.target, null, this, null);
                    }
                    catch (Exception exception) {
                        this.observer.requestFinishedWithError("I/O error: " + exception.getMessage());
                        exception.printStackTrace();
                    }
                } else {
                    this.observer.requestFinished();
                }
            } else {
                this.observer.requestFinished();
            }
        }
    }

    public void setMaxInstances(int n2) {
        this.maxInstances = n2;
    }
}

