/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.explorer;

import com.agentpp.common.MemoryStatus;
import com.agentpp.explorer.RequestObserver;
import com.agentpp.explorer.log.SnmpLogger;
import com.agentpp.snmp.GenTarget;
import com.borland.jbcl.layout.VerticalFlowLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Hashtable;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.apache.log4j.Logger;
import org.snmp4j.PDU;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.event.ResponseListener;
import org.snmp4j.smi.TcpAddress;
import org.snmp4j.transport.UnsupportedAddressClassException;

public class RequestObserverPanel
extends JPanel
implements RequestObserver {
    JButton jButtonStop = new JButton();
    private TimingOut _$25251;
    private Snmp _$14889;
    private Timer _$16145 = new Timer();
    private volatile transient boolean _$25252 = false;
    private boolean _$25253 = false;
    private JPanel _$25254 = new JPanel();
    private JProgressBar _$25255 = new JProgressBar();
    private JLabel _$25256 = new JLabel();
    private BorderLayout _$549 = new BorderLayout();
    private FlowLayout _$25257 = new FlowLayout();
    private JPanel _$25258 = new JPanel();
    private VerticalFlowLayout _$14339 = new VerticalFlowLayout();
    private Hashtable _$25259 = new Hashtable(10);
    private boolean _$25260;

    public RequestObserverPanel(Snmp snmp) {
        this(snmp, false);
    }

    public RequestObserverPanel(Snmp snmp, boolean bl) {
        this._$25253 = bl;
        this._$14889 = snmp;
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public RequestObserverPanel() {
        this((Snmp)null);
    }

    void jbInit() throws Exception {
        this.setLayout(this._$549);
        this.setMessage(" ");
        URL uRL = Thread.currentThread().getContextClassLoader().getResource("toolbarButtonGraphics/media/Stop16.gif");
        this.jButtonStop.setIcon(new ImageIcon(uRL));
        this.jButtonStop.setToolTipText("Cancel current request");
        this.jButtonStop.setEnabled(false);
        this.jButtonStop.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RequestObserverPanel.this.jButtonStop_actionPerformed(actionEvent);
            }
        });
        this._$25254.setLayout(this._$25257);
        this._$25257.setAlignment(0);
        this._$25258.setLayout(this._$14339);
        this._$14339.setAlignment(2);
        this.add((Component)this._$25254, "West");
        this._$25254.add((Component)this.jButtonStop, null);
        this._$25254.add((Component)this._$25255, null);
        this._$25254.add((Component)this._$25256, null);
        this.add((Component)this._$25258, "East");
        if (this._$25253) {
            this._$25258.add((Component)new MemoryStatus(), null);
        }
    }

    public void stop() {
        if (this._$25251 != null) {
            this._$25251.stop();
            this._$25251 = null;
            this._$25252 = true;
            this.setMessage("Stopped.");
            this.stopped();
        }
    }

    synchronized void jButtonStop_actionPerformed(ActionEvent actionEvent) {
        this.stop();
    }

    public void stopped() {
    }

    public void requestFinishedWithError(String string) {
        this.requestFinished();
        this.setMessage(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMessage(String string) {
        JLabel jLabel = this._$25256;
        synchronized (jLabel) {
            if (string != null && string.trim().length() > 0 && !string.endsWith(".") && !string.endsWith("!")) {
                string = string + ".";
            }
            this._$25256.setText(string);
        }
    }

    public synchronized void requestFinished() {
        if (this._$25251 != null) {
            this._$25251.stop();
            this._$25251 = null;
        }
        this.updateTimerButtons();
        this.setMessage("Finished.");
    }

    public synchronized void addOutstanding(Object object, ResponseListener responseListener) {
        this._$25259.put(object, responseListener);
    }

    public synchronized void removeOutstanding(Object object) {
        this._$25259.remove(object);
    }

    public void setCurrentRequest(PDU pDU, ResponseListener responseListener, String string) {
        if (this._$25251 != null) {
            this._$25251.reset(pDU, responseListener);
            if (string != null) {
                this.setMessage(string);
            }
        }
    }

    public void updateTimerButtons() {
        this.jButtonStop.setEnabled(this._$25251 != null);
    }

    public synchronized boolean isRequestCanceled() {
        return this._$25251 == null;
    }

    public synchronized String getMessage() {
        return this._$25256.getText();
    }

    public synchronized void request(int n2, PDU pDU, GenTarget genTarget, Target target, Object object, ResponseListener responseListener, String string) {
        if (this._$25251 != null) {
            this._$25251.stop();
        }
        this._$25251 = null;
        if (target == null) {
            Toolkit.getDefaultToolkit().beep();
            this.setMessage("Timeout on engine ID discovery!");
            return;
        }
        if (target.getAddress() == null) {
            Toolkit.getDefaultToolkit().beep();
            this.setMessage("Could not resolve " + genTarget.getAddressType() + " address: " + genTarget.getAddressString());
            return;
        }
        int n3 = genTarget.getTimeout() * (1 + genTarget.getRetries());
        this._$25255.setMaximum(n3);
        this._$25255.setMinimum(0);
        this._$25255.setValue(0);
        if (n2 != -89) {
            this._$25251 = new TimingOut(pDU, responseListener, n3);
            this.updateTimerButtons();
            this._$16145.scheduleAtFixedRate((TimerTask)this._$25251, 0L, 10L);
        }
        try {
            if (string == null) {
                String string2 = RequestObserverPanel.getRequestTypeString(n2);
                if (string2 != null) {
                    if (target.getVersion() == 0 && n2 == -91) {
                        string2 = RequestObserverPanel.getRequestTypeString(-95);
                    }
                    this.setMessage("Sending " + string2 + " request to " + target.getAddress().toString());
                }
            } else {
                this.setMessage(string);
            }
            switch (n2) {
                case -91: {
                    this._$14889.getBulk(pDU, target, object, responseListener);
                    break;
                }
                case -95: {
                    this._$14889.getNext(pDU, target, object, responseListener);
                    break;
                }
                case -93: {
                    this._$14889.set(pDU, target, object, responseListener);
                    break;
                }
                case -90: {
                    this._$14889.inform(pDU, target, object, responseListener);
                    break;
                }
                case -89: {
                    this._$14889.notify(pDU, target);
                    this.setMessage("Sent " + PDU.getTypeString(n2) + " to " + target.getAddress());
                    break;
                }
                default: {
                    this._$14889.get(pDU, target, object, responseListener);
                }
            }
            SnmpLogger.logRequest(pDU, genTarget);
            if (this._$25260) {
                this._$25259.put(pDU, responseListener);
            }
        }
        catch (UnsupportedAddressClassException unsupportedAddressClassException) {
            Logger logger = Logger.getLogger("SNMP.Transport");
            logger.error("Failed to send request: " + unsupportedAddressClassException.getMessage());
            this.stop();
            String string3 = "UDP";
            if (unsupportedAddressClassException.getAddressClass().equals(TcpAddress.class)) {
                string3 = "TCP";
            }
            String[] stringArray = new String[]{"The transport '" + string3 + "' is not available or not enabled.", "Please verify under Preferences/Transport that this transport", "is enabled and then try again!"};
            JOptionPane.showMessageDialog(this, stringArray, "Unavailable Transport", 0);
        }
        catch (Exception exception) {
            Logger logger = Logger.getLogger("SNMP.Transport");
            logger.fatal("Failed to send request: " + exception.getMessage());
            exception.printStackTrace();
            this.stop();
            this.setMessage("Failed to send request: " + exception.getMessage());
        }
    }

    public synchronized void resendRequest(int n2, PDU pDU, GenTarget genTarget, Target target, Object object, ResponseListener responseListener, String string) {
        if (target == null) {
            Toolkit.getDefaultToolkit().beep();
            this.setMessage("Timeout on engine ID discovery!");
            return;
        }
        if (this._$25251 != null) {
            this._$25251.reset(pDU, responseListener);
        } else {
            if (this._$25259.size() == 0) {
                return;
            }
            int n3 = genTarget.getTimeout() * (1 + genTarget.getRetries());
            this._$25251 = new TimingOut(pDU, responseListener, n3);
            this._$16145.scheduleAtFixedRate((TimerTask)this._$25251, 0L, 10L);
        }
        this.updateTimerButtons();
        try {
            if (string == null) {
                String string2 = RequestObserverPanel.getRequestTypeString(n2);
                if (string2 != null) {
                    this.setMessage("Sending " + string2 + " request to " + target.getAddress().toString());
                }
            } else {
                this.setMessage(string);
            }
            switch (n2) {
                case -91: {
                    this._$14889.getBulk(pDU, target, object, responseListener);
                    break;
                }
                case -96: {
                    this._$14889.get(pDU, target, object, responseListener);
                    break;
                }
                case -95: {
                    this._$14889.getNext(pDU, target, object, responseListener);
                    break;
                }
                case -93: {
                    this._$14889.set(pDU, target, object, responseListener);
                }
            }
            SnmpLogger.logRequest(pDU, genTarget);
            if (this._$25260) {
                this._$25259.put(pDU, responseListener);
            }
        }
        catch (Exception exception) {
            Logger logger = Logger.getLogger("SNMP.Transport");
            logger.error("Failed to send request: " + exception.getMessage());
            this.setMessage("Failed to send request: " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    public static String getRequestTypeString(int n2) {
        String string = null;
        switch (n2) {
            case -91: {
                string = "BULK";
                break;
            }
            case -96: {
                string = "GET";
                break;
            }
            case -95: {
                string = "GETNEXT";
                break;
            }
            case -93: {
                string = "SET";
            }
        }
        return string;
    }

    public void setMultiRequestEnabled(boolean bl) {
        this._$25260 = bl;
    }

    public boolean isMultiRequestEnabled() {
        return this._$25260;
    }

    public int getRequestedValuesLimit() {
        return 0;
    }

    class TimingOut
    extends TimerTask {
        private int _$25277 = 0;
        private int _$16035;
        private PDU _$20772;
        private ResponseListener _$21228;
        private int _$25278 = 10;

        public TimingOut(PDU pDU, ResponseListener responseListener, int n2) {
            this._$20772 = pDU;
            this._$21228 = responseListener;
            this._$16035 = n2;
        }

        public void reset(PDU pDU, ResponseListener responseListener) {
            this._$20772 = pDU;
            this._$21228 = responseListener;
            this._$25277 = 0;
        }

        public void setStepping(int n2) {
            this._$25278 = n2;
        }

        public void stop() {
            this.cancel();
            RequestObserverPanel.this._$14889.cancel(this._$20772, this._$21228);
            this._$25277 = 0;
            RequestObserverPanel.this._$25255.setValue(this._$25277);
            RequestObserverPanel.this.updateTimerButtons();
        }

        public void run() {
            if (this._$25277 < this._$16035) {
                this._$25277 += this._$25278;
            } else {
                RequestObserverPanel.this._$25255.setValue(this._$16035);
                return;
            }
            RequestObserverPanel.this._$25255.setValue(this._$25277);
        }
    }
}

