/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.explorer;

import com.agentpp.common.ChangeManager;
import com.agentpp.common.ComponentLinkEvent;
import com.agentpp.common.ComponentLinkListener;
import com.agentpp.common.StandardDialog;
import com.agentpp.common.StandardFrame;
import com.agentpp.common.images.ToolBarUtils;
import com.agentpp.common.table.ExtendedTable;
import com.agentpp.common.table.JTableColumnResizeEmulator;
import com.agentpp.common.table.PopupTable;
import com.agentpp.common.table.RowMove;
import com.agentpp.common.table.TableUtils;
import com.agentpp.explorer.DraggableTreeNode;
import com.agentpp.explorer.MIBExplorerFrame;
import com.agentpp.explorer.MIBInstance;
import com.agentpp.explorer.MIBTablePanel;
import com.agentpp.explorer.MultiPDUDialog;
import com.agentpp.explorer.PDUTabbedPanel;
import com.agentpp.explorer.PDUTypePanel;
import com.agentpp.explorer.RequestObserverPanel;
import com.agentpp.explorer.SelectTargetsPanel;
import com.agentpp.explorer.TabbedControlledPanel;
import com.agentpp.explorer.cfg.MIBExplorerConfig;
import com.agentpp.explorer.editors.cell.EnumCellEditor;
import com.agentpp.explorer.editors.cell.IpAddressCellEditor;
import com.agentpp.explorer.editors.cell.ObjectIDCellEditor;
import com.agentpp.explorer.log.SnmpLogger;
import com.agentpp.mib.MIBEnum;
import com.agentpp.mib.MIBNotifyType;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBObjectType;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.MIBSyntax;
import com.agentpp.mib.MIBTextualConvention;
import com.agentpp.mib.ObjectID;
import com.agentpp.mib.event.MIBObjectEvent;
import com.agentpp.mib.event.MIBObjectListener;
import com.agentpp.smiparser.SMI;
import com.agentpp.snmp.GenTarget;
import com.agentpp.snmp.JCValueConverter;
import com.agentpp.snmp.ValueConverter;
import com.agentpp.snmp.types.ComparableIpAddress;
import com.agentpp.util.ExampleFileFilter;
import com.agentpp.util.UserConfigFile;
import com.klg.jclass.cell.JCCellEditor;
import com.klg.jclass.cell.editors.BaseCellEditor;
import com.klg.jclass.cell.editors.JCBigDecimalCellEditor;
import com.klg.jclass.cell.editors.JCComboBoxCellEditor;
import com.klg.jclass.cell.editors.JCIntegerCellEditor;
import com.klg.jclass.cell.editors.JCLongCellEditor;
import com.klg.jclass.cell.editors.JCStringCellEditor;
import com.klg.jclass.field.JCSpinField;
import com.klg.jclass.table.CellArea;
import com.klg.jclass.table.JCCellDisplayEvent;
import com.klg.jclass.table.JCCellDisplayListener;
import com.klg.jclass.table.JCCellPosition;
import com.klg.jclass.table.JCCellRange;
import com.klg.jclass.table.JCCellStyle;
import com.klg.jclass.table.JCEditCellEvent;
import com.klg.jclass.table.JCEditCellListener;
import com.klg.jclass.table.JCSelectEvent;
import com.klg.jclass.table.JCSelectListener;
import com.klg.jclass.table.JCTable;
import com.klg.jclass.table.JCTableCellInfo;
import com.klg.jclass.table.TablePopupMenu;
import com.klg.jclass.table.data.JCEditableVectorDataSource;
import com.klg.jclass.util.value.JCValueEvent;
import com.klg.jclass.util.value.JCValueListener;
import com.objectspace.jgl.Pair;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.snmp4j.PDU;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.event.ResponseListener;
import org.snmp4j.mp.SnmpConstants;
import org.snmp4j.smi.Null;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TimeTicks;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;

public class MultiVariablePanel
extends TabbedControlledPanel
implements ResponseListener,
JCCellDisplayListener,
JCValueListener,
JCEditCellListener,
DropTargetListener,
JCSelectListener,
MouseListener,
ActionListener {
    public static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String[] TITLES = new String[]{"Object ID", "Syntax", "Value", ""};
    private static final int[] _$25679 = new int[]{25, 15, 20, 0};
    public static final int COL_OID = 0;
    public static final int COL_SYNTAX = 1;
    public static final int COL_VALUE = 2;
    public static final int COL_VALUE_CONVERTER = 3;
    public static final String ACTION_UNLOCK = "Unlock";
    public static final String[] WIRE_SYNTAXES = new String[]{SMI.SMI_SYNTAX[0], SMI.SMI_SYNTAX[1], SMI.SMI_SYNTAX[2], SMI.SMI_SYNTAX[4], SMI.SMI_SYNTAX[11], SMI.SMI_SYNTAX[3], SMI.SMI_SYNTAX[6], SMI.SMI_SYNTAX[12], SMI.SMI_SYNTAX[9], SMI.SMI_SYNTAX[10], SMI.SMI_SYNTAX[14]};
    public static final int[] WIRE_SYNTAX_IDS = new int[]{0, 1, 2, 4, 11, 3, 6, 12, 9, 10, 14};
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanelNorth = new JPanel();
    JPanel jPanelCenter = new JPanel();
    JToolBar jToolBar1 = new JToolBar();
    JButton jButtonNewRow = new JButton();
    JButton jButtonCopyRow = new JButton();
    JButton jButtonRefresh = new JButton();
    Border border1;
    private File _$28749;
    private boolean _$28750 = true;
    private JFrame _$25700;
    private JCEditableVectorDataSource _$11754 = new JCEditableVectorDataSource();
    private Snmp _$14889;
    private Target _$15238 = null;
    private GenTarget _$15220;
    private MIBRepository _$20550;
    private PopupTable _$274;
    private PDU _$20772;
    private JCCellStyle _$25703;
    JButton jButtonUndo = new JButton();
    private ChangeManager _$25705 = new ChangeManager();
    private CellEdit _$25707 = null;
    JButton jButtonRedo = new JButton();
    private JCSpinField _$28751 = new JCSpinField();
    private JComboBox _$28752 = new JComboBox();
    private DefaultComboBoxModel _$28753 = new DefaultComboBoxModel();
    private Timer _$16145;
    BorderLayout borderLayout4 = new BorderLayout();
    JProgressBar jProgressBarTimer = new JProgressBar();
    JButton jButtonPlay = new JButton();
    JButton jButtonPause = new JButton();
    private int _$25713 = 5;
    private boolean _$25714 = false;
    Border border2;
    private boolean _$28178 = false;
    JLabel jLabelRefresh = new JLabel();
    JToolBar jToolBarRefresh = new JToolBar();
    FlowLayout flowLayout3 = new FlowLayout();
    JButton jButtonApply = new JButton();
    private JCCellStyle _$26899;
    private DropTarget _$10361;
    private DropTarget _$25717;
    private Hashtable _$7365;
    private UserConfigFile _$5250;
    JButton jButtonDeleteRow = new JButton();
    JButton jButtonMultiSet = new JButton();
    JToggleButton jToggleButtonExport = new JToggleButton();
    JButton jButtonMoveUp = new JButton();
    JButton jButtonMoveDown = new JButton();
    RequestObserverPanel observer;
    private String _$7264;
    JButton jButtonZoomIn = new JButton();
    JButton jButtonZoomOut = new JButton();
    JMenu dhMenu = new JMenu("String Format");
    private transient Vector _$25728;
    private SnmpLogger _$12571;
    StandardFrame f = null;
    private File _$19387;
    public static ImageIcon imageZoomIn16 = new ImageIcon(Thread.currentThread().getContextClassLoader().getResource("toolbarButtonGraphics/general/ZoomIn16.gif"));
    public static ImageIcon imageZoomOut16 = new ImageIcon(Thread.currentThread().getContextClassLoader().getResource("toolbarButtonGraphics/general/ZoomOut16.gif"));
    public static ImageIcon imageSaveAs16 = new ImageIcon(Thread.currentThread().getContextClassLoader().getResource("toolbarButtonGraphics/general/SaveAs16.gif"));
    public static ImageIcon imageNew16 = new ImageIcon(Thread.currentThread().getContextClassLoader().getResource("toolbarButtonGraphics/general/New16.gif"));
    public static ImageIcon imagePause16 = new ImageIcon(Thread.currentThread().getContextClassLoader().getResource("toolbarButtonGraphics/media/Pause16.gif"));
    public static ImageIcon imagePlay16 = new ImageIcon(Thread.currentThread().getContextClassLoader().getResource("toolbarButtonGraphics/media/Play16.gif"));
    public static ImageIcon imageExport16 = new ImageIcon(Thread.currentThread().getContextClassLoader().getResource("toolbarButtonGraphics/general/Export16.gif"));
    public static ImageIcon imagePreferences16 = new ImageIcon(Thread.currentThread().getContextClassLoader().getResource("toolbarButtonGraphics/general/Preferences16.gif"));
    public static ImageIcon imageEdit16 = new ImageIcon(Thread.currentThread().getContextClassLoader().getResource("toolbarButtonGraphics/general/Edit16.gif"));
    public static ImageIcon imageHelp16 = new ImageIcon(Thread.currentThread().getContextClassLoader().getResource("toolbarButtonGraphics/general/Help16.gif"));
    public static ImageIcon imageSendMail16 = new ImageIcon(Thread.currentThread().getContextClassLoader().getResource("toolbarButtonGraphics/general/SendMail16.gif"));
    public static ImageIcon imageDeleteRow16 = new ImageIcon(Thread.currentThread().getContextClassLoader().getResource("toolbarButtonGraphics/table/RowDelete16.gif"));
    public static ImageIcon imageUndo16 = new ImageIcon(Thread.currentThread().getContextClassLoader().getResource("toolbarButtonGraphics/general/Undo16.gif"));
    public static ImageIcon imageRedo16 = new ImageIcon(Thread.currentThread().getContextClassLoader().getResource("toolbarButtonGraphics/general/Redo16.gif"));
    public static ImageIcon imageRefresh16 = new ImageIcon(Thread.currentThread().getContextClassLoader().getResource("toolbarButtonGraphics/general/Refresh16.gif"));
    public static ImageIcon imageUp16 = new ImageIcon(Thread.currentThread().getContextClassLoader().getResource("toolbarButtonGraphics/navigation/Up16.gif"));
    public static ImageIcon imageDown16 = new ImageIcon(Thread.currentThread().getContextClassLoader().getResource("toolbarButtonGraphics/navigation/Down16.gif"));
    private transient Vector _$25771;
    private transient Vector _$25772;

    public MultiVariablePanel() {
        this._$274 = new PopupTable();
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public MultiVariablePanel(JFrame jFrame, Snmp snmp, MIBRepository mIBRepository, Hashtable hashtable, UserConfigFile userConfigFile) {
        this._$25700 = jFrame;
        this._$14889 = snmp;
        this.observer = new RequestObserverPanel(snmp);
        this._$20550 = mIBRepository;
        this._$12571 = new SnmpLogger(mIBRepository);
        this._$11754 = this._$11754;
        this._$5250 = userConfigFile;
        this._$7365 = hashtable;
        this._$15238 = this._$15238;
        this._$25808();
        this._$28759(MultiPDUDialog.NON_TRAP_PDU_TYPES);
        this._$274 = new ExtendedTable(){

            public boolean isPopupAllowed(int n2, int n3) {
                TablePopupMenu tablePopupMenu = super.getPopupMenu();
                JCCellPosition jCCellPosition = MultiVariablePanel.this._$274.XYToCell(n2, n3);
                int n4 = MultiVariablePanel.this._$1241(jCCellPosition.row, jCCellPosition.column);
                if (n4 < 0) {
                    return false;
                }
                ValueConverter valueConverter = (ValueConverter)MultiVariablePanel.this._$11754.getTableDataItem(n4, 3);
                if (valueConverter == null || !SMI.isString(valueConverter.getEffectiveSyntax().getSyntax())) {
                    MultiVariablePanel.this.dhMenu.setEnabled(false);
                } else {
                    MultiVariablePanel.this.dhMenu.setEnabled(true);
                }
                return true;
            }

            public String getToolTipText(MouseEvent mouseEvent) {
                ValueConverter valueConverter;
                JCCellPosition jCCellPosition = this.XYToCell(mouseEvent.getX(), mouseEvent.getY());
                if (jCCellPosition.column < 0 || jCCellPosition.row < 0) {
                    return null;
                }
                int n2 = MultiVariablePanel.this._$1241(jCCellPosition.row, jCCellPosition.column);
                int n3 = MultiVariablePanel.this._$25810(jCCellPosition.row, jCCellPosition.column);
                Object object = MultiVariablePanel.this._$11754.getTableDataItem(n2, n3);
                if (object == null) {
                    return null;
                }
                if (n3 == 2 && object instanceof String && (valueConverter = (ValueConverter)MultiVariablePanel.this._$11754.getTableDataItem(n2, 3)) != null) {
                    OctetString octetString = (OctetString)valueConverter.fromNative(object);
                    return ValueConverter.getPrintableString(octetString);
                }
                return object.toString();
            }
        };
        ToolTipManager.sharedInstance().registerComponent(this._$274);
        this._$274.setRowHidden(0, true);
        this._$274.setColumnLabelDisplay(true);
        this._$274.setRowLabelDisplay(true);
        this._$274.setResizeEven(false);
        this._$274.setDataSource(this._$11754);
        this._$274.setVisibleColumns(this._$11754.getNumColumns());
        this._$274.setVisibleRows(20);
        this._$274.setColumnHidden(3, true);
        this._$274.setPopupMenuEnabled(false);
        this._$274.setAllowCellResize(2);
        this._$274.setCharWidth(-1, 2);
        this._$274.setVertSBTrackColumn(-1);
        this._$274.setAutoScroll(1);
        this._$274.setCharHeight(-1, 1);
        TablePopupMenu tablePopupMenu = this._$274.getPopupMenu();
        tablePopupMenu.addItem(ACTION_UNLOCK, this);
        tablePopupMenu.add(new JSeparator());
        tablePopupMenu.add(this.dhMenu);
        this.dhMenu.setMnemonic('F');
        JMenuItem jMenuItem = this.dhMenu.add(new FormatAction("ASCII", "255a"));
        jMenuItem.setToolTipText("Sets the display and input format for this string object to '255a', e.g. 'aBc' renders 'aBc'");
        jMenuItem.setMnemonic('A');
        jMenuItem = this.dhMenu.add(new FormatAction("Decimal", "1d."));
        jMenuItem.setToolTipText("Sets the display and input format for this string object to '1d.', e.g. 'aBc' renders '97.66.99'");
        jMenuItem.setMnemonic('D');
        jMenuItem = this.dhMenu.add(new FormatAction("Hexadecimal", "1x:"));
        jMenuItem.setToolTipText("Sets the display and input format for this string object to '1x:', e.g. 'aBc' renders '61:42:63'");
        jMenuItem.setMnemonic('H');
        jMenuItem = this.dhMenu.add(new FormatAction("Octal", "1o:"));
        jMenuItem.setToolTipText("Sets the display and input format for this string object to '1o:', e.g. 'aBc' renders '141:102:143'");
        jMenuItem.setMnemonic('O');
        jMenuItem = this.dhMenu.add(new FormatAction("Binary", "1b:"));
        jMenuItem.setToolTipText("Sets the display and input format for this string object to '1b:', e.g. 'aBc' renders '01100001:01000010:01100011'");
        jMenuItem.setMnemonic('B');
        jMenuItem = this.dhMenu.add(new FormatAction("MIB", null));
        jMenuItem.setToolTipText("Sets the default display and input format for this string object as defined in the corresponding MIB module");
        jMenuItem.setMnemonic('M');
        this._$274.setPopupMenuEnabled(true);
        this._$5268();
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this._$274.addCellDisplayListener(this);
        this._$274.addSelectListener(this);
        this._$274.addEditCellListener(this);
        this._$274.addResizeCellMotionListener(new JTableColumnResizeEmulator(2));
        this._$274.addMouseListener(this);
        this._$28751.addValueListener(this);
        this._$274.setSelectionPolicy(2);
        this.updateButtons();
        this._$25817();
    }

    public void setTargets(Hashtable hashtable) {
        this._$7365 = hashtable;
    }

    public void setTarget(GenTarget genTarget) {
        this._$15220 = genTarget;
    }

    private void _$25817() {
        this._$10361 = new DropTarget(this._$274, 3, this);
    }

    private void _$25830() {
        this._$274.getCellAreaHandler().createRequiredCellAreas();
        if (this._$25717 == null) {
            this._$25717 = new DropTarget(this._$274.getCellAreaHandler().findByType(0), 3, this);
        }
    }

    public void resetChangeManager() {
        this._$25705.reset();
    }

    private void _$25808() {
        this._$11754.setNumRows(0);
        this._$11754.setNumColumns(TITLES.length);
        for (int i2 = 0; i2 < TITLES.length; ++i2) {
            this._$11754.setColumnLabel(i2, TITLES[i2]);
        }
        this._$11754.addRow(Integer.MAX_VALUE, new Integer(0), null);
    }

    private void _$28759(String[] stringArray) {
        this._$28753.removeAllElements();
        for (String string : stringArray) {
            this._$28753.addElement(string);
        }
        this._$28752.setModel(this._$28753);
    }

    private void _$5384(int n2, int n3, JCCellStyle jCCellStyle) {
        this._$274.setCellStyle(n2, n3, jCCellStyle);
    }

    private void _$5268() {
        this._$25703 = new JCCellStyle(this._$274.getDefaultCellStyle());
        this._$25703.setEditable(true);
        this._$25703.setBackground(Color.blue);
        this._$25703.setForeground(Color.white);
        this._$26899 = new JCCellStyle(this._$25703);
        this._$26899.setCellEditor(new JCComboBoxCellEditor(WIRE_SYNTAXES, WIRE_SYNTAX_IDS));
        for (int i2 = 0; i2 < this._$274.getNumColumns(); ++i2) {
            if (i2 != 1) {
                this._$274.setCellStyle(-997, i2, this._$25703);
            } else {
                this._$5384(-997, i2, this._$26899);
            }
            this._$274.setCharWidth(i2, _$25679[i2]);
        }
        this._$274.setCellEditor(ObjectID.class, MultiVariablePanel.getCellEditor(new ValueConverter(2), this._$20550));
    }

    public void updateStyle() {
        this._$274.setCellStyle(-997, 2, this._$25703);
    }

    public static JCCellEditor getCellEditor(ValueConverter valueConverter, MIBRepository mIBRepository) {
        BaseCellEditor baseCellEditor;
        switch (SMI.smiSyntax(valueConverter.getEffectiveSyntax().getSyntax())) {
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 11: 
            case 13: {
                JCLongCellEditor jCLongCellEditor = new JCLongCellEditor();
                jCLongCellEditor.addValidateListener(new JCValueConverter(valueConverter));
                baseCellEditor = jCLongCellEditor;
                break;
            }
            case 6: {
                JCBigDecimalCellEditor jCBigDecimalCellEditor = new JCBigDecimalCellEditor();
                jCBigDecimalCellEditor.addValidateListener(new JCValueConverter(valueConverter));
                baseCellEditor = jCBigDecimalCellEditor;
                break;
            }
            case 0: 
            case 8: {
                if (valueConverter.getEffectiveSyntax().hasEnums()) {
                    EnumCellEditor enumCellEditor = new EnumCellEditor(valueConverter.getEffectiveSyntax().getEnumsVector());
                    baseCellEditor = enumCellEditor;
                    break;
                }
                JCIntegerCellEditor jCIntegerCellEditor = new JCIntegerCellEditor();
                jCIntegerCellEditor.addValidateListener(new JCValueConverter(valueConverter));
                baseCellEditor = jCIntegerCellEditor;
                break;
            }
            case 2: {
                ObjectIDCellEditor objectIDCellEditor = new ObjectIDCellEditor(mIBRepository);
                baseCellEditor = objectIDCellEditor;
                break;
            }
            case 9: {
                IpAddressCellEditor ipAddressCellEditor;
                baseCellEditor = ipAddressCellEditor = new IpAddressCellEditor();
                break;
            }
            default: {
                JCStringCellEditor jCStringCellEditor = new JCStringCellEditor();
                jCStringCellEditor.addValidateListener(new JCValueConverter(valueConverter));
                baseCellEditor = jCStringCellEditor;
                break;
            }
        }
        return baseCellEditor;
    }

    void jbInit() throws Exception {
        this.border2 = BorderFactory.createEmptyBorder(2, 2, 2, 2);
        this.jButtonRefresh.setToolTipText("Send this PDU with the type specified on the left to current target");
        this.jButtonRefresh.setIcon(imageRefresh16);
        this.jButtonRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MultiVariablePanel.this.jButtonRefresh_actionPerformed(actionEvent);
            }
        });
        this.jButtonNewRow.setToolTipText("Add a row (variable) to the PDU table");
        this.jButtonNewRow.setIcon(imageNew16);
        this.jButtonNewRow.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MultiVariablePanel.this.jButtonNewRow_actionPerformed(actionEvent);
            }
        });
        this.jButtonCopyRow.setToolTipText("Duplicate the selected row");
        this.jButtonCopyRow.setIcon(MIBExplorerFrame.imageCopy16);
        this.jButtonCopyRow.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MultiVariablePanel.this.jButtonCopyRow_actionPerformed(actionEvent);
            }
        });
        this.border1 = new EtchedBorder(0, Color.white, new Color(148, 145, 140));
        this.setLayout(this.borderLayout1);
        this.jPanelNorth.setLayout(this.flowLayout3);
        this.jPanelCenter.setLayout(this.borderLayout4);
        this.jButtonUndo.setToolTipText("Undo last change made to the table");
        this.jButtonUndo.setIcon(imageUndo16);
        this.jButtonUndo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MultiVariablePanel.this.jButtonUndo_actionPerformed(actionEvent);
            }
        });
        this.jButtonRedo.setIcon(imageRedo16);
        this.jButtonRedo.setToolTipText("Redo last change");
        this.jButtonRedo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MultiVariablePanel.this.jButtonRedo_actionPerformed(actionEvent);
            }
        });
        this._$28751.setBorder(this.border2);
        this._$28751.setToolTipText("Periodical refresh in seconds");
        this._$28751.setDataProperties(MIBTablePanel.getRefreshDataProperties());
        this._$28752.setBorder(this.border2);
        this._$28752.setToolTipText("PDU Type");
        this._$28752 = new JComboBox<String>(MultiPDUDialog.NON_TRAP_PDU_TYPES);
        this._$28752.setSelectedIndex(0);
        this.jButtonPause.setToolTipText("Suspends periodic refresh");
        this.jButtonPause.setIcon(imagePause16);
        this.jButtonPause.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MultiVariablePanel.this.jButtonPause_actionPerformed(actionEvent);
            }
        });
        this.jButtonPlay.setToolTipText("Start periodic refresh");
        this.jButtonPlay.setIcon(imagePlay16);
        this.jButtonPlay.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MultiVariablePanel.this.jButtonPlay_actionPerformed(actionEvent);
            }
        });
        this.jProgressBarTimer.setPreferredSize(new Dimension(50, 16));
        this.jProgressBarTimer.setToolTipText("Time to next periodic update in %");
        this.jLabelRefresh.setText("Refresh:");
        this.flowLayout3.setAlignment(0);
        this.jButtonApply.setIcon(imageEdit16);
        this.jButtonApply.setToolTipText("Send PDU as SET request to current target");
        this.jButtonApply.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MultiVariablePanel.this.jButtonApply_actionPerformed(actionEvent);
            }
        });
        this.jButtonDeleteRow.setIcon(imageDeleteRow16);
        this.jButtonDeleteRow.setEnabled(false);
        this.jButtonDeleteRow.setToolTipText("Remove selected rows (variables) from PDU");
        this.jButtonDeleteRow.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MultiVariablePanel.this.jButtonDeleteRow_actionPerformed(actionEvent);
            }
        });
        this.jButtonMultiSet.setIcon(imageSendMail16);
        this.jButtonMultiSet.setToolTipText("Send PDU as GET, GETNEXT, GETBULK, SET, TRAP, or INFORM request to a set of targets");
        this.jButtonMultiSet.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MultiVariablePanel.this.jButtonMultiSet_actionPerformed(actionEvent);
            }
        });
        this.jToggleButtonExport.setIcon(imageExport16);
        this.jToggleButtonExport.setToolTipText("Export PDU contents to a text file (and append new values when periodically refreshed)");
        this.jToggleButtonExport.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                MultiVariablePanel.this.jToggleButtonExport_itemStateChanged(itemEvent);
            }
        });
        this.jButtonMoveUp.setIcon(imageUp16);
        this.jButtonMoveUp.setEnabled(false);
        this.jButtonMoveUp.setToolTipText("Move selected rows up by one");
        this.jButtonMoveUp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MultiVariablePanel.this.jButtonMoveUp_actionPerformed(actionEvent);
            }
        });
        this.jButtonMoveDown.setIcon(imageDown16);
        this.jButtonMoveDown.setEnabled(false);
        this.jButtonMoveDown.setToolTipText("Move selected rows down by one");
        this.jButtonMoveDown.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MultiVariablePanel.this.jButtonMoveDown_actionPerformed(actionEvent);
            }
        });
        this.jButtonZoomIn.setIcon(imageZoomIn16);
        this.jButtonZoomIn.setToolTipText("Detach PDU from PDUs tab and show it in its own frame");
        this.jButtonZoomIn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MultiVariablePanel.this.jButtonZoomIn_actionPerformed(actionEvent);
            }
        });
        this.jButtonZoomOut.setIcon(imageZoomOut16);
        this.jButtonZoomOut.setToolTipText("Attach PDU frame to PDUs tab");
        this.jButtonZoomOut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MultiVariablePanel.this.jButtonZoomOut_actionPerformed(actionEvent);
            }
        });
        this.jButtonZoomOut.setEnabled(false);
        this.add((Component)this.jPanelNorth, "North");
        this.jPanelNorth.add((Component)this.jToolBar1, null);
        this.jPanelNorth.add((Component)this.jToolBarRefresh, null);
        this.jToolBar1.add((Component)this.jButtonNewRow, null);
        this.jToolBar1.add((Component)this.jButtonCopyRow, null);
        this.jToolBar1.add((Component)this.jButtonDeleteRow, null);
        this.jToolBar1.add((Component)this.jButtonMoveUp, null);
        this.jToolBar1.add((Component)this.jButtonMoveDown, null);
        this.jToolBar1.addSeparator();
        this.jToolBar1.add((Component)this.jButtonApply, null);
        this.jToolBar1.add((Component)this.jButtonMultiSet, null);
        this.jToolBar1.add((Component)this._$28752, null);
        this.jToolBar1.add((Component)this.jButtonRefresh, null);
        this.jToolBar1.addSeparator();
        this.jToolBar1.add((Component)this.jButtonRedo, null);
        this.jToolBar1.add((Component)this.jButtonUndo, null);
        this.jToolBar1.add((Component)this.jButtonZoomIn, null);
        this.jToolBar1.add((Component)this.jButtonZoomOut, null);
        this.jToolBar1.addSeparator();
        ToolBarUtils.setMinimumButtonSize(this.jToolBar1);
        this.jToolBarRefresh.add((Component)this.jLabelRefresh, null);
        this.jToolBarRefresh.addSeparator();
        this.jToolBarRefresh.add((Component)this._$28751, null);
        this.jToolBarRefresh.addSeparator();
        this.jToolBarRefresh.add((Component)this.jButtonPlay, null);
        this.jToolBarRefresh.add((Component)this.jButtonPause, null);
        this.jToolBarRefresh.addSeparator();
        this.jToolBarRefresh.add((Component)this.jProgressBarTimer, null);
        this.jToolBarRefresh.addSeparator();
        this.jToolBarRefresh.add((Component)this.jToggleButtonExport, null);
        this.jToolBarRefresh.addSeparator();
        ToolBarUtils.setMinimumButtonSize(this.jToolBarRefresh);
        this.jPanelCenter.add((Component)this._$274, "Center");
        this.add((Component)this.observer, "South");
        this.add((Component)this.jPanelCenter, "Center");
    }

    void jButtonApply_actionPerformed(ActionEvent actionEvent) {
        this.updateStyle();
        this.commitChanges();
    }

    void jButtonCancel_actionPerformed(ActionEvent actionEvent) {
        this.stopTimer();
    }

    public synchronized void stopTimer() {
        this.fireActionPerformed(new ActionEvent(this, 1001, "Stopped"));
        if (this._$16145 != null) {
            this._$16145.cancel();
        }
        this._$25714 = false;
        this.jProgressBarTimer.setValue(0);
        this._$25266();
    }

    public synchronized void onResponse(ResponseEvent responseEvent) {
        try {
            this._$14889.cancel(responseEvent.getRequest(), this);
            if (!this._$12571.logResponse(responseEvent, this.observer)) {
                if (responseEvent.getResponse() != null && responseEvent.getResponse().getType() != -88 && responseEvent.getResponse().getErrorStatus() != 0) {
                    int n2;
                    this.observer.requestFinishedWithError("SNMP error " + responseEvent.getResponse().getErrorStatusText() + " at index " + responseEvent.getResponse().getErrorIndex());
                    PDU pDU = responseEvent.getResponse();
                    if (responseEvent.getRequest().getType() == -93 && (n2 = pDU.getErrorIndex()) > 0 && n2 < pDU.size()) {
                        for (int i2 = 2; i2 <= 2; ++i2) {
                            JCCellStyle jCCellStyle = new JCCellStyle(this._$274.getCellStyle(n2, i2));
                            jCCellStyle.setBackground(Color.red);
                            jCCellStyle.setForeground(Color.black);
                            this._$274.setCellStyle(n2, i2, jCCellStyle);
                        }
                        this._$274.traverse(n2, 2, true, true);
                    }
                }
            } else {
                this.observer.requestFinished();
                VariableBinding[] variableBindingArray = responseEvent.getResponse().toArray();
                for (int i3 = 0; i3 < variableBindingArray.length; ++i3) {
                    if (variableBindingArray[i3].isException() || variableBindingArray[i3].getVariable() == null) {
                        this._$11754.setTableDataItem(null, i3 + 1, 2);
                        for (int i4 = 2; i4 <= 2; ++i4) {
                            JCCellStyle jCCellStyle = new JCCellStyle(this._$274.getCellStyle(i3 + 1, i4));
                            jCCellStyle.setBackground(Color.orange);
                            jCCellStyle.setForeground(Color.black);
                            this._$274.setCellStyle(i3 + 1, i4, jCCellStyle);
                        }
                        this._$11754.setTableDataItem(null, i3 + 1, 2);
                        this._$11754.setTableDataItem(new Integer(ValueConverter.getSmiSyntax(variableBindingArray[i3].getSyntax())), i3 + 1, 1);
                        continue;
                    }
                    ValueConverter valueConverter = (ValueConverter)this._$11754.getTableDataItem(i3 + 1, 3);
                    if (!valueConverter.isSyntaxCompatible(variableBindingArray[i3].getVariable().getSyntax())) {
                        valueConverter = new ValueConverter(variableBindingArray[i3].getVariable().getClass());
                    }
                    this._$11754.setTableDataItem(new Integer(valueConverter.getSMISyntax()), i3 + 1, 1);
                    this._$11754.setTableDataItem(valueConverter.toNative(variableBindingArray[i3].getVariable()), i3 + 1, 2);
                    this._$11754.setTableDataItem(valueConverter, i3 + 1, 3);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this._$25891();
        this.notify();
    }

    private void _$25891() {
        if (this._$28749 != null) {
            try {
                this.saveTableToFile(this._$28749, this._$28750);
                if (!this._$28750 && this.isPeriodicRefreshEnabled()) {
                    this._$28750 = true;
                }
            }
            catch (IOException iOException) {
                final String[] stringArray = new String[]{"Could not write log file:", iOException.getMessage()};
                Runnable runnable = new Runnable(){

                    public void run() {
                        JOptionPane.showMessageDialog(MultiVariablePanel.this._$25700, stringArray, "Export Failed", 0);
                    }
                };
                if (!SwingUtilities.isEventDispatchThread()) {
                    SwingUtilities.invokeLater(runnable);
                }
                runnable.run();
            }
        }
    }

    public synchronized void refresh() {
        this._$274.commitEdit(true);
        this._$15238 = this._$15220.getTarget();
        this.updateStyle();
        this._$25705.reset();
        this.updateButtons();
        this._$20772 = this._$15220.makePDU();
        int n2 = this._$28765();
        VariableBinding[] variableBindingArray = new VariableBinding[this._$11754.getNumRows() - 1];
        switch (n2) {
            case -96: 
            case -95: 
            case -91: {
                for (int i2 = 0; i2 < variableBindingArray.length; ++i2) {
                    Object object = this._$11754.getTableDataItem(i2 + 1, 0);
                    OID oID = object != null ? new OID(object.toString()) : new OID();
                    variableBindingArray[i2] = new VariableBinding();
                    variableBindingArray[i2].setOid(oID);
                }
                break;
            }
            default: {
                variableBindingArray = this._$28766();
            }
        }
        this._$20772.addAll(variableBindingArray);
        if (n2 == -91) {
            this._$20772.setMaxRepetitions(1);
        }
        this.observer.request(n2, this._$20772, this._$15220, this._$15238, null, this, null);
    }

    private int _$1241(int n2, int n3) {
        return n2;
    }

    private int _$25810(int n2, int n3) {
        return n3;
    }

    public void cellDisplay(JCCellDisplayEvent jCCellDisplayEvent) {
        try {
            int n2 = this._$1241(jCCellDisplayEvent.getRow(), jCCellDisplayEvent.getColumn());
            int n3 = this._$25810(jCCellDisplayEvent.getRow(), jCCellDisplayEvent.getColumn());
            if (n2 == -1 || jCCellDisplayEvent.getDisplayData() == null) {
                return;
            }
            switch (n3) {
                case 0: {
                    ObjectID objectID = (ObjectID)jCCellDisplayEvent.getCellData();
                    String string = this._$20550.getObjectName(objectID);
                    if (string == null) {
                        string = this._$20550.getPathSuffix(objectID);
                    }
                    if (string == null) break;
                    jCCellDisplayEvent.setDisplayData(string);
                    break;
                }
                case 1: {
                    int n4 = (Integer)jCCellDisplayEvent.getDisplayData();
                    String string = ValueConverter.getExceptionString(n4);
                    if (string == null) {
                        string = SMI.SMI_SYNTAX[n4];
                    }
                    jCCellDisplayEvent.setDisplayData(string);
                    break;
                }
                case 2: {
                    ValueConverter valueConverter = (ValueConverter)this._$11754.getTableDataItem(n2, 3);
                    if (valueConverter != null && valueConverter.getEffectiveSyntax() != null && valueConverter.getEffectiveSyntax().hasEnums()) {
                        if (!(jCCellDisplayEvent.getDisplayData() instanceof Integer)) break;
                        Integer n5 = (Integer)jCCellDisplayEvent.getDisplayData();
                        if (n5 == null) {
                            return;
                        }
                        MIBEnum mIBEnum = valueConverter.getEffectiveSyntax().getEnum(n5.intValue());
                        if (mIBEnum != null) {
                            jCCellDisplayEvent.setDisplayData(mIBEnum.toString());
                        }
                    } else {
                        if (valueConverter != null && valueConverter.getSMISyntax() == 11 && jCCellDisplayEvent.getCellData() instanceof Long) {
                            jCCellDisplayEvent.setDisplayData(new TimeTicks((Long)jCCellDisplayEvent.getCellData()).toString());
                            break;
                        }
                        if (jCCellDisplayEvent.getDisplayData() instanceof ComparableIpAddress || this._$28178 || !(jCCellDisplayEvent.getDisplayData() instanceof ObjectID) || valueConverter == null || valueConverter.getSMISyntax() != 2) break;
                        ObjectID objectID = (ObjectID)jCCellDisplayEvent.getCellData();
                        String string = this._$20550.getObjectName(objectID);
                        if (string == null) {
                            string = this._$20550.getPathSuffix(objectID);
                        }
                        if (string != null) {
                            jCCellDisplayEvent.setDisplayData(string);
                        }
                    }
                    break;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private JCTableCellInfo _$25986(int n2, int n3) {
        JCTableCellInfo jCTableCellInfo = new JCTableCellInfo();
        jCTableCellInfo.initialize(this._$274, this._$11754.getTableDataItem(n2, n3), n2, n3, this._$274.getCellStyle(n3, n2));
        return jCTableCellInfo;
    }

    public void beforeEditCell(JCEditCellEvent jCEditCellEvent) {
        int n2;
        int n3 = this._$1241(jCEditCellEvent.getRow(), jCEditCellEvent.getColumn());
        int n4 = this._$25810(jCEditCellEvent.getRow(), jCEditCellEvent.getColumn());
        if (n4 == 1 && (n2 = ((Integer)this._$11754.getTableDataItem(n3, n4)).intValue()) < 0) {
            this._$11754.setTableDataItem(new Integer(1), n3, n4);
        }
        this._$25707 = new CellEdit(this._$25986(n3, n4), this._$11754.getTableDataItem(n3, n4), null);
        if (this.isPeriodicRefreshEnabled()) {
            this.stopTimer();
        }
    }

    public void editCell(JCEditCellEvent jCEditCellEvent) {
    }

    public void afterEditCell(JCEditCellEvent jCEditCellEvent) {
        int n2 = this._$1241(jCEditCellEvent.getRow(), jCEditCellEvent.getColumn());
        int n3 = this._$25810(jCEditCellEvent.getRow(), jCEditCellEvent.getColumn());
        if (!jCEditCellEvent.isCancelled() && n3 == 1) {
            int n4 = (Integer)this._$11754.getTableDataItem(n2, n3);
            ValueConverter valueConverter = new ValueConverter(n4);
            this._$11754.setTableDataItem(valueConverter, n2, 3);
            this._$11754.setTableDataItem(valueConverter.getNativeExample(), n2, 2);
            JCCellStyle jCCellStyle = new JCCellStyle(this._$25703);
            jCCellStyle.setCellEditor(MultiVariablePanel.getCellEditor(valueConverter, this._$20550));
            this._$5384(n2, 2, jCCellStyle);
        }
        this._$25707.setNewValue(this._$11754.getTableDataItem(n2, n3));
        this._$25705.addEdit(this._$25707);
        this.updateButtons();
    }

    public static ValueConverter[] makeVCsFromModel(JCEditableVectorDataSource jCEditableVectorDataSource) {
        ValueConverter[] valueConverterArray = new ValueConverter[jCEditableVectorDataSource.getNumRows() - 1];
        for (int i2 = 0; i2 < valueConverterArray.length; ++i2) {
            valueConverterArray[i2] = (ValueConverter)jCEditableVectorDataSource.getTableDataItem(i2 + 1, 3);
        }
        return valueConverterArray;
    }

    public static VariableBinding[] makeVBsFromModel(JCEditableVectorDataSource jCEditableVectorDataSource) {
        VariableBinding[] variableBindingArray = new VariableBinding[jCEditableVectorDataSource.getNumRows() - 1];
        for (int i2 = 0; i2 < variableBindingArray.length; ++i2) {
            variableBindingArray[i2] = new VariableBinding();
            variableBindingArray[i2].setOid(new OID(jCEditableVectorDataSource.getTableDataItem(i2 + 1, 0).toString()));
            ValueConverter valueConverter = (ValueConverter)jCEditableVectorDataSource.getTableDataItem(i2 + 1, 3);
            Variable variable = null;
            if (valueConverter != null) {
                variable = valueConverter.fromNative(jCEditableVectorDataSource.getTableDataItem(i2 + 1, 2));
            }
            if (variable == null) {
                variableBindingArray[i2].setVariable(new Null());
                continue;
            }
            variableBindingArray[i2].setVariable(variable);
        }
        return variableBindingArray;
    }

    private VariableBinding[] _$28766() {
        return MultiVariablePanel.makeVBsFromModel(this._$11754);
    }

    public void commitChanges() {
        this._$274.commitEdit(true);
        this._$15238 = this._$15220.getTarget();
        this._$20772 = this._$15220.makePDU();
        this._$20772.addAll(this._$28766());
        this.observer.request(-93, this._$20772, this._$15220, this._$15238, null, this, null);
    }

    private Vector _$23143() {
        Vector<Object> vector = new Vector<Object>(TITLES.length);
        vector.addElement(new ObjectID());
        vector.addElement(new Integer(1));
        vector.addElement(new String());
        vector.addElement(new ValueConverter(1));
        return vector;
    }

    void jButtonNewRow_actionPerformed(ActionEvent actionEvent) {
        if (!this._$274.commitEdit(true)) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        Vector vector = this._$23143();
        int n2 = TableUtils.getFirstSelectedRow(this._$274);
        if (n2 == -1) {
            n2 = Integer.MAX_VALUE;
        }
        this._$11754.addRow(n2, new Integer(this._$11754.getNumRows()), vector);
        if (n2 == Integer.MAX_VALUE) {
            n2 = this._$11754.getNumRows() - 1;
        }
        this._$18260(n2);
        this._$25705.addEdit(new RowAddEdit(n2, true, vector));
        this.updateButtons();
    }

    void jButtonCopyRow_actionPerformed(ActionEvent actionEvent) {
        if (!this._$274.commitEdit(true)) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        Vector vector = this._$23143();
        int n2 = TableUtils.getFirstSelectedRow(this._$274);
        if (n2 == -1) {
            return;
        }
        ObjectID objectID = new ObjectID((ObjectID)this._$11754.getTableDataItem(n2, 0));
        Integer n3 = new Integer((Integer)this._$11754.getTableDataItem(n2, 1));
        ValueConverter valueConverter = new ValueConverter((ValueConverter)this._$11754.getTableDataItem(n2, 3));
        Object object = valueConverter.toNative(valueConverter.fromNative(this._$11754.getTableDataItem(n2, 2)));
        vector.set(0, objectID);
        vector.set(1, n3);
        vector.set(2, object);
        vector.set(3, valueConverter);
        if (++n2 >= this._$11754.getNumRows()) {
            n2 = Integer.MAX_VALUE;
        }
        this._$11754.addRow(n2, new Integer(this._$11754.getNumRows()), vector);
        if (n2 == Integer.MAX_VALUE) {
            n2 = this._$11754.getNumRows() - 1;
        }
        this._$18260(n2);
        this._$25705.addEdit(new RowAddEdit(n2, true, vector));
        this.updateButtons();
        this._$274.setRowSelection(n2, n2);
        this._$274.setCurrentCell(n2, 2);
    }

    private void _$18260(int n2) {
        for (int i2 = n2; i2 < this._$11754.getNumRows(); ++i2) {
            this._$11754.setRowLabel(i2, new Integer(i2));
        }
    }

    public void traverse(int n2, int n3, boolean bl, boolean bl2) {
        this._$274.traverse(n2, n3, bl, bl2);
    }

    void jButtonRefresh_actionPerformed(ActionEvent actionEvent) {
        this.refresh();
    }

    public void resendRequest(ResponseEvent responseEvent, ResponseListener responseListener) {
        VariableBinding[] variableBindingArray = (VariableBinding[])responseEvent.getRequest().getVariableBindings().toArray();
        int n2 = variableBindingArray.length / 2;
        VariableBinding[][] variableBindingArrayArray = new VariableBinding[2][];
        Vector[] vectorArray = new Vector[2];
        if (responseEvent.getUserObject() instanceof Vector) {
            vectorArray[0] = new Vector(n2 + 1);
            vectorArray[1] = new Vector(n2 + 1);
            Vector vector = (Vector)responseEvent.getUserObject();
            for (int i2 = 0; i2 < vector.size(); ++i2) {
                if (i2 < n2) {
                    vectorArray[0].addElement(vector.elementAt(i2));
                    continue;
                }
                vectorArray[1].addElement(vector.elementAt(i2));
            }
        }
        variableBindingArrayArray[0] = new VariableBinding[n2];
        variableBindingArrayArray[1] = new VariableBinding[variableBindingArray.length - n2];
        System.arraycopy(variableBindingArray, 0, variableBindingArrayArray[0], 0, n2);
        System.arraycopy(variableBindingArray, n2, variableBindingArrayArray[1], 0, variableBindingArray.length - n2);
        try {
            block7: for (int i3 = 0; i3 < variableBindingArrayArray.length; ++i3) {
                responseEvent.getRequest().clear();
                responseEvent.getRequest().addAll(variableBindingArrayArray[i3]);
                switch (responseEvent.getRequest().getType()) {
                    case -91: {
                        this._$14889.getBulk(responseEvent.getRequest(), this._$15238, vectorArray[i3], responseListener);
                        continue block7;
                    }
                    case -93: {
                        this._$14889.set(responseEvent.getRequest(), this._$15238, responseEvent.getUserObject(), responseListener);
                    }
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void undo() {
        this._$274.cancelEdit(true);
        this._$25705.undo();
        this.updateButtons();
    }

    public void redo() {
        this._$274.cancelEdit(true);
        this._$25705.redo();
        this.updateButtons();
    }

    void jButtonUndo_actionPerformed(ActionEvent actionEvent) {
        this.undo();
    }

    void jButtonRedo_actionPerformed(ActionEvent actionEvent) {
        this.redo();
    }

    public void updateButtons() {
        this.jButtonNewRow.setEnabled(true);
        this.jButtonCopyRow.setEnabled(TableUtils.getFirstSelectedRow(this._$274) != -1);
        this.jButtonUndo.setEnabled(this._$25705.canUndo());
        this.jButtonRedo.setEnabled(this._$25705.canRedo());
        this.jButtonApply.setEnabled(this._$11754.getNumRows() > 1);
        Collection collection = this._$274.getSelectedCells();
        if (collection == null || collection.size() == 0) {
            this.jButtonDeleteRow.setEnabled(false);
            this.jButtonMoveDown.setEnabled(false);
            this.jButtonMoveUp.setEnabled(false);
        } else {
            this.jButtonDeleteRow.setEnabled(true);
            JCCellRange jCCellRange = (JCCellRange)collection.iterator().next();
            TableUtils.setRangeAfterCopy(jCCellRange);
            if (jCCellRange.start_row > 1) {
                this.jButtonMoveUp.setEnabled(true);
            } else {
                this.jButtonMoveUp.setEnabled(false);
            }
            if (jCCellRange.end_row < this._$11754.getNumRows() - 1) {
                this.jButtonMoveDown.setEnabled(true);
            } else {
                this.jButtonMoveDown.setEnabled(false);
            }
        }
    }

    public void valueChanged(JCValueEvent jCValueEvent) {
        if (jCValueEvent.getSource() == this._$28751) {
            if (this._$16145 != null) {
                this._$16145.cancel();
            }
            this.runTimer();
        }
    }

    public boolean isRunning() {
        return this.isPeriodicRefreshEnabled();
    }

    public synchronized void runTimer() {
        this.fireActionPerformed(new ActionEvent(this, 1001, "Running"));
        this._$16145 = new Timer();
        Long l2 = (Long)this._$28751.getValue();
        long l3 = l2 * 10L * (long)this._$25713;
        if (l3 > 0L) {
            this._$25714 = true;
            this._$16145.schedule((TimerTask)new PeriodicRefresh(this._$25713), l3, l3);
        }
        this._$25266();
    }

    private void _$25266() {
        this.jButtonPlay.setEnabled(!this._$25714);
        this.jButtonPause.setEnabled(this._$25714);
    }

    public void valueChanging(JCValueEvent jCValueEvent) {
    }

    protected MultiVariablePanel getPanel() {
        return this;
    }

    void jButtonPause_actionPerformed(ActionEvent actionEvent) {
        this.stopTimer();
    }

    void jButtonPlay_actionPerformed(ActionEvent actionEvent) {
        this.stopTimer();
        this.runTimer();
    }

    public void setPeriodicRefreshStepping(int n2) {
        this._$25713 = n2;
    }

    public int getPeriodicRefreshStepping() {
        return this._$25713;
    }

    public boolean isPeriodicRefreshEnabled() {
        return this._$25714;
    }

    public void setDisplayOID(boolean bl) {
        this._$28178 = bl;
    }

    public boolean isDisplayOID() {
        return this._$28178;
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        try {
            Serializable serializable;
            Serializable serializable2;
            ObjectID objectID;
            MIBObject mIBObject;
            dropTargetDropEvent.acceptDrop(dropTargetDropEvent.getDropAction());
            Point point = dropTargetDropEvent.getLocation();
            Transferable transferable = dropTargetDropEvent.getTransferable();
            Object object = transferable.getTransferData(DraggableTreeNode.supported[0]);
            if (object == null || !(object instanceof MIBObject) && !(object instanceof MIBInstance)) {
                this.observer.setMessage("Invalid drag source!");
                dropTargetDropEvent.dropComplete(false);
                return;
            }
            this._$274.cancelEdit(true);
            Object object2 = object;
            ValueConverter valueConverter = null;
            boolean bl = false;
            if (object instanceof MIBInstance) {
                mIBObject = ((MIBInstance)object2).getObjectClass();
                objectID = new ObjectID(((MIBInstance)object2).getOid().toString());
                valueConverter = ((MIBInstance)object2).getValueConverter();
                bl = true;
            } else {
                mIBObject = (MIBObject)object2;
                objectID = mIBObject.getOid();
                if (mIBObject instanceof MIBObjectType && (((MIBObjectType)(serializable2 = (MIBObjectType)mIBObject)).isColumnarObject() || ((MIBObjectType)serializable2).isScalar())) {
                    bl = !((MIBObjectType)serializable2).isColumnarObject();
                    serializable = this._$20550.getEffectiveSyntax(((MIBObjectType)serializable2).getSyntax());
                    valueConverter = new ValueConverter((MIBObjectType)serializable2, ((MIBTextualConvention)serializable).getSyntax(), ((MIBTextualConvention)serializable).getDisplayHint());
                }
            }
            serializable2 = this._$274.getCellAreaHandler().findByType(0);
            serializable = this._$274.XYToCell(point.x + ((CellArea)serializable2).getStandardOffsetX(), point.y + ((CellArea)serializable2).getStandardOffsetY());
            ValueConverter valueConverter2 = (ValueConverter)this._$274.getDataView().getTableDataItem(((JCCellPosition)serializable).row, 3);
            if (((JCCellPosition)serializable).row > 0 && ((JCCellPosition)serializable).row < this._$11754.getNumRows() && (((JCCellPosition)serializable).column == 0 && valueConverter2.getObjectType() == null || ((JCCellPosition)serializable).column == 2 && this._$274.getDataView().getTableDataItem(((JCCellPosition)serializable).row, 2) instanceof ObjectID)) {
                Object object3 = this._$274.getDataView().getTableDataItem(((JCCellPosition)serializable).row, ((JCCellPosition)serializable).column);
                CellEdit cellEdit = new CellEdit(this._$25986(((JCCellPosition)serializable).row, ((JCCellPosition)serializable).column), object3, objectID);
                this._$25705.addEdit(cellEdit);
                this._$274.getDataView().setTableDataItem(objectID, ((JCCellPosition)serializable).row, ((JCCellPosition)serializable).column);
            } else {
                Vector<Object> vector = new Vector<Object>(TITLES.length);
                if (object instanceof MIBInstance) {
                    vector.addElement(new ObjectID(((MIBInstance)object2).getOid().toString()));
                    if (valueConverter == null) {
                        valueConverter = new ValueConverter(((MIBInstance)object).getValue().getClass());
                    }
                    vector.addElement(new Integer(valueConverter.getSMISyntax()));
                    vector.addElement(valueConverter.toNative(((MIBInstance)object2).getValue()));
                    vector.addElement(valueConverter);
                } else {
                    if (object instanceof MIBNotifyType) {
                        this._$11754.deleteRows(1, this._$11754.getNumRows() - 1);
                        this.addTrapObjects(System.currentTimeMillis() - PDUTabbedPanel.applicationStart);
                        MIBNotifyType mIBNotifyType = (MIBNotifyType)object;
                        this._$11754.setTableDataItem(new ObjectID(mIBNotifyType.getOid()), 2, 2);
                        if (mIBNotifyType.hasVariables()) {
                            Enumeration enumeration = mIBNotifyType.getVariablesVector().elements();
                            while (enumeration.hasMoreElements()) {
                                vector = new Vector(TITLES.length);
                                String string = (String)enumeration.nextElement();
                                String string2 = this._$20550.getModuleName(mIBNotifyType.getModuleID());
                                MIBObject mIBObject2 = this._$20550.getScopedObject(string2, string);
                                if (mIBObject2 == null || !(mIBObject2 instanceof MIBObjectType)) continue;
                                MIBObjectType mIBObjectType = (MIBObjectType)mIBObject2;
                                vector.add(new ObjectID(mIBObjectType.getOid()));
                                MIBTextualConvention mIBTextualConvention = this._$20550.getEffectiveSyntax(mIBObjectType.getSyntax());
                                valueConverter = new ValueConverter(mIBObjectType, mIBTextualConvention.getSyntax(), mIBTextualConvention.getDisplayHint());
                                vector.add(new Integer(valueConverter.getSMISyntax()));
                                Variable variable = ValueConverter.getDefaultValue(this._$20550, valueConverter.getObjectType(), valueConverter.getEffectiveSyntax());
                                if (variable != null) {
                                    vector.addElement(valueConverter.toNative(variable));
                                } else {
                                    vector.addElement(valueConverter.getNativeExample());
                                }
                                vector.add(valueConverter);
                                this._$11754.addRow(Integer.MAX_VALUE, new Integer(this._$11754.getNumRows()), vector);
                                this.setReadOnly(this._$11754.getNumRows() - 1, true);
                                this._$28771(this._$11754.getNumRows() - 1, false);
                                this._$25705.addEdit(new RowAddEdit(this._$11754.getNumRows() - 1, true, vector));
                            }
                        }
                        dropTargetDropEvent.dropComplete(true);
                        this.updateButtons();
                        return;
                    }
                    if (bl) {
                        vector.addElement(new ObjectID(mIBObject.getPrintableOid() + ".0"));
                    } else {
                        vector.addElement(mIBObject.getOid());
                    }
                    if (valueConverter == null) {
                        vector.addElement(new Integer(1));
                        vector.addElement(new String());
                    } else {
                        vector.addElement(new Integer(valueConverter.getSMISyntax()));
                        Variable variable = ValueConverter.getDefaultValue(this._$20550, valueConverter.getObjectType(), valueConverter.getEffectiveSyntax());
                        if (variable != null) {
                            vector.addElement(valueConverter.toNative(variable));
                        } else {
                            vector.addElement(valueConverter.getNativeExample());
                        }
                        vector.addElement(valueConverter);
                    }
                }
                this._$11754.addRow(Integer.MAX_VALUE, new Integer(this._$11754.getNumRows()), vector);
                if (bl) {
                    this.setReadOnly(this._$11754.getNumRows() - 1, true);
                }
                this._$28771(this._$11754.getNumRows() - 1, false);
                this._$25705.addEdit(new RowAddEdit(this._$11754.getNumRows() - 1, true, vector));
            }
            dropTargetDropEvent.dropComplete(true);
            this.updateButtons();
        }
        catch (Exception exception) {
            Toolkit.getDefaultToolkit().beep();
            exception.printStackTrace();
            dropTargetDropEvent.dropComplete(false);
        }
    }

    public JCTable getTable() {
        return this._$274;
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        boolean bl = dropTargetDragEvent.isDataFlavorSupported(DraggableTreeNode.supported[0]);
        int n2 = dropTargetDragEvent.getDropAction();
        if (bl && (n2 & 3) > 0) {
            dropTargetDragEvent.acceptDrag(n2);
        } else {
            dropTargetDragEvent.rejectDrag();
        }
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    void jButtonDeleteRow_actionPerformed(ActionEvent actionEvent) {
        int n2;
        Collection collection = this._$274.getSelectedCells();
        if (collection == null) {
            return;
        }
        JCCellRange[] jCCellRangeArray = new JCCellRange[collection.size()];
        collection.toArray(jCCellRangeArray);
        for (n2 = 0; n2 < jCCellRangeArray.length; ++n2) {
            TableUtils.setRangeAfterCopy(jCCellRangeArray[n2]);
        }
        for (n2 = 0; n2 < jCCellRangeArray.length; ++n2) {
            Vector vector;
            if (jCCellRangeArray[n2].start_row >= this._$11754.getNumRows()) continue;
            Vector<Vector> vector2 = new Vector<Vector>();
            for (int i2 = jCCellRangeArray[n2].start_row; i2 <= jCCellRangeArray[n2].end_row; ++i2) {
                vector = new Vector();
                vector.addElement(new Integer(i2));
                for (int i3 = 0; i3 <= this._$11754.getNumColumns(); ++i3) {
                    vector.addElement(this._$11754.getTableDataItem(i2, i3));
                }
                vector2.addElement(vector);
            }
            this._$11754.deleteRows(jCCellRangeArray[n2].start_row, jCCellRangeArray[n2].end_row - jCCellRangeArray[n2].start_row + 1);
            Enumeration enumeration = vector2.elements();
            while (enumeration.hasMoreElements()) {
                vector = (Vector)enumeration.nextElement();
                Object e2 = vector.firstElement();
                vector.removeElementAt(0);
                this._$25705.addEdit(new RowAddEdit((Integer)e2, false, vector));
            }
        }
        this._$18260(1);
        this.updateButtons();
    }

    public Object getData() {
        return this._$11754;
    }

    public void setData(Object object) {
        this._$11754 = (JCEditableVectorDataSource)object;
        this._$11754.setColumnLabels(TITLES);
        this._$274.setDataSource(this._$11754);
        for (int i2 = 1; i2 < this._$11754.getNumRows(); ++i2) {
            this._$28771(i2, true);
        }
        this.updateButtons();
        this._$25830();
    }

    public void setReadOnly(int n2, boolean bl) {
        for (int i2 = 0; i2 < 2; ++i2) {
            if (bl) {
                JCCellStyle jCCellStyle = new JCCellStyle(this._$274.getCellStyle(n2, i2));
                jCCellStyle.setEditable(false);
                jCCellStyle.setBackground(Color.lightGray);
                jCCellStyle.setForeground(Color.black);
                this._$274.setCellStyle(n2, i2, jCCellStyle);
                continue;
            }
            if (i2 != 1) {
                this._$5384(n2, i2, this._$25703);
                continue;
            }
            this._$5384(n2, i2, this._$26899);
        }
    }

    private void _$28771(int n2, boolean bl) {
        ValueConverter valueConverter = (ValueConverter)this._$11754.getTableDataItem(n2, 3);
        if (bl && valueConverter != null && valueConverter.getObjectType() != null) {
            this.setReadOnly(n2, true);
        }
        if (valueConverter != null) {
            JCCellStyle jCCellStyle = new JCCellStyle(this._$25703);
            jCCellStyle.setCellEditor(MultiVariablePanel.getCellEditor(valueConverter, this._$20550));
            this._$5384(n2, 2, jCCellStyle);
        }
    }

    void jButtonMultiSet_actionPerformed(ActionEvent actionEvent) {
        VariableBinding[] variableBindingArray = this._$28766();
        if (variableBindingArray.length == 0) {
            return;
        }
        SelectTargetsPanel selectTargetsPanel = new SelectTargetsPanel(this._$7365);
        selectTargetsPanel.moveTargetL2R(this._$15220);
        StandardDialog standardDialog = new StandardDialog(this._$25700, "Send PDU To Multiple Targets", true);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)selectTargetsPanel, "Center");
        boolean bl = MultiPDUDialog.isValidTrapPDU(variableBindingArray);
        PDUTypePanel pDUTypePanel = new PDUTypePanel(bl);
        pDUTypePanel.setMaxVbs(variableBindingArray.length);
        if (!bl) {
            pDUTypePanel.setSelectedItem(this._$28752.getSelectedItem());
        }
        jPanel.add((Component)pDUTypePanel, "South");
        standardDialog.setCenterPanel(jPanel);
        standardDialog.setLocationRelativeTo(this._$25700);
        standardDialog.setVisible(true);
        standardDialog.setPreferredSize(MIBExplorerConfig.getStandardDialogDimension(this._$5250));
        standardDialog.pack();
        if (standardDialog.getResult() == 0) {
            List<GenTarget> list = selectTargetsPanel.getSelectedTargets();
            if (list.size() == 0) {
                JOptionPane.showMessageDialog(this._$25700, "No targets have been selected!", "Nothing To Do", 0);
                return;
            }
            String string = pDUTypePanel.getSelectedType();
            MultiPDUDialog multiPDUDialog = new MultiPDUDialog(this._$25700, string + " PDU Results", false, list, this._$14889, variableBindingArray, MultiPDUDialog.PDU_IDS[pDUTypePanel.getSelectedIndex()], this._$20550, pDUTypePanel.getNonRepeaters(), pDUTypePanel.getMaxRepetitions());
            multiPDUDialog.setSize(MIBExplorerConfig.getStandardDialogDimension(this._$5250));
            multiPDUDialog.setLocationRelativeTo(this._$25700);
            multiPDUDialog.setVisible(true);
        }
    }

    void jToggleButtonExport_itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            JFileChooser jFileChooser = new JFileChooser(new File(this._$5250.get("mibexplorer.LogPath", "")));
            ExampleFileFilter exampleFileFilter = new ExampleFileFilter();
            exampleFileFilter.addExtension("csv");
            exampleFileFilter.setDescription("Comma Separated Values");
            jFileChooser.setFileFilter(exampleFileFilter);
            jFileChooser.setFileSelectionMode(0);
            if (jFileChooser.showSaveDialog(this._$25700) == 0) {
                File file = jFileChooser.getSelectedFile();
                if (!file.getName().toUpperCase().endsWith(".CSV")) {
                    file = new File(file.getParentFile(), file.getName() + ".csv");
                }
                this._$5250.put("mibexplorer.LogPath", jFileChooser.getSelectedFile().getParent());
                if (file.exists()) {
                    Object[] objectArray = new Object[]{"Overwrite", "Append", "Cancel"};
                    int n2 = JOptionPane.showOptionDialog(this._$25700, "File already exists. Overwrite it?", "Log File", 1, 3, null, objectArray, objectArray[1]);
                    if (n2 == 2) {
                        this._$28749 = null;
                        this.jToggleButtonExport.setSelected(false);
                        return;
                    }
                    this._$28750 = n2 != 0;
                }
                this._$28749 = file;
                if (this.isPeriodicRefreshEnabled()) {
                    this.stopTimer();
                    this.runTimer();
                } else {
                    this.refresh();
                }
            } else {
                this._$28749 = null;
                this.jToggleButtonExport.setSelected(false);
            }
        } else {
            this._$28749 = null;
        }
    }

    private String _$26077() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\"Time\"");
        for (int i2 = 1; i2 < this._$11754.getNumRows(); ++i2) {
            stringBuffer.append(",\"");
            stringBuffer.append(this._$11754.getTableDataItem(i2, 0));
            stringBuffer.append('\"');
        }
        stringBuffer.append('\n');
        return stringBuffer.toString();
    }

    public synchronized void saveTableToFile(File file, boolean bl) throws IOException {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file.getPath(), bl));
        if (!bl) {
            bufferedOutputStream.write(this._$26077().getBytes());
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATE_FORMAT);
        String string = simpleDateFormat.format(new Date());
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('\"');
        stringBuffer.append(string);
        stringBuffer.append('\"');
        for (int i2 = 1; i2 < this._$11754.getNumRows(); ++i2) {
            stringBuffer.append(",\"");
            stringBuffer.append(this._$11754.getTableDataItem(i2, 2));
            stringBuffer.append('\"');
        }
        stringBuffer.append('\n');
        bufferedOutputStream.write(stringBuffer.toString().getBytes());
        bufferedOutputStream.flush();
        bufferedOutputStream.close();
    }

    public void addTrapObjects(long l2) {
        Vector<Object> vector = new Vector<Object>(3);
        ObjectID objectID = new ObjectID(SnmpConstants.sysUpTime.toString());
        vector.addElement(objectID);
        vector.addElement(new Integer(11));
        vector.addElement(new Long(l2));
        ValueConverter valueConverter = new ValueConverter(new MIBObjectType(objectID, "sysUpTime", new Integer(-1)), new MIBSyntax(SMI.SMI_SYNTAX[11], 0), null);
        vector.addElement(valueConverter);
        this._$11754.addRow(1, new Integer(1), vector);
        this.setReadOnly(1, true);
        this._$18260(1);
        vector = new Vector(3);
        ObjectID objectID2 = new ObjectID(SnmpConstants.snmpTrapOID.toString());
        vector.addElement(objectID2);
        vector.addElement(new Integer(2));
        vector.addElement(new ObjectID());
        valueConverter = new ValueConverter(new MIBObjectType(objectID2, "snmpTrapOid", new Integer(-1)), new MIBSyntax(SMI.SMI_SYNTAX[2], 0), null);
        vector.addElement(valueConverter);
        this._$11754.addRow(2, new Integer(2), vector);
        this.setReadOnly(2, true);
        this._$18260(2);
        this._$25830();
        this._$28759(MultiPDUDialog.PDU_TYPES);
    }

    private int _$28765() {
        String string = (String)this._$28752.getSelectedItem();
        if ("TRAP".equals(string)) {
            return -89;
        }
        return PDU.getTypeFromString(string);
    }

    void jButtonMoveUp_actionPerformed(ActionEvent actionEvent) {
        int n2;
        Collection collection = this._$274.getSelectedCells();
        if (collection == null) {
            return;
        }
        JCCellRange[] jCCellRangeArray = new JCCellRange[collection.size()];
        collection.toArray(jCCellRangeArray);
        for (n2 = 0; n2 < jCCellRangeArray.length; ++n2) {
            TableUtils.setRangeAfterCopy(jCCellRangeArray[n2]);
        }
        for (n2 = 0; n2 < jCCellRangeArray.length; ++n2) {
            if (jCCellRangeArray[n2].start_row <= 1) continue;
            this._$25705.addEdit(new RowMoveMV(jCCellRangeArray[n2].start_row, jCCellRangeArray[n2].end_row - jCCellRangeArray[n2].start_row + 1, -1));
        }
        this.updateButtons();
    }

    void jButtonMoveDown_actionPerformed(ActionEvent actionEvent) {
        int n2;
        Collection collection = this._$274.getSelectedCells();
        if (collection == null) {
            return;
        }
        JCCellRange[] jCCellRangeArray = new JCCellRange[collection.size()];
        collection.toArray(jCCellRangeArray);
        for (n2 = 0; n2 < jCCellRangeArray.length; ++n2) {
            TableUtils.setRangeAfterCopy(jCCellRangeArray[n2]);
        }
        for (n2 = 0; n2 < jCCellRangeArray.length; ++n2) {
            if (jCCellRangeArray[n2].end_row == this._$11754.getNumRows() - 1) continue;
            this._$25705.addEdit(new RowMoveMV(jCCellRangeArray[n2].start_row, jCCellRangeArray[n2].end_row - jCCellRangeArray[n2].start_row + 1, 1));
        }
        this.updateButtons();
    }

    public void afterSelect(JCSelectEvent jCSelectEvent) {
        if (jCSelectEvent.getStartColumn() == -1) {
            this.traverse(jCSelectEvent.getStartRow(), 0, false, false);
        }
        if (jCSelectEvent.getStartRow() == -1) {
            this.traverse(0, jCSelectEvent.getStartColumn(), false, false);
        }
        this.updateButtons();
    }

    public void beforeSelect(JCSelectEvent jCSelectEvent) {
    }

    public void select(JCSelectEvent jCSelectEvent) {
    }

    public void setMessage(String string) {
        this.observer.setMessage(string);
    }

    public boolean isChanged() {
        return this._$25705.canUndo();
    }

    public void setTitle(String string) {
        this._$7264 = string;
        this.jToolBar1.setName("PDU Main Tool Bar of " + this._$7264);
        this.jToolBarRefresh.setName("PDU Refresh Tool Bar of " + this._$7264);
    }

    public String getTitle() {
        return this._$7264;
    }

    void jButtonZoomOut_actionPerformed(ActionEvent actionEvent) {
        this.jButtonZoomIn.setEnabled(true);
        this.jButtonZoomOut.setEnabled(false);
        this.fireLinkComponent(new ComponentLinkEvent(this, this.getPanel(), this._$7264));
        this.getPanel().updateButtons();
        this.f.dispose();
        this.f = null;
    }

    void jButtonZoomIn_actionPerformed(ActionEvent actionEvent) {
        this.jButtonZoomIn.setEnabled(false);
        this.jButtonZoomOut.setEnabled(true);
        this.fireUnlinkComponent(new ComponentLinkEvent(this, this, this.getTitle()));
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MultiVariablePanel.this.f = new StandardFrame(false){

                    public boolean cancel() {
                        ComponentLinkEvent componentLinkEvent = new ComponentLinkEvent(this, MultiVariablePanel.this, MultiVariablePanel.this._$7264);
                        MultiVariablePanel.this.fireUnlinkComponent(componentLinkEvent);
                        return componentLinkEvent.isAccepted();
                    }
                };
                MultiVariablePanel.this.f.addWindowListener((WindowListener)((Object)MultiVariablePanel.this._$25700));
                MultiVariablePanel.this.f.setIconImage(MIBExplorerFrame.explorerIcon);
                MultiVariablePanel.this.f.setTitle(MultiVariablePanel.this.getTitle());
                MultiVariablePanel.this.setVisible(true);
                MultiVariablePanel.this.f.setPanel(MultiVariablePanel.this.getPanel());
                MultiVariablePanel.this.revalidate();
                MultiVariablePanel.this.repaint();
                MIBExplorerFrame.centerFrame(MultiVariablePanel.this.f);
                MultiVariablePanel.this.f.setVisible(true);
            }
        });
    }

    public synchronized void removeComponentLinkListener(ComponentLinkListener componentLinkListener) {
        if (this._$25728 != null && this._$25728.contains(componentLinkListener)) {
            Vector vector = (Vector)this._$25728.clone();
            vector.removeElement(componentLinkListener);
            this._$25728 = vector;
        }
    }

    public synchronized void addComponentLinkListener(ComponentLinkListener componentLinkListener) {
        Vector vector;
        Vector vector2 = vector = this._$25728 == null ? new Vector(2) : (Vector)this._$25728.clone();
        if (!vector.contains(componentLinkListener)) {
            vector.addElement(componentLinkListener);
            this._$25728 = vector;
        }
    }

    protected void fireUnlinkComponent(ComponentLinkEvent componentLinkEvent) {
        if (this._$25728 != null) {
            Vector vector = this._$25728;
            int n2 = vector.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                ((ComponentLinkListener)vector.elementAt(i2)).unlinkComponent(componentLinkEvent);
            }
        }
    }

    protected void fireLinkComponent(ComponentLinkEvent componentLinkEvent) {
        if (this._$25728 != null) {
            Vector vector = this._$25728;
            int n2 = vector.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                ((ComponentLinkListener)vector.elementAt(i2)).linkComponent(componentLinkEvent);
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() > 0) {
            JCCellPosition jCCellPosition = this._$274.XYToCell(mouseEvent.getPoint().x, mouseEvent.getPoint().y);
            if (jCCellPosition == null || jCCellPosition.column != -1) {
                return;
            }
            ObjectID objectID = (ObjectID)this._$11754.getTableDataItem(jCCellPosition.row, 0);
            if (objectID == null) {
                objectID = new ObjectID();
            }
            try {
                Pair pair = this._$20550.getSplittedObjectID(objectID);
                if (pair.second == null) {
                    return;
                }
                MIBObject mIBObject = this._$20550.getObject((ObjectID)pair.first);
                if (mIBObject == null) {
                    return;
                }
                this.fireChangedMIBObject(new MIBObjectEvent(this, mIBObject, 0));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public synchronized void removeMIBObjectListener(MIBObjectListener mIBObjectListener) {
        if (this._$25771 != null && this._$25771.contains(mIBObjectListener)) {
            Vector vector = (Vector)this._$25771.clone();
            vector.removeElement(mIBObjectListener);
            this._$25771 = vector;
        }
    }

    public synchronized void addMIBObjectListener(MIBObjectListener mIBObjectListener) {
        Vector vector;
        Vector vector2 = vector = this._$25771 == null ? new Vector(2) : (Vector)this._$25771.clone();
        if (!vector.contains(mIBObjectListener)) {
            vector.addElement(mIBObjectListener);
            this._$25771 = vector;
        }
    }

    protected void fireChangedMIBObject(MIBObjectEvent mIBObjectEvent) {
        if (this._$25771 != null) {
            Vector vector = this._$25771;
            int n2 = vector.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                ((MIBObjectListener)vector.elementAt(i2)).changedMIBObject(mIBObjectEvent);
            }
        }
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        if (this._$25772 != null && this._$25772.contains(actionListener)) {
            Vector vector = (Vector)this._$25772.clone();
            vector.removeElement(actionListener);
            this._$25772 = vector;
        }
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        Vector vector;
        Vector vector2 = vector = this._$25772 == null ? new Vector(2) : (Vector)this._$25772.clone();
        if (!vector.contains(actionListener)) {
            vector.addElement(actionListener);
            this._$25772 = vector;
        }
    }

    protected void fireActionPerformed(ActionEvent actionEvent) {
        if (this._$25772 != null) {
            Vector vector = this._$25772;
            int n2 = vector.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                ((ActionListener)vector.elementAt(i2)).actionPerformed(actionEvent);
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int[] nArray = TableUtils.getSelectedRows(this._$274);
        if (actionEvent.getActionCommand().equals(ACTION_UNLOCK)) {
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                this.setReadOnly(nArray[i2], false);
            }
        }
    }

    public void setFile(File file) {
        this._$19387 = file;
    }

    public File getFile() {
        return this._$19387;
    }

    class FormatAction
    extends AbstractAction {
        private String _$7197;

        public FormatAction(String string, String string2) {
            super(string);
            this._$7197 = string2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JCCellPosition jCCellPosition = MultiVariablePanel.this._$274.getPopupCellPosition();
            int n2 = MultiVariablePanel.this._$1241(jCCellPosition.row, jCCellPosition.column);
            ValueConverter valueConverter = (ValueConverter)MultiVariablePanel.this._$11754.getTableDataItem(n2, 3);
            if (valueConverter != null) {
                MultiVariablePanel.this._$274.commitEdit(true);
                Variable variable = valueConverter.fromNative(MultiVariablePanel.this._$11754.getTableDataItem(n2, 2));
                if (this._$7197 == null) {
                    MIBObjectType mIBObjectType = valueConverter.getObjectType();
                    if (mIBObjectType != null) {
                        MIBTextualConvention mIBTextualConvention = MultiVariablePanel.this._$20550.getEffectiveSyntax(mIBObjectType.getSyntax());
                        if (mIBTextualConvention.getDisplayHint() != null) {
                            valueConverter.setDisplayHint(MIBObject.getUnquotedString(mIBTextualConvention.getDisplayHint()));
                        } else {
                            valueConverter.setDisplayHint(null);
                        }
                    } else {
                        valueConverter.setDisplayHint(null);
                    }
                } else {
                    valueConverter.setDisplayHint(this._$7197);
                }
                MultiVariablePanel.this._$11754.setTableDataItem(valueConverter.toNative(variable), n2, 2);
            }
        }
    }

    class RequestListener
    implements ResponseListener {
        public ResponseEvent pduEvent = null;

        public void onResponse(ResponseEvent responseEvent) {
            this.pduEvent = responseEvent;
            responseEvent.getUserObject().notify();
        }
    }

    class RowMoveMV
    extends RowMove {
        private int _$7188;
        private int _$26002;
        private int _$23074;

        public RowMoveMV(int n2, int n3, int n4) {
            super(MultiVariablePanel.this._$274, MultiVariablePanel.this._$11754, n2, n3, n4);
        }

        protected void renumberRows(int n2) {
            MultiVariablePanel.this._$18260(n2);
        }
    }

    class RowAddEdit
    extends AbstractUndoableEdit {
        private int _$355;
        private boolean _$11903 = true;
        private Vector _$7187;

        public RowAddEdit(int n2, boolean bl, Vector vector) {
            this._$355 = n2;
            this._$11903 = bl;
            this._$7187 = vector;
            if (bl) {
                MultiVariablePanel.this._$25830();
            }
        }

        public void undo() {
            super.undo();
            if (this._$11903) {
                if (!MultiVariablePanel.this._$11754.deleteRows(this._$355, 1)) {
                    throw new CannotUndoException();
                }
                MultiVariablePanel.this._$18260(this._$355);
            } else {
                if (!MultiVariablePanel.this._$11754.addRow(this._$355, new Integer(this._$355), this._$7187)) {
                    throw new CannotUndoException();
                }
                MultiVariablePanel.this._$28771(this._$355, true);
                MultiVariablePanel.this._$18260(this._$355);
            }
        }

        public void redo() {
            super.redo();
            if (this._$11903) {
                if (!MultiVariablePanel.this._$11754.addRow(this._$355, new Integer(this._$355), this._$7187)) {
                    throw new CannotRedoException();
                }
                MultiVariablePanel.this._$28771(this._$355, true);
                MultiVariablePanel.this._$18260(this._$355);
            } else {
                if (!MultiVariablePanel.this._$11754.deleteRows(this._$355, 1)) {
                    throw new CannotRedoException();
                }
                MultiVariablePanel.this._$18260(this._$355);
            }
        }
    }

    class CellEdit
    extends AbstractUndoableEdit {
        public JCTableCellInfo info;
        public Object oldValue;
        public Object newValue;
        public Object oldValueValue;

        public CellEdit(JCTableCellInfo jCTableCellInfo, Object object, Object object2) {
            this.info = jCTableCellInfo;
            this.oldValue = object;
            if (jCTableCellInfo.getColumn() == 1) {
                this.oldValueValue = MultiVariablePanel.this._$11754.getTableDataItem(jCTableCellInfo.getRow(), 2);
            }
            this.newValue = object2;
        }

        public void undo() {
            super.undo();
            if (!MultiVariablePanel.this._$11754.setTableDataItem(this.oldValue, this.info.getRow(), this.info.getColumn())) {
                throw new CannotUndoException();
            }
            if (this.info.getColumn() == 1) {
                int n2 = (Integer)MultiVariablePanel.this._$11754.getTableDataItem(this.info.getRow(), this.info.getColumn());
                ValueConverter valueConverter = new ValueConverter(n2);
                MultiVariablePanel.this._$11754.setTableDataItem(valueConverter, this.info.getRow(), 3);
                MultiVariablePanel.this._$11754.setTableDataItem(this.oldValueValue, this.info.getRow(), 2);
                JCCellStyle jCCellStyle = new JCCellStyle(MultiVariablePanel.this._$25703);
                jCCellStyle.setCellEditor(MultiVariablePanel.getCellEditor(valueConverter, MultiVariablePanel.this._$20550));
                MultiVariablePanel.this._$5384(this.info.getRow(), 2, jCCellStyle);
            }
            MultiVariablePanel.this.traverse(this.info.getRow(), this.info.getColumn(), false, true);
        }

        public void redo() {
            super.redo();
            if (!MultiVariablePanel.this._$11754.setTableDataItem(this.newValue, this.info.getRow(), this.info.getColumn())) {
                throw new CannotRedoException();
            }
            if (this.info.getColumn() == 1) {
                int n2 = (Integer)MultiVariablePanel.this._$11754.getTableDataItem(this.info.getRow(), this.info.getColumn());
                ValueConverter valueConverter = new ValueConverter(n2);
                MultiVariablePanel.this._$11754.setTableDataItem(valueConverter, this.info.getRow(), 3);
                MultiVariablePanel.this._$11754.setTableDataItem(valueConverter.getNativeExample(), this.info.getRow(), 2);
                JCCellStyle jCCellStyle = new JCCellStyle(MultiVariablePanel.this._$25703);
                jCCellStyle.setCellEditor(MultiVariablePanel.getCellEditor(valueConverter, MultiVariablePanel.this._$20550));
                MultiVariablePanel.this._$5384(this.info.getRow(), 2, jCCellStyle);
            }
            MultiVariablePanel.this.traverse(this.info.getRow(), this.info.getColumn(), false, true);
        }

        public void setNewValue(Object object) {
            this.newValue = object;
        }
    }

    class PeriodicRefresh
    extends TimerTask {
        private int _$25277 = 0;
        private int _$25278;

        public PeriodicRefresh(int n2) {
            this._$25278 = n2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (this._$25277 + this._$25278 < 100) {
                this._$25277 += this._$25278;
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        MultiVariablePanel.this.refresh();
                    }
                });
                MultiVariablePanel multiVariablePanel = MultiVariablePanel.this.getPanel();
                synchronized (multiVariablePanel) {
                    try {
                        MultiVariablePanel.this.getPanel().wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                this._$25277 = 0;
            }
            MultiVariablePanel.this.jProgressBarTimer.setValue(this._$25277);
        }
    }
}

