/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.explorer;

import com.agentpp.common.StandardDialog;
import com.agentpp.common.table.FlexListTable;
import com.agentpp.common.table.TableUtils;
import com.agentpp.explorer.BrowsePanel;
import com.agentpp.explorer.log.SnmpLogger;
import com.agentpp.mib.MIBRepository;
import com.agentpp.snmp.GenTarget;
import com.klg.jclass.table.JCListTable;
import com.klg.jclass.table.JCSelectEvent;
import com.klg.jclass.table.JCSelectListener;
import com.klg.jclass.table.data.JCEditableVectorDataSource;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.snmp4j.PDU;
import org.snmp4j.PDUv1;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.event.ResponseListener;
import org.snmp4j.mp.SnmpConstants;
import org.snmp4j.smi.IpAddress;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.TimeTicks;
import org.snmp4j.smi.VariableBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiPDUDialog
extends StandardDialog
implements JCSelectListener {
    public static final String[] PDU_TYPES = new String[]{"GET", "GETNEXT", "GETBULK", "SET", "TRAP", "INFORM"};
    public static final String[] NON_TRAP_PDU_TYPES = new String[]{"GET", "GETNEXT", "GETBULK", "SET"};
    public static final int[] PDU_IDS = new int[]{-96, -95, -91, -93, -89, -90};
    private static long _$26010 = System.currentTimeMillis();
    private List<GenTarget> _$7365;
    private VariableBinding[] _$20793;
    private MIBRepository _$20550;
    private JCEditableVectorDataSource _$27832 = new JCEditableVectorDataSource();
    private BrowsePanel _$27833;
    private UserUpdate _$25296;
    private int _$27835;
    protected int nonrep;
    protected int maxrep;
    JPanel resultPanel = new JPanel();
    JButton resendButton = new JButton();
    BorderLayout borderLayout1 = new BorderLayout();
    JCListTable table = new FlexListTable();
    Border border1;
    TitledBorder titledBorder1;
    Border border2;
    Border border3;
    TitledBorder titledBorder2;
    Border border4;
    private Snmp _$14889;
    private SnmpLogger _$12571;

    public MultiPDUDialog(JFrame jFrame, String string, boolean bl, List<GenTarget> list, Snmp snmp, VariableBinding[] variableBindingArray, int n2, MIBRepository mIBRepository, int n3, int n4) {
        super(jFrame, string, bl);
        int n5;
        this.setCancelButtonToolTip("Cancel any outstanding requests");
        this.setOKButtonToolTip("Close window");
        this._$7365 = list;
        this._$14889 = snmp;
        this._$20793 = variableBindingArray;
        this.nonrep = n3;
        this.maxrep = n4;
        this._$20550 = mIBRepository;
        this._$12571 = new SnmpLogger(mIBRepository);
        this._$27835 = n2;
        this._$27833 = new BrowsePanel(mIBRepository);
        this._$27832.setNumColumns(3);
        this._$27832.setNumRows(0);
        this._$27832.setColumnLabel(0, "Target");
        this._$27832.setColumnLabel(1, "Address");
        this._$27832.setColumnLabel(2, "Status");
        this.table.setToolTipText("Select a row to view the corresponding response PDU (if available)");
        ToolTipManager.sharedInstance().registerComponent(this.table);
        this.table.setDataSource(this._$27832);
        this.table.setVisibleRows(20);
        this.table.setVariableEstimateCount(20);
        this.table.setRowLabelDisplay(false);
        this.table.getDefaultCellStyle().setEditable(false);
        for (n5 = 0; n5 < 2; ++n5) {
            this.table.setPixelWidth(n5, 33002);
        }
        this.table.addSelectListener(this);
        this.table.setCharWidth(2, 20);
        for (n5 = 0; n5 < list.size(); ++n5) {
            GenTarget genTarget = list.get(n5);
            if (!(genTarget instanceof GenTarget)) {
                System.err.println(genTarget.getClass() + "=" + genTarget);
            }
            GenTarget genTarget2 = genTarget;
            Vector<String> vector = new Vector<String>(3);
            vector.addElement(genTarget2.getName());
            vector.addElement(genTarget2.getAddress().toString());
            vector.addElement("Waiting...");
            this._$27832.addRow(Integer.MAX_VALUE, genTarget2, vector);
        }
        this._$25296 = new UserUpdate(this._$27832, variableBindingArray, n2);
        this._$25296.setResultDialog(this);
        this.setOkButtonEnabled(false);
        this.resendButton.setEnabled(false);
        this._$27833.set(this._$27833.makeRow(null, variableBindingArray), 0, 0);
        try {
            this.jbInit2();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public MultiPDUDialog() {
        try {
            this.jbInit2();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void jbInit2() throws Exception {
        this.resendButton.setText("Resend All");
        this.resendButton.setToolTipText("Cancel any outstanding requests and send PDU to all targets once again");
        this.buttons.add((Component)this.resendButton, 1);
        this.resendButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MultiPDUDialog.this.resend_actionPerformed(actionEvent);
            }
        });
        this.resultPanel.setLayout(new BorderLayout());
        this.border1 = new EtchedBorder(0, Color.white, new Color(148, 145, 140));
        this.titledBorder1 = new TitledBorder(this.border1, "Results");
        this.border2 = BorderFactory.createCompoundBorder(this.titledBorder1, BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.border3 = new EtchedBorder(0, Color.white, new Color(148, 145, 140));
        this.titledBorder2 = new TitledBorder(this.border3, "Response PDU ");
        this.border4 = BorderFactory.createCompoundBorder(this.titledBorder2, BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.resultPanel.setBorder(this.border2);
        this._$27833.setBorder(this.border4);
        this.resultPanel.add((Component)this.table, "North");
        this.resultPanel.add((Component)this._$27833, "Center");
        this.panelRoot.add((Component)this.resultPanel, "Center");
        this.pack();
    }

    @Override
    public void setVisible(boolean bl) {
        this._$25296.start();
        this._$27833.clear();
        super.setVisible(bl);
    }

    public void resend_actionPerformed(ActionEvent actionEvent) {
        this.cancel();
        this._$27833.clear();
        this.resendButton.setEnabled(false);
        this.setCancelButtonEnabled(true);
        for (int i2 = 0; i2 < this._$7365.size(); ++i2) {
            this._$27832.setTableDataItem("Waiting...", i2, 2);
            this._$27832.setRowLabel(i2, this._$7365.get(i2));
        }
        this._$25296 = new UserUpdate(this._$27832, this._$20793, this._$27835);
        this._$25296.setResultDialog(this);
        this.setOkButtonEnabled(false);
        this._$25296.start();
    }

    @Override
    public boolean cancel() {
        this._$25296.cancel();
        super.setCancelButtonEnabled(false);
        return false;
    }

    public static String getPDUString(int n2) {
        switch (n2) {
            case -90: {
                return "INFORM";
            }
            case -93: {
                return "SET";
            }
            case -96: {
                return "GET";
            }
            case -91: {
                return "GETBULK";
            }
            case -89: {
                return "TRAP";
            }
            case -95: {
                return "GETNEXT";
            }
        }
        return "?";
    }

    @Override
    public void select(JCSelectEvent jCSelectEvent) {
    }

    @Override
    public void beforeSelect(JCSelectEvent jCSelectEvent) {
    }

    @Override
    public void afterSelect(JCSelectEvent jCSelectEvent) {
        int n2 = jCSelectEvent.getStartRow();
        this._$27849(n2);
    }

    private void _$27849(int n2) {
        this._$27833.clear();
        if (this._$27832.getTableRowLabel(n2) != null && this._$27832.getTableRowLabel(n2) instanceof PDU) {
            PDU pDU = (PDU)this._$27832.getTableRowLabel(n2);
            Vector vector = this._$27833.makeRow(null, pDU.toArray());
            this._$27833.set(vector, pDU.getErrorStatus(), pDU.getErrorIndex());
        }
    }

    public static IpAddress getAgentAddress(VariableBinding[] variableBindingArray) {
        for (int i2 = 0; i2 < variableBindingArray.length; ++i2) {
            if (!variableBindingArray[i2].getOid().equals(SnmpConstants.snmpTrapAddress) || variableBindingArray[i2].getSyntax() != 64) continue;
            return (IpAddress)variableBindingArray[i2].getVariable();
        }
        return new IpAddress("0.0.0.0");
    }

    public static OID getTrapOID(VariableBinding[] variableBindingArray) {
        for (int i2 = 0; i2 < variableBindingArray.length; ++i2) {
            if (!variableBindingArray[i2].getOid().equals(SnmpConstants.snmpTrapOID) || variableBindingArray[i2].getSyntax() != 6) continue;
            return new OID(((OID)variableBindingArray[i2].getVariable()).toString());
        }
        return new OID();
    }

    public static long getTimestamp(VariableBinding[] variableBindingArray) {
        for (int i2 = 0; i2 < variableBindingArray.length; ++i2) {
            if (!variableBindingArray[i2].getOid().equals(SnmpConstants.sysUpTime) || !(variableBindingArray[i2].getVariable() instanceof TimeTicks)) continue;
            return ((TimeTicks)variableBindingArray[i2].getVariable()).getValue();
        }
        return 0L;
    }

    public static boolean isValidTrapPDU(VariableBinding[] variableBindingArray) {
        return variableBindingArray.length >= 2 && variableBindingArray[1].getOid().equals(SnmpConstants.snmpTrapOID) && variableBindingArray[0].getOid().equals(SnmpConstants.sysUpTime) && variableBindingArray[0].getSyntax() == 67 && variableBindingArray[1].getSyntax() == 6;
    }

    public static VariableBinding[] getV1TrapVbs(VariableBinding[] variableBindingArray) {
        Vector<VariableBinding> vector = new Vector<VariableBinding>(variableBindingArray.length + 1);
        for (int i2 = 0; i2 < variableBindingArray.length; ++i2) {
            if (variableBindingArray[i2].getOid().equals(SnmpConstants.sysUpTime) || variableBindingArray[i2].getOid().equals(SnmpConstants.snmpTrapOID) || variableBindingArray[i2].getOid().equals(SnmpConstants.snmpTrapAddress)) continue;
            vector.addElement(variableBindingArray[i2]);
        }
        Object[] objectArray = new VariableBinding[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    class UserUpdate
    extends Thread
    implements ResponseListener {
        private JCEditableVectorDataSource _$27832;
        private boolean _$16166 = false;
        private StandardDialog _$22539;
        private boolean _$27850 = true;
        private VariableBinding[] _$20793;
        private PDU[] _$16162;
        private int _$27835;

        public UserUpdate(JCEditableVectorDataSource jCEditableVectorDataSource, VariableBinding[] variableBindingArray, int n2) {
            this._$27832 = jCEditableVectorDataSource;
            this._$20793 = variableBindingArray;
            this._$27835 = n2;
            this._$16162 = new PDU[jCEditableVectorDataSource.getNumRows()];
        }

        public void setResultDialog(StandardDialog standardDialog) {
            this._$22539 = standardDialog;
        }

        public synchronized void cancel() {
            this._$16166 = true;
            for (int i2 = 0; i2 < this._$16162.length; ++i2) {
                if (this._$16162[i2] == null) continue;
                MultiPDUDialog.this._$14889.cancel(this._$16162[i2], this);
                this._$27832.setTableDataItem("Canceled", i2, 2);
            }
        }

        public synchronized void onResponse(ResponseEvent responseEvent) {
            MultiPDUDialog.this._$14889.cancel(responseEvent.getRequest(), this);
            PDU pDU = responseEvent.getResponse();
            MultiPDUDialog.this._$12571.logResponse(responseEvent, null);
            Integer n2 = (Integer)responseEvent.getUserObject();
            int n3 = n2;
            this._$16162[n3] = null;
            this._$27832.setRowLabel(n3, pDU);
            if (pDU == null) {
                this._$27832.setTableDataItem("Timeout", n3, 2);
            } else if (pDU.getErrorStatus() != 0) {
                this._$27832.setTableDataItem(pDU.getErrorStatusText() + " at index " + pDU.getErrorIndex(), n3, 2);
            } else {
                this._$27832.setTableDataItem("Success", n3, 2);
            }
            boolean bl = true;
            for (int i2 = 0; i2 < this._$16162.length; ++i2) {
                if (this._$16162[i2] == null) continue;
                bl = false;
                break;
            }
            if (bl) {
                this._$22539.setCancelButtonEnabled(false);
                int[] nArray = TableUtils.getSelectedRows(MultiPDUDialog.this.table);
                if (nArray == null || nArray.length == 0) {
                    MultiPDUDialog.this.table.setSelection(0, 0, 0, MultiPDUDialog.this.table.getNumColumns() - 1);
                    MultiPDUDialog.this._$27849(0);
                } else {
                    MultiPDUDialog.this._$27849(TableUtils.getFirstSelectedRow(MultiPDUDialog.this.table));
                }
            }
        }

        public void run() {
            int n2;
            block13: for (n2 = 0; !this._$16166 && n2 < this._$27832.getNumRows(); ++n2) {
                this._$27832.setTableDataItem("Processing...", n2, 2);
                GenTarget genTarget = (GenTarget)this._$27832.getTableRowLabel(n2);
                try {
                    Target target = genTarget.getTarget();
                    PDU pDU = genTarget.makePDU();
                    VariableBinding[] variableBindingArray = new VariableBinding[this._$20793.length];
                    block14: for (int i2 = 0; i2 < this._$20793.length; ++i2) {
                        switch (this._$27835) {
                            case -96: 
                            case -95: 
                            case -91: {
                                variableBindingArray[i2] = new VariableBinding(this._$20793[i2].getOid());
                                continue block14;
                            }
                            default: {
                                variableBindingArray[i2] = (VariableBinding)this._$20793[i2].clone();
                            }
                        }
                    }
                    pDU.addAll(variableBindingArray);
                    switch (this._$27835) {
                        case -96: {
                            MultiPDUDialog.this._$14889.get(pDU, target, new Integer(n2), this);
                            break;
                        }
                        case -95: {
                            MultiPDUDialog.this._$14889.getNext(pDU, target, new Integer(n2), this);
                            break;
                        }
                        case -91: {
                            pDU.setNonRepeaters(MultiPDUDialog.this.nonrep);
                            pDU.setMaxRepetitions(MultiPDUDialog.this.maxrep);
                            MultiPDUDialog.this._$14889.getBulk(pDU, target, new Integer(n2), this);
                            break;
                        }
                        case -93: {
                            MultiPDUDialog.this._$14889.set(pDU, target, new Integer(n2), this);
                            break;
                        }
                        case -90: {
                            MultiPDUDialog.this._$14889.inform(pDU, target, new Integer(n2), this);
                            break;
                        }
                        case -89: {
                            if (target.getVersion() == 0) {
                                PDUv1 pDUv1 = new PDUv1();
                                pDUv1.setType(-92);
                                pDUv1.setAgentAddress(MultiPDUDialog.getAgentAddress(this._$20793));
                                OID oID = MultiPDUDialog.getTrapOID(this._$20793);
                                int n3 = SnmpConstants.getGenericTrapID(oID);
                                if (n3 == -1) {
                                    pDUv1.setGenericTrap(6);
                                    if (oID.size() < 3 || oID.get(oID.size() - 2) != 0) {
                                        this._$27832.setTableDataItem("Not send due to invalid SNMPv1 trap OID: " + oID, n2, 2);
                                        continue block13;
                                    }
                                    int n4 = oID.get(oID.size() - 1);
                                    oID.trim(2);
                                    pDUv1.setEnterprise(oID);
                                    pDUv1.setSpecificTrap(n4);
                                } else {
                                    pDUv1.setGenericTrap(n3);
                                }
                                pDUv1.setTimestamp(MultiPDUDialog.getTimestamp(this._$20793));
                                VariableBinding[] variableBindingArray2 = MultiPDUDialog.getV1TrapVbs(this._$20793);
                                pDUv1.addAll(variableBindingArray2);
                                pDU = pDUv1;
                            } else {
                                pDU.setType(-89);
                            }
                            MultiPDUDialog.this._$14889.send(pDU, target);
                            this._$27832.setTableDataItem("Success", n2, 2);
                            break;
                        }
                        default: {
                            this._$27832.setTableDataItem("Not send", n2, 2);
                        }
                    }
                    SnmpLogger.logRequest(pDU, genTarget);
                    if (this._$27835 == -89) continue;
                    this._$16162[n2] = pDU;
                    continue;
                }
                catch (Exception exception) {
                    this._$27832.setTableDataItem(exception.getMessage(), n2, 2);
                    this._$27850 = false;
                    exception.printStackTrace();
                }
            }
            if (this._$16166) {
                while (n2 < this._$27832.getNumRows()) {
                    this._$27832.setTableDataItem("Canceled", n2, 2);
                    this._$27850 = false;
                    ++n2;
                }
            }
            this._$22539.setOkButtonEnabled(true);
            MultiPDUDialog.this.resendButton.setEnabled(true);
            if (this._$27835 == -89) {
                this._$22539.setCancelButtonEnabled(false);
            }
        }

        public boolean isOverallSuccess() {
            return this._$27850;
        }
    }
}

