/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.explorer;

import com.agentpp.explorer.IndexConverter;
import com.agentpp.explorer.MIBTableModelChangeListener;
import com.agentpp.explorer.MIBTableModelRowKey;
import com.agentpp.mib.IndexStruct;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBObjectType;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.MIBSyntax;
import com.agentpp.mib.MIBTextualConvention;
import com.agentpp.mib.ObjectID;
import com.agentpp.mib.ObjectIDFormatException;
import com.agentpp.smiparser.SMI;
import com.agentpp.snmp.GenTarget;
import com.agentpp.snmp.JCValueConverter;
import com.agentpp.snmp.ValueConverter;
import com.klg.jclass.table.data.JCEditableVectorDataSource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.SwingUtilities;
import org.snmp4j.smi.Counter32;
import org.snmp4j.smi.Counter64;
import org.snmp4j.smi.Gauge32;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.IpAddress;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Opaque;
import org.snmp4j.smi.TimeTicks;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MIBTableModel
extends JCEditableVectorDataSource {
    protected ArrayList<OID> colids;
    protected IndexStruct[] index = null;
    protected MIBRepository rep;
    protected ArrayList<MIBObject> columns = new ArrayList();
    protected ArrayList<JCValueConverter> valueConverter = new ArrayList();
    protected ArrayList<MIBTableModelRowKey> indexes = new ArrayList();
    protected TreeMap<MIBTableModelRowKey, MIBTableModelRowKey> index2row = new TreeMap();
    protected Set<MIBTableModelRowKey> obsoleteRows = Collections.synchronizedSet(new HashSet());
    protected transient MIBTableModelChangeListener changeListener;

    public MIBTableModel(MIBRepository mIBRepository, Vector<MIBObject> vector, Vector<String> vector2, IndexStruct[] indexStructArray) {
        this.rep = mIBRepository;
        this.columns.addAll(vector);
        this.colids = new ArrayList(vector.size() + 1);
        int n2 = 0;
        Object object = vector.elements();
        while (object.hasMoreElements()) {
            MIBObjectType mIBObjectType = (MIBObjectType)object.nextElement();
            if (n2 >= indexStructArray.length && !mIBObjectType.getAccess().equals(SMI.ACCESS[0])) {
                this.colids.add(new OID(mIBObjectType.getOid().toString()));
            }
            MIBTextualConvention mIBTextualConvention = mIBRepository.getEffectiveSyntax(mIBObjectType.getSyntax());
            JCValueConverter jCValueConverter = new JCValueConverter(mIBObjectType, mIBTextualConvention.getSyntax(), mIBTextualConvention.getDisplayHint());
            this.valueConverter.add(jCValueConverter);
            ++n2;
        }
        object = new Vector(vector2.size());
        if (vector2.size() < vector.size() + 1) {
            int n3;
            for (n3 = 0; n3 < indexStructArray.length; ++n3) {
                ((Vector)object).add(vector2.get(n3));
            }
            ((Vector)object).add("Target");
            while (n3 < vector2.size()) {
                ((Vector)object).add(vector2.get(n3));
                ++n3;
            }
        }
        this.setColumnLabels((Vector)object);
        this.setNumRows(0);
        this.setNumColumns(((Vector)object).size());
        this.index = indexStructArray;
    }

    public List<OID> getColumnIDs() {
        return this.colids;
    }

    public List<MIBObject> getColumns() {
        return this.columns;
    }

    public int getValueColumnCount() {
        return super.getNumColumns() - 1;
    }

    public int getColumn(OID oID) {
        for (int i2 = 0; i2 < this.colids.size(); ++i2) {
            OID oID2 = this.colids.get(i2);
            if (oID.leftMostCompare(oID2.size(), oID2) != 0) continue;
            return this.index.length + 1 + i2;
        }
        return -1;
    }

    public int getColumn(OID oID, int n2) {
        for (int i2 = n2; i2 < this.colids.size(); ++i2) {
            OID oID2 = this.colids.get(i2);
            if (oID.leftMostCompare(oID2.size(), oID2) != 0) continue;
            return this.index.length + 1 + i2;
        }
        return -1;
    }

    private static String _$35848(String string) {
        String string2 = string;
        while (string2.length() > 2 && Character.isLowerCase(string2.charAt(string2.length() - 1))) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        if (string2.length() < 2) {
            return "";
        }
        return string2.substring(0, string2.length() - 1);
    }

    public static Vector getTitlesFromNames(String string, Vector vector) {
        String string2;
        int n2;
        Vector vector2 = new Vector(vector.size() + 1);
        String string3 = MIBTableModel._$35848(string);
        boolean bl = false;
        block0: while (!bl && string3.length() > 0) {
            bl = true;
            for (n2 = 0; n2 < vector.size(); ++n2) {
                string2 = vector.elementAt(n2).toString();
                if (string2.startsWith(string3)) continue;
                string3 = MIBTableModel._$35848(string3);
                bl = false;
                continue block0;
            }
        }
        if (bl) {
            for (n2 = 0; n2 < vector.size(); ++n2) {
                string2 = vector.elementAt(n2).toString();
                vector2.addElement(string2.substring(string3.length()));
            }
        } else {
            vector2 = (Vector)vector.clone();
        }
        return vector2;
    }

    public OID getOidOf(int n2, int n3) {
        int n4 = n3;
        if (n4 > this.index.length) {
            --n4;
        } else if (n4 == this.index.length) {
            return null;
        }
        MIBObject mIBObject = this.columns.get(n4);
        OID oID = new OID(mIBObject.getPrintableOid());
        oID.append(new OID(this.getIndexOf(n2).getIndex().toString()));
        return oID;
    }

    public MIBObjectType getColumnObject(int n2) {
        int n3 = n2;
        if (n3 == this.index.length) {
            return null;
        }
        if (n3 > this.index.length) {
            --n3;
        }
        return (MIBObjectType)this.columns.get(n3);
    }

    public boolean isCellEditable(int n2, int n3) {
        int n4 = n3;
        if (n3 == this.index.length) {
            return true;
        }
        if (n3 > this.index.length) {
            --n4;
        }
        return SMI.isWritable(this.getColumnObject(n4).getAccess());
    }

    private int _$5446(MIBTableModelRowKey mIBTableModelRowKey) {
        return this.index2row.containsKey(mIBTableModelRowKey) ? this.index2row.headMap(mIBTableModelRowKey).size() : -1;
    }

    public int getRow(ObjectID objectID, GenTarget genTarget) {
        MIBTableModelRowKey mIBTableModelRowKey = new MIBTableModelRowKey(objectID, genTarget);
        return this._$5446(mIBTableModelRowKey);
    }

    public int getRow(OID oID, GenTarget genTarget) {
        ObjectID objectID = new ObjectID(oID.toString());
        try {
            objectID = (ObjectID)this.rep.getSplittedObjectID((ObjectID)objectID).second;
            return this.getRow(objectID, genTarget);
        }
        catch (ObjectIDFormatException objectIDFormatException) {
            objectIDFormatException.printStackTrace();
            return -1;
        }
    }

    public ObjectID getIndex(OID oID) {
        if (oID == null) {
            return null;
        }
        ObjectID objectID = new ObjectID(oID.toString());
        try {
            objectID = (ObjectID)this.rep.getSplittedObjectID((ObjectID)objectID).second;
            return objectID;
        }
        catch (ObjectIDFormatException objectIDFormatException) {
            objectIDFormatException.printStackTrace();
            return null;
        }
    }

    public MIBTableModelRowKey getIndexOf(int n2) {
        if (n2 >= 0 && n2 < this.indexes.size()) {
            return this.indexes.get(n2);
        }
        return null;
    }

    public int getIndexColumnCount() {
        return this.index.length + 1;
    }

    public void refreshStart() {
        this.obsoleteRows.clear();
        this.obsoleteRows.addAll(this.indexes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshEnd(GenTarget genTarget) {
        ArrayList<MIBTableModelRowKey> arrayList = new ArrayList<MIBTableModelRowKey>();
        try {
            for (MIBTableModelRowKey mIBTableModelRowKey : this.obsoleteRows) {
                if (genTarget != null && !genTarget.equals(mIBTableModelRowKey.getTarget())) continue;
                this._$29862(mIBTableModelRowKey.getTarget(), mIBTableModelRowKey.getIndex());
                arrayList.add(mIBTableModelRowKey);
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.obsoleteRows.removeAll(arrayList);
        }
    }

    public void addOrUpdateRow(GenTarget genTarget, ObjectID objectID, VariableBinding[] variableBindingArray) {
        MIBTableModelRowKey mIBTableModelRowKey = new MIBTableModelRowKey(objectID, genTarget);
        this.obsoleteRows.remove(mIBTableModelRowKey);
        int n2 = this.getRowIndex(mIBTableModelRowKey);
        if (n2 == Integer.MAX_VALUE) {
            n2 = this.addEmptyRow(objectID, genTarget);
        } else {
            this.obsoleteRows.remove(mIBTableModelRowKey);
        }
        int n3 = this._$5446(mIBTableModelRowKey);
        if (n3 < 0) {
            this.addEmptyRow(objectID, genTarget);
            n2 = this._$5446(mIBTableModelRowKey);
        } else {
            n2 = n3;
        }
        for (int i2 = 0; i2 < variableBindingArray.length; ++i2) {
            int n4 = i2 + this.getIndexColumnCount();
            if (variableBindingArray[i2] == null) {
                this.setTableDataItem(null, n2, n4);
                continue;
            }
            JCValueConverter jCValueConverter = this.getValueConverter(n4);
            Object object = jCValueConverter.toNative(variableBindingArray[i2].getVariable());
            this.setTableDataItem(object, n2, n4);
        }
    }

    private void _$29869(ObjectID objectID, VariableBinding[] variableBindingArray, GenTarget genTarget) {
        MIBTableModelRowKey mIBTableModelRowKey = new MIBTableModelRowKey(objectID, genTarget);
        this.obsoleteRows.remove(mIBTableModelRowKey);
        int n2 = this.getRowIndex(mIBTableModelRowKey);
        if (n2 == Integer.MAX_VALUE) {
            n2 = this.getNumDataRows();
        }
        this.setRow(variableBindingArray, true, genTarget);
    }

    public void refreshRow(VariableBinding[] variableBindingArray, GenTarget genTarget) {
        if (variableBindingArray.length <= 0) {
            return;
        }
        ObjectID objectID = new ObjectID(variableBindingArray[0].getOid().getValue());
        try {
            objectID = (ObjectID)this.rep.getSplittedObjectID((ObjectID)objectID).second;
            if (objectID != null) {
                OID oID = new OID(objectID.asIntArray());
                VariableBinding[] variableBindingArray2 = variableBindingArray;
                for (int i2 = 0; i2 < variableBindingArray2.length; ++i2) {
                    if (variableBindingArray2[i2].getOid().rightMostCompare(oID.size(), oID) == 0) continue;
                    VariableBinding[] variableBindingArray3 = new VariableBinding[i2];
                    if (variableBindingArray3.length > 0) {
                        System.arraycopy(variableBindingArray2, 0, variableBindingArray3, 0, i2);
                        this._$29869(objectID, variableBindingArray3, genTarget);
                    }
                    variableBindingArray3 = new VariableBinding[variableBindingArray2.length - i2];
                    objectID = new ObjectID(variableBindingArray2[i2].getOid().getValue());
                    System.arraycopy(variableBindingArray2, i2, variableBindingArray3, 0, variableBindingArray2.length - i2);
                    variableBindingArray2 = variableBindingArray3;
                    objectID = (ObjectID)this.rep.getSplittedObjectID((ObjectID)objectID).second;
                    if (objectID != null) {
                        oID = new OID(objectID.asIntArray());
                    }
                    i2 = 0;
                }
                if (variableBindingArray2.length > 0) {
                    this._$29869(objectID, variableBindingArray2, genTarget);
                }
            }
        }
        catch (ObjectIDFormatException objectIDFormatException) {
            System.err.println("MIBTableModel: Error setting row: " + objectIDFormatException.getMessage());
            objectIDFormatException.printStackTrace();
        }
    }

    public int getNumDataRows() {
        return this.indexes.size();
    }

    public int setRow(VariableBinding[] variableBindingArray, boolean bl, GenTarget genTarget) {
        if (variableBindingArray.length <= 0) {
            return -1;
        }
        return this.setSparseRow(variableBindingArray, bl, genTarget);
    }

    public int setSparseRow(VariableBinding[] variableBindingArray, boolean bl, GenTarget genTarget) {
        if (variableBindingArray.length <= 0) {
            return -1;
        }
        ObjectID objectID = new ObjectID(variableBindingArray[0].getOid().toString());
        try {
            objectID = (ObjectID)this.rep.getSplittedObjectID((ObjectID)objectID).second;
            int n2 = -1;
            if (objectID != null) {
                MIBTableModelRowKey mIBTableModelRowKey = new MIBTableModelRowKey(objectID, genTarget);
                n2 = this._$5446(mIBTableModelRowKey);
                if (n2 < 0) {
                    n2 = bl ? this.addEmptyRow(objectID, genTarget) : this.addNewRow(objectID, genTarget);
                }
                for (int i2 = 0; i2 < variableBindingArray.length; ++i2) {
                    int n3 = this.getColumn(variableBindingArray[i2].getOid(), i2);
                    if (n3 < 0) continue;
                    JCValueConverter jCValueConverter = this.getValueConverter(n3);
                    Object object = jCValueConverter.toNative(variableBindingArray[i2].getVariable());
                    this.setTableDataItem(object, n2, n3);
                }
            }
            return n2;
        }
        catch (ObjectIDFormatException objectIDFormatException) {
            System.err.println("MIBTableModel: Error setting row: " + objectIDFormatException.getMessage());
            objectIDFormatException.printStackTrace();
            return -1;
        }
    }

    protected int getRowIndex(MIBTableModelRowKey mIBTableModelRowKey) {
        try {
            if (this.index2row.lastKey().compareTo(mIBTableModelRowKey) < 0) {
                return Integer.MAX_VALUE;
            }
        }
        catch (Exception exception) {
            return Integer.MAX_VALUE;
        }
        int n2 = this.index2row.headMap(mIBTableModelRowKey).size();
        return n2;
    }

    protected int addRowAt(ObjectID objectID, GenTarget genTarget, Vector vector) {
        MIBTableModelRowKey mIBTableModelRowKey = new MIBTableModelRowKey(objectID, genTarget);
        int n2 = this.getRowIndex(mIBTableModelRowKey);
        if (n2 >= 0) {
            if (n2 == Integer.MAX_VALUE) {
                n2 = this.getNumDataRows() + (this.getNumRows() - this.getNumDataRows());
                if (!this.addRow(Integer.MAX_VALUE, objectID, vector)) {
                    return -1;
                }
                this.indexes.add(mIBTableModelRowKey);
            } else {
                if (!this.addRow(n2, objectID, vector)) {
                    return -1;
                }
                this.indexes.add(n2, mIBTableModelRowKey);
            }
            this.index2row.put(mIBTableModelRowKey, mIBTableModelRowKey);
        }
        return n2;
    }

    public int duplicateRow(ObjectID objectID, int n2) {
        int n3;
        ObjectID[] objectIDArray;
        Vector vector = this.createDefaultInstances();
        for (int i2 = this.index.length + 1; i2 - (this.index.length + 1) < vector.size() && i2 < this.valueConverter.size(); ++i2) {
            if (this.getTableDataItem(n2, i2) != null) {
                vector.set(i2 - (this.index.length + 1), this.getTableDataItem(n2, i2));
                continue;
            }
            objectIDArray = this.getValueConverter(i2);
            vector.setElementAt(objectIDArray.toNative((Variable)vector.get(i2 - (this.index.length + 1))), i2 - (this.index.length + 1));
        }
        GenTarget genTarget = this.getTarget(n2);
        vector.insertElementAt(genTarget, 0);
        objectIDArray = this.rep.getIndexObjectIDs(objectID, this.index);
        for (n3 = this.index.length - 1; n3 >= 0; --n3) {
            JCValueConverter jCValueConverter = this.getValueConverter(n3);
            Object object = jCValueConverter.toNative(IndexConverter.getIndexVariable(this.index[n3], objectIDArray[n3]));
            vector.insertElementAt(object, 0);
        }
        n3 = this.addRowAt(objectID, genTarget, vector);
        return n3;
    }

    public int addNewRow(ObjectID objectID, GenTarget genTarget) {
        int n2;
        Vector vector = this.createDefaultInstances();
        for (int i2 = this.index.length + 1; i2 - this.index.length < vector.size() && i2 < this.valueConverter.size(); ++i2) {
            JCValueConverter jCValueConverter = this.getValueConverter(i2);
            vector.setElementAt(jCValueConverter.toNative((Variable)vector.get(i2 - (this.index.length + 1))), i2 - (this.index.length + 1));
        }
        vector.insertElementAt(genTarget, 0);
        ObjectID[] objectIDArray = this.rep.getIndexObjectIDs(objectID, this.index);
        for (n2 = this.index.length - 1; n2 >= 0; --n2) {
            JCValueConverter jCValueConverter = this.getValueConverter(n2);
            Object object = jCValueConverter.toNative(IndexConverter.getIndexVariable(this.index[n2], objectIDArray[n2]));
            vector.insertElementAt(object, 0);
        }
        n2 = this.addRowAt(objectID, genTarget, vector);
        return n2;
    }

    public String getIndexString(ObjectID objectID) {
        if (objectID == null) {
            return "<null>";
        }
        ObjectID[] objectIDArray = this.rep.getIndexObjectIDs(objectID, this.index);
        ValueConverter[] valueConverterArray = new ValueConverter[this.index.length];
        for (int i2 = 0; i2 < this.index.length; ++i2) {
            valueConverterArray[i2] = this.getValueConverter(i2);
        }
        return IndexConverter.getIndexString(valueConverterArray, this.index, objectIDArray);
    }

    public Vector getIndexObjects(ObjectID objectID) {
        IndexStruct[] indexStructArray;
        ObjectID[] objectIDArray = null;
        IndexStruct[] indexStructArray2 = this.index;
        int n2 = 0;
        while (n2 < this.index.length && objectIDArray == null) {
            objectIDArray = this.rep.getIndexObjectIDs(objectID, indexStructArray2);
            if (objectIDArray != null) continue;
            indexStructArray = new IndexStruct[indexStructArray2.length - ++n2];
            System.arraycopy(indexStructArray2, 0, indexStructArray, 0, indexStructArray.length);
            indexStructArray2 = indexStructArray;
        }
        indexStructArray = new Vector(this.index.length + 1);
        for (int i2 = 0; i2 < this.index.length; ++i2) {
            JCValueConverter jCValueConverter = this.getValueConverter(i2);
            if (i2 < indexStructArray2.length && objectIDArray != null && i2 < objectIDArray.length) {
                Object object = jCValueConverter.toNative(IndexConverter.getIndexVariable(this.index[i2], objectIDArray[i2]));
                indexStructArray.addElement(object);
                continue;
            }
            indexStructArray.add(null);
        }
        return indexStructArray;
    }

    public int addEmptyRow(ObjectID objectID, GenTarget genTarget) {
        Vector vector = this.getIndexObjects(objectID);
        vector.add(genTarget);
        return this.addRowAt(objectID, genTarget, vector);
    }

    public boolean removeRow(OID oID, GenTarget genTarget) {
        try {
            ObjectID objectID = this.getIndex(oID);
            return this._$29862(genTarget, objectID);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean _$29862(GenTarget genTarget, ObjectID objectID) {
        MIBTableModelRowKey mIBTableModelRowKey = new MIBTableModelRowKey(objectID, genTarget);
        int n2 = this.getRowIndex(mIBTableModelRowKey);
        this.index2row.remove(mIBTableModelRowKey);
        this.indexes.remove(n2);
        return super.deleteRows(n2, 1);
    }

    public boolean removeRow(int n2, GenTarget genTarget) {
        try {
            MIBTableModelRowKey mIBTableModelRowKey = this.indexes.get(n2);
            if (genTarget.equals(mIBTableModelRowKey.getTarget())) {
                if (this.changeListener != null) {
                    ArrayList<Object> arrayList = new ArrayList<Object>(this.getIndexColumnCount() - this.getIndexColumnCount());
                    for (int i2 = this.getIndexColumnCount(); i2 < this.getIndexColumnCount(); ++i2) {
                        arrayList.add(super.getTableDataItem(n2, i2));
                    }
                    return true;
                }
                this.index2row.remove(mIBTableModelRowKey);
                this.indexes.remove(n2);
                return this.deleteRows(n2, 1);
            }
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public Variable getInitialValue(MIBSyntax mIBSyntax) {
        if (mIBSyntax.getType() == 3 && (mIBSyntax = this.rep.resolveTC(mIBSyntax.getSyntax())) == null) {
            return null;
        }
        if (mIBSyntax.hasEnums()) {
            return new Integer32((int)mIBSyntax.getEnumsVector().firstElement().getLongValue());
        }
        if (mIBSyntax.getSyntax().equals("INTEGER") || mIBSyntax.getSyntax().equals("Integer32")) {
            return new Integer32();
        }
        if (mIBSyntax.getSyntax().equals("Counter") || mIBSyntax.getSyntax().equals("Counter32")) {
            return new Counter32();
        }
        if (mIBSyntax.getSyntax().equals("UInteger32") || mIBSyntax.getSyntax().equals("Unsigned32") || mIBSyntax.getSyntax().equals("Gauge") || mIBSyntax.getSyntax().equals("Gauge32")) {
            return new Gauge32();
        }
        if (mIBSyntax.getSyntax().equals("Counter64")) {
            return new Counter64();
        }
        if (mIBSyntax.getSyntax().equals("TimeTicks")) {
            return new TimeTicks();
        }
        if (mIBSyntax.getSyntax().equals("IpAddress") || mIBSyntax.getSyntax().equals("NetworkAddress")) {
            return new IpAddress("0.0.0.0");
        }
        if (mIBSyntax.getSyntax().equals("Opaque")) {
            return new Opaque();
        }
        if (mIBSyntax.getSyntax().startsWith("OCTET STRING")) {
            return new OctetString();
        }
        if (mIBSyntax.getSyntax().equals("OBJECT-IDENTITY") || mIBSyntax.getSyntax().equals("OBJECT IDENTIFIER")) {
            return new OID();
        }
        return null;
    }

    public static OctetString parseOctetStringConstant(String string) throws NumberFormatException {
        int n2 = 10;
        int n3 = 3;
        if (string.startsWith("\"")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\"");
            if (!stringTokenizer.hasMoreTokens()) {
                return new OctetString();
            }
            return new OctetString(stringTokenizer.nextToken());
        }
        if (string.startsWith("'")) {
            StringTokenizer stringTokenizer;
            if (string.endsWith("h") || string.endsWith("H")) {
                n2 = 16;
                n3 = 2;
            }
            if (string.endsWith("o") || string.endsWith("O")) {
                n2 = 8;
                n3 = 4;
            }
            if (string.endsWith("b") || string.endsWith("B")) {
                n2 = 2;
                n3 = 8;
            }
            if (!(stringTokenizer = new StringTokenizer(string, "'")).hasMoreTokens()) {
                throw new NumberFormatException("String must be enclosed in '.");
            }
            String string2 = stringTokenizer.nextToken();
            if (string2.length() == 0) {
                return new OctetString();
            }
            try {
                byte[] byArray = new byte[string2.length() / n3];
                int n4 = 0;
                int n5 = 0;
                while (n4 < string2.length()) {
                    char c2 = (char)Integer.parseInt(string2.substring(n4, n4 + n3), n2);
                    byArray[n5] = (byte)c2;
                    n4 += n3;
                    ++n5;
                }
                return new OctetString(byArray);
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                return new OctetString();
            }
        }
        return new OctetString();
    }

    public Vector createDefaultInstances() {
        Vector<Variable> vector = new Vector<Variable>(this.getNumColumns());
        for (int i2 = this.index.length + 1; i2 < this.getNumColumns(); ++i2) {
            MIBObjectType mIBObjectType = this.getColumnObject(i2);
            JCValueConverter jCValueConverter = this.getValueConverter(i2);
            Variable variable = ValueConverter.getDefaultValue(this.rep, mIBObjectType, jCValueConverter.getEffectiveSyntax());
            if (variable != null) {
                vector.addElement(variable);
                continue;
            }
            vector.addElement(this.getInitialValue(jCValueConverter.getEffectiveSyntax()));
        }
        return vector;
    }

    protected void setIndexObjects(int n2, ObjectID objectID) {
        ObjectID[] objectIDArray = null;
        objectIDArray = this.rep.getIndexObjectIDs(objectID, this.index);
        for (int i2 = 0; i2 < this.index.length; ++i2) {
            if (objectIDArray == null) continue;
            JCValueConverter jCValueConverter = this.getValueConverter(i2);
            Variable variable = IndexConverter.getIndexVariable(this.index[i2], objectIDArray[i2]);
            if (variable == null) continue;
            this.setTableDataItem(jCValueConverter.toNative(variable), n2, i2);
        }
    }

    public IndexStruct[] getIndexStruct() {
        return this.index;
    }

    public JCValueConverter getValueConverter(int n2) {
        int n3 = 0;
        if (n2 == this.index.length) {
            return null;
        }
        if (n2 > this.index.length) {
            n3 = -1;
        }
        return this.valueConverter.get(n2 + n3);
    }

    public List<JCValueConverter> getValueConverters() {
        return this.valueConverter;
    }

    public int addExpressionRow(int n2, Vector vector) {
        return n2;
    }

    @Override
    public boolean setTableDataItem(Object object, int n2, int n3) {
        Object object2 = super.getTableDataItem(n2, n3);
        try {
            if (object2 == null && object == null || object2 != null && object2.equals(object)) {
                if (this.changeListener != null) {
                    this.changeListener.cellUpdatedWithoutChange(n2, n3);
                }
                return true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (SwingUtilities.isEventDispatchThread()) {
            boolean bl = super.setTableDataItem(object, n2, n3);
            if (this.changeListener != null && bl && object2 != null) {
                this.changeListener.cellChanged(n2, n3);
            }
            return bl;
        }
        RowUpdate rowUpdate = new RowUpdate(1, n2, n3, object);
        try {
            SwingUtilities.invokeAndWait(rowUpdate);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return rowUpdate.isSuccess();
    }

    @Override
    public boolean deleteRows(int n2, int n3) {
        if (SwingUtilities.isEventDispatchThread()) {
            return super.deleteRows(n2, n3);
        }
        RowUpdate rowUpdate = new RowUpdate(4, n2, n3);
        try {
            SwingUtilities.invokeAndWait(rowUpdate);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return rowUpdate.isSuccess();
    }

    @Override
    public boolean addRow(int n2, Object object, Vector vector) {
        if (SwingUtilities.isEventDispatchThread()) {
            boolean bl = super.addRow(n2, object, vector);
            if (this.changeListener != null && bl) {
                this.changeListener.rowAdded(n2);
            }
            return bl;
        }
        RowUpdate rowUpdate = new RowUpdate(3, n2, object, vector);
        try {
            SwingUtilities.invokeAndWait(rowUpdate);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return rowUpdate.isSuccess();
    }

    public void clear() {
        super.deleteRows(0, this.getNumDataRows());
        this.indexes.clear();
        this.index2row.clear();
    }

    public GenTarget getTarget(int n2) {
        return (GenTarget)super.getTableDataItem(n2, this.index.length);
    }

    public void setTarget(int n2, GenTarget genTarget) {
        super.setTableDataItem(genTarget, n2, this.index.length);
        this._$35868(n2);
    }

    private void _$35868(int n2) {
    }

    public void setChangeListener(MIBTableModelChangeListener mIBTableModelChangeListener) {
        this.changeListener = mIBTableModelChangeListener;
    }

    public MIBTableModelChangeListener getChangeListener() {
        return this.changeListener;
    }

    class RowUpdate
    implements Runnable {
        private boolean _$28255 = false;
        private int _$35869;
        private Object _$5462;
        private Vector _$84;
        private int _$355;
        private int _$20790 = 0;

        public RowUpdate(int n2, int n3, Object object, Vector vector) {
            this._$35869 = n2;
            this._$355 = n3;
            this._$84 = vector;
            this._$5462 = object;
        }

        public RowUpdate(int n2, int n3, int n4) {
            this._$35869 = n2;
            this._$355 = n3;
            this._$20790 = n4;
        }

        public RowUpdate(int n2, int n3, int n4, Object object) {
            this._$35869 = n2;
            this._$355 = n3;
            this._$20790 = n4;
            this._$5462 = object;
        }

        public void run() {
            switch (this._$35869) {
                case 3: {
                    this._$28255 = MIBTableModel.this.addRow(this._$355, this._$5462, this._$84);
                    break;
                }
                case 4: {
                    this._$28255 = MIBTableModel.this.deleteRows(this._$355, this._$20790);
                    break;
                }
                case 1: {
                    this._$28255 = MIBTableModel.this.setTableDataItem(this._$5462, this._$355, this._$20790);
                    break;
                }
            }
        }

        public boolean isSuccess() {
            return this._$28255;
        }

        public int getRowIndex() {
            return this._$355;
        }
    }
}

