/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.explorer;

import com.agentpp.common.ComponentLinkListener;
import com.agentpp.common.PropertiesEditor;
import com.agentpp.common.velocity.Log4JProxy;
import com.agentpp.explorer.MIBExplorerFrame;
import com.agentpp.explorer.MIBExplorerRemoteServerAuthImpl;
import com.agentpp.explorer.MIBSetPanel;
import com.agentpp.explorer.MonitorManager;
import com.agentpp.explorer.TabbedControlledPanel;
import com.agentpp.explorer.TargetConfiguration;
import com.agentpp.explorer.cfg.JdbcDriverRegistration;
import com.agentpp.explorer.cfg.Preferences;
import com.agentpp.explorer.cfg.SNMPv3Settings;
import com.agentpp.explorer.http.ExplorerHttpServer;
import com.agentpp.explorer.log.SnmpLogger;
import com.agentpp.explorer.monitor.Monitor;
import com.agentpp.explorer.monitor.MonitorConfigPanel;
import com.agentpp.explorer.monitor.MonitorEvent;
import com.agentpp.explorer.monitor.MonitorListener;
import com.agentpp.explorer.monitor.MonitorPanel;
import com.agentpp.explorer.monitor.MonitorProperty;
import com.agentpp.explorer.monitor.MonitorServerImpl;
import com.agentpp.explorer.monitor.ServerMonitor;
import com.agentpp.explorer.monitor.db.Monitor2DB;
import com.agentpp.explorer.script.MIBContext;
import com.agentpp.explorer.script.Script;
import com.agentpp.explorer.script.ScriptContext;
import com.agentpp.explorer.traps.TrapProxy;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBRepository;
import com.agentpp.repository.DefaultRepositoryManager;
import com.agentpp.repository.RepositoryManager;
import com.agentpp.slimdao.jdbc.DriverLoader;
import com.agentpp.snmp.GenTarget;
import com.agentpp.snmp.UserProfile;
import com.agentpp.util.UserConfigFile;
import com.agentpp.util.license.Validate;
import com.klg.jclass.table.data.JCEditableVectorDataSource;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.rmi.Naming;
import java.rmi.Remote;
import java.rmi.registry.LocateRegistry;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.Vector;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.snmp4j.MessageDispatcher;
import org.snmp4j.MessageDispatcherImpl;
import org.snmp4j.Snmp;
import org.snmp4j.log.Log4jLogFactory;
import org.snmp4j.log.LogFactory;
import org.snmp4j.mp.MPv1;
import org.snmp4j.mp.MPv2c;
import org.snmp4j.mp.MPv3;
import org.snmp4j.security.SecurityModels;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.security.USM;
import org.snmp4j.security.UsmUser;
import org.snmp4j.smi.OctetString;

public class MIBExplorerServer
implements MonitorManager {
    private UserConfigFile _$5250 = new UserConfigFile(true);
    private Snmp _$14889;
    private Vector _$47712 = new Vector();
    private String _$47762;
    private String _$47763;
    private Vector _$47764 = new Vector();
    private Vector _$33841 = new Vector();
    private DefaultRepositoryManager _$31188 = new DefaultRepositoryManager();
    private MIBRepository _$20550 = new MIBRepository(true);
    private Hashtable _$7365;
    private GenTarget _$15220;
    private TrapProxy _$31253;
    private boolean _$47765 = true;
    private MonitorPanel _$31278;
    private Logger _$5475;
    private Vector _$47766 = new Vector();
    private int _$10346 = 800;
    private int _$10347 = 600;
    private int _$47767 = 4976;
    private static final byte _$31194 = 48;
    private static byte _$31225;
    private static GregorianCalendar _$31226;
    private Vector _$14762 = new Vector();
    private ExplorerHttpServer _$31256;
    private LinkedList _$47768 = new LinkedList();
    private boolean _$47769 = false;
    private DriverLoader _$14341 = new DriverLoader();

    public MIBExplorerServer(String[] stringArray) {
        String string;
        Object object;
        Object object2;
        Object object3;
        Log4JProxy.logger = Logger.getLogger("Velocity");
        System.out.println();
        System.out.println("MIB Explorer Server v4.1.9 - SNMPv1/v2c/v3 Monitor.");
        System.out.println("Copyright \u00a9 2001-2014, Frank Fock. All rights reserved.");
        System.out.println();
        Logger.getRootLogger().setLevel(Level.DEBUG);
        this._$5475 = Logger.getLogger("MIBExplorer.Server");
        if (System.getProperty("java.version").compareTo("1.6") < 0) {
            System.err.println("MIB Explorer Server needs Java Runtime Environment 1.6 or later installed!");
            System.err.println("Current version is: " + System.getProperty("java.version"));
            System.exit(1);
        }
        String string2 = "mxp4.cf";
        String string3 = null;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (!stringArray[i2].equals("-configFile")) continue;
            if (stringArray.length < i2 + 1) {
                System.out.println("There is no config file name given for the -config option, aborting.");
                System.exit(1);
                continue;
            }
            string3 = stringArray[i2 + 1];
        }
        if (string3 != null) {
            this._$5250.setConfigFile(string3);
        } else {
            this._$5250.setConfigName(string2);
        }
        this._$5250.read(true);
        System.out.println();
        this._$10346 = this._$5250.getInteger("mibexplorer.monitor.image.sizeX", 640);
        this._$10347 = this._$5250.getInteger("mibexplorer.monitor.image.sizeY", 480);
        byte[] byArray = Validate.fromHexString(this._$5250.get("mibexplorer.License", null));
        byte[] byArray2 = this._$5250.get("mibexplorer.LicenseKey", "").getBytes();
        if (byArray == null || byArray2 == null) {
            try {
                System.err.println("Invalid license, aborting!");
                Thread.sleep(3000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            System.exit(1);
        }
        int n2 = 0;
        n2 = this._$31356(byArray, byArray2);
        if (n2 == 0) {
            try {
                System.err.println("Invalid license, aborting!");
                Thread.sleep(3000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            System.exit(1);
        }
        try {
            object3 = new MessageDispatcherImpl();
            this._$14889 = new Snmp((MessageDispatcher)object3);
            ((MessageDispatcherImpl)object3).addMessageProcessingModel(new MPv1());
            ((MessageDispatcherImpl)object3).addMessageProcessingModel(new MPv2c());
            ((MessageDispatcherImpl)object3).addMessageProcessingModel(new MPv3(SNMPv3Settings.getEngineID(this._$5250).getValue()));
            object2 = new Preferences(this._$5250, this._$14889, this._$31253, this._$20550, this._$31188, true, this._$14341);
            SecurityProtocols.getInstance().addDefaultProtocols();
            SecurityModels.getInstance().addSecurityModel(new USM(SecurityProtocols.getInstance(), SNMPv3Settings.getEngineID(this._$5250), SNMPv3Settings.getEngineBoots(this._$5250)));
            JdbcDriverRegistration.loadDrivers(this._$5250, this._$14341);
            ((Preferences)object2).initTransportMappings(null);
            this._$14889.listen();
        }
        catch (IOException iOException) {
            this._$5475.fatal("Cannot bind any UDP port, aborting... (Reason: " + iOException.getMessage() + ")");
            System.exit(2);
        }
        object3 = new TargetConfiguration(this._$5250, this._$14889);
        ((TargetConfiguration)object3).load();
        this._$31388(((TargetConfiguration)object3).getUsers());
        object2 = this._$5250.get("mibexplorer.server.secret", "");
        if (((String)object2).contains("#")) {
            object2 = OctetString.fromHexString(TargetConfiguration.decryptPassphraseToHexString(((TargetConfiguration)object3).getPropertyEncrypter(), this._$5250, (String)object2)).toString();
        }
        this._$14762.add(object2);
        Hashtable hashtable = PropertiesEditor.filterProperties(this._$5250.properties);
        PropertyConfigurator.configure(this._$5250.properties);
        this._$5250.properties.putAll((Map<?, ?>)hashtable);
        if (System.getProperty("log4j.configuration") == null) {
            BasicConfigurator.configure();
        }
        try {
            this._$31188.open(new File(this._$5250.get("mibexplorer.RepositoryPath", "mibrepository")));
        }
        catch (IOException iOException) {
            object = new String[]{"The current repository path '" + this._$5250.get("mibexplorer.RepositoryPath", "mibrepository") + "'", "is not valid. Please choose a new one with the MIB Explorer GUI."};
            this._$5475.fatal(object);
            System.exit(2);
        }
        Vector vector = MIBExplorerFrame.getConfiguredModules(this._$5250);
        this.loadMIBs(vector);
        if (!this._$47769) {
            try {
                for (int i3 = 0; i3 < stringArray.length; ++i3) {
                    if (!stringArray[i3].equalsIgnoreCase("-securitymanager")) continue;
                    System.setSecurityManager(new SecurityManager());
                    break;
                }
                this._$47767 = Integer.parseInt(System.getProperty("mibexplorer.server.port", "4976"));
                LocateRegistry.createRegistry(this._$47767);
                this._$5475.info("RMI registry created at port " + this._$47767);
            }
            catch (Exception exception) {
                this._$5475.warn(exception);
            }
        }
        object = this._$5250.get("mibexplorer.ActiveTarget", null);
        this._$15220 = ((TargetConfiguration)object3).loadTarget(this._$5250, (String)object);
        this._$7365 = ((TargetConfiguration)object3).loadAllTargets(this._$5250);
        this._$31253 = new TrapProxy(this._$5250, this._$15220, new Hashtable(5), this._$31188, this._$14889);
        this._$31253.loadConfig();
        this._$31278 = new MonitorPanel(this._$5250, null, this._$14889, this._$20550, (RepositoryManager)this._$31188, this._$7365);
        this._$31278.setTrapProxy(this._$31253);
        this._$47774(stringArray);
        Runtime.getRuntime().addShutdownHook(new ShutdownThread());
        this._$31256 = new ExplorerHttpServer(this._$5250, this._$14889, this._$7365, this._$15220, new SnmpLogger(this._$20550), this._$20550, (RepositoryManager)this._$31188);
        try {
            this._$31256.run();
            if (this._$31256.isStarted()) {
                this._$31278.addMonitorListener((MonitorListener)this._$31256);
                this._$5475.info("HTTP server started on " + this._$31256.getPort());
            } else {
                this._$5475.warn("HTTP server NOT started on port " + this._$31256.getPort());
            }
        }
        catch (Exception exception) {
            this._$5475.error("HTTP server not started: " + exception.getMessage());
        }
        for (Object object4 : this._$33841) {
            Thread thread = new Thread((Runnable)object4);
            this._$5475.info("Running script " + ((ScriptRunnable)((Object)object4))._$46);
            thread.start();
        }
        this._$31278.setTarget(this._$15220);
        this._$31278.setMonitorManager((MonitorManager)this);
        if (this._$47762 == null) {
            this._$47712.addAll((List)this._$31278.initDone(true));
        } else {
            Object object4;
            Iterator iterator = this._$5250.getArray("mibexplorer.monitor.restart.monitors");
            object4 = new LinkedList();
            if (iterator != null && ((Vector)((Object)iterator)).size() > 0) {
                for (int i4 = 0; i4 < ((Vector)((Object)iterator)).size(); ++i4) {
                    string = (String)((Vector)((Object)iterator)).get(i4);
                    File file = new File(string);
                    String string4 = file.getName();
                    string4 = this._$31278.cutExtension(this._$31278.getTypeExtensions(), string4);
                    try {
                        MonitorConfigPanel monitorConfigPanel = this.createMonitor(file, string4);
                        monitorConfigPanel.addComponentLinkListener((ComponentLinkListener)this._$31278);
                        this._$31278.loadData((TabbedControlledPanel)monitorConfigPanel, file);
                        if (monitorConfigPanel.getDBMonitor() == null && !this._$47780(monitorConfigPanel, new File(file.getParent(), string4 + ".dbm"), this._$47763)) {
                            this._$5475.info("Monitor migration to DB failed: " + monitorConfigPanel.getTitle());
                            monitorConfigPanel.stopTimer();
                            ((Vector)((Object)iterator)).remove(monitorConfigPanel);
                            monitorConfigPanel.removeComponentLinkListener((ComponentLinkListener)this._$31278);
                            continue;
                        }
                        monitorConfigPanel.getMonitorProperties().getExportConfig().setAutoSave(true);
                        monitorConfigPanel.setExportEnabled(true);
                        monitorConfigPanel.run();
                        ((LinkedList)object4).add(monitorConfigPanel);
                        continue;
                    }
                    catch (IOException iOException) {
                        this._$5475.warn("Could not start monitor '" + string + "': " + iOException.getMessage());
                        continue;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        this._$5475.error("Monitor file '" + string + "' has unrecognizable format");
                    }
                }
            }
        }
        for (Object object4 : this._$47766) {
            MonitorConfigPanel monitorConfigPanel = this._$47779(this._$15220, new File((String)object4));
            if (monitorConfigPanel == null) continue;
            monitorConfigPanel.addComponentLinkListener((ComponentLinkListener)this._$31278);
            this._$47712.add(monitorConfigPanel);
            if (this._$47762 != null) {
                string = new File((String)object4).getName();
                if (string.toLowerCase().endsWith(".mon") || string.toLowerCase().endsWith(".xml")) {
                    string = string.substring(0, string.length() - 4);
                }
                if (!this._$47780(monitorConfigPanel, new File(this.getMonitorPath(), string + ".dbm"), this._$47763)) {
                    this._$5475.info("Monitor migration to DB failed: " + monitorConfigPanel.getTitle());
                    monitorConfigPanel.stopTimer();
                    this._$47712.remove(monitorConfigPanel);
                    monitorConfigPanel.removeComponentLinkListener((ComponentLinkListener)this._$31278);
                    continue;
                }
            }
            this._$31256.monitorChanged(new MonitorEvent((Object)this, 1, (Monitor)monitorConfigPanel));
            this._$5475.info("Started monitor: " + monitorConfigPanel.getTitle());
        }
        if (this._$47768 == null) {
            for (Object object4 : this._$47712) {
                this._$5475.info("Truncating data of monitor " + object4.getTitle());
                object4.resetValues();
            }
        } else {
            for (Object object4 : this._$47712) {
                if (!this._$47768.contains(object4.getTitle())) continue;
                this._$47768.remove(object4.getTitle());
                this._$5475.info("Truncating data of monitor " + object4.getTitle());
                object4.resetValues();
            }
        }
        try {
            Naming.rebind("//:" + this._$47767 + "/MIBExplorerServer", new MIBExplorerRemoteServerAuthImpl(this._$47764, this._$47712, this, this._$14762));
            this._$5475.info("Bound RMI server //:" + this._$47767 + "/MIBExplorerServer");
        }
        catch (Exception exception) {
            this._$5475.warn(exception);
        }
        while (true) {
            try {
                while (true) {
                    Thread.sleep(10000000L);
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    private boolean _$47780(MonitorConfigPanel monitorConfigPanel, File file, String string) {
        Vector vector = (Vector)monitorConfigPanel.getData();
        MonitorProperty monitorProperty = (MonitorProperty)vector.get(1);
        Monitor2DB monitor2DB = monitorConfigPanel.getDBMonitor();
        try {
            String string2;
            Long l2;
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            if (monitor2DB == null) {
                monitor2DB = new Monitor2DB(string, this._$5250.get("mibexplorer.db.schema", "MXP"), this._$5250.get("mibexplorer.db.config.xml", ""));
                monitor2DB.connect(this._$47762, string, new Properties());
                int n2 = monitor2DB.getSchemaVersion();
                if (n2 < 0) {
                    monitor2DB.createSchema();
                } else if (n2 < monitor2DB.getRequiredSchemaVersion()) {
                    // empty if block
                }
                monitorConfigPanel.setDBMonitor(monitor2DB);
            }
            if ((l2 = monitor2DB.getMonitorID(string2 = file.getName())) != null) {
                monitor2DB.saveMonitorToDB(string2, l2, monitorProperty, (JCEditableVectorDataSource)vector.get(0), fileOutputStream);
            } else {
                monitor2DB.saveMonitorToDB(string2, null, monitorProperty, (JCEditableVectorDataSource)vector.get(0), fileOutputStream);
            }
            fileOutputStream.flush();
            fileOutputStream.close();
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            this._$5475.error("JDBC Driver '" + string + "' not found!", classNotFoundException);
        }
        catch (SQLException sQLException) {
            this._$5475.error("SQL exception: " + sQLException.getMessage(), sQLException);
        }
        catch (IOException iOException) {
            this._$5475.error("IO exception while migrating monitor '" + file + "' to DB: " + iOException.getMessage(), iOException);
        }
        return false;
    }

    public void loadMIBs(Vector vector) {
        if (vector.size() == 0) {
            this._$5475.warn("No MIB modules loaded");
            return;
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement().toString();
            try {
                int n2;
                MIBObject[] mIBObjectArray = this._$31188.getObjects(string);
                MIBObject[] mIBObjectArray2 = this._$31188.getImportedObjects(string);
                for (n2 = 0; n2 < mIBObjectArray.length; ++n2) {
                    this._$20550.addObject(mIBObjectArray[n2]);
                }
                for (n2 = 0; n2 < mIBObjectArray2.length; ++n2) {
                    this._$20550.addObject(mIBObjectArray2[n2]);
                }
            }
            catch (IOException iOException) {
                this._$5475.fatal("Error while accessing MIB repository: " + iOException.getMessage());
                System.exit(1);
            }
        }
        if (vector.size() > 1) {
            this._$5475.info("Loaded " + vector.size() + " MIB modules");
        } else {
            this._$5475.info("Loaded " + vector.size() + " MIB module");
        }
        this._$20550.structureChanged();
    }

    private void _$24833() {
        System.out.println();
        System.out.println("MIB Explorer Headless Server can be run using Java 6 or later.");
        System.out.println();
        System.out.println("Usage:");
        System.out.println("java -Djava.awt.headless=true [-Djava.rmi.server.hostname=<host>] \\");
        System.out.println("  mxp-pro.jar [options]");
        System.out.println("where [options] is any combination of the following parameters:");
        System.out.println();
        System.out.println(" -?                          prints this usage information");
        System.out.println(" -a[ccept] secrect           accept client connections from MIB Explorers");
        System.out.println("                             using the specified server 'secret' (which");
        System.out.println("                             is by default the client's license)");
        System.out.println(" -acceptall                  accept any MIB Explorer clients");
        System.out.println(" -d[isableMonitorScripting]  disables scripting for monitor alarms");
        System.out.println(" -m2db <jdbc-url> <driver>   migrates .mon and .xml monitor files given by");
        System.out.println("                             the -m option to the database identified by");
        System.out.println("                             jdbc:<driver>://<server>:<port>/<database>");
        System.out.println("                             :user=<username>;password={<password>};");
        System.out.println("                             If the DB has not yet an appropriate MIB Explorer");
        System.out.println("                             schema, it will be created. <driver> is the used");
        System.out.println("                             driver class name (e.g. 'com.ibm.db2.jcc.DB2Driver')");
        System.out.println(" -h[eight]                   sets the height of monitor charts in pixels");
        System.out.println(" -http-servlets off|all|monitorcharts|monitordata|script}");
        System.out.println("                             enables none, all, or the specified subset");
        System.out.println("                             of HTTP servlets. Setting httpservlets to 'off'");
        System.out.println("                             disables the HTTP server.");
        System.out.println(" -http-port port             specifies the HTTP server port.");
        System.out.println(" -w[idth]                    sets the width of monitor charts in pixels");
        System.out.println(" -monitor-truncate [ALL|<monitor-name>]");
        System.out.println("                             clears all monitor data of either all monitors");
        System.out.println("                             or only the specified monitor on server start.");
        System.out.println(" -m[onitor] filename ..      runs the specified monitor configuration files");
        System.out.println(" -mibs[et] name              loads the specified MIB set in addition to already");
        System.out.println("                             loaded modules (i.e. those module that were loaded");
        System.out.println("                             when the MIB Explorer GUI has been exited last)");
        System.out.println(" -p[ath]                     path to load and store monitor files");
        System.out.println(" -s[cript] script output     runs the script file 'script' and writes the");
        System.out.println("                             output to the file denoted by 'output'");
        System.out.println(" -l[oglevel] category=level  overrides the configured log level for 'category'");
        System.out.println("                             with 'level'. Use for example 'Script=OFF' to");
        System.out.println("                             switch off logging for scripting");
        System.out.println(" -rmihost                    specifies the DNS hostname (including domain)");
        System.out.println("                             of the host running the server. This option sets");
        System.out.println("                             the 'java.rmi.server.hostname' system property.");
        System.out.println(" -rmiport                    specifies the port to bind the RMI server.");
        System.out.println("                             Default is 4976.");
        System.out.println(" -rmioff                     disables the RMI server.");
        System.out.println(" -securitymanager            runs the server with a security manager");
        System.out.println("                             This options requires specifying a policy file");
        System.out.println("                             with-Djava.security.policy=server.security at the");
        System.out.println("                             command line");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void _$47774(String[] stringArray) {
        int n2 = 0;
        try {
            block8: while (n2 < stringArray.length) {
                Object object;
                if (stringArray[n2].equals("-?") || stringArray[n2].equals("-help")) {
                    this._$24833();
                    System.exit(0);
                }
                if (stringArray[n2].equals("-m") || stringArray[n2].equals("-monitor")) {
                    ++n2;
                    while (true) {
                        if (n2 >= stringArray.length || stringArray[n2].startsWith("-")) continue block8;
                        this._$47766.add(stringArray[n2++]);
                    }
                }
                if (stringArray[n2].equals("-m2db")) {
                    if (++n2 >= stringArray.length) {
                        this._$5475.warn("JDBC URL for monitor to DB migration must be specified");
                        return;
                    }
                    this._$47762 = stringArray[n2++];
                    if (n2 >= stringArray.length) {
                        this._$5475.warn("JDBC driver class name must be specified with option -m2db");
                        this._$47762 = null;
                        return;
                    }
                    this._$47763 = stringArray[n2++];
                    continue;
                }
                if (stringArray[n2].equals("-securitymanager")) {
                    this._$5475.info("Running MIB Explorer Server with security manager");
                    ++n2;
                    continue;
                }
                if (stringArray[n2].equals("-acceptall")) {
                    this._$5475.warn("MIB Explorer will accept any client connection (provided that security policy allowes it)");
                    ++n2;
                    this._$14762.removeAllElements();
                    continue;
                }
                if (stringArray[n2].equals("-a") || stringArray[n2].equals("-accept")) {
                    int n3 = ++n2;
                    ++n2;
                    this._$14762.add(stringArray[n3]);
                    continue;
                }
                if (stringArray[n2].equals("-d") || stringArray[n2].equals("-disableMonitorScripting")) {
                    ++n2;
                    this._$47765 = false;
                    continue;
                }
                if (stringArray[n2].equals("-p") || stringArray[n2].equals("-path")) {
                    int n4 = ++n2;
                    ++n2;
                    String string = stringArray[n4];
                    File file = new File(string);
                    if (!file.exists() || !file.isDirectory()) {
                        this._$5475.warn("Invalid monitor path '" + string + "' given, option will be ignored!");
                    }
                    this._$5250.put("mibexplorer.PDUPath", string);
                    continue;
                }
                if (stringArray[n2].equals("-mibs") || stringArray[n2].equals("-mibset")) {
                    TreeMap treeMap = MIBSetPanel.loadMIBSets(this._$5250);
                    Vector vector = (Vector)treeMap.get(stringArray[++n2]);
                    if (vector == null) {
                        throw new IllegalArgumentException("MIB set " + stringArray[n2] + " not found!");
                    }
                    this.loadMIBs(vector);
                    ++n2;
                    continue;
                }
                if (stringArray[n2].equals("-monitor-truncate")) {
                    int n5 = ++n2;
                    ++n2;
                    String string = stringArray[n5];
                    if (string.equals("ALL")) {
                        this._$47768 = null;
                        continue;
                    }
                    if (this._$47768 == null) continue;
                    this._$47768.add(string);
                    continue;
                }
                if (stringArray[n2].equals("-h") || stringArray[n2].equals("-height")) {
                    int n6 = ++n2;
                    ++n2;
                    this._$10347 = Integer.parseInt(stringArray[n6]);
                    continue;
                }
                if (stringArray[n2].equals("-rmiport")) {
                    ++n2;
                    try {
                        this._$47767 = Integer.parseInt(stringArray[n2++]);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IllegalArgumentException("Specified RMI port is not a number");
                    }
                }
                if (stringArray[n2].equals("-rmihost")) {
                    int n7 = ++n2;
                    ++n2;
                    System.setProperty("java.rmi.server.hostname", stringArray[n7]);
                    continue;
                }
                if (stringArray[n2].equals("-w") || stringArray[n2].equals("-width")) {
                    int n8 = ++n2;
                    ++n2;
                    this._$10346 = Integer.parseInt(stringArray[n8]);
                    continue;
                }
                if (stringArray[n2].equals("-s") || stringArray[n2].equals("-script")) {
                    if (stringArray.length < ++n2 + 2) {
                        throw new IllegalArgumentException("Missing script file name or script output filename");
                    }
                    String string = stringArray[n2++];
                    String string2 = this._$47786(string);
                    object = new ScriptRunnable(string2, string, new File(stringArray[n2++]));
                    this._$33841.add(object);
                    continue;
                }
                if (stringArray[n2].equals("-l") || stringArray[n2].equals("-loglevel")) {
                    int n9 = ++n2;
                    ++n2;
                    String string = stringArray[n9];
                    int n10 = string.indexOf(61);
                    if (n10 < 0 || n10 == string.length() - 1) {
                        System.err.println("Invalid log level assignment: " + string);
                        System.err.println("Aborting.");
                        System.exit(1);
                    }
                    object = string.substring(0, n10);
                    String string3 = string.substring(n10 + 1);
                    if (((String)object).length() == 0) {
                        Logger.getRootLogger().setLevel(Level.toLevel(string3));
                        continue;
                    }
                    Logger.getLogger((String)object).setLevel(Level.toLevel(string3));
                    continue;
                }
                if (stringArray[n2].equals("-server")) {
                    ++n2;
                    continue;
                }
                if (stringArray[n2].equals("-rmioff")) {
                    this._$47769 = true;
                    ++n2;
                    continue;
                }
                if (stringArray[n2].equals("-http-servlets")) {
                    String string = this._$47788(stringArray, n2);
                    n2 += 2;
                    if (string.equalsIgnoreCase("off")) {
                        this._$5250.putBoolean("mibexplorer.http.server.enabled", false);
                        continue;
                    }
                    if (string.equalsIgnoreCase("all")) {
                        this._$5250.putBoolean("mibexplorer.http.server.enabled", true);
                        this._$5250.putBoolean("mibexplorer.http.server.chart.enabled", true);
                        this._$5250.putBoolean("mibexplorer.http.server.data.enabled", true);
                        this._$5250.putBoolean("mibexplorer.http.server.script.enabled", true);
                        continue;
                    }
                    if (string.equalsIgnoreCase("monitorcharts")) {
                        this._$5250.putBoolean("mibexplorer.http.server.chart.enabled", true);
                        continue;
                    }
                    if (string.equalsIgnoreCase("monitordata")) {
                        this._$5250.putBoolean("mibexplorer.http.server.data.enabled", true);
                        continue;
                    }
                    if (string.equalsIgnoreCase("scripts")) {
                        this._$5250.putBoolean("mibexplorer.http.server.script.enabled", true);
                        continue;
                    }
                    System.err.println("Unrecognized parameter '" + string + "' for option 'http-servlets', aborting.");
                    System.exit(1);
                    continue;
                }
                if (stringArray[n2].equals("-http-port")) {
                    ++n2;
                    try {
                        int n11 = Integer.parseInt(stringArray[n2++]);
                        this._$5250.putInteger("mibexplorer.http.server.port", n11);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IllegalArgumentException("Specified HTTP port is not a number");
                    }
                }
                System.err.println("Unrecognized command line argument: " + stringArray[n2]);
                System.err.println("Aborting.");
                System.exit(1);
            }
            return;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.err.println("Missing parameter at " + stringArray[stringArray.length - 1]);
            System.exit(1);
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println(illegalArgumentException.getMessage());
            System.err.println("Aborting.");
            System.exit(1);
            return;
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
            System.err.println("Aborting.");
            System.exit(1);
        }
    }

    private String _$47788(String[] stringArray, int n2) {
        if (stringArray.length < n2 + 1) {
            System.err.println("Missing parameter for option '" + stringArray[n2] + "', aborting.");
            System.exit(1);
        }
        return stringArray[n2 + 1];
    }

    private void _$31388(Hashtable hashtable) {
        Collection collection = hashtable.values();
        UsmUser[] usmUserArray = new UsmUser[collection.size()];
        Vector<UserProfile> vector = new Vector<UserProfile>();
        int n2 = 0;
        for (UserProfile userProfile : collection) {
            usmUserArray[n2] = userProfile.getUser();
            if (userProfile.isPrincipal()) {
                vector.add(userProfile);
            }
            ++n2;
        }
        this._$14889.getUSM().getUserTable().clear();
        this._$14889.getUSM().setUsers(usmUserArray);
    }

    private String _$47786(String string) throws IOException {
        byte[] byArray;
        int n2;
        FileInputStream fileInputStream = new FileInputStream(string);
        StringBuffer stringBuffer = new StringBuffer(Math.max(fileInputStream.available(), 1000));
        while (fileInputStream.available() > 0 && (n2 = fileInputStream.read(byArray = new byte[fileInputStream.available()])) > 0) {
            stringBuffer.append(new String(byArray, 0, n2));
        }
        return stringBuffer.toString();
    }

    private MonitorConfigPanel _$47779(GenTarget genTarget, File file) {
        ServerMonitor serverMonitor = new ServerMonitor(this._$14889, this._$20550, (RepositoryManager)this._$31188, this._$7365, this._$5250, this._$10346, this._$10347, this._$47765);
        this._$47712.add(serverMonitor);
        serverMonitor.setTarget(genTarget);
        try {
            this._$31278.loadData((TabbedControlledPanel)serverMonitor, file);
            int n2 = file.getName().lastIndexOf(46);
            if (n2 < 0) {
                n2 = file.getName().length();
            }
            serverMonitor.setTitle(file.getName().substring(0, n2));
        }
        catch (Exception exception) {
            this._$5475.fatal("Failed to create monitor '" + file + "+':" + exception.getMessage(), exception);
            return null;
        }
        serverMonitor.getChart().setSize(this._$10346, this._$10347);
        serverMonitor.getMonitorProperties().getExportConfig().setAutoSave(serverMonitor.getDBMonitor() == null);
        serverMonitor.setExportEnabled(true);
        try {
            MonitorServerImpl monitorServerImpl = new MonitorServerImpl((MonitorConfigPanel)serverMonitor);
            Naming.rebind("//:" + this._$47767 + "/" + serverMonitor.getTitle(), (Remote)monitorServerImpl);
            this._$47764.add(monitorServerImpl);
        }
        catch (Exception exception) {
            this._$5475.warn(exception);
        }
        if (!serverMonitor.isRunning()) {
            serverMonitor.run();
        }
        return serverMonitor;
    }

    public void initMonitor(ServerMonitor serverMonitor) {
        serverMonitor.removeComponentLinkListener((ComponentLinkListener)this._$31278);
        serverMonitor.addComponentLinkListener((ComponentLinkListener)this._$31278);
        serverMonitor.getChart().setSize(this._$10346, this._$10347);
        if (!serverMonitor.isRunning()) {
            serverMonitor.run();
        }
    }

    public MonitorConfigPanel runMonitor(String string) {
        return this._$47779(this._$15220, new File(this.getMonitorPath(), string));
    }

    public MonitorConfigPanel createMonitor(String string) {
        ServerMonitor serverMonitor = new ServerMonitor(this._$14889, this._$20550, (RepositoryManager)this._$31188, this._$7365, this._$5250, this._$10346, this._$10347, this._$47765);
        this._$47712.add(serverMonitor);
        serverMonitor.setTarget(this._$15220);
        File file = this.getMonitorPath();
        serverMonitor.setExportEnabled(file.exists() && file.isDirectory());
        serverMonitor.setConfigFile(new File(this.getMonitorPath(), string + ".mon"));
        serverMonitor.setTitle(string);
        if (!this._$47769) {
            try {
                MonitorServerImpl monitorServerImpl = new MonitorServerImpl((MonitorConfigPanel)serverMonitor);
                Naming.rebind("//:" + this._$47767 + "/" + serverMonitor.getTitle(), (Remote)monitorServerImpl);
                this._$47764.add(monitorServerImpl);
            }
            catch (Exception exception) {
                this._$5475.warn(exception);
            }
        }
        return serverMonitor;
    }

    public MonitorConfigPanel createMonitor(File file, String string) {
        ServerMonitor serverMonitor = new ServerMonitor(this._$14889, this._$20550, (RepositoryManager)this._$31188, this._$7365, this._$5250, this._$10346, this._$10347, this._$47765);
        this._$47712.add(serverMonitor);
        serverMonitor.setTarget(this._$15220);
        serverMonitor.setExportEnabled(file.exists() && file.canWrite());
        serverMonitor.setConfigFile(file);
        serverMonitor.setTitle(string);
        if (!this._$47769) {
            try {
                MonitorServerImpl monitorServerImpl = new MonitorServerImpl((MonitorConfigPanel)serverMonitor);
                Naming.rebind("//:" + this._$47767 + "/" + serverMonitor.getTitle(), (Remote)monitorServerImpl);
                this._$47764.add(monitorServerImpl);
            }
            catch (Exception exception) {
                this._$5475.warn(exception);
            }
        }
        return serverMonitor;
    }

    private int _$31356(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = Validate.decrypt(byArray, new String(byArray2).toCharArray());
        if (byArray3 == null || byArray3.length < 7 || byArray3[0] != 48 || byArray3[1] != 4) {
            return 0;
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar(2000 + byArray3[4], byArray3[5] - 1, byArray3[6]);
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar(2000 + byArray3[4] - (byArray3[5] > 2 ? 0 : 1), byArray3[5] > 2 ? byArray3[5] - 3 : 11 - (2 - byArray3[5]), byArray3[6]);
        GregorianCalendar gregorianCalendar3 = new GregorianCalendar();
        if ((byArray3[4] != 0 || byArray3[5] != 0 || byArray3[6] != 0) && (gregorianCalendar3.getTime().before(gregorianCalendar2.getTime()) || gregorianCalendar.getTime().before(gregorianCalendar3.getTime()))) {
            return 0;
        }
        _$31226 = byArray3[4] == 0 && byArray3[5] == 0 && byArray3[6] == 0 ? null : gregorianCalendar;
        _$31225 = byArray3[3];
        this._$5250.put("mibexplorer.License", Validate.asHexString(byArray));
        this._$5250.put("mibexplorer.LicenseKey", new String(byArray2));
        return byArray3[0];
    }

    public File getMonitorPath() {
        String string = this._$5250.get("mibexplorer.PDUPath", ".");
        return new File(string);
    }

    static {
        LogFactory.setLogFactory(new Log4jLogFactory());
        _$31225 = 0;
    }

    class ScriptRunnable
    extends Script {
        private File _$47791;
        private String _$46;

        public ScriptRunnable(String string, String string2, File file) {
            super(string, new StringWriter(), new ScriptContext(MIBExplorerServer.this._$14889, MIBExplorerServer.this._$5250, MIBExplorerServer.this._$15220, MIBExplorerServer.this._$7365, new SnmpLogger(MIBExplorerServer.this._$20550), MIBExplorerServer.this._$20550, string2), new MIBContext((RepositoryManager)MIBExplorerServer.this._$31188, MIBExplorerServer.this._$20550), "Script");
            this._$46 = string2;
            this._$47791 = file;
        }

        public void output() {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(this._$47791);
                fileOutputStream.write(this.output.toString().getBytes());
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                l.error("Script output from " + this._$46 + " could not be written: " + iOException.getMessage());
            }
        }
    }

    class ShutdownThread
    extends Thread {
        ShutdownThread() {
        }

        public void run() {
            for (MonitorServerImpl monitorServerImpl : MIBExplorerServer.this._$47764) {
                monitorServerImpl.get().fireRemoteDisconnect();
                MIBExplorerServer.this._$5475.info("Stopped monitor: " + monitorServerImpl.get().getTitle());
            }
            for (MonitorServerImpl monitorServerImpl : MIBExplorerServer.this._$47712) {
                monitorServerImpl.stopTimer();
                MIBExplorerServer.this._$5475.info("Stopped monitor: " + monitorServerImpl.getTitle());
            }
        }
    }
}

