/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.explorer;

import com.agentpp.explorer.IndexConverter;
import com.agentpp.explorer.MIBInstance;
import com.agentpp.mib.IndexStruct;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.ObjectID;
import com.agentpp.snmp.ValueConverter;
import com.agentpp.snmp.types.ComparableIpAddress;
import com.klg.jclass.field.JCFieldComponent;
import com.objectspace.jgl.Pair;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Variable;

public class IndexPanel
extends JPanel {
    Vector indexFields = new Vector();
    IndexStruct[] index = null;
    ValueConverter[] vcs = null;
    String indexToolTip = null;
    GridBagConstraints c = new GridBagConstraints();
    GridBagLayout gridbag = new GridBagLayout();
    MIBRepository rep = null;
    String octetDisplayHint;

    public IndexPanel(String string) {
        this.octetDisplayHint = string;
        this.c.fill = 2;
        this.c.insets = new Insets(10, 10, 0, 0);
        this.setLayout(this.gridbag);
    }

    public void setIndexToolTip(String string) {
        this.indexToolTip = string;
    }

    public String isValidIndex() {
        int n2 = 0;
        Enumeration enumeration = this.indexFields.elements();
        while (enumeration.hasMoreElements()) {
            Pair pair = (Pair)enumeration.nextElement();
            JCFieldComponent jCFieldComponent = (JCFieldComponent)pair.second;
            if (jCFieldComponent.getValue() == null) {
                return this.index[n2].name;
            }
            Variable variable = this.vcs[n2].fromNative(jCFieldComponent.getValue());
            if (variable == null) {
                return this.index[n2].name;
            }
            switch (this.index[n2].baseType) {
                case 1: {
                    Object object = ((OctetString)this.vcs[n2].fromNative(jCFieldComponent.getValue())).getValue();
                    if (((Object)object).length >= this.index[n2].minLength && ((Object)object).length <= this.index[n2].maxLength) break;
                    return this.index[n2].name;
                }
                case 5: 
                case 12: {
                    Object object = new StringTokenizer(jCFieldComponent.getValue().toString(), ".");
                    if (((StringTokenizer)object).countTokens() != 4) {
                        return this.index[n2].name;
                    }
                    for (int i2 = 0; i2 < 4; ++i2) {
                        String string = ((StringTokenizer)object).nextToken();
                        try {
                            Integer n3 = Integer.valueOf(string);
                            if (n3 >= 0 && n3 <= 255) continue;
                            return this.index[n2].name;
                        }
                        catch (NumberFormatException numberFormatException) {
                            return this.index[n2].name;
                        }
                    }
                    break;
                }
                case 3: {
                    Object object = new ObjectID(jCFieldComponent.getValue().toString());
                    if (!((ObjectID)object).isValid()) {
                        return this.index[n2].name;
                    }
                    if (((ObjectID)object).size() >= this.index[n2].minLength && ((ObjectID)object).size() <= this.index[n2].maxLength) break;
                    return this.index[n2].name;
                }
                default: {
                    Object object;
                    try {
                        object = Long.valueOf(jCFieldComponent.getValue().toString());
                        if ((Long)object < 0L && this.index[n2].baseType != 0) {
                            return this.index[n2].name;
                        }
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        return this.index[n2].name;
                    }
                }
            }
            ++n2;
        }
        return null;
    }

    public void setIndexStruct(MIBRepository mIBRepository, ValueConverter[] valueConverterArray, IndexStruct[] indexStructArray, ObjectID[] objectIDArray) {
        this.removeAll();
        this.indexFields = new Vector(indexStructArray.length);
        this.index = indexStructArray;
        this.vcs = valueConverterArray;
        this.rep = mIBRepository;
        this._$38446(objectIDArray);
        this._$38465();
    }

    private void _$38446(ObjectID[] objectIDArray) {
        int n2 = 0;
        while (n2 < this.index.length) {
            Object object;
            JLabel jLabel = new JLabel();
            jLabel.setText(this.index[n2].name + ":");
            if (this.indexToolTip != null) {
                jLabel.setToolTipText(this.indexToolTip + " " + (n2 + 1));
            }
            this.c.weightx = 1.0;
            this.c.weighty = 1.0;
            this.c.gridx = 0;
            this.c.gridy = n2;
            this.gridbag.setConstraints(jLabel, this.c);
            JCFieldComponent jCFieldComponent = MIBInstance.getEditor(this.rep, this.vcs[n2], null, this.octetDisplayHint);
            if (objectIDArray != null) {
                object = IndexConverter.getIndexVariable(this.index[n2], objectIDArray[n2]);
                Object object2 = this.vcs[n2].toNative((Variable)object);
                if (object2 instanceof ComparableIpAddress) {
                    jCFieldComponent.setValue(object2.toString());
                } else {
                    jCFieldComponent.setValue(object2);
                }
            }
            this.c.weightx = 1.0;
            this.c.weighty = 1.0;
            this.c.gridx = 1;
            this.c.gridy = n2++;
            this.gridbag.setConstraints((JComponent)((Object)jCFieldComponent), this.c);
            object = new Pair(jLabel, jCFieldComponent);
            this.indexFields.addElement(object);
        }
    }

    private void _$38465() {
        for (int i2 = 0; i2 < this.indexFields.size(); ++i2) {
            Pair pair = (Pair)this.indexFields.elementAt(i2);
            this.add((Component)pair.first);
            this.add((Component)pair.second);
        }
    }

    public ObjectID getObjectID() {
        int n2 = 0;
        String string = new String();
        Enumeration enumeration = this.indexFields.elements();
        while (enumeration.hasMoreElements()) {
            Comparable comparable;
            Variable variable;
            Pair pair = (Pair)enumeration.nextElement();
            JCFieldComponent jCFieldComponent = (JCFieldComponent)pair.second;
            if (jCFieldComponent.getValue() == null) {
                return null;
            }
            if (this.vcs[n2].getDisplayHint() != null) {
                variable = this.vcs[n2].fromNative(jCFieldComponent.getValue());
                string = variable instanceof OctetString ? (this.index[n2].impliedLength ? string + "." + ObjectID.asOID(((OctetString)variable).getValue()) : (((ObjectID)(comparable = ObjectID.asOID(((OctetString)variable).getValue()))).size() > 0 ? string + "." + ((ObjectID)comparable).size() + "." + ((ObjectID)comparable).toString() : string + ".0")) : (variable instanceof OID ? (this.index[n2].impliedLength ? string + "." + ((Object)variable).toString() : (((OID)(comparable = (OID)variable)).size() > 0 ? string + "." + ((OID)comparable).size() + "." + ((OID)comparable).toString() : string + ".0")) : string + "." + jCFieldComponent.getValue().toString());
            } else if (this.index[n2].baseType == 1) {
                variable = (OctetString)this.vcs[n2].fromNative(jCFieldComponent.getValue());
                string = this.index[n2].impliedLength ? string + "." + ObjectID.asOID(((OctetString)variable).getValue()) : (((ObjectID)(comparable = ObjectID.asOID(((OctetString)variable).getValue()))).size() > 0 ? string + "." + ((ObjectID)comparable).size() + "." + ((ObjectID)comparable).toString() : string + ".0");
            } else if (this.index[n2].baseType == 3) {
                variable = (OID)this.vcs[n2].fromNative(jCFieldComponent.getValue());
                string = this.index[n2].impliedLength ? string + "." + ((OID)variable).toString() : (((OID)variable).size() > 0 ? string + "." + ((OID)variable).size() + "." + ((OID)variable).toString() : string + ".0");
            } else {
                string = string + "." + jCFieldComponent.getValue().toString();
            }
            ++n2;
        }
        if (string.length() > 0) {
            return new ObjectID(string.substring(1));
        }
        return new ObjectID();
    }

    public JComponent getLastComponent() {
        try {
            Object e2 = this.indexFields.lastElement();
            return (JComponent)((Pair)e2).second;
        }
        catch (NoSuchElementException noSuchElementException) {
            return null;
        }
    }

    public int getIndexFieldCount() {
        return this.indexFields.size();
    }

    public Enumeration getIndexFields() {
        return this.indexFields.elements();
    }

    public GridBagLayout getGridBagLayout() {
        return this.gridbag;
    }
}

