/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.explorer;

import com.agentpp.explorer.IndexConverter;
import com.agentpp.explorer.MIBInstance;
import com.agentpp.mib.IndexStruct;
import com.agentpp.mib.MIBNotifyType;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBObjectType;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.MIBTextualConvention;
import com.agentpp.mib.ObjectID;
import com.agentpp.mib.ObjectIDFormatException;
import com.agentpp.smiparser.SMI;
import com.agentpp.snmp.ValueConverter;
import com.agentpp.util.UserConfigFile;
import java.awt.Color;
import java.awt.Component;
import java.io.Serializable;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;

public class ExplorerTreeCellRenderer
extends DefaultTreeCellRenderer {
    public static final Color bookmarkColor = new Color(190, 230, 195);
    MIBRepository rep;
    TreeMap bookmarks;
    private UserConfigFile _$5250;
    public static final String CFG_ICON_PREFIX = "tree.icon.";
    private static final String _$24291 = "tree.icon.INSTANCE";
    private static final String _$24292 = "tree.icon.INSTANCE_MUTABLE";
    private Map _$24293 = new HashMap(SMI.ENTRY_TYPES.length + 3);

    public ExplorerTreeCellRenderer(MIBRepository mIBRepository, TreeMap treeMap) {
        this.rep = mIBRepository;
        this.bookmarks = treeMap;
    }

    public void setConfig(UserConfigFile userConfigFile) {
        this._$5250 = userConfigFile;
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n2, boolean bl4) {
        Object object2;
        Serializable serializable;
        String string = "";
        Object object3 = ((DefaultMutableTreeNode)object).getUserObject();
        if (object3 instanceof MIBObject) {
            serializable = (MIBObject)object3;
            this._$24300((MIBObject)serializable);
            if (serializable instanceof MIBTextualConvention) {
                this.setToolTipText(null);
            } else {
                this.setToolTipText(((MIBObject)serializable).getPrintableOid());
            }
        } else if (object3 instanceof MIBInstance) {
            serializable = (MIBInstance)object3;
            try {
                object2 = new ObjectID(((MIBInstance)serializable).getOid().toString()).getSuffix(((MIBInstance)serializable).getOid().size() - ((MIBInstance)serializable).getObjectClass().getOid().size());
                if (((MIBInstance)serializable).getObjectClass() != null) {
                    MIBObject mIBObject = this.rep.getParent(((MIBInstance)serializable).getObjectClass());
                    if (mIBObject != null && mIBObject instanceof MIBObjectType && ((MIBObjectType)mIBObject).isTable()) {
                        IndexStruct[] indexStructArray;
                        string = "[";
                        MIBObjectType mIBObjectType = (MIBObjectType)mIBObject;
                        if (mIBObjectType.getIndexPart().isAugment()) {
                            mIBObjectType = (MIBObjectType)this.rep.getObject(mIBObjectType.getIndexPart().getIndexPart()[0]);
                        }
                        if ((indexStructArray = mIBObjectType.getIndexPart().getIndexStruct(this.rep)) == null) {
                            string = "[" + ((ObjectID)object2).toString() + "] " + ((MIBInstance)serializable).toString();
                        } else {
                            try {
                                ObjectID[] objectIDArray = this.rep.getIndexObjectIDs((ObjectID)object2, indexStructArray);
                                ValueConverter[] valueConverterArray = this._$24307(mIBObjectType);
                                string = string + IndexConverter.getIndexString(valueConverterArray, indexStructArray, objectIDArray);
                                string = string + "] " + ((MIBInstance)serializable).toString();
                            }
                            catch (NullPointerException nullPointerException) {
                                string = "[" + ((ObjectID)object2).toString() + "] " + ((MIBInstance)serializable).toString();
                            }
                        }
                    } else {
                        string = "[" + ((ObjectID)object2).toString() + "] " + ((MIBInstance)serializable).toString();
                    }
                } else {
                    string = "[" + ((ObjectID)object2).toString() + "] " + ((MIBInstance)serializable).toString();
                }
                this.setToolTipText(((MIBInstance)serializable).getOid().toString());
            }
            catch (ObjectIDFormatException objectIDFormatException) {
                string = "[?] " + ((MIBInstance)serializable).getValue();
            }
            this._$24300(((MIBInstance)serializable).getObjectClass());
        } else if (object3 instanceof String) {
            this.setTextNonSelectionColor(Color.black);
            this.setBackgroundNonSelectionColor(Color.white);
        } else {
            this.setTextNonSelectionColor(Color.black);
            this.setBackgroundNonSelectionColor(Color.white);
        }
        if (string.startsWith("[] ")) {
            string = string.substring(3);
        }
        super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n2, bl4);
        if (object3 instanceof MIBObject) {
            serializable = (MIBObject)object3;
            this.setText(((MIBObject)serializable).getName());
            if (this._$5250 != null) {
                object2 = CFG_ICON_PREFIX + ((MIBObject)serializable).getTypeString();
                if (serializable instanceof MIBObjectType) {
                    object2 = (String)object2 + "." + ((MIBObjectType)serializable).getSubTypeString();
                }
                this._$24314((String)object2);
            }
        } else if (object3 instanceof MIBInstance) {
            this.setText(string);
            if (this._$5250 != null) {
                serializable = ((MIBInstance)object3).getObjectClass();
                if (serializable instanceof MIBObjectType) {
                    if (SMI.isWritable(((MIBObjectType)serializable).getAccess())) {
                        this._$24314(_$24292);
                    } else {
                        this._$24314(_$24291);
                    }
                } else {
                    this._$24314(_$24291);
                }
            }
        }
        return this;
    }

    private void _$24314(String string) {
        String string2 = this._$5250.get(string, null);
        ImageIcon imageIcon = (ImageIcon)this._$24293.get(string2);
        if (string2 != null && imageIcon == null) {
            imageIcon = this.createImageIcon(string2);
            this._$24293.put(string2, imageIcon);
        }
        if (imageIcon != null) {
            this.setIcon(imageIcon);
        }
    }

    private ValueConverter[] _$24307(MIBObjectType mIBObjectType) {
        if (!mIBObjectType.isTable()) {
            return null;
        }
        Vector<? extends MIBObjectType> vector = this.rep.getColumnarObjectsOfTable(mIBObjectType, true, false);
        if (mIBObjectType.userObject instanceof ValueConverter[]) {
            return (ValueConverter[])mIBObjectType.userObject;
        }
        ValueConverter[] valueConverterArray = new ValueConverter[vector.size()];
        for (int i2 = 0; i2 < valueConverterArray.length; ++i2) {
            MIBObjectType mIBObjectType2 = vector.elementAt(i2);
            MIBTextualConvention mIBTextualConvention = this.rep.getEffectiveSyntax(mIBObjectType2.getSyntax());
            valueConverterArray[i2] = new ValueConverter(mIBObjectType2, mIBTextualConvention.getSyntax(), mIBTextualConvention.getDisplayHint());
        }
        mIBObjectType.userObject = valueConverterArray;
        return valueConverterArray;
    }

    private void _$24300(MIBObject mIBObject) {
        if (this.bookmarks.get(mIBObject.getObjectID()) != null) {
            this.setBackgroundNonSelectionColor(bookmarkColor);
        } else {
            this.setBackgroundNonSelectionColor(Color.white);
        }
        int n2 = SMI.statusType(mIBObject.getStatus());
        if (n2 == 4 || n2 == 3) {
            this.setTextNonSelectionColor(Color.lightGray);
        } else if (mIBObject instanceof MIBObjectType) {
            MIBObjectType mIBObjectType = (MIBObjectType)mIBObject;
            if (mIBObjectType.getAccess() != null) {
                if (mIBObjectType.getAccess().equals("read-only")) {
                    this.setTextNonSelectionColor(Color.darkGray);
                } else if (mIBObjectType.getAccess().equals("read-create")) {
                    this.setTextNonSelectionColor(Color.red);
                } else if (mIBObjectType.getAccess().equals("read-write")) {
                    this.setTextNonSelectionColor(Color.blue);
                } else {
                    this.setTextNonSelectionColor(Color.black);
                }
            } else {
                this.setTextNonSelectionColor(Color.black);
            }
        } else if (mIBObject instanceof MIBNotifyType) {
            this.setTextNonSelectionColor(new Color(200, 100, 45));
        } else {
            this.setTextNonSelectionColor(Color.black);
        }
    }

    protected ImageIcon createImageIcon(String string) {
        URL uRL = this.getClass().getResource(string);
        if (uRL != null) {
            return new ImageIcon(uRL);
        }
        System.err.println("Couldn't find file: " + string);
        return null;
    }
}

