/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.explorer;

import com.agentpp.explorer.MxpPduHandle;
import com.agentpp.explorer.ber.BERLogPanel;
import com.agentpp.snmp.TargetStatistics;
import com.klg.jclass.table.data.JCEditableVectorDataSource;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import org.snmp4j.CommandResponderEvent;
import org.snmp4j.MessageDispatcherImpl;
import org.snmp4j.SNMP4JSettings;
import org.snmp4j.TransportMapping;
import org.snmp4j.TransportStateReference;
import org.snmp4j.mp.PduHandle;
import org.snmp4j.smi.Address;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExplorerMessageDispatcher
extends MessageDispatcherImpl {
    private static final String[] _$37092;
    private BERLogPanel _$12571;
    private Map<Address, TargetStatistics> _$16040 = new HashMap<Address, TargetStatistics>();
    private DecimalFormat _$37093 = new DecimalFormat("0.###");

    public ExplorerMessageDispatcher(BERLogPanel bERLogPanel) {
        this._$12571 = bERLogPanel;
    }

    @Override
    public void processMessage(TransportMapping transportMapping, Address address, ByteBuffer byteBuffer, TransportStateReference transportStateReference) {
        this._$12571.processMessage(transportMapping, address, byteBuffer, transportStateReference);
        super.processMessage(transportMapping, address, byteBuffer, transportStateReference);
    }

    @Override
    protected void sendMessage(TransportMapping transportMapping, Address address, byte[] byArray, TransportStateReference transportStateReference) throws IOException {
        super.sendMessage(transportMapping, address, byArray, transportStateReference);
        this._$12571.processMessage(transportMapping, address, byArray, transportStateReference);
    }

    @Override
    protected PduHandle createPduHandle() {
        return new MxpPduHandle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void fireProcessPdu(CommandResponderEvent commandResponderEvent) {
        super.fireProcessPdu(commandResponderEvent);
        Map<Address, TargetStatistics> map = this._$16040;
        synchronized (map) {
            TargetStatistics targetStatistics = this._$16040.get(commandResponderEvent.getPeerAddress());
            if (targetStatistics == null) {
                targetStatistics = new TargetStatistics();
                this._$16040.put(commandResponderEvent.getPeerAddress(), targetStatistics);
            }
            targetStatistics.add(commandResponderEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Address, TargetStatistics> getTargetStatistics() {
        TreeMap<Address, TargetStatistics> treeMap = new TreeMap<Address, TargetStatistics>();
        Map<Address, TargetStatistics> map = this._$16040;
        synchronized (map) {
            treeMap.putAll(this._$16040);
        }
        return treeMap;
    }

    public JCEditableVectorDataSource getTableModel() {
        Map<Address, TargetStatistics> map = this.getTargetStatistics();
        JCEditableVectorDataSource jCEditableVectorDataSource = new JCEditableVectorDataSource();
        jCEditableVectorDataSource.setNumColumns(_$37092.length);
        jCEditableVectorDataSource.setNumRows(0);
        for (int i2 = 0; i2 < _$37092.length; ++i2) {
            jCEditableVectorDataSource.setColumnLabel(i2, _$37092[i2]);
        }
        for (Map.Entry<Address, TargetStatistics> entry : map.entrySet()) {
            Collection<Integer> collection = entry.getValue().getStatisticsKeys();
            for (Integer n2 : collection) {
                Vector<Object> vector = new Vector<Object>(jCEditableVectorDataSource.getNumColumns());
                vector.add(entry.getKey());
                if (n2 < 0) {
                    vector.add("*");
                } else {
                    vector.add(5 * (n2 - 1) + " - " + 5 * n2);
                }
                TargetStatistics.RequestStats requestStats = entry.getValue().getStatistics(n2);
                vector.add(requestStats.getTotalMessages().getCount());
                vector.add(requestStats.getTotalMessages().getMin());
                vector.add(requestStats.getTotalMessages().getMax());
                vector.add(this._$37093.format(requestStats.getTotalMessages().getAverage()));
                vector.add(requestStats.getResponseMessageIndex().getMin());
                vector.add(requestStats.getResponseMessageIndex().getMax());
                vector.add(this._$37093.format(requestStats.getResponseMessageIndex().getAverage()));
                vector.add(requestStats.getRuntimes().getMin());
                vector.add(requestStats.getRuntimes().getMax());
                vector.add(this._$37093.format(requestStats.getRuntimes().getAverage()));
                jCEditableVectorDataSource.addRow(Integer.MAX_VALUE, null, vector);
            }
        }
        return jCEditableVectorDataSource;
    }

    static {
        SNMP4JSettings.getSnmp4jStatistics();
        SNMP4JSettings.setSnmp4jStatistics(SNMP4JSettings.Snmp4jStatistics.extended);
        _$37092 = new String[]{"Address", "PDU-Size", "Total Messages Sent", "Sent/Req. MIN", "Sent/Req. MAX", "Sent/Req. AVG", "Retries MIN", "Retries MAX", "Retries AVG", "Runtime (ms) MIN", "Runtime (ms) MAX", "Runtime (ms) AVG"};
    }
}

