/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.explorer;

import com.agentpp.mib.MIBModule;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBObjectType;
import com.agentpp.mib.ObjectID;
import com.agentpp.smiparser.SMI;
import com.agentpp.snmp.GenTarget;
import com.agentpp.snmp.GenTargetEvent;
import com.agentpp.snmp.GenTargetListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import org.snmp4j.PDU;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.VariableBinding;

public class CheckMIBSupport
extends Thread {
    private Vector _$21240;
    private Vector _$7365;
    private Vector _$55576 = new Vector();
    private Snmp _$14889;
    private JFrame _$25700;
    private transient Vector _$37481;

    public CheckMIBSupport(JFrame jFrame, Snmp snmp, Vector vector, Vector vector2) {
        this._$14889 = snmp;
        this._$21240 = vector;
        this._$7365 = vector2;
        this._$25700 = jFrame;
    }

    public void run() {
        try {
            ProgressMonitor progressMonitor = new ProgressMonitor(this._$25700, "Scanning targets for implemented MIBs...", "", 0, this._$21240.size() * this._$7365.size());
            for (int i2 = 0; i2 < this._$7365.size() && !progressMonitor.isCanceled(); ++i2) {
                GenTarget genTarget = (GenTarget)this._$7365.elementAt(i2);
                Target target = genTarget.getTarget();
                if (target == null) {
                    this.fireTargetChanged(new GenTargetEvent(this, genTarget, 2));
                    continue;
                }
                boolean bl = true;
                for (int i3 = 0; i3 < this._$21240.size() && !progressMonitor.isCanceled(); ++i3) {
                    progressMonitor.setNote(target.toString() + ", " + this._$21240.elementAt(i3));
                    progressMonitor.setProgress(i2 * this._$21240.size() + i3);
                    MIBModule mIBModule = (MIBModule)this._$21240.elementAt(i3);
                    boolean bl2 = false;
                    boolean bl3 = false;
                    if (mIBModule == null) continue;
                    Enumeration enumeration = mIBModule.objects();
                    while (enumeration.hasMoreElements() && !progressMonitor.isCanceled()) {
                        PDU pDU;
                        ResponseEvent responseEvent;
                        VariableBinding variableBinding;
                        PDU pDU2;
                        MIBObject mIBObject = (MIBObject)enumeration.nextElement();
                        if (!(mIBObject instanceof MIBObjectType)) continue;
                        MIBObjectType mIBObjectType = (MIBObjectType)mIBObject;
                        if (mIBObjectType.isTable()) {
                            pDU2 = genTarget.makePDU();
                            variableBinding = new VariableBinding();
                            variableBinding.setOid(new OID(mIBObjectType.getPrintableOid()));
                            pDU2.add(variableBinding);
                            responseEvent = this._$14889.getNext(pDU2, target);
                            pDU = responseEvent.getResponse();
                            bl3 = true;
                            if (pDU == null) {
                                progressMonitor.close();
                                this._$16035();
                                return;
                            }
                            if (pDU.getErrorStatus() != 0 || pDU.size() != 1 || pDU.get(0).isException()) continue;
                            OID oID = pDU.get(0).getOid();
                            if (!mIBObjectType.getObjectID().isRootOf(new ObjectID(oID.toString()))) continue;
                            bl2 = true;
                            break;
                        }
                        if (mIBObjectType.isColumnarObject() || !SMI.isAccessible(mIBObjectType.getAccess())) continue;
                        pDU2 = genTarget.makePDU();
                        variableBinding = new VariableBinding();
                        variableBinding.setOid(new OID(mIBObjectType.getPrintableOid() + ".0"));
                        pDU2.add(variableBinding);
                        responseEvent = this._$14889.get(pDU2, target);
                        pDU = responseEvent.getResponse();
                        bl3 = true;
                        if (pDU == null) {
                            progressMonitor.close();
                            this._$16035();
                            return;
                        }
                        if (pDU.getErrorStatus() != 0 || pDU.size() != 1 || pDU.get(0).isException()) continue;
                        bl2 = true;
                        break;
                    }
                    if (!bl3 || bl2) continue;
                    bl = false;
                    break;
                }
                if (bl) continue;
                this.fireTargetChanged(new GenTargetEvent(this, genTarget, 2));
            }
            progressMonitor.close();
            this.fireTargetChanged(new GenTargetEvent(this, null, 0));
        }
        catch (Exception exception) {
            final String string = exception.getMessage();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    String[] stringArray = new String[]{"An unexpected error occured during scan:", string};
                    JOptionPane.showMessageDialog(CheckMIBSupport.this._$25700, stringArray, "Internal Error", 0);
                }
            });
            exception.printStackTrace();
        }
    }

    private void _$16035() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                String[] stringArray = new String[]{"Timeout occured during scan.", "Please check the target's security settings!", "If settings are correct, increase timeout value", "or retries for the target."};
                JOptionPane.showMessageDialog(CheckMIBSupport.this._$25700, stringArray, "Timeout", 0);
            }
        });
    }

    public synchronized void removeGenTargetListener(GenTargetListener genTargetListener) {
        if (this._$37481 != null && this._$37481.contains(genTargetListener)) {
            Vector vector = (Vector)this._$37481.clone();
            vector.removeElement(genTargetListener);
            this._$37481 = vector;
        }
    }

    public synchronized void addGenTargetListener(GenTargetListener genTargetListener) {
        Vector vector;
        Vector vector2 = vector = this._$37481 == null ? new Vector(2) : (Vector)this._$37481.clone();
        if (!vector.contains(genTargetListener)) {
            vector.addElement(genTargetListener);
            this._$37481 = vector;
        }
    }

    protected void fireTargetChanged(GenTargetEvent genTargetEvent) {
        if (this._$37481 != null) {
            Vector vector = this._$37481;
            int n2 = vector.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                ((GenTargetListener)vector.elementAt(i2)).targetChanged(genTargetEvent);
            }
        }
    }
}

