/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.explorer;

import com.agentpp.common.ChangeManager;
import com.agentpp.common.table.ExtendedTable;
import com.agentpp.common.table.TableUtils;
import com.agentpp.explorer.IndexConverter;
import com.agentpp.explorer.MultiVariablePanel;
import com.agentpp.explorer.RequestObserver;
import com.agentpp.explorer.log.SnmpLogger;
import com.agentpp.mib.IndexStruct;
import com.agentpp.mib.MIBEnum;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBObjectType;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.MIBTextualConvention;
import com.agentpp.mib.ObjectID;
import com.agentpp.mib.ObjectIDFormatException;
import com.agentpp.mib.event.MIBObjectEvent;
import com.agentpp.mib.event.MIBObjectListener;
import com.agentpp.smiparser.SMI;
import com.agentpp.snmp.GenTarget;
import com.agentpp.snmp.ValueConverter;
import com.agentpp.snmp.types.ComparableIpAddress;
import com.agentpp.util.Regex;
import com.klg.jclass.table.JCCellDisplayEvent;
import com.klg.jclass.table.JCCellDisplayListener;
import com.klg.jclass.table.JCCellPosition;
import com.klg.jclass.table.JCCellRange;
import com.klg.jclass.table.JCCellStyle;
import com.klg.jclass.table.JCEditCellEvent;
import com.klg.jclass.table.JCEditCellListener;
import com.klg.jclass.table.JCTableCellInfo;
import com.klg.jclass.table.TablePopupMenu;
import com.klg.jclass.table.data.JCEditableVectorDataSource;
import com.objectspace.jgl.Pair;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.snmp4j.PDU;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.event.ResponseListener;
import org.snmp4j.smi.AbstractVariable;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TimeTicks;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;

public class BrowsePanel
extends JPanel
implements ResponseListener,
ActionListener,
JCCellDisplayListener,
JCEditCellListener,
MouseListener {
    private static final String _$28156 = "Undo";
    private static final String _$28157 = "Redo";
    public static final char NEW_LINE_DELIM = '\n';
    public static final char TAB_DELIM = '\t';
    public static final String EMPTY_STRING = "";
    public static final String NEWLINE = "\n";
    public static final String NULL = "null";
    public static final String TAB = "\t";
    public static final DataFlavor data_flavour = new DataFlavor(String.class, "ExcelTokenizedString");
    private Clipboard _$28164;
    private int _$28165;
    private int _$28166;
    private StringSelection _$28167;
    private Collection _$27852;
    public static final int COL_OID = 0;
    public static final int COL_SYNTAX = 1;
    public static final int COL_VALUE = 2;
    public static final int COL_VARIABLE = 3;
    public static final int COL_VALUECONVERTER = 4;
    private static final String[] _$1713 = new String[]{"OID", "Syntax", "Value", "", ""};
    private static final int[] _$25679 = new int[]{25, 10, 25, 0};
    private static JCCellStyle _$28172;
    private static JCCellStyle _$28173;
    private transient Vector _$25771 = new Vector(1);
    private JMenu _$28174 = new JMenu("String Format");
    private JMenuItem _$28175 = new JMenuItem("Undo");
    private JMenuItem _$28176 = new JMenuItem("Redo");
    private ChangeManager _$25705 = new ChangeManager();
    private CellEdit _$25707;
    private boolean _$11764;
    private boolean _$28177;
    BorderLayout borderLayout1 = new BorderLayout();
    ExtendedTable table = new ExtendedTable(){

        public boolean isPopupAllowed(int n2, int n3) {
            JCCellPosition jCCellPosition = BrowsePanel.this.table.XYToCell(n2, n3);
            int n4 = jCCellPosition.row;
            int n5 = jCCellPosition.column;
            if (n5 != 2) {
                return false;
            }
            ValueConverter valueConverter = (ValueConverter)BrowsePanel.this.model.getTableDataItem(n4, 4);
            if (valueConverter == null || !SMI.isString(valueConverter.getEffectiveSyntax().getSyntax())) {
                BrowsePanel.this._$28174.setEnabled(false);
            } else {
                if (valueConverter.getObjectType() == null) {
                    BrowsePanel.this._$28174.getMenuComponent(BrowsePanel.this._$28174.getMenuComponentCount() - 1).setEnabled(false);
                } else {
                    BrowsePanel.this._$28174.getMenuComponent(BrowsePanel.this._$28174.getMenuComponentCount() - 1).setEnabled(true);
                }
                BrowsePanel.this._$28174.setEnabled(true);
            }
            return true;
        }

        public String getToolTipText(MouseEvent mouseEvent) {
            JCCellPosition jCCellPosition = this.XYToCell(mouseEvent.getX(), mouseEvent.getY());
            if (jCCellPosition.column < 0 || jCCellPosition.row < 0) {
                return null;
            }
            int n2 = jCCellPosition.row;
            int n3 = jCCellPosition.column;
            Object object = BrowsePanel.this.model.getTableDataItem(n2, n3);
            if (object == null) {
                return null;
            }
            ValueConverter valueConverter = (ValueConverter)BrowsePanel.this.model.getTableDataItem(n2, 4);
            if (valueConverter == null) {
                return object.toString();
            }
            if (n3 == 2) {
                Variable variable = (Variable)BrowsePanel.this.model.getTableDataItem(n2, 3);
                if (variable instanceof OctetString) {
                    return ((OctetString)variable).toHexString();
                }
            } else if (n3 == 1) {
                return BrowsePanel.getSyntaxString((Integer)object);
            }
            return object.toString();
        }

        public boolean isEditable(int n2, int n3) {
            if (n3 == 2) {
                return BrowsePanel.this._$11764;
            }
            return false;
        }
    };
    JCEditableVectorDataSource model = new JCEditableVectorDataSource();
    private boolean _$28178;
    private MIBRepository _$7308;
    private Snmp _$14889;
    private Target _$15220;
    private GenTarget _$15238;
    private int _$28179 = 0;
    private RequestObserver _$21169;
    private SnmpLogger _$12571;
    private String _$17278;
    private JCCellStyle _$25703;
    private int _$28180 = 0;

    public BrowsePanel(RequestObserver requestObserver, Snmp snmp, MIBRepository mIBRepository, String string, boolean bl) {
        this._$21169 = requestObserver;
        this._$17278 = string;
        this._$14889 = snmp;
        this._$7308 = mIBRepository;
        this._$12571 = new SnmpLogger(mIBRepository);
        this.model.setNumRows(0);
        this.model.setNumColumns(_$1713.length);
        this.table.getDefaultCellStyle().setEditable(false);
        this.table.setPopupMenuEnabled(true);
        TablePopupMenu tablePopupMenu = this.table.getPopupMenu();
        if (bl) {
            this._$28175.setMnemonic('U');
            this._$28176.setMnemonic('R');
            tablePopupMenu.add(this._$28175);
            tablePopupMenu.add(this._$28176);
            this._$28175.addActionListener(this);
            this._$28176.addActionListener(this);
            tablePopupMenu.add(new JSeparator());
        }
        tablePopupMenu.add(this._$28174);
        this._$28174.setMnemonic('F');
        JMenuItem jMenuItem = this._$28174.add(new FormatAction("ASCII", "255a"));
        jMenuItem.setToolTipText("Sets the display and input format for this string object to '255a', e.g. 'aBc' renders 'aBc'");
        jMenuItem.setMnemonic('A');
        jMenuItem = this._$28174.add(new FormatAction("Decimal", "1d."));
        jMenuItem.setToolTipText("Sets the display and input format for this string object to '1d.', e.g. 'aBc' renders '97.66.99'");
        jMenuItem.setMnemonic('D');
        jMenuItem = this._$28174.add(new FormatAction("Hexadecimal", "1x:"));
        jMenuItem.setToolTipText("Sets the display and input format for this string object to '1x:', e.g. 'aBc' renders '61:42:63'");
        jMenuItem.setMnemonic('H');
        jMenuItem = this._$28174.add(new FormatAction("Octal", "1o:"));
        jMenuItem.setToolTipText("Sets the display and input format for this string object to '1o:', e.g. 'aBc' renders '141:102:143'");
        jMenuItem.setMnemonic('O');
        jMenuItem = this._$28174.add(new FormatAction("Binary", "1b:"));
        jMenuItem.setToolTipText("Sets the display and input format for this string object to '1b:', e.g. 'aBc' renders '01100001:01000010:01100011'");
        jMenuItem.setMnemonic('B');
        jMenuItem = this._$28174.add(new FormatAction("MIB", null));
        jMenuItem.setToolTipText("Sets the default display and input format for this string object as defined in the corresponding MIB module");
        jMenuItem.setMnemonic('M');
        ToolTipManager.sharedInstance().registerComponent(this.table);
        this.table.setResizeEven(false);
        this.table.setDataSource(this.model);
        this.table.setColumnHidden(4, true);
        this.table.setColumnHidden(3, true);
        this.table.addCellDisplayListener(this);
        this.table.setSelectionPolicy(2);
        this.table.setAllowCellResize(4);
        this.table.addMouseListener(this);
        this._$25703 = new JCCellStyle(this.table.getDefaultCellStyle());
        this._$25703.setBackground(Color.blue);
        this._$25703.setForeground(Color.white);
        this._$25703.setEditable(true);
        if (_$28172 == null) {
            _$28172 = new JCCellStyle(this.table.getDefaultCellStyle());
            _$28172.setBackground(Color.orange);
        }
        if (_$28173 == null) {
            _$28173 = new JCCellStyle(this.table.getDefaultCellStyle());
            _$28173.setBackground(Color.red);
        }
        for (int i2 = 0; i2 < _$1713.length - 1; ++i2) {
            this.model.setColumnLabel(i2, _$1713[i2]);
            this.table.setCharWidth(i2, _$25679[i2]);
        }
        this.table.setCharWidth(-1, 6);
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        KeyStroke keyStroke = KeyStroke.getKeyStroke(67, 2, false);
        this.table.registerKeyboardAction(this, "copy", keyStroke, 0);
        this._$5576(bl);
    }

    public BrowsePanel(MIBRepository mIBRepository) {
        this(null, null, mIBRepository, null, false);
    }

    public BrowsePanel() {
        this(new MIBRepository());
    }

    private void _$5576(boolean bl) {
        this.table.removeEditCellListener(this);
        this._$11764 = bl;
        if (bl) {
            this.table.addEditCellListener(this);
        }
        this._$14354();
    }

    public void setAllEditable(boolean bl) {
        this._$28177 = bl;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("copy")) {
            this.copySelectionToClipBoard();
        } else if (string.equals(_$28156)) {
            this._$25705.undo();
        } else if (string.equals(_$28157)) {
            this._$25705.redo();
        }
    }

    public JCEditableVectorDataSource getModel() {
        return this.model;
    }

    private void _$14379(JCCellRange jCCellRange) {
        int n2;
        if (jCCellRange.start_row == -1) {
            jCCellRange.start_row = 0;
        }
        if (jCCellRange.start_column == -1) {
            jCCellRange.start_column = 0;
        }
        if (jCCellRange.start_row > jCCellRange.end_row) {
            n2 = jCCellRange.start_row;
            jCCellRange.start_row = jCCellRange.end_row;
            jCCellRange.end_row = n2;
        }
        if (jCCellRange.start_column > jCCellRange.end_column) {
            n2 = jCCellRange.start_column;
            jCCellRange.start_column = jCCellRange.end_column;
            jCCellRange.end_column = n2;
        }
        this._$28165 = jCCellRange.end_row;
        this._$28166 = jCCellRange.end_column;
        if (this._$28165 > this.model.getNumRows()) {
            this._$28165 = this.model.getNumRows() - 1;
        }
        if (this._$28166 > this.model.getNumColumns()) {
            this._$28166 = this.model.getNumColumns() - 1;
        }
    }

    public void copySelectionToClipBoard() {
        JCCellRange jCCellRange2 = null;
        String string = null;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            this._$27852 = this.table.getSelectedCells();
            for (JCCellRange jCCellRange2 : this._$27852) {
                this._$14379(jCCellRange2);
                for (int i2 = jCCellRange2.start_row; i2 <= this._$28165; ++i2) {
                    for (int i3 = jCCellRange2.start_column; i3 <= this._$28166; ++i3) {
                        string = this.table.getDataView().getObject(i2, i3).toString();
                        if (string == null) {
                            string = EMPTY_STRING;
                        } else {
                            string = string.replace('\t', ' ');
                            string = string.replace('\n', ' ');
                        }
                        if (string == NULL) continue;
                        stringBuffer.append(string);
                        if (i3 < this._$28166) {
                            stringBuffer.append(TAB);
                        }
                        if (i3 != this._$28166) continue;
                        stringBuffer.append(NEWLINE);
                    }
                }
            }
            this._$28167 = new StringSelection(stringBuffer.toString());
            this._$28164 = Toolkit.getDefaultToolkit().getSystemClipboard();
            this._$28164.setContents(this._$28167, this._$28167);
        }
        catch (NullPointerException nullPointerException) {
            Toolkit.getDefaultToolkit().beep();
        }
        this._$28167 = null;
    }

    public String getPathSuffixWithIndex(ObjectID objectID) {
        Pair pair = null;
        try {
            pair = this._$7308.getSplittedObjectID(objectID);
            if (pair.second != null && ((ObjectID)pair.second).size() > 0) {
                ObjectID objectID2 = (ObjectID)pair.first;
                ObjectID objectID3 = (ObjectID)pair.second;
                MIBObject mIBObject = this._$7308.getObject(objectID2);
                MIBObjectType mIBObjectType = (MIBObjectType)this._$7308.getParent(mIBObject);
                if (mIBObjectType != null) {
                    IndexStruct[] indexStructArray;
                    if (mIBObjectType.getIndexPart().isAugment()) {
                        mIBObjectType = (MIBObjectType)this._$7308.getObject(mIBObjectType.getIndexPart().getIndexPart()[0]);
                    }
                    if ((indexStructArray = mIBObjectType.getIndexPart().getIndexStruct(this._$7308)) != null) {
                        try {
                            ObjectID[] objectIDArray = this._$7308.getIndexObjectIDs(objectID3, indexStructArray);
                            ValueConverter[] valueConverterArray = this._$24307(mIBObjectType);
                            return mIBObject.getName() + "." + IndexConverter.getIndexString(valueConverterArray, indexStructArray, objectIDArray);
                        }
                        catch (NullPointerException nullPointerException) {}
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this._$7308.getPathSuffix(objectID);
    }

    private ValueConverter[] _$24307(MIBObjectType mIBObjectType) {
        if (!mIBObjectType.isTable()) {
            return null;
        }
        Vector<? extends MIBObjectType> vector = this._$7308.getColumnarObjectsOfTable(mIBObjectType, true, false);
        if (mIBObjectType.userObject instanceof ValueConverter[]) {
            return (ValueConverter[])mIBObjectType.userObject;
        }
        ValueConverter[] valueConverterArray = new ValueConverter[vector.size()];
        for (int i2 = 0; i2 < valueConverterArray.length; ++i2) {
            MIBObjectType mIBObjectType2 = vector.elementAt(i2);
            MIBTextualConvention mIBTextualConvention = this._$7308.getEffectiveSyntax(mIBObjectType2.getSyntax());
            valueConverterArray[i2] = new ValueConverter(mIBObjectType2, mIBTextualConvention.getSyntax(), mIBTextualConvention.getDisplayHint());
        }
        mIBObjectType.userObject = valueConverterArray;
        return valueConverterArray;
    }

    public void cellDisplay(JCCellDisplayEvent jCCellDisplayEvent) {
        try {
            int n2 = jCCellDisplayEvent.getRow();
            int n3 = jCCellDisplayEvent.getColumn();
            if (n3 == 1 && n2 != -1 && jCCellDisplayEvent.getDisplayData() != null) {
                jCCellDisplayEvent.setDisplayData(BrowsePanel.getSyntaxString((Integer)jCCellDisplayEvent.getDisplayData()));
                return;
            }
            if (n3 != 2 && n3 != 0 || n2 == -1 || jCCellDisplayEvent.getDisplayData() == null) {
                return;
            }
            if (n3 == 0) {
                if (!this._$28178 && jCCellDisplayEvent.getDisplayData() instanceof ObjectID) {
                    ObjectID objectID = (ObjectID)jCCellDisplayEvent.getCellData();
                    String string = this._$7308.getObjectName(objectID);
                    if (string == null) {
                        string = this.getPathSuffixWithIndex(objectID);
                    }
                    if (string != null) {
                        jCCellDisplayEvent.setDisplayData(string);
                    }
                }
                return;
            }
            ValueConverter valueConverter = (ValueConverter)this.model.getTableDataItem(n2, 4);
            if (valueConverter != null && valueConverter.getEffectiveSyntax().hasEnums()) {
                if (jCCellDisplayEvent.getDisplayData() instanceof Integer) {
                    Integer n4 = (Integer)jCCellDisplayEvent.getDisplayData();
                    if (n4 == null) {
                        return;
                    }
                    MIBEnum mIBEnum = valueConverter.getEffectiveSyntax().getEnum(n4.intValue());
                    if (mIBEnum != null) {
                        jCCellDisplayEvent.setDisplayData(mIBEnum.toString());
                    }
                }
            } else if (valueConverter != null && valueConverter.getSMISyntax() == 11 && jCCellDisplayEvent.getCellData() instanceof Long) {
                jCCellDisplayEvent.setDisplayData(new TimeTicks((Long)jCCellDisplayEvent.getCellData()).toString());
            } else if (!(jCCellDisplayEvent.getDisplayData() instanceof ComparableIpAddress)) {
                if (!this._$28178 && jCCellDisplayEvent.getDisplayData() instanceof ObjectID) {
                    ObjectID objectID = (ObjectID)jCCellDisplayEvent.getCellData();
                    String string = this._$7308.getObjectName(objectID);
                    if (string == null) {
                        string = this._$7308.getPathSuffix(objectID);
                    }
                    if (string != null) {
                        jCCellDisplayEvent.setDisplayData(string);
                    }
                } else if (valueConverter != null && valueConverter.getDisplayHint() == null && jCCellDisplayEvent.getDisplayData() instanceof String && valueConverter.getEffectiveSyntax().getSyntax().equals(SMI.SMI_SYNTAX[1])) {
                    OctetString octetString = (OctetString)valueConverter.fromNative(jCCellDisplayEvent.getDisplayData());
                    jCCellDisplayEvent.setDisplayData(octetString.toHexString());
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setNumRows(int n2) {
        this.model.setNumRows(n2);
        this.table.setVisibleRows(n2);
    }

    void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.add((Component)this.table, "Center");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        JCEditableVectorDataSource jCEditableVectorDataSource = this.model;
        synchronized (jCEditableVectorDataSource) {
            this._$25705.reset();
            this.table.setRepaintEnabled(false);
            this.model.deleteRows(0, this.model.getNumRows());
            this.table.setRepaintEnabled(true);
            this._$14354();
        }
    }

    public void set(Vector vector, final int n2, final int n3) {
        this.table.setVisibleRows(vector.size());
        final Updater updater = new Updater(vector);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                updater.run();
                if (n2 != 0 && n3 - 1 >= 0 && n3 - 1 < BrowsePanel.this.model.getNumRows()) {
                    BrowsePanel.this.table.setCellStyle(n3 - 1, -997, _$28173);
                }
            }
        });
    }

    public void browse(GenTarget genTarget, OID oID, boolean bl, int n2, boolean bl2) {
        block5: {
            this.clear();
            this._$28180 = this._$21169.getRequestedValuesLimit();
            this._$15220 = genTarget.getTarget();
            if (this._$15220 == null) {
                this._$21169.setMessage("Timeout on engine ID discovery!");
                return;
            }
            this._$15238 = genTarget;
            this._$28179 = 0;
            this.table.setRepaintEnabled(bl2);
            try {
                PDU pDU = genTarget.makePDU();
                VariableBinding[] variableBindingArray = new VariableBinding[]{new VariableBinding()};
                variableBindingArray[0].setOid(oID);
                pDU.addAll(variableBindingArray);
                pDU.setMaxRepetitions(n2);
                if (bl) {
                    this._$21169.request(-91, pDU, genTarget, this._$15220, oID, this, null);
                } else {
                    this._$21169.request(-91, pDU, genTarget, this._$15220, null, this, null);
                }
            }
            catch (Exception exception) {
                this.table.setRepaintEnabled(true);
                this._$21169.requestFinishedWithError("Request failed: " + exception.getMessage());
                if (!SnmpLogger.cGetBulkReq.isDebugEnabled()) break block5;
                exception.printStackTrace();
            }
        }
    }

    public synchronized void onResponse(ResponseEvent responseEvent) {
        try {
            this._$14889.cancel(responseEvent.getRequest(), this);
            if (this._$21169.isRequestCanceled()) {
                this.table.setRepaintEnabled(true);
                return;
            }
            if (!this._$12571.logResponse(responseEvent, this._$21169)) {
                this.table.setRepaintEnabled(true);
            } else if (responseEvent.getRequest().getType() != -93) {
                if (responseEvent.getResponse() == null || responseEvent.getRequest().getErrorStatus() != 0) {
                    if (responseEvent.getResponse() == null) {
                        this._$21169.requestFinishedWithError("SET request timed out.");
                    } else {
                        this._$21169.requestFinishedWithError(PDU.toErrorStatusText(responseEvent.getResponse().getErrorStatus()));
                    }
                } else {
                    OID oID = (OID)responseEvent.getUserObject();
                    VariableBinding[] variableBindingArray = responseEvent.getResponse().toArray();
                    this._$28179 += variableBindingArray.length;
                    Updater updater = new Updater(this.makeRow(new ObjectID(oID.toString()), variableBindingArray));
                    SwingUtilities.invokeLater(updater);
                    if (!(variableBindingArray.length <= 0 || variableBindingArray[variableBindingArray.length - 1].isException() || oID != null && variableBindingArray[variableBindingArray.length - 1].getOid().leftMostCompare(oID.size(), oID) != 0)) {
                        PDU pDU = responseEvent.getRequest();
                        pDU.clear();
                        VariableBinding[] variableBindingArray2 = new VariableBinding[]{new VariableBinding()};
                        variableBindingArray2[0].setOid(variableBindingArray[variableBindingArray.length - 1].getOid());
                        pDU.addAll(variableBindingArray2);
                        if (this._$28180 > 0 && this._$28179 > this._$28180) {
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    BrowsePanel.this.display();
                                    BrowsePanel.this._$21169.requestFinished();
                                    BrowsePanel.this._$21169.setMessage("Browse limit " + BrowsePanel.this._$28180 + " reached. Browse stopped. Use Settings>General to change limit.");
                                }
                            });
                        }
                        try {
                            this._$21169.resendRequest(-91, pDU, this._$15238, this._$15220, oID, this, "Received " + this._$28179 + " instances...");
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    } else {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                BrowsePanel.this.display();
                                BrowsePanel.this._$21169.requestFinished();
                            }
                        });
                    }
                }
            } else if (responseEvent.getResponse() == null || responseEvent.getRequest().getErrorStatus() != 0) {
                if (responseEvent.getResponse() == null) {
                    this._$21169.requestFinishedWithError("SET request timed out.");
                } else {
                    this._$21169.requestFinishedWithError(PDU.toErrorStatusText(responseEvent.getResponse().getErrorStatus()));
                }
            } else {
                this._$21169.requestFinished();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void display() {
        this.table.setRepaintEnabled(true);
    }

    public Vector makeRow(ObjectID objectID, VariableBinding[] variableBindingArray) {
        Vector<Serializable> vector = new Vector<Serializable>(variableBindingArray.length + 1);
        ValueConverter valueConverter = null;
        MIBObjectType mIBObjectType = null;
        for (int i2 = 0; i2 < variableBindingArray.length; ++i2) {
            Serializable serializable;
            MIBObjectType mIBObjectType2 = null;
            Variable variable = variableBindingArray[i2].getVariable();
            Object object = ((Object)variable).toString();
            ObjectID objectID2 = new ObjectID(variableBindingArray[i2].getOid().toString());
            if (variable == null || objectID != null && !objectID.isRootOf(objectID2)) continue;
            mIBObjectType2 = this._$7308.getObjectType(objectID2);
            boolean bl = false;
            boolean bl2 = false;
            if (variable.isException()) {
                object = ValueConverter.getExceptionString(variable.getSyntax());
            } else if (mIBObjectType2 != null) {
                bl = true;
                if (mIBObjectType == null || !mIBObjectType2.equals(mIBObjectType)) {
                    mIBObjectType = mIBObjectType2;
                    if (mIBObjectType2.getSyntax() == null) continue;
                    serializable = this._$7308.getEffectiveSyntax(mIBObjectType2.getSyntax());
                    valueConverter = new ValueConverter(mIBObjectType2, ((MIBTextualConvention)serializable).getSyntax(), ((MIBTextualConvention)serializable).getDisplayHint());
                }
                if (!valueConverter.isSyntaxCompatible(variable.getSyntax())) {
                    object = ((Object)variable).toString();
                    bl2 = true;
                } else {
                    object = valueConverter.toNative(variable);
                    if (object == null) {
                        object = ((Object)variable).toString();
                    }
                }
            } else if (variableBindingArray[i2].getVariable() instanceof OID) {
                serializable = new ObjectID(((OID)variable).toString());
                object = serializable;
            } else if (variable instanceof OctetString) {
                valueConverter = new ValueConverter(OctetString.class);
                object = valueConverter.toNative(variable);
                bl = true;
            }
            serializable = new Vector<Comparable>(_$1713.length);
            ((Vector)serializable).addElement(objectID2);
            ((Vector)serializable).addElement(new Integer(variable.getSyntax()));
            ((Vector)serializable).addElement(object);
            ((Vector)serializable).add(variable);
            if (bl) {
                ((Vector)serializable).addElement(valueConverter);
            }
            if (bl2) {
                ((Vector)serializable).addElement(new Integer(1));
            }
            vector.addElement(serializable);
        }
        return vector;
    }

    public void setDisplayOID(boolean bl) {
        this._$28178 = bl;
    }

    public boolean isDisplayOID() {
        return this._$28178;
    }

    public void setRepository(MIBRepository mIBRepository) {
        this._$7308 = mIBRepository;
    }

    public MIBRepository getRepository() {
        return this._$7308;
    }

    public static String getSyntaxString(int n2) {
        return AbstractVariable.getSyntaxString(n2);
    }

    public void setTarget(Target target) {
        this._$15220 = target;
    }

    public Target getTarget() {
        return this._$15220;
    }

    public synchronized int saveToFile(File file) throws IOException {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        for (int i2 = 0; i2 < this.model.getNumRows(); ++i2) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.model.getTableRowLabel(i2).toString());
            stringBuffer.append(": ");
            stringBuffer.append(this.model.getTableDataItem(i2, 0).toString());
            stringBuffer.append(" {");
            stringBuffer.append(BrowsePanel.getSyntaxString((Integer)this.model.getTableDataItem(i2, 1)));
            stringBuffer.append("} = ");
            stringBuffer.append(this.model.getTableDataItem(i2, 2).toString());
            stringBuffer.append('\n');
            bufferedOutputStream.write(stringBuffer.toString().getBytes());
        }
        bufferedOutputStream.flush();
        bufferedOutputStream.close();
        return this.model.getNumRows();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() > 0) {
            JCCellPosition jCCellPosition = this.table.XYToCell(mouseEvent.getPoint().x, mouseEvent.getPoint().y);
            if (jCCellPosition == null || jCCellPosition.column != 0 || jCCellPosition.row < 0) {
                return;
            }
            ObjectID objectID = (ObjectID)this.model.getTableDataItem(jCCellPosition.row, 0);
            try {
                Pair pair = this._$7308.getSplittedObjectID(objectID);
                if (pair.second == null) {
                    return;
                }
                MIBObject mIBObject = this._$7308.getObject((ObjectID)pair.first);
                if (mIBObject == null) {
                    return;
                }
                this.fireMIBObjectEvent(new MIBObjectEvent(this, mIBObject, 0));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void changedMIBObject(MIBObjectEvent mIBObjectEvent) {
    }

    public synchronized void removeMIBObjectListener(MIBObjectListener mIBObjectListener) {
        if (this._$25771 != null && this._$25771.contains(mIBObjectListener)) {
            Vector vector = (Vector)this._$25771.clone();
            vector.removeElement(mIBObjectListener);
            this._$25771 = vector;
        }
    }

    public synchronized void addMIBObjectListener(MIBObjectListener mIBObjectListener) {
        Vector vector;
        Vector vector2 = vector = this._$25771 == null ? new Vector(2) : (Vector)this._$25771.clone();
        if (!vector.contains(mIBObjectListener)) {
            vector.addElement(mIBObjectListener);
            this._$25771 = vector;
        }
    }

    public synchronized void fireMIBObjectEvent(MIBObjectEvent mIBObjectEvent) {
        Enumeration enumeration = this._$25771.elements();
        while (enumeration.hasMoreElements()) {
            ((MIBObjectListener)enumeration.nextElement()).changedMIBObject(mIBObjectEvent);
        }
    }

    private void _$17293(int[] nArray, String string, boolean bl) {
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            ValueConverter valueConverter;
            int n2 = nArray[i2];
            if (n2 < 0 || (valueConverter = (ValueConverter)this.model.getTableDataItem(n2, 4)) == null || bl && valueConverter.getDisplayHint() != null || !SMI.isString(valueConverter.getEffectiveSyntax().getSyntax())) continue;
            this.table.commitEdit(true);
            valueConverter = new ValueConverter(valueConverter);
            this.model.setTableDataItem(valueConverter, n2, 4);
            Variable variable = valueConverter.fromNative(this.model.getTableDataItem(n2, 2));
            if (string == null) {
                MIBTextualConvention mIBTextualConvention = this._$7308.getEffectiveSyntax(valueConverter.getObjectType().getSyntax());
                if (mIBTextualConvention.getDisplayHint() != null) {
                    valueConverter.setDisplayHint(MIBObject.getUnquotedString(mIBTextualConvention.getDisplayHint()));
                } else {
                    valueConverter.setDisplayHint(null);
                }
            } else {
                valueConverter.setDisplayHint(string);
            }
            this.model.setTableDataItem(valueConverter.toNative(variable), n2, 2);
        }
    }

    private int _$1241(int n2, int n3) {
        return n2;
    }

    private int _$25810(int n2, int n3) {
        return n3;
    }

    private void _$5384(int n2, int n3, JCCellStyle jCCellStyle) {
        this.table.setCellStyle(n2, n3, jCCellStyle);
    }

    private JCTableCellInfo _$25986(int n2, int n3) {
        JCTableCellInfo jCTableCellInfo = new JCTableCellInfo();
        jCTableCellInfo.initialize(this.table, this.model.getTableDataItem(n2, n3), n2, n3, this.table.getCellStyle(n3, n2));
        return jCTableCellInfo;
    }

    public void beforeEditCell(JCEditCellEvent jCEditCellEvent) {
        int n2;
        int n3 = this._$1241(jCEditCellEvent.getRow(), jCEditCellEvent.getColumn());
        int n4 = this._$25810(jCEditCellEvent.getRow(), jCEditCellEvent.getColumn());
        if (n4 == 1 && (n2 = ((Integer)this.model.getTableDataItem(n3, n4)).intValue()) < 0) {
            this.model.setTableDataItem(new Integer(1), n3, n4);
        }
        this._$25707 = new CellEdit(this._$25986(n3, n4), this.model.getTableDataItem(n3, n4), null);
    }

    public void editCell(JCEditCellEvent jCEditCellEvent) {
    }

    public void afterEditCell(JCEditCellEvent jCEditCellEvent) {
        int n2 = this._$1241(jCEditCellEvent.getRow(), jCEditCellEvent.getColumn());
        int n3 = this._$25810(jCEditCellEvent.getRow(), jCEditCellEvent.getColumn());
        if (!jCEditCellEvent.isCancelled() && n3 == 1) {
            int n4 = (Integer)this.model.getTableDataItem(n2, n3);
            ValueConverter valueConverter = new ValueConverter(ValueConverter.getSmiSyntax(n4));
            this.model.setTableDataItem(valueConverter, n2, 4);
            this.model.setTableDataItem(valueConverter.getNativeExample(), n2, 2);
            JCCellStyle jCCellStyle = new JCCellStyle(this.table.getCellStyle(n2, 2));
            jCCellStyle.setCellEditor(MultiVariablePanel.getCellEditor(valueConverter, this._$7308));
            this._$5384(n2, 2, jCCellStyle);
        }
        Object object = this.model.getTableDataItem(n2, n3);
        this._$25707.setNewValue(object);
        this._$25705.addEdit(this._$25707);
        try {
            if (!this._$25707._$7155(object)) {
                this._$25705.undo();
                this._$21169.setMessage("Invalid value '" + object + "' entered, restored previous value.");
            }
        }
        catch (IOException iOException) {
            this._$25705.undo();
            this._$21169.setMessage("Failed to set value '" + object + "': " + iOException.getMessage());
        }
        this._$14354();
    }

    private void _$14354() {
        this._$28175.setEnabled(this._$25705.canUndo());
        this._$28176.setEnabled(this._$25705.canRedo());
    }

    public void traverse(int n2, int n3, boolean bl, boolean bl2) {
        this.table.traverse(n2, n3, bl, bl2);
    }

    public String getSelectedOID() {
        int n2 = TableUtils.getFirstSelectedRow(this.table);
        if (n2 >= 0) {
            return this.model.getTableDataItem(n2, 0).toString();
        }
        return null;
    }

    public boolean search(Regex regex, boolean bl) {
        if (bl) {
            for (int i2 = 0; i2 < this.model.getNumRows(); ++i2) {
                if (!this._$28211(regex, i2)) continue;
                this.table.setRowSelection(i2, i2);
                this.table.traverse(i2, 2, false, false);
                return true;
            }
        } else {
            for (int i3 = this.model.getNumRows() - 1; i3 >= 0; --i3) {
                if (!this._$28211(regex, i3)) continue;
                this.table.setRowSelection(i3, i3);
                this.table.traverse(i3, 2, false, false);
                return true;
            }
        }
        return false;
    }

    public boolean searchAgain(Regex regex, boolean bl) {
        int n2 = TableUtils.getFirstSelectedRow(this.table);
        if (bl) {
            int n3 = 0;
            if (n2 > 0) {
                n3 = n2 + 1;
            }
            for (int i2 = n3; i2 < this.model.getNumRows(); ++i2) {
                if (!this._$28211(regex, i2)) continue;
                this.table.setRowSelection(i2, i2);
                this.table.traverse(i2, 2, false, false);
                return true;
            }
        } else {
            int n4 = this.model.getNumRows() - 1;
            if (n2 >= 0) {
                n4 = n2 - 1;
            }
            for (int i3 = n4; i3 >= 0; --i3) {
                if (!this._$28211(regex, i3)) continue;
                this.table.setRowSelection(i3, i3);
                this.table.traverse(i3, 2, false, false);
                return true;
            }
        }
        return false;
    }

    private boolean _$28211(Regex regex, int n2) {
        for (int i2 = 0; i2 < 3; ++i2) {
            Object object = this.table.getDataView().getTableDataItem(n2, i2);
            if (object == null || !regex.match(object.toString())) continue;
            return true;
        }
        return false;
    }

    class CellEdit
    extends AbstractUndoableEdit {
        public JCTableCellInfo info;
        public Object oldValue;
        public Object newValue;

        public CellEdit(JCTableCellInfo jCTableCellInfo, Object object, Object object2) {
            this.info = jCTableCellInfo;
            this.oldValue = object;
            this.newValue = object2;
        }

        public void undo() {
            super.undo();
            if (!BrowsePanel.this.model.setTableDataItem(this.oldValue, this.info.getRow(), this.info.getColumn())) {
                throw new CannotUndoException();
            }
            BrowsePanel.this.traverse(this.info.getRow(), this.info.getColumn(), false, true);
            try {
                this._$7155(this.oldValue);
            }
            catch (IOException iOException) {
                throw new CannotUndoException();
            }
            BrowsePanel.this._$14354();
        }

        private boolean _$7155(Object object) throws IOException {
            PDU pDU = BrowsePanel.this._$15238.makePDU();
            VariableBinding variableBinding = this._$28208(object);
            if (variableBinding != null) {
                pDU.add(variableBinding);
                BrowsePanel.this._$21169.request(-93, pDU, BrowsePanel.this._$15238, BrowsePanel.this._$15220, null, BrowsePanel.this, "Setting " + variableBinding);
                return true;
            }
            return false;
        }

        public void redo() {
            super.redo();
            if (!BrowsePanel.this.model.setTableDataItem(this.newValue, this.info.getRow(), this.info.getColumn())) {
                throw new CannotRedoException();
            }
            BrowsePanel.this.traverse(this.info.getRow(), this.info.getColumn(), false, true);
            try {
                this._$7155(this.oldValue);
            }
            catch (IOException iOException) {
                throw new CannotRedoException();
            }
            BrowsePanel.this._$14354();
        }

        public void setNewValue(Object object) {
            this.newValue = object;
        }

        private VariableBinding _$28208(Object object) {
            ObjectID objectID = (ObjectID)BrowsePanel.this.model.getTableDataItem(this.info.getRow(), 0);
            VariableBinding variableBinding = null;
            try {
                Variable variable;
                variableBinding = new VariableBinding(new OID(objectID.asIntArray()));
                ValueConverter valueConverter = (ValueConverter)BrowsePanel.this.model.getTableDataItem(this.info.getRow(), 4);
                if (valueConverter == null) {
                    valueConverter = new ValueConverter(ValueConverter.getSmiSyntax((Integer)BrowsePanel.this.model.getTableDataItem(this.info.getRow(), 1)));
                }
                if ((variable = valueConverter.fromNative(object)) == null) {
                    return null;
                }
                variableBinding.setVariable(variable);
                return variableBinding;
            }
            catch (ObjectIDFormatException objectIDFormatException) {
                return null;
            }
        }
    }

    class FormatAction
    extends AbstractAction {
        private String _$7197;

        public FormatAction(String string, String string2) {
            super(string);
            this._$7197 = string2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JCCellPosition jCCellPosition = BrowsePanel.this.table.getPopupCellPosition();
            int[] nArray = TableUtils.getSelectedRows(BrowsePanel.this.table);
            if (nArray.length == 0) {
                nArray = new int[]{jCCellPosition.row};
            }
            BrowsePanel.this._$17293(nArray, this._$7197, false);
        }
    }

    class Updater
    implements Runnable {
        private Vector _$5396;

        public Updater(Vector vector) {
            this._$5396 = vector;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void run() {
            JCEditableVectorDataSource jCEditableVectorDataSource = BrowsePanel.this.model;
            synchronized (jCEditableVectorDataSource) {
                Enumeration enumeration = this._$5396.elements();
                while (enumeration.hasMoreElements()) {
                    Vector vector = (Vector)enumeration.nextElement();
                    ValueConverter valueConverter = null;
                    if (vector.size() > 4) {
                        valueConverter = (ValueConverter)vector.get(4);
                    }
                    boolean bl = vector.size() == _$1713.length - 1 || valueConverter.getObjectType() == null;
                    int n2 = 0;
                    if (vector.size() >= _$1713.length + 1) {
                        n2 = (Integer)vector.get(_$1713.length);
                        vector.removeElementAt(_$1713.length);
                    }
                    BrowsePanel.this.model.addRow(Integer.MAX_VALUE, new Integer(BrowsePanel.this.model.getNumRows() + 1), vector);
                    if (bl) {
                        BrowsePanel.this.table.setCellStyle(BrowsePanel.this.model.getNumRows() - 1, -997, _$28172);
                        if (BrowsePanel.this._$11764) {
                            BrowsePanel.this.table.setCellStyle(BrowsePanel.this.model.getNumRows() - 1, 2, BrowsePanel.this._$25703);
                        }
                    } else if (BrowsePanel.this._$11764 && valueConverter != null && (BrowsePanel.this._$28177 || valueConverter.isWritable())) {
                        BrowsePanel.this.table.setCellStyle(BrowsePanel.this.model.getNumRows() - 1, 2, BrowsePanel.this._$25703);
                    }
                    if (n2 != 0) {
                        BrowsePanel.this.table.setCellStyle(BrowsePanel.this.model.getNumRows() - 1, -997, _$28173);
                    }
                    if (BrowsePanel.this._$17278 == null || !(vector.get(3) instanceof OctetString)) continue;
                    BrowsePanel.this._$17293(new int[]{BrowsePanel.this.model.getNumRows() - 1}, BrowsePanel.this._$17278, true);
                }
            }
        }
    }
}

