/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.commons.snmp.editor;

import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.ObjectID;
import com.agentpp.mib.ObjectIDFormatException;
import com.klg.jclass.cell.editors.JCStringCellEditor;
import com.klg.jclass.cell.validate.JCValidateEvent;
import com.klg.jclass.cell.validate.JCValidateListener;
import org.snmp4j.smi.OID;

public class OidCellEditor
extends JCStringCellEditor
implements JCValidateListener {
    private MIBRepository rep;

    public OidCellEditor() {
        this.rep = null;
        this.addValidateListener(this);
    }

    public OidCellEditor(MIBRepository r2) {
        this.rep = r2;
        this.addValidateListener(this);
    }

    public void setRepository(MIBRepository rep) {
        this.rep = rep;
    }

    public MIBRepository getRepository() {
        return this.rep;
    }

    @Override
    public Object getCellEditorValue() {
        String s = super.getCellEditorValue().toString();
        try {
            return new OID(new ObjectID(s).asIntArray());
        }
        catch (ObjectIDFormatException e2) {
            if (this.rep != null) {
                ObjectID objectID = this.rep.getObjectID(s);
                if (objectID == null) {
                    return new OID();
                }
                if (objectID.isValid()) {
                    return new OID(objectID.toString());
                }
            }
            return null;
        }
    }

    @Override
    public void stateIsInvalid(JCValidateEvent e2) {
    }

    @Override
    public void valueChangedBegin(JCValidateEvent e2) {
        String s = e2.getValue().toString();
        ObjectID id = new ObjectID(s);
        if (!id.isValid() && !ObjectID.isIdentifier(s)) {
            e2.setBeep(true);
            e2.setValid(false);
        } else if (ObjectID.isIdentifier(s)) {
            id = this.rep == null ? null : this.rep.getObjectID(s);
            if (id != null) {
                e2.setValue(id.toString());
            } else {
                e2.setBeep(true);
                e2.setValid(false);
            }
        }
    }

    @Override
    public void valueChangedEnd(JCValidateEvent e2) {
    }
}

