/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.commons.snmp;

import com.agentpp.commons.ui.OctetStringField;
import com.agentpp.commons.ui.UIObjectUpdateListener;
import com.agentpp.snmp.GenTarget;
import com.agentpp.snmp.UserProfile;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import org.snmp4j.smi.OctetString;

public class TargetEditorPanel {
    private JLabel targetNameLabel;
    private JTextField targetNameField;
    private JLabel transportLabel;
    private JComboBox<String> transportComboBox;
    private JButton addressLabel;
    private JTextField addressTextField;
    private JLabel versionLabel;
    private JComboBox versionComboBox;
    private JLabel timeoutLabel;
    private JLabel retriesLabel;
    private JLabel mibSetLabel;
    private JComboBox<String> mibSetComboBox;
    private JPanel versionSpecificFieldPanel;
    private JPanel communityBasedPanel;
    private JLabel communityLabel;
    private JPanel userBasedPanel;
    private JLabel userLabel;
    private JComboBox<String> userComboBox;
    private JLabel contextNameLabel;
    private JLabel contextEngineIdLabel;
    private OctetStringField contextEngineID;
    private OctetStringField contextName;
    private JButton securityEngineIdLabel;
    private OctetStringField securityEngineID;
    private JSpinner timeout;
    private JSpinner retries;
    private OctetStringField community;
    private JPanel panel;
    private GenTarget target;
    private Map<String, UserProfile> userList = new HashMap<String, UserProfile>();
    private UIObjectUpdateListener<GenTarget> updateListener;
    private UpdateInputVerifier updateInputVerifier = new UpdateInputVerifier();
    private volatile boolean updating;

    public TargetEditorPanel() {
        this.$$$setupUI$$$();
        this.contextEngineID.setMode(OctetStringField.EditMode.Hex);
        this.securityEngineID.setMode(OctetStringField.EditMode.Hex);
        this.timeout.setModel(new SpinnerNumberModel((Number)5000, Integer.valueOf(1), null, (Number)1000));
        this.retries.setModel(new SpinnerNumberModel(1, 0, 100000, 1));
        this.targetNameField.setInputVerifier(this.updateInputVerifier);
        this.contextEngineID.setInputVerifier(this.updateInputVerifier);
        this.securityEngineID.setInputVerifier(this.updateInputVerifier);
        this.contextName.setInputVerifier(this.updateInputVerifier);
        this.community.setInputVerifier(this.updateInputVerifier);
        this.mibSetComboBox.setInputVerifier(this.updateInputVerifier);
        this.timeout.setInputVerifier(this.updateInputVerifier);
        this.retries.setInputVerifier(this.updateInputVerifier);
        this.addressTextField.setInputVerifier(this.updateInputVerifier);
        this.versionComboBox.setInputVerifier(this.updateInputVerifier);
        this.transportComboBox.setInputVerifier(this.updateInputVerifier);
        this.contextEngineID.setMinLength(5);
        this.contextEngineID.setMaxLength(32);
        this.contextEngineID.setEmptyAllowed(true);
        this.securityEngineID.setMinLength(5);
        this.securityEngineID.setMaxLength(32);
        this.securityEngineID.setEmptyAllowed(true);
        this.contextEngineID.setMode(OctetStringField.EditMode.Hex);
        this.securityEngineID.setMode(OctetStringField.EditMode.Hex);
        this.setEnabled(false);
        this.versionComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e2) {
                if (e2.getStateChange() == 1) {
                    if (TargetEditorPanel.getSnmpVersionFromIndex(TargetEditorPanel.this.versionComboBox.getSelectedIndex()) == 3) {
                        TargetEditorPanel.this.showUserBased();
                    } else {
                        TargetEditorPanel.this.showCommunityBased();
                    }
                }
                TargetEditorPanel.this.updateInputVerifier.verify(TargetEditorPanel.this.versionComboBox);
            }
        });
        this.userComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e2) {
                if (e2.getStateChange() == 1) {
                    TargetEditorPanel.this.updateInputVerifier.verify(TargetEditorPanel.this.userComboBox);
                }
            }
        });
    }

    public void setEnabled(boolean enabled) {
        this.targetNameField.setEnabled(enabled);
        this.contextEngineID.setEnabled(enabled);
        this.securityEngineID.setEnabled(enabled);
        this.contextName.setEnabled(enabled);
        this.community.setEnabled(enabled);
        this.mibSetComboBox.setEnabled(enabled);
        this.timeout.setEnabled(enabled);
        this.retries.setEnabled(enabled);
        this.addressTextField.setEnabled(enabled);
        this.versionComboBox.setEnabled(enabled);
        this.transportComboBox.setEnabled(enabled);
        this.userComboBox.setEnabled(enabled);
        this.addressLabel.setEnabled(enabled);
        this.securityEngineIdLabel.setEnabled(enabled);
    }

    public void setUserList(Collection<UserProfile> userList) {
        this.userComboBox.removeAllItems();
        this.userComboBox.addItem(null);
        this.userList.clear();
        for (UserProfile userProfile : userList) {
            this.userList.put(userProfile.getName(), userProfile);
        }
        ArrayList<String> sortedUserList = new ArrayList<String>(this.userList.keySet());
        Collections.sort(sortedUserList);
        for (String userName : sortedUserList) {
            this.userComboBox.addItem(userName);
        }
    }

    public void addActionListener(ActionListener l2) {
        this.securityEngineIdLabel.addActionListener(l2);
        this.addressLabel.addActionListener(l2);
    }

    public void setMibSetList(Collection<String> mibSetList) {
        this.mibSetComboBox.removeAllItems();
        for (String mibSet : mibSetList) {
            this.mibSetComboBox.addItem(mibSet);
        }
    }

    public void setTransportList(Collection<String> transportList) {
        this.transportComboBox.removeAllItems();
        for (String transportID : transportList) {
            this.transportComboBox.addItem(transportID);
        }
    }

    public void setTarget(GenTarget target) {
        this.updateFields(target);
        if (target == null || target.getVersion() == 3) {
            this.showUserBased();
        } else {
            this.showCommunityBased();
        }
        this.targetNameField.setBackground(Color.white);
        this.setEnabled(target != null);
    }

    private void showCommunityBased() {
        ((CardLayout)this.versionSpecificFieldPanel.getLayout()).show(this.versionSpecificFieldPanel, "Community Based");
    }

    private void showUserBased() {
        ((CardLayout)this.versionSpecificFieldPanel.getLayout()).show(this.versionSpecificFieldPanel, "User Based");
    }

    public UIObjectUpdateListener<GenTarget> getUpdateListener() {
        return this.updateListener;
    }

    public void setUpdateListener(UIObjectUpdateListener<GenTarget> updateListener) {
        this.updateListener = updateListener;
    }

    public GenTarget getTarget() {
        if (this.target == null) {
            return null;
        }
        GenTarget target = new GenTarget(this.target);
        this.updateTarget(target);
        return target;
    }

    public GenTarget updateTarget() {
        this.updateTarget(this.target);
        return this.target;
    }

    private void updateTarget(GenTarget target) {
        target.setName(this.targetNameField.getText());
        target.setAddressString(this.addressTextField.getText());
        target.setAddressType((String)this.transportComboBox.getSelectedItem());
        target.setCommunity(this.community.getOctetString());
        target.setContext(this.contextName.getOctetString());
        target.setEngineID(this.securityEngineID.getOctetString());
        target.setMIBSet((String)this.mibSetComboBox.getSelectedItem());
        target.setContextEngineID(this.contextEngineID.getOctetString());
        target.setRetries((Integer)this.retries.getValue());
        target.setTimeout((Integer)this.timeout.getValue());
        target.setUser(this.userComboBox.getSelectedItem() == null ? null : this.userList.get((String)this.userComboBox.getSelectedItem()));
        target.setVersion(TargetEditorPanel.getSnmpVersionFromIndex(this.versionComboBox.getSelectedIndex()));
    }

    public JPanel getPanel() {
        return this.panel;
    }

    private static int getSnmpVersionIndex(int snmpVersion) {
        if (snmpVersion >= 3) {
            return snmpVersion - 1;
        }
        return snmpVersion;
    }

    private static int getSnmpVersionFromIndex(int snmpVersionIndex) {
        if (snmpVersionIndex >= 2) {
            return snmpVersionIndex + 1;
        }
        return snmpVersionIndex;
    }

    private void updateFields(GenTarget target) {
        this.updating = true;
        if (target != null) {
            this.userComboBox.setSelectedItem(target.getUser() == null ? null : target.getUser().getName());
            this.targetNameField.setText(target.getName());
            this.transportComboBox.setSelectedItem(target.getAddressType());
            this.addressTextField.setText(target.getAddressString());
            this.timeout.setValue(target.getTimeout());
            this.retries.setValue(target.getRetries());
            this.versionComboBox.setSelectedIndex(TargetEditorPanel.getSnmpVersionIndex(target.getVersion()));
            this.mibSetComboBox.setSelectedItem(target.getMIBSet());
            this.community.setOctetString(target.getCommunity());
            this.contextName.setOctetString(target.getContext());
            this.contextEngineID.setOctetString(target.getContextEngineID());
            this.securityEngineID.setOctetString(target.getEngineID());
        } else {
            this.userComboBox.setSelectedItem(null);
            this.targetNameField.setText("");
            this.transportComboBox.setSelectedItem(null);
            this.addressTextField.setText("");
            this.timeout.setValue(0);
            this.retries.setValue(0);
            this.versionComboBox.setSelectedIndex(TargetEditorPanel.getSnmpVersionIndex(3));
            this.mibSetComboBox.setSelectedItem(null);
            this.community.setOctetString(new OctetString());
            this.contextName.setOctetString(new OctetString());
            this.contextEngineID.setOctetString(new OctetString());
            this.securityEngineID.setOctetString(new OctetString());
        }
        this.target = target;
        this.updating = false;
    }

    private void $$$setupUI$$$() {
        this.panel = new JPanel();
        this.panel.setLayout(new GridBagLayout());
        this.timeoutLabel = new JLabel();
        this.timeoutLabel.setText("Timeout:");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.panel.add((Component)this.timeoutLabel, gbc);
        JPanel spacer1 = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 4;
        gbc.gridy = 3;
        gbc.fill = 2;
        this.panel.add((Component)spacer1, gbc);
        this.versionSpecificFieldPanel = new JPanel();
        this.versionSpecificFieldPanel.setLayout(new CardLayout(0, 0));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.gridwidth = 10;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.panel.add((Component)this.versionSpecificFieldPanel, gbc);
        this.communityBasedPanel = new JPanel();
        this.communityBasedPanel.setLayout(new GridBagLayout());
        this.versionSpecificFieldPanel.add((Component)this.communityBasedPanel, "Community Based");
        JPanel spacer2 = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.fill = 3;
        this.communityBasedPanel.add((Component)spacer2, gbc);
        this.community = new OctetStringField();
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.communityBasedPanel.add((Component)this.community.$$$getRootComponent$$$(), gbc);
        this.communityLabel = new JLabel();
        this.communityLabel.setText("Community:");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.communityBasedPanel.add((Component)this.communityLabel, gbc);
        this.userBasedPanel = new JPanel();
        this.userBasedPanel.setLayout(new GridBagLayout());
        this.versionSpecificFieldPanel.add((Component)this.userBasedPanel, "User Based");
        this.userLabel = new JLabel();
        this.userLabel.setText("User:");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.userBasedPanel.add((Component)this.userLabel, gbc);
        JPanel spacer3 = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.fill = 2;
        this.userBasedPanel.add((Component)spacer3, gbc);
        this.userComboBox = new JComboBox();
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.weightx = 0.5;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.userBasedPanel.add(this.userComboBox, gbc);
        this.contextNameLabel = new JLabel();
        this.contextNameLabel.setText("Context:");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 17;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.userBasedPanel.add((Component)this.contextNameLabel, gbc);
        this.contextName = new OctetStringField();
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.weightx = 0.5;
        gbc.fill = 2;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.userBasedPanel.add((Component)this.contextName.$$$getRootComponent$$$(), gbc);
        this.securityEngineIdLabel = new JButton();
        this.securityEngineIdLabel.setActionCommand("Discover Engine ID");
        this.securityEngineIdLabel.setText("Engine ID:");
        this.securityEngineIdLabel.setToolTipText("Discover engine ID from target address");
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.userBasedPanel.add((Component)this.securityEngineIdLabel, gbc);
        this.securityEngineID = new OctetStringField();
        gbc = new GridBagConstraints();
        gbc.gridx = 4;
        gbc.gridy = 0;
        gbc.weightx = 0.5;
        gbc.fill = 2;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.userBasedPanel.add((Component)this.securityEngineID.$$$getRootComponent$$$(), gbc);
        this.contextEngineIdLabel = new JLabel();
        this.contextEngineIdLabel.setText("Context Engine ID:");
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 1;
        gbc.anchor = 17;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.userBasedPanel.add((Component)this.contextEngineIdLabel, gbc);
        this.contextEngineID = new OctetStringField();
        gbc = new GridBagConstraints();
        gbc.gridx = 4;
        gbc.gridy = 1;
        gbc.weightx = 0.5;
        gbc.fill = 2;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.userBasedPanel.add((Component)this.contextEngineID.$$$getRootComponent$$$(), gbc);
        this.timeout = new JSpinner();
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 2;
        gbc.gridwidth = 5;
        gbc.weightx = 0.5;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.panel.add((Component)this.timeout, gbc);
        this.retries = new JSpinner();
        gbc = new GridBagConstraints();
        gbc.gridx = 9;
        gbc.gridy = 2;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.panel.add((Component)this.retries, gbc);
        this.versionLabel = new JLabel();
        this.versionLabel.setText("Version:");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.panel.add((Component)this.versionLabel, gbc);
        this.versionComboBox = new JComboBox();
        DefaultComboBoxModel<String> defaultComboBoxModel1 = new DefaultComboBoxModel<String>();
        defaultComboBoxModel1.addElement("SNMPv1");
        defaultComboBoxModel1.addElement("SNMPv2c");
        defaultComboBoxModel1.addElement("SNMPv3");
        this.versionComboBox.setModel(defaultComboBoxModel1);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.weightx = 0.5;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.panel.add((Component)this.versionComboBox, gbc);
        this.transportLabel = new JLabel();
        this.transportLabel.setText("Transport:");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 17;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.panel.add((Component)this.transportLabel, gbc);
        this.transportComboBox = new JComboBox();
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 0.5;
        gbc.fill = 2;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.panel.add(this.transportComboBox, gbc);
        this.addressLabel = new JButton();
        this.addressLabel.setActionCommand("Test Connectivity");
        this.addressLabel.setText("Address:");
        this.addressLabel.setToolTipText("Test connectivity");
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.anchor = 17;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.panel.add((Component)this.addressLabel, gbc);
        this.addressTextField = new JTextField();
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 1;
        gbc.gridwidth = 7;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.panel.add((Component)this.addressTextField, gbc);
        this.targetNameLabel = new JLabel();
        this.targetNameLabel.setText("Name:");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.panel.add((Component)this.targetNameLabel, gbc);
        this.targetNameField = new JTextField();
        this.targetNameField.setEditable(true);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 7;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.panel.add((Component)this.targetNameField, gbc);
        this.mibSetLabel = new JLabel();
        this.mibSetLabel.setText("MIB Set:");
        gbc = new GridBagConstraints();
        gbc.gridx = 8;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.panel.add((Component)this.mibSetLabel, gbc);
        this.mibSetComboBox = new JComboBox();
        gbc = new GridBagConstraints();
        gbc.gridx = 9;
        gbc.gridy = 0;
        gbc.weightx = 0.5;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.panel.add(this.mibSetComboBox, gbc);
        this.retriesLabel = new JLabel();
        this.retriesLabel.setText("Retries:");
        gbc = new GridBagConstraints();
        gbc.gridx = 8;
        gbc.gridy = 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.panel.add((Component)this.retriesLabel, gbc);
    }

    public JComponent $$$getRootComponent$$$() {
        return this.panel;
    }

    private class UpdateInputVerifier
    extends InputVerifier {
        private UpdateInputVerifier() {
        }

        @Override
        public boolean verify(JComponent input) {
            boolean ok = true;
            if (!TargetEditorPanel.this.updating && TargetEditorPanel.this.target != null && TargetEditorPanel.this.updateListener != null) {
                try {
                    GenTarget target = TargetEditorPanel.this.getTarget();
                    if (target == null || !TargetEditorPanel.this.updateListener.uiObjectVerification(TargetEditorPanel.this, target, TargetEditorPanel.this.target)) {
                        ok = false;
                    } else {
                        TargetEditorPanel.this.updateTarget();
                        TargetEditorPanel.this.updateListener.uiObjectUpdated(TargetEditorPanel.this, TargetEditorPanel.this.target);
                    }
                }
                catch (IllegalArgumentException iax) {
                    ok = false;
                }
            }
            if (ok) {
                if (input.getBackground() == Color.pink) {
                    input.setBackground(Color.white);
                }
            } else if (input.getBackground() == Color.white) {
                input.setBackground(Color.pink);
            }
            return ok;
        }
    }
}

