/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.common.tree;

import com.agentpp.mib.MIBImport;
import com.agentpp.mib.MIBModule;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.ObjectID;
import com.klg.jclass.util.treetable.JCTreeTableModel;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class MIBTreeModel
implements JCTreeTableModel,
TableModel {
    private static final String[] _$23669 = new String[]{"MIB Tree", "Object ID", "Object Type", "Status"};
    static final int COL_OID = 1;
    static final int COL_TYPE = 2;
    static final int COL_STATUS = 3;
    private MIBRepository _$414;
    private TreeMap _$15552 = new TreeMap();
    private DefaultMutableTreeNode _$16198;
    private MIBTreeNode[] _$84;
    private transient Vector _$35363;
    private transient Vector _$35364;
    private boolean _$35334 = false;

    public Object getValueAt(Object node, int column) {
        DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode)node;
        MIBTreeNode values = (MIBTreeNode)dmtn.getUserObject();
        if (column == -1) {
            return values;
        }
        if (values != null) {
            return values.getColumn(column);
        }
        return null;
    }

    public boolean isCellEditable(Object parm1, int parm2) {
        return false;
    }

    public void setValueAt(Object parm1, Object parm2, int parm3) {
        throw new UnsupportedOperationException("Methode setValueAt() noch nicht implementiert.");
    }

    public Class getColumnClass(int column) {
        return String.class;
    }

    public int getColumnCount() {
        return _$23669.length;
    }

    public String getColumnName(int column) {
        return _$23669[column];
    }

    public Object getRoot() {
        return this._$16198;
    }

    public Object getChild(Object parent, int index) {
        return ((DefaultMutableTreeNode)parent).getChildAt(index);
    }

    public int getChildCount(Object parent) {
        return ((DefaultMutableTreeNode)parent).getChildCount();
    }

    public boolean isLeaf(Object node) {
        return ((DefaultMutableTreeNode)node).isLeaf();
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    public int getIndexOfChild(Object parent, Object child) {
        DefaultMutableTreeNode pNode = (DefaultMutableTreeNode)parent;
        DefaultMutableTreeNode cNode = (DefaultMutableTreeNode)child;
        if (pNode == null || cNode == null) {
            return -1;
        }
        return pNode.getIndex(cNode);
    }

    public MIBRepository getRepository() {
        return this._$414;
    }

    public boolean isRegisteredOnly() {
        return this._$35334;
    }

    public void setRepository(MIBRepository repository) {
        this._$414 = repository;
    }

    public void setRegisteredOnly(boolean registeredOnly) {
        this._$35334 = registeredOnly;
    }

    public int getRowCount() {
        return this._$15552.size();
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        return this._$84[rowIndex].getColumn(columnIndex);
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    private void _$35376(DefaultMutableTreeNode node, MIBTreeNode child) {
        boolean added = false;
        for (int i2 = 0; i2 < node.getChildCount(); ++i2) {
            DefaultMutableTreeNode n2 = (DefaultMutableTreeNode)node.getChildAt(i2);
            if (child.compareTo((MIBTreeNode)n2.getUserObject()) > 0) continue;
            node.insert(child.getNode(), i2);
            added = true;
            break;
        }
        if (!added) {
            node.add(child.getNode());
        }
    }

    public void buildTree(MIBModule module) {
        this._$15552.clear();
        this._$16198 = new DefaultMutableTreeNode();
        this._$35378(this._$16198, module);
        this._$84 = new MIBTreeNode[this._$15552.size()];
        int i2 = 0;
        Iterator it = this._$15552.values().iterator();
        while (it.hasNext()) {
            this._$84[i2] = (MIBTreeNode)it.next();
            ++i2;
        }
    }

    private void _$35378(DefaultMutableTreeNode root, MIBModule module) {
        MIBObject current;
        LinkedList<MIBObject> base = new LinkedList<MIBObject>();
        if (module.hasImports()) {
            MIBImport[] imports = (MIBImport[])module.getImports();
            for (int i2 = 0; i2 < imports.length; ++i2) {
                Enumeration<String> en = imports[i2].getImportsVector().elements();
                while (en.hasMoreElements()) {
                    String is = en.nextElement().toString();
                    current = this._$414.getObject(imports[i2].getSource(), is);
                    if (current == null || current.getOid().size() < 1) continue;
                    base.add(current);
                    MIBTreeNode childNode = new MIBTreeNode(current);
                    this._$15552.put(current.getObjectID(), childNode);
                    this._$35376(root, childNode);
                    this.buildSubTree(module, childNode.getNode(), this._$414.getChildren(current.getOid(), false));
                }
            }
        }
        current = null;
        Enumeration en = module.objectsByOid().elements();
        while (en.hasMoreElements()) {
            MIBObject parent;
            MIBObject o2 = (MIBObject)en.nextElement();
            if (current != null && current.getOid().isRootOf(o2.getOid()) || (parent = this._$414.getParent(current = o2)) != null) continue;
            DefaultMutableTreeNode child = new DefaultMutableTreeNode(current);
            MIBTreeNode childNode = new MIBTreeNode(current);
            this._$35376(root, childNode);
            this.buildSubTree(module, child, this._$414.getChildren(current));
        }
    }

    public int buildSubTree(MIBModule module, DefaultMutableTreeNode node, Vector children) {
        int i2 = 0;
        int n2 = 0;
        Enumeration e2 = children.elements();
        while (e2.hasMoreElements()) {
            MIBObject current = (MIBObject)e2.nextElement();
            if (!current.getModuleID().equals(module.getModuleID())) continue;
            MIBTreeNode childNode = new MIBTreeNode(current);
            this._$15552.put(current.getObjectID(), childNode);
            this._$35376(node, childNode);
            ++i2;
            ++n2;
            n2 += this.buildSubTree(module, childNode.getNode(), this._$414.getChildren(current));
        }
        return n2;
    }

    public synchronized void removeTreeModelListener(TreeModelListener l2) {
        if (this._$35363 != null && this._$35363.contains(l2)) {
            Vector v = (Vector)this._$35363.clone();
            v.removeElement(l2);
            this._$35363 = v;
        }
    }

    public synchronized void addTreeModelListener(TreeModelListener l2) {
        Vector v;
        Vector vector = v = this._$35363 == null ? new Vector(2) : (Vector)this._$35363.clone();
        if (!v.contains(l2)) {
            v.addElement(l2);
            this._$35363 = v;
        }
    }

    protected void fireTreeNodesChanged(TreeModelEvent e2) {
        if (this._$35363 != null) {
            Vector listeners = this._$35363;
            int count = listeners.size();
            for (int i2 = 0; i2 < count; ++i2) {
                ((TreeModelListener)listeners.elementAt(i2)).treeNodesChanged(e2);
            }
        }
    }

    protected void fireTreeNodesInserted(TreeModelEvent e2) {
        if (this._$35363 != null) {
            Vector listeners = this._$35363;
            int count = listeners.size();
            for (int i2 = 0; i2 < count; ++i2) {
                ((TreeModelListener)listeners.elementAt(i2)).treeNodesInserted(e2);
            }
        }
    }

    protected void fireTreeNodesRemoved(TreeModelEvent e2) {
        if (this._$35363 != null) {
            Vector listeners = this._$35363;
            int count = listeners.size();
            for (int i2 = 0; i2 < count; ++i2) {
                ((TreeModelListener)listeners.elementAt(i2)).treeNodesRemoved(e2);
            }
        }
    }

    protected void fireTreeStructureChanged(TreeModelEvent e2) {
        if (this._$35363 != null) {
            Vector listeners = this._$35363;
            int count = listeners.size();
            for (int i2 = 0; i2 < count; ++i2) {
                ((TreeModelListener)listeners.elementAt(i2)).treeStructureChanged(e2);
            }
        }
    }

    public synchronized void removeTableModelListener(TableModelListener l2) {
        if (this._$35364 != null && this._$35364.contains(l2)) {
            Vector v = (Vector)this._$35364.clone();
            v.removeElement(l2);
            this._$35364 = v;
        }
    }

    public synchronized void addTableModelListener(TableModelListener l2) {
        Vector v;
        Vector vector = v = this._$35364 == null ? new Vector(2) : (Vector)this._$35364.clone();
        if (!v.contains(l2)) {
            v.addElement(l2);
            this._$35364 = v;
        }
    }

    protected void fireTableChanged(TableModelEvent e2) {
        if (this._$35364 != null) {
            Vector listeners = this._$35364;
            int count = listeners.size();
            for (int i2 = 0; i2 < count; ++i2) {
                ((TableModelListener)listeners.elementAt(i2)).tableChanged(e2);
            }
        }
    }

    public static MIBTreeModel createModel(MIBRepository rep, MIBModule module, boolean registeredOnly) {
        MIBTreeModel mibTreeModel = new MIBTreeModel();
        mibTreeModel.setRegisteredOnly(registeredOnly);
        mibTreeModel.setRepository(rep);
        mibTreeModel.buildTree(module);
        return mibTreeModel;
    }

    class MIBTreeNode
    implements Comparable {
        private MIBObject _$27655;
        private DefaultMutableTreeNode _$15628;

        public MIBTreeNode(MIBObject ot) {
            this._$27655 = ot;
        }

        public MIBObject getMIBObject() {
            return this._$27655;
        }

        public int compareTo(Object o2) {
            return this._$27655.getOid().compareTo(((MIBTreeNode)o2).getOID());
        }

        public ObjectID getOID() {
            return this._$27655.getOid();
        }

        public DefaultMutableTreeNode getNode() {
            if (this._$15628 == null) {
                this._$15628 = new DefaultMutableTreeNode(this);
            }
            return this._$15628;
        }

        public void setNode(DefaultMutableTreeNode node) {
            this._$15628 = node;
        }

        public Object getColumn(int column) {
            switch (column) {
                case 0: {
                    String name = MIBTreeModel.this._$414.getPathSuffix(this.getOID());
                    return name;
                }
                case 1: {
                    return this._$27655.getOid();
                }
                case 2: {
                    return this._$27655.getTypeString();
                }
                case 3: {
                    return this._$27655.getStatus();
                }
            }
            return null;
        }
    }
}

