/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.common.table.print;

import com.agentpp.common.table.print.VectorView;
import com.klg.jclass.page.EndOfFrameException;
import com.klg.jclass.page.JCAlternate;
import com.klg.jclass.page.JCDocument;
import com.klg.jclass.page.JCFrame;
import com.klg.jclass.page.JCPageTable;
import com.klg.jclass.page.JCTableStyle;
import com.klg.jclass.page.JCTextStyle;
import com.klg.jclass.page.JCUnit;
import com.klg.jclass.util.swing.JCExitFrame;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class JDBCView
extends VectorView {
    protected static String query = "select * from Orders";
    protected static String url = "jdbc:odbc:JClassDemo";
    protected static String driver = "sun.jdbc.odbc.JdbcOdbcDriver";
    protected static String login = "Admin";
    protected static String password = "";
    protected String originalQuery = "select * from Orders";
    protected String originalUrl = "jdbc:odbc:JClassDemo";
    protected String originalDriver = "sun.jdbc.odbc.JdbcOdbcDriver";
    protected String originalLogin = "Admin";
    protected String originalPassword = "";
    protected String[] QUERIES = new String[]{"select * from Orders", "select * from OrderDetails", "select * from Customers", "select * from Products"};

    public JComponent createView() {
        return new TablePanel();
    }

    public JCPageTable createPageTable(JCDocument doc) {
        ResultSet resultSet = null;
        JCPageTable table = null;
        try {
            Class.forName(driver);
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
        }
        try {
            Connection connection = DriverManager.getConnection(url, login, password);
            Statement statement = connection.createStatement();
            resultSet = statement.executeQuery(query);
            try {
                table = JDBCView.createCustomPageTable(doc, resultSet);
            }
            catch (Exception e2) {
                // empty catch block
            }
            resultSet.close();
            statement.close();
            connection.close();
        }
        catch (SQLException sqle) {
            JOptionPane.showMessageDialog(null, sqle.toString(), "SQL error", 0);
            return null;
        }
        return table;
    }

    public void resetModel(boolean use_vector) {
    }

    public static JCPageTable createCustomPageTable(JCDocument doc, ResultSet resultSet) {
        JCPageTable table = null;
        try {
            ResultSetMetaData rsmd = resultSet.getMetaData();
            JCTextStyle style = JCTextStyle.stringToStyle("default text");
            Vector<JCUnit.Measure> columns = new Vector<JCUnit.Measure>(rsmd.getColumnCount());
            for (int i2 = 0; i2 < rsmd.getColumnCount(); ++i2) {
                int colWidth = rsmd.getColumnDisplaySize(i2 + 1);
                colWidth = Math.max(33, Math.min(colWidth * 6, 76));
                JCUnit.Measure width = new JCUnit.Measure(JCUnit.POINTS, colWidth);
                columns.add(width);
            }
            JCTableStyle tableStyle = (JCTableStyle)JCTableStyle.STYLE_DEFAULT.clone();
            tableStyle.setAlternate(new JCAlternate(Color.white, new Color(236, 236, 236), true));
            table = new JCPageTable(doc, columns, tableStyle);
            table.setAlignment(4);
            JCPageTable header = table.createHeaders();
            for (int i3 = 0; i3 < rsmd.getColumnCount(); ++i3) {
                JCFrame frame = header.getCellFrame(0, i3);
                JDBCView.printWithNewlines(frame, style, rsmd.getColumnLabel(i3 + 1));
            }
            int rowIdx = 0;
            while (resultSet.next()) {
                for (int colIdx = 0; colIdx < rsmd.getColumnCount(); ++colIdx) {
                    JCFrame frame = table.getCellFrame(rowIdx, colIdx);
                    String string = resultSet.getString(colIdx + 1);
                    JDBCView.printWithNewlines(frame, style, string);
                }
                ++rowIdx;
            }
        }
        catch (SQLException sqle) {
            JOptionPane.showMessageDialog(null, sqle.toString(), "SQL error", 0);
        }
        catch (EndOfFrameException e2) {
            // empty catch block
        }
        return table;
    }

    public static void printWithNewlines(JCFrame frame, JCTextStyle style, String text) throws EndOfFrameException {
        if (text != null) {
            StringTokenizer st = new StringTokenizer(text, "\n");
            while (st.hasMoreTokens()) {
                frame.print(style, st.nextToken());
                frame.newLine(style);
            }
        }
    }

    public JPanel getOptionsPanel() {
        return this.getSQLOptionsPanel();
    }

    public JPanel getSQLOptionsPanel() {
        return new SqlOptionsPanel();
    }

    public static void main(String[] args) {
        JDBCView e2 = new JDBCView();
        JCExitFrame frame = new JCExitFrame("JDBC Example");
        frame.getContentPane().add(e2.createView());
        frame.pack();
        frame.setVisible(true);
    }

    class TablePanel
    extends JScrollPane {
        TablePanel() {
            this.setBorder(new TitledBorder("JDBC"));
            this.setPreferredSize(new Dimension(300, 200));
            JPanel panel = new JPanel();
            panel.setLayout(new GridLayout(0, 1, 5, 0));
            panel.add(new JLabel(" "));
            JLabel label = new JLabel("JClass PageLayout can create a report");
            Font lFont = new Font("TimesRoman", 1, 14);
            label.setFont(lFont);
            panel.add(label);
            label = new JLabel("directly from vector data or a JDBC ResultSet.");
            label.setFont(lFont);
            panel.add(label);
            panel.add(new JLabel(" "));
            label = new JLabel("Please click on the 'Preview' or 'Print' buttons.");
            label.setFont(lFont);
            panel.add(label);
            this.getViewport().add(panel);
        }
    }

    public class SqlOptionsPanel
    extends JPanel
    implements ActionListener {
        JTextField driverField;
        JTextField urlField;
        JTextField loginField;
        JTextField passwordField;
        JTextField queryField;
        JComboBox queryCombo;
        JButton button;

        public SqlOptionsPanel() {
            this.setBorder(new TitledBorder("SQL options"));
            this.setLayout(new BorderLayout());
            JPanel top = new JPanel();
            top.setLayout(new GridLayout(5, 2));
            top.add(new JLabel("Driver"));
            this.driverField = new JTextField(driver);
            top.add(this.driverField);
            top.add(new JLabel("Url"));
            this.urlField = new JTextField(url);
            top.add(this.urlField);
            top.add(new JLabel("Login"));
            this.loginField = new JTextField(login);
            top.add(this.loginField);
            top.add(new JLabel("Password"));
            this.passwordField = new JTextField(password);
            top.add(this.passwordField);
            top.add(new JLabel("Query"));
            this.queryCombo = new JComboBox<String>(JDBCView.this.QUERIES);
            top.add(this.queryCombo);
            this.queryCombo.setEditable(true);
            this.add((Component)top, "North");
            JPanel bottom = new JPanel();
            this.button = new JButton("Execute query");
            bottom.add(this.button);
            this.button.addActionListener(this);
            this.button = new JButton("Reset");
            bottom.add(this.button);
            this.button.addActionListener(this);
            this.add((Component)bottom, "South");
        }

        public void actionPerformed(ActionEvent event) {
            String command = event.getActionCommand();
            if (command.equals("Execute query")) {
                driver = this.driverField.getText();
                url = this.urlField.getText();
                login = this.loginField.getText();
                password = this.passwordField.getText();
                query = "" + this.queryCombo.getSelectedItem();
                JDBCView.this.resetModel(false);
            } else if (command.equals("Reset")) {
                this.driverField.setText(JDBCView.this.originalDriver);
                this.urlField.setText(JDBCView.this.originalUrl);
                this.loginField.setText(JDBCView.this.originalLogin);
                this.passwordField.setText(JDBCView.this.originalPassword);
                this.queryCombo.setSelectedIndex(0);
            }
        }
    }
}

