/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.common.table.print;

import com.agentpp.common.table.print.DocumentFlow;
import com.klg.jclass.page.EndOfFrameException;
import com.klg.jclass.page.JCDocument;
import com.klg.jclass.page.JCFlow;
import com.klg.jclass.page.JCFrame;
import com.klg.jclass.page.JCPage;
import com.klg.jclass.page.JCPageTemplate;
import com.klg.jclass.page.JCTab;
import com.klg.jclass.page.JCTextStyle;
import com.klg.jclass.page.JCUnit;
import com.klg.jclass.page.TextMacro;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.io.StringReader;
import java.util.List;
import javax.swing.JComponent;

public class ComponentFlow
implements DocumentFlow {
    static String templateText = "<?xml version=\"1.0\"?><!DOCTYPE JCPAGETEMPLATE SYSTEM \"JCPageTemplate.dtd\">\n<JCPAGETEMPLATE TITLE=\"8p5x11\">\n    <PAGE NAME=\"8p5x11\" UNIT=\"inches\">        <LOCATION X=\"0\" Y=\"0\"/>        <SIZE WIDTH=\"8.5\"  HEIGHT=\"11\"/>        <FRAME NAME=\"header\" UNIT=\"inches\">            <LOCATION X=\"1\" Y=\"0.25\"/>            <SIZE WIDTH=\"6.5\"  HEIGHT=\"0.75\"/>        </FRAME>        <FRAME NAME=\"body\" UNIT=\"inches\">            <LOCATION X=\"1\" Y=\"1\"/>            <SIZE WIDTH=\"6.5\"  HEIGHT=\"9\"/>        </FRAME>        <FRAME NAME=\"footer\" UNIT=\"inches\">            <LOCATION X=\"1\" Y=\"10.25\"/>            <SIZE WIDTH=\"6.5\"  HEIGHT=\"0.75\"/>        </FRAME>        <FLOWFRAME NAME=\"body\"/>        <FLOWPAGE NAME=\"8p5x11\"/>        <FLOWSECTION NAME=\"8p5x11\"/>    </PAGE></JCPAGETEMPLATE>\n";
    private Font _$25628;
    private JComponent _$6504;
    private boolean _$35063;

    public List getTemplates() {
        List result = null;
        try {
            result = JCPageTemplate.loadTemplates(new StringReader(templateText));
        }
        catch (Exception e2) {
            System.err.println("Error loading template = " + e2);
        }
        return result;
    }

    public String getFlowPage() {
        return "8p5x11";
    }

    public void flow(JCDocument document, JCPage template) {
        Object table = null;
        if (this.getComponent() == null) {
            return;
        }
        JCFrame headerFrame = template.stringToFrame("header");
        try {
            Font pf = new Font("TimesRoman", 0, 14);
            if (this.getHeader() != null) {
                JCTextStyle header = new JCTextStyle("Header");
                Font tmpfont = new Font(pf.getName(), 1, pf.getSize() + 4);
                header.setParagraphSpacing(1.5);
                header.setAlignment(4);
                header.setFont(tmpfont);
                header.makeImmutable();
                headerFrame.print(header, this.getHeader());
            }
        }
        catch (EndOfFrameException e2) {
            e2.printStackTrace(System.out);
        }
        JCTextStyle style = (JCTextStyle)JCTextStyle.stringToStyle("default text").clone();
        style.setAlignment(4);
        style.makeImmutable();
        if (this.isPageNumbering()) {
            JCFrame footerFrame = template.stringToFrame("footer");
            try {
                footerFrame.print(style, TextMacro.PAGE_NUMBER);
            }
            catch (EndOfFrameException e3) {
                // empty catch block
            }
        }
        JCFlow flow = new JCFlow(document);
        style = (JCTextStyle)JCTextStyle.stringToStyle("default text").clone();
        style.setAlignment(2);
        if (this._$25628 != null) {
            style.setFont(this._$25628);
        }
        style.addTab(new JCTab(new JCUnit.Measure(JCUnit.CM, 1.0)));
        style.makeImmutable();
        flow.setCurrentTextStyle(style);
        this.printTop(flow);
        try {
            JCUnit.Dimension d2 = (JCUnit.Dimension)template.getSize().clone();
            d2.height *= 0.75;
            d2.width *= 0.75;
            Dimension cd = this.getComponent().getSize();
            double screenRatio = (double)cd.width / (double)cd.height;
            double printRatio = d2.width / d2.height;
            if (screenRatio > printRatio) {
                d2.height = d2.width / screenRatio;
            } else {
                d2.width = d2.height / screenRatio;
            }
            flow.embedComponent(this.getComponent(), 4, d2);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            flow.embedComponent((Component)this.getComponent(), 4);
        }
        this.printBottom(flow);
    }

    protected String getHeader() {
        return null;
    }

    protected void printTop(JCFlow flow) {
    }

    protected void printBottom(JCFlow flow) {
    }

    public void setDefaultFont(Font font) {
        this._$25628 = font;
    }

    public void setFitToPage(boolean fitToPage) {
    }

    public void setWrapNextPage(boolean wrapNext) {
    }

    public void setComponent(JComponent component) {
        this._$6504 = component;
    }

    public JComponent getComponent() {
        return this._$6504;
    }

    public void setPageNumbering(boolean pageNumbering) {
        this._$35063 = pageNumbering;
    }

    public boolean isPageNumbering() {
        return this._$35063;
    }
}

