/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.common.table;

import com.klg.jclass.table.JCCellRange;
import com.klg.jclass.table.JCListTable;
import com.klg.jclass.table.JCTable;
import com.klg.jclass.table.SortableDataViewModel;
import com.klg.jclass.table.TableDataView;
import com.klg.jclass.table.data.JCVectorDataSource;
import java.util.Collection;
import java.util.Vector;

public class TableUtils {
    public static void setRangeAfterCopy(JCCellRange range) {
        if (range.start_row == -1) {
            range.start_row = 0;
        }
        if (range.start_column == -1) {
            range.start_column = 0;
        }
        if (range.start_row > range.end_row) {
            int temp_row = range.start_row;
            range.start_row = range.end_row;
            range.end_row = temp_row;
        }
        if (range.start_column > range.end_column) {
            int temp_col = range.start_column;
            range.start_column = range.end_column;
            range.end_column = temp_col;
        }
    }

    public static int getFirstMarkedRow(JCTable table) {
        int row = TableUtils.getFirstSelectedRow(table);
        if (row < 0) {
            row = table.getCurrentRow();
        }
        return row;
    }

    public static int getFirstSelectedRow(JCTable table) {
        Collection c2 = table.getSelectedCells();
        if (c2 == null) {
            return -1;
        }
        JCCellRange[] r2 = new JCCellRange[c2.size()];
        c2.toArray(r2);
        int min = Integer.MAX_VALUE;
        for (int i2 = 0; i2 < r2.length; ++i2) {
            TableUtils.setRangeAfterCopy(r2[i2]);
            if (r2[i2].start_row < min) {
                min = r2[i2].start_row;
            }
            if (r2[i2].end_row >= min) continue;
            min = r2[i2].end_row;
        }
        if (table.getDataView() instanceof SortableDataViewModel) {
            return ((SortableDataViewModel)table.getDataView()).getDataRow(min);
        }
        return min;
    }

    public static int getFirstSelectedColumn(JCTable table) {
        Collection c2 = table.getSelectedCells();
        if (c2 == null) {
            return -1;
        }
        JCCellRange[] r2 = new JCCellRange[c2.size()];
        c2.toArray(r2);
        int min = Integer.MAX_VALUE;
        for (int i2 = 0; i2 < r2.length; ++i2) {
            TableUtils.setRangeAfterCopy(r2[i2]);
            if (r2[i2].start_column < min) {
                min = r2[i2].start_column;
            }
            if (r2[i2].end_column >= min) continue;
            min = r2[i2].end_column;
        }
        if (table.getDataView() instanceof SortableDataViewModel) {
            return ((SortableDataViewModel)table.getDataView()).getDataColumn(min);
        }
        return min;
    }

    public static int getLastSelectedRow(JCTable table) {
        Collection c2 = table.getSelectedCells();
        if (c2 == null) {
            return -1;
        }
        JCCellRange[] r2 = new JCCellRange[c2.size()];
        c2.toArray(r2);
        int max = -1;
        for (int i2 = 0; i2 < r2.length; ++i2) {
            TableUtils.setRangeAfterCopy(r2[i2]);
            if (r2[i2].start_row > max) {
                max = r2[i2].start_row;
            }
            if (r2[i2].end_row <= max) continue;
            max = r2[i2].end_row;
        }
        if (table.getDataView() instanceof SortableDataViewModel) {
            return ((SortableDataViewModel)table.getDataView()).getDataRow(max);
        }
        return max;
    }

    public static int[] getSelectedRows(Collection c2) {
        if (c2 == null) {
            return new int[0];
        }
        Vector<Integer> v = new Vector<Integer>(10, 100);
        JCCellRange[] r2 = new JCCellRange[c2.size()];
        c2.toArray(r2);
        for (int i2 = 0; i2 < r2.length; ++i2) {
            TableUtils.setRangeAfterCopy(r2[i2]);
            for (int j2 = r2[i2].start_row; j2 <= r2[i2].end_row; ++j2) {
                v.add(new Integer(j2));
            }
        }
        int[] s = new int[v.size()];
        for (int i3 = 0; i3 < v.size(); ++i3) {
            s[i3] = (Integer)v.elementAt(i3);
        }
        return s;
    }

    public static int[] getSelectedRows(int numrows, Collection c2) {
        if (c2 == null) {
            return new int[0];
        }
        Vector<Integer> v = new Vector<Integer>(10, 100);
        JCCellRange[] r2 = new JCCellRange[c2.size()];
        c2.toArray(r2);
        for (int i2 = 0; i2 < r2.length; ++i2) {
            TableUtils.setRangeAfterCopy(r2[i2]);
            if (r2[i2].end_row >= numrows) {
                r2[i2].end_row = numrows - 1;
            }
            for (int j2 = r2[i2].start_row; j2 <= r2[i2].end_row; ++j2) {
                v.add(new Integer(j2));
            }
        }
        int[] s = new int[v.size()];
        for (int i3 = 0; i3 < v.size(); ++i3) {
            s[i3] = (Integer)v.elementAt(i3);
        }
        return s;
    }

    public static int[] getSelectedRows(JCTable table) {
        return TableUtils.getDataRows(table, TableUtils.getSelectedRows(table.getNumRows(), table.getSelectedCells()));
    }

    public static int[] getMarkedRows(JCTable table) {
        int[] rows = TableUtils.getDataRows(table, TableUtils.getSelectedRows(table.getNumRows(), table.getSelectedCells()));
        if (rows == null || rows.length == 0) {
            int[] markedRow = new int[]{TableUtils.getFirstMarkedRow(table)};
            if (markedRow[0] < 0) {
                return rows;
            }
            return markedRow;
        }
        return rows;
    }

    public static int[] getDataRows(JCTable table, int[] rows) {
        if (table.getDataView() instanceof SortableDataViewModel) {
            int[] map = new int[rows.length];
            SortableDataViewModel sv = (SortableDataViewModel)table.getDataView();
            for (int i2 = 0; i2 < rows.length; ++i2) {
                map[i2] = sv.getDataRow(rows[i2]);
            }
            return map;
        }
        return rows;
    }

    public static void removeRows(JCVectorDataSource data, int[] rows) {
        for (int i2 = 0; i2 < rows.length; ++i2) {
            data.deleteRows(rows[i2], 1);
            int j2 = i2 + 1;
            while (j2 < rows.length) {
                int n2 = j2++;
                rows[n2] = rows[n2] - 1;
            }
        }
    }

    public static boolean moveRow(JCVectorDataSource data, int row, int delta) {
        return data.moveRows(row, 1, row + (delta > 0 ? 1 : 0) + delta);
    }

    public static boolean moveSelectedRow(JCTable table, JCVectorDataSource data, int delta) {
        int row = TableUtils.getFirstSelectedRow(table);
        boolean ok = TableUtils.moveRow(data, row, delta);
        if (ok) {
            table.clearSelection();
            table.setCurrentCell(table.getCurrentRow() + delta, table.getCurrentColumn());
            if (table instanceof JCListTable) {
                table.setRowSelection(row + delta, row + delta);
            } else {
                table.setSelection(row + delta, 0, row + delta, table.getDataSource().getNumColumns() - 1);
            }
        }
        return ok;
    }

    public static void removeSelectedRows(JCTable table, JCVectorDataSource data) {
        int[] rows = TableUtils.getSelectedRows(table.getSelectedCells());
        rows = TableUtils.getDataRows(table, rows);
        TableUtils.removeRows(data, rows);
    }

    public static Vector sortVectorByView(JCTable table, Vector inputVector) {
        if (table.getDataView().getNumRows() != inputVector.size()) {
            return inputVector;
        }
        Vector v = new Vector(inputVector.size() + 1);
        TableDataView tdv = (TableDataView)table.getDataView();
        for (int i2 = 0; i2 < tdv.getNumRows(); ++i2) {
            v.addElement(inputVector.elementAt(tdv.getDataRow(i2)));
        }
        return v;
    }
}

