/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.common.table;

import com.agentpp.common.table.ConsolidationFunction;
import com.agentpp.common.table.RoundRobinEvent;
import com.agentpp.common.table.RoundRobinListener;
import com.klg.jclass.table.EditableTableDataModel;
import com.klg.jclass.table.JCTableDataEvent;
import com.klg.jclass.table.JCTableDataListener;
import com.klg.jclass.table.data.JCVectorDataSource;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;

public class RoundRobinDataSource
implements EditableTableDataModel,
JCTableDataListener,
RoundRobinListener,
Serializable,
ConsolidationFunction {
    public static final long serialVersionUID = 2776133236688388574L;
    protected int position = 0;
    protected int samples = 288;
    protected JCVectorDataSource data = new JCVectorDataSource();
    private transient Vector tableDataListeners;
    private transient Vector roundRobinListeners;
    private int sampleRate = 300;
    private int consolidationFunction;
    private String name;
    private Vector lastSamples = new Vector(1);
    private transient boolean changed = true;
    private transient boolean dataChanged = false;
    private transient Long id;

    public RoundRobinDataSource() {
        this.activate();
    }

    public RoundRobinDataSource(int samples) {
        this();
        this.samples = samples;
    }

    public RoundRobinDataSource(int cf, int samples, int rate) {
        this();
        this.consolidationFunction = cf;
        this.samples = samples;
        this.sampleRate = rate;
    }

    public synchronized void setNumSamples(int samples) {
        this.samples = samples;
        if (this.data.getNumRows() > samples) {
            this.data.setNumRows(samples);
        }
    }

    public int getPosition() {
        return this.position;
    }

    public Vector getColumnLabels() {
        return this.data.getColumnLabels();
    }

    public void activate() {
        this.data.addTableDataListener(this);
        if (this.lastSamples == null) {
            this.resetSamples();
        }
    }

    public void deactivate() {
        this.data.removeTableDataListener(this);
    }

    public int getNumSamples() {
        return this.samples;
    }

    private int getTranslatedRow(int row) {
        int t = this.position + row;
        int size = Math.min(this.samples, this.getNumRows());
        if (t >= size) {
            t -= size;
        }
        return t;
    }

    private int getBackTranslatedRow(int row) {
        int r2 = row - this.position;
        if (r2 < 0) {
            r2 = this.getNumRows() + r2;
        }
        return r2;
    }

    public List getCells() {
        Vector v = new Vector(this.getNumRows() + 1);
        for (int i2 = 0; i2 < this.data.getNumRows(); ++i2) {
            int row = this.getTranslatedRow(i2);
            Vector<Object> vr = new Vector<Object>(this.getNumColumns() + 1);
            vr.add(this.data.getTableRowLabel(row));
            for (int j2 = 0; j2 < this.getNumColumns(); ++j2) {
                vr.add(this.data.getTableDataItem(row, j2));
            }
            v.add(vr);
        }
        return v;
    }

    public Object getTableDataItem(int row, int column) {
        return this.data.getTableDataItem(this.getTranslatedRow(row), column);
    }

    public void setCell(int row, int col, Object o2) {
        this.data.setCell(this.getTranslatedRow(row), col, o2);
    }

    public Object getTableColumnLabel(int col) {
        return this.data.getTableColumnLabel(col);
    }

    public Object getTableRowLabel(int row) {
        return this.data.getTableRowLabel(this.getTranslatedRow(row));
    }

    public void setRowLabel(int row, Object label) {
        this.data.setRowLabel(this.getTranslatedRow(row), label);
    }

    private int decPosition() {
        int cp;
        block0: {
            if ((cp = this.position--) != 0) break block0;
            this.position = this.getNumRows() - 1;
        }
        return cp;
    }

    private int incPosition() {
        int cp = this.position;
        this.position = this.position + 1 == this.samples ? 0 : ++this.position;
        return cp;
    }

    public boolean deleteColumns(int col, int num) {
        boolean r2 = this.data.deleteColumns(col, num);
        return r2;
    }

    public boolean addColumn(int col, Object label) {
        Vector<Double> v = new Vector<Double>(this.data.getNumRows() + 1);
        for (int i2 = 0; i2 < this.data.getNumRows(); ++i2) {
            v.add(new Double(0.0));
        }
        return this.data.addColumn(col, label, v);
    }

    public boolean moveColumn(int src, int num, int dest) {
        boolean r2 = this.data.moveColumns(src, num, dest);
        return r2;
    }

    public boolean addRow(int row, Object label, Vector v) {
        this.dataChanged = true;
        if (this.getNumRows() < this.samples) {
            if (row == Integer.MAX_VALUE) {
                if (this.position == 0) {
                    return this.data.addRow(Integer.MAX_VALUE, label, v);
                }
                return this.data.addRow(this.incPosition(), label, v);
            }
            return this.data.addRow(this.getTranslatedRow(row), label, v);
        }
        row = row == Integer.MAX_VALUE ? this.incPosition() : this.getTranslatedRow(row);
        this.data.setRowLabel(row, label);
        for (int i2 = 0; i2 < v.size(); ++i2) {
            this.data.setCell(row, i2, v.elementAt(i2));
        }
        this.fireDataChanged(new JCTableDataEvent(this, 0, 0, 0, 0, 14));
        return true;
    }

    public boolean deleteRows(int row, int n2) {
        this.data.removeTableDataListener(this);
        int r2 = this.getTranslatedRow(row);
        int sz = this.getNumRows();
        if (this.position >= r2) {
            this.position -= Math.min(this.position - r2, n2);
            if (this.position < 0) {
                this.position = sz - n2 + this.position;
            }
        }
        boolean ok = r2 + n2 <= sz ? this.data.deleteRows(r2, n2) : this.data.deleteRows(r2, sz - r2) && this.data.deleteRows(0, r2 + n2 - sz);
        this.data.addTableDataListener(this);
        if (ok) {
            this.fireDataChanged(new JCTableDataEvent(this, 0, 0, 0, 0, 14));
        }
        return ok;
    }

    public int getNumRows() {
        return this.data.getNumRows();
    }

    public int getNumColumns() {
        return this.data.getNumColumns();
    }

    public boolean setTableDataItem(Object o2, int row, int col) {
        this.data.setCell(this.getTranslatedRow(row), col, o2);
        return true;
    }

    public void setNumRows(int rows) {
        if (this.position > rows) {
            this.position = rows;
        }
        this.data.setNumRows(rows);
    }

    public void setNumColumns(int cols) {
        this.data.setNumColumns(cols);
    }

    public void setColumnLabel(int col, Object label) {
        this.data.setColumnLabel(col, label);
    }

    public synchronized void removeTableDataListener(JCTableDataListener l2) {
        if (this.tableDataListeners != null && this.tableDataListeners.contains(l2)) {
            Vector v = (Vector)this.tableDataListeners.clone();
            v.removeElement(l2);
            this.tableDataListeners = v;
        }
    }

    public synchronized void addTableDataListener(JCTableDataListener l2) {
        Vector v;
        Vector vector = v = this.tableDataListeners == null ? new Vector(2) : (Vector)this.tableDataListeners.clone();
        if (!v.contains(l2)) {
            v.addElement(l2);
            this.tableDataListeners = v;
        }
    }

    public void fireAddDataPoint(RoundRobinEvent e2) {
        if (this.roundRobinListeners != null) {
            Vector listeners = this.roundRobinListeners;
            int count = listeners.size();
            for (int i2 = 0; i2 < count; ++i2) {
                ((RoundRobinListener)listeners.get(i2)).addDataPoint(e2);
            }
        }
    }

    public void fireRemoveDataPoint(RoundRobinEvent e2) {
        if (this.roundRobinListeners != null) {
            Vector listeners = this.roundRobinListeners;
            int count = listeners.size();
            for (int i2 = 0; i2 < count; ++i2) {
                ((RoundRobinListener)listeners.get(i2)).removeDataPoint(e2);
            }
        }
    }

    public void fireResetSamples(RoundRobinEvent e2) {
        if (this.roundRobinListeners != null) {
            Vector listeners = this.roundRobinListeners;
            int count = listeners.size();
            for (int i2 = 0; i2 < count; ++i2) {
                ((RoundRobinListener)listeners.get(i2)).addDataPoint(e2);
            }
        }
    }

    protected void fireDataChanged(JCTableDataEvent e2) {
        if (this.tableDataListeners != null) {
            Vector listeners = this.tableDataListeners;
            int count = listeners.size();
            for (int i2 = 0; i2 < count; ++i2) {
                ((JCTableDataListener)listeners.elementAt(i2)).dataChanged(e2);
            }
        }
    }

    public void dataChanged(JCTableDataEvent e2) {
        JCTableDataEvent event = new JCTableDataEvent(e2.getSource(), this.getBackTranslatedRow(e2.getRow()), e2.getColumn(), e2.getNumAffected(), e2.getDestination(), e2.getCommand());
        this.fireDataChanged(event);
    }

    private boolean checkNewData(RoundRobinEvent e2) {
        boolean ok = true;
        Enumeration en = e2.getRow().elements();
        while (en.hasMoreElements()) {
            Object value = en.nextElement();
            if (value != null && value instanceof Number) continue;
            ok = false;
            break;
        }
        return ok;
    }

    public synchronized void addDataPoint(RoundRobinEvent e2) {
        block18: {
            try {
                this.changed = false;
                if (this.sampleRate <= 0) break block18;
                if (!this.checkNewData(e2)) {
                    return;
                }
                this.addSample(e2);
                if (this.lastSamples.size() < this.sampleRate) break block18;
                double[] v = new double[((RoundRobinEvent)this.lastSamples.firstElement()).getRow().size()];
                if (this.consolidationFunction == 3) {
                    Vector r2 = ((RoundRobinEvent)this.lastSamples.lastElement()).getRow();
                    for (int j2 = 0; j2 < r2.size(); ++j2) {
                        v[j2] = ((Number)r2.elementAt(j2)).doubleValue();
                    }
                } else {
                    int i2;
                    for (i2 = 0; i2 < this.lastSamples.size(); ++i2) {
                        Vector r3 = ((RoundRobinEvent)this.lastSamples.elementAt(i2)).getRow();
                        block9: for (int j3 = 0; j3 < r3.size(); ++j3) {
                            if (i2 == 0) {
                                v[j3] = ((Number)r3.elementAt(j3)).doubleValue();
                                continue;
                            }
                            switch (this.consolidationFunction) {
                                case 1: {
                                    if (!(((Number)r3.elementAt(j3)).doubleValue() < v[j3])) continue block9;
                                    v[j3] = ((Number)r3.elementAt(j3)).doubleValue();
                                    continue block9;
                                }
                                case 2: {
                                    if (!(((Number)r3.elementAt(j3)).doubleValue() > v[j3])) continue block9;
                                    v[j3] = ((Number)r3.elementAt(j3)).doubleValue();
                                    continue block9;
                                }
                                case 0: 
                                case 4: {
                                    int n2 = j3;
                                    v[n2] = v[n2] + ((Number)r3.elementAt(j3)).doubleValue();
                                }
                            }
                        }
                    }
                    if (this.consolidationFunction == 0) {
                        for (i2 = 0; i2 < v.length; ++i2) {
                            v[i2] = v[i2] / (double)this.lastSamples.size();
                        }
                    }
                }
                Vector<Double> newRow = new Vector<Double>(v.length);
                for (int i3 = 0; i3 < v.length; ++i3) {
                    newRow.add(new Double(v[i3]));
                }
                if (this.addRow(Integer.MAX_VALUE, ((RoundRobinEvent)this.lastSamples.lastElement()).getLabel(), newRow)) {
                    this.changed = true;
                    this.fireAddDataPoint(new RoundRobinEvent(this, ((RoundRobinEvent)this.lastSamples.lastElement()).getLabel(), newRow, false));
                }
                this.resetSamples();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void addSample(RoundRobinEvent e2) {
        this.lastSamples.addElement(e2);
        this.fireAddDataPoint(new RoundRobinEvent(this, e2.getLabel(), e2.getRow(), true));
    }

    public synchronized void removeRoundRobinListener(RoundRobinListener l2) {
        if (this.roundRobinListeners != null && this.roundRobinListeners.contains(l2)) {
            Vector v = (Vector)this.roundRobinListeners.clone();
            v.removeElement(l2);
            this.roundRobinListeners = v;
        }
    }

    public synchronized void addRoundRobinListener(RoundRobinListener l2) {
        Vector v;
        Vector vector = v = this.roundRobinListeners == null ? new Vector(2) : (Vector)this.roundRobinListeners.clone();
        if (!v.contains(l2)) {
            v.addElement(l2);
            this.roundRobinListeners = v;
        }
    }

    public synchronized void setSampleRate(int newSampleRate) {
        this.sampleRate = newSampleRate;
        this.resetSamples();
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public void setConsolidationFunction(int newConsolidationFunction) {
        this.consolidationFunction = newConsolidationFunction;
    }

    public int getConsolidationFunction() {
        return this.consolidationFunction;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public boolean isDataChanged() {
        return this.dataChanged;
    }

    public Long getId() {
        return this.id;
    }

    public void setDataChanged(boolean dataChanged) {
        this.dataChanged = dataChanged;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setData(int position, int rowCount, int colCount, Vector rowLabels, Vector colLabels, Vector cells) {
        this.position = position;
        this.data = new JCVectorDataSource(rowCount, colCount, rowLabels, colLabels, cells);
    }

    public RoundRobinDataSource createDataClone() {
        RoundRobinDataSource copy = new RoundRobinDataSource(this.consolidationFunction, this.samples, this.sampleRate);
        copy.setName(this.getName());
        copy.data = new JCVectorDataSource(this.data.getNumRows(), this.data.getNumColumns(), (Vector)this.data.getRowLabels().clone(), (Vector)this.data.getColumnLabels().clone(), (Vector)this.data.getCells().clone());
        return copy;
    }

    public List getLastSamples() {
        if (this.lastSamples == null) {
            return Collections.EMPTY_LIST;
        }
        return new ArrayList(this.lastSamples);
    }

    public void setLastSamples(List samples) {
        this.lastSamples = new Vector(samples);
        this.fireResetSamples(new RoundRobinEvent(this, null, this.lastSamples, true));
    }

    public void resetSamples(RoundRobinEvent e2) {
        this.resetSamples();
    }

    private void resetSamples() {
        this.lastSamples = new Vector(this.sampleRate + 1);
        this.fireResetSamples(new RoundRobinEvent(this, null, this.lastSamples, true));
    }

    public void removeDataPoint(RoundRobinEvent e2) {
    }
}

