/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.common.smi.print;

import com.agentpp.common.smi.editor.SmiContext;
import com.agentpp.common.smi.editor.SmiDocument;
import com.agentpp.common.smi.editor.Token;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Segment;
import javax.swing.text.Style;
import javax.swing.text.TabExpander;

public class SmiTextPrintable
implements Printable {
    private Font _$4493;
    protected SmiContext styles;
    protected SmiDocument text;
    private String _$46;
    private boolean _$2448;
    private boolean _$18140;
    private boolean _$18141;
    private int _$18142 = 8;
    protected String footerText = "";
    private boolean _$18144;
    protected SmiDocument.Scanner scanner;
    private int _$18146 = -1;
    private LinkedList _$18147;
    private int _$18148;
    private int _$18149;
    private int _$18150;
    private boolean _$9586;
    private LineMetrics _$18151;
    private ArrayList _$18152 = new ArrayList(10);
    private static Color _$18153 = Color.lightGray;
    private static Color _$18154 = Color.black;
    private static Color _$18155 = Color.lightGray;
    private static Color _$18156 = Color.black;
    private static Color _$18157 = Color.gray;
    private static Color _$18158 = Color.black;

    public SmiTextPrintable(SmiDocument text, Font font, String name, String footerText, boolean lineNumbers, boolean colored, SmiContext context, int tablen) {
        this.text = text;
        this._$46 = name;
        this._$2448 = name != null;
        this._$4493 = font;
        this._$18141 = colored;
        this._$2448 = this._$2448;
        this._$18140 = footerText != null;
        this.footerText = footerText;
        this.styles = context;
        this._$18142 = tablen;
        this.scanner = text.createScanner();
        this._$18144 = lineNumbers;
    }

    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (pageIndex > this._$18148 + 1) {
            for (int i2 = this._$18148; i2 < pageIndex; ++i2) {
                this._$18160(graphics, pageFormat, i2, true);
            }
            this._$18148 = pageIndex - 1;
        }
        if (pageIndex == this._$18148 + 1) {
            if (this._$9586) {
                return 1;
            }
            this._$18149 = this._$18150;
            this._$18148 = pageIndex;
        } else if (pageIndex == this._$18148) {
            this._$18150 = this._$18149;
        }
        this._$18160(graphics, pageFormat, pageIndex, true);
        return 0;
    }

    private void _$18160(Graphics graphics, PageFormat pageFormat, int pageIndex, boolean actuallyPaint) {
        double lineNumberWidth;
        Graphics2D gfx = (Graphics2D)graphics;
        gfx.setFont(this._$4493);
        double pageX = pageFormat.getImageableX();
        double pageY = pageFormat.getImageableY();
        double pageWidth = pageFormat.getImageableWidth();
        double pageHeight = pageFormat.getImageableHeight();
        if (this._$2448) {
            double headerHeight = this._$18168(gfx, pageX, pageY, pageWidth, actuallyPaint);
            pageY += headerHeight * 2.0;
            pageHeight -= headerHeight * 2.0;
        }
        if (this._$18140) {
            double footerHeight = this._$18170(gfx, pageX, pageY, pageWidth, pageHeight, pageIndex, actuallyPaint);
            pageHeight -= footerHeight * 2.0;
        }
        FontRenderContext frc = gfx.getFontRenderContext();
        if (this._$18144) {
            int lineNumberDigits = (int)Math.ceil(Math.log(this.text.getLineCount() + 1) / Math.log(10.0)) + 1;
            char[] chars = new char[lineNumberDigits];
            for (int i2 = 0; i2 < chars.length; ++i2) {
                chars[i2] = 48;
            }
            lineNumberWidth = this._$4493.getStringBounds(chars, 0, lineNumberDigits, frc).getWidth();
        } else {
            lineNumberWidth = 0.0;
        }
        char[] chars = new char[this._$18142];
        for (int i3 = 0; i3 < chars.length; ++i3) {
            chars[i3] = 32;
        }
        double tabWidth = this._$4493.getStringBounds(chars, 0, this._$18142, frc).getWidth();
        PrintTabExpander e2 = new PrintTabExpander(tabWidth);
        Segment seg = new Segment();
        double y = 0.0;
        this._$18151 = this._$4493.getLineMetrics("gGyYX", frc);
        while (true) {
            if (this._$18150 == this.text.getLineCount()) {
                this._$9586 = true;
                break;
            }
            this._$18152.clear();
            try {
                this.text.getText(this.text.getLineStartOffset(this._$18150), this.text.getLineLength(this._$18150), seg);
            }
            catch (BadLocationException blex) {
                blex.printStackTrace();
            }
            this.lineToChunkList(this._$18150, seg, this.styles, frc, (float)(pageWidth - lineNumberWidth), e2, this._$18152);
            if (this._$18152.size() == 0) {
                this._$18152.add(null);
            }
            if (y + (double)(this._$18151.getHeight() * (float)this._$18152.size()) >= pageHeight) break;
            if (this._$18144 && actuallyPaint) {
                gfx.setFont(this._$4493);
                gfx.setColor(_$18157);
                gfx.drawString(String.valueOf(this._$18150 + 1), (float)pageX, (float)(pageY + y));
            }
            for (int i4 = 0; i4 < this._$18152.size(); ++i4) {
                Chunk chunks = (Chunk)this._$18152.get(i4);
                if (chunks != null) {
                    this.paintChunkList(chunks, gfx, (float)(pageX + lineNumberWidth), (float)(pageY + y), false);
                }
                y += (double)this._$18151.getHeight();
            }
            ++this._$18150;
        }
    }

    private double _$18168(Graphics2D gfx, double pageX, double pageY, double pageWidth, boolean actuallyPaint) {
        String headerText = this._$46;
        FontRenderContext frc = gfx.getFontRenderContext();
        this._$18151 = this._$4493.getLineMetrics(headerText, frc);
        Rectangle2D bounds = this._$4493.getStringBounds(headerText, frc);
        Rectangle2D.Double headerBounds = new Rectangle2D.Double(pageX, pageY, pageWidth, bounds.getHeight());
        if (actuallyPaint) {
            gfx.setColor(_$18153);
            gfx.fill(headerBounds);
            gfx.setColor(_$18154);
            gfx.drawString(headerText, (float)(pageX + (pageWidth - bounds.getWidth()) / 2.0), (float)(pageY + (double)this._$18151.getAscent()));
        }
        return ((RectangularShape)headerBounds).getHeight();
    }

    private double _$18170(Graphics2D gfx, double pageX, double pageY, double pageWidth, double pageHeight, int pageIndex, boolean actuallyPaint) {
        String ft = MessageFormat.format(this.footerText, new Date(), new Integer(pageIndex + 1));
        FontRenderContext frc = gfx.getFontRenderContext();
        this._$18151 = this._$4493.getLineMetrics(ft, frc);
        Rectangle2D bounds = this._$4493.getStringBounds(ft, frc);
        Rectangle2D.Double footerBounds = new Rectangle2D.Double(pageX, pageY + pageHeight - bounds.getHeight(), pageWidth, bounds.getHeight());
        if (actuallyPaint) {
            gfx.setColor(_$18155);
            gfx.fill(footerBounds);
            gfx.setColor(_$18156);
            gfx.drawString(ft, (float)(pageX + (pageWidth - bounds.getWidth()) / 2.0), (float)(pageY + pageHeight - bounds.getHeight() + (double)this._$18151.getAscent()));
        }
        return ((RectangularShape)footerBounds).getHeight();
    }

    public void lineToChunkList(int line, Segment seg, SmiContext styles, FontRenderContext fontRenderContext, float wrapMargin, TabExpander e2, List out) {
        if (wrapMargin != 0.0f) {
            wrapMargin += 2.0f;
        }
        float x = 0.0f;
        float endX = 0.0f;
        boolean seenNonWhiteSpace = false;
        boolean addedNonWhiteSpace = false;
        boolean lastWasSpace = false;
        float firstNonWhiteSpace = 0.0f;
        Chunk first = null;
        Chunk current = null;
        Chunk end = null;
        if (line < 0 || line >= this.text.getDefaultRootElement().getElementCount()) {
            throw new ArrayIndexOutOfBoundsException(line);
        }
        int startOffset = this.text.getLineStartOffset(line);
        int endOffset = this.text.getLineEndOffset(line);
        int start = this.scanner.getScannerStart(startOffset);
        int startLine = this.text.getLineOfOffset(start);
        int tokenListOffset = startOffset;
        try {
            this.scanner.setRange(start, this.text.getLength());
            while (this.scanner.getEndOffset() < startOffset) {
                this.scanner.getNextToken();
            }
            while (this.scanner.getToken().getScanValue() != Token.EOF.getScanValue() && this.scanner.getBeginOffset() < endOffset) {
                int i2;
                int flushIndex = Math.max(this.scanner.getBeginOffset(), startOffset);
                Token t = this.scanner.getToken();
                for (i2 = tokenListOffset; i2 < flushIndex; ++i2) {
                    Chunk newChunk;
                    if (seg.array[i2] == '\t') {
                        newChunk = new Chunk(t.getScanValue(), seg, i2, i2, fontRenderContext);
                        if (first == null) {
                            first = current = newChunk;
                        } else {
                            current.next = newChunk;
                            current = newChunk;
                        }
                        float newX = e2.nextTabStop(x, i2 + tokenListOffset);
                        current.width = newX - x;
                        x = newX;
                        current.length = 1;
                    }
                    if (seg.array[i2] == '\r' || seg.array[i2] == '\n') continue;
                    newChunk = new Chunk(Token.UNSCANNED.getScanValue(), seg, i2, i2 + 1, fontRenderContext);
                    if (first == null) {
                        first = newChunk;
                    }
                    if (current != null) {
                        current.next = newChunk;
                    }
                    current = newChunk;
                    x += newChunk.width;
                    lastWasSpace = true;
                    seenNonWhiteSpace = false;
                }
                for (i2 = tokenListOffset = flushIndex; i2 < endOffset && i2 < this.scanner.getEndOffset(); ++i2) {
                    Chunk newChunk;
                    char ch = seg.array[i2];
                    if (ch == '\n' || ch == '\r' || ch == '\t' || ch == ' ' && wrapMargin != 0.0f) {
                        if (i2 != flushIndex) {
                            newChunk = new Chunk(t.getScanValue(), seg, flushIndex, i2, fontRenderContext);
                            if (current != null) {
                                current.next = newChunk;
                            }
                            current = newChunk;
                            x += newChunk.width;
                            lastWasSpace = false;
                            seenNonWhiteSpace = true;
                        }
                        if (end != null && !lastWasSpace && addedNonWhiteSpace && wrapMargin != 0.0f && x > wrapMargin) {
                            if (first != null) {
                                out.add(first);
                            }
                            first = new Chunk(firstNonWhiteSpace, end.offset + 1);
                            first.next = end.next;
                            end.next = null;
                            x = x + firstNonWhiteSpace - endX;
                        }
                        if (first == null) {
                            first = current;
                        }
                        if (ch == ' ') {
                            newChunk = new Chunk(t.getScanValue(), seg, i2, i2 + 1, fontRenderContext);
                            if (first == null) {
                                first = current = newChunk;
                            } else {
                                current.next = newChunk;
                                current = newChunk;
                            }
                            x += current.width;
                        } else if (ch == '\t') {
                            newChunk = new Chunk(t.getScanValue(), seg, i2, i2, fontRenderContext);
                            if (first == null) {
                                first = current = newChunk;
                            } else {
                                current.next = newChunk;
                                current = newChunk;
                            }
                            float newX = e2.nextTabStop(x, i2 + tokenListOffset);
                            current.width = newX - x;
                            x = newX;
                            current.length = 1;
                        }
                        if (first == null) {
                            first = current;
                        }
                        end = current;
                        endX = x;
                        flushIndex = i2 + 1;
                        lastWasSpace = true;
                        addedNonWhiteSpace = seenNonWhiteSpace;
                        if (seenNonWhiteSpace) continue;
                        firstNonWhiteSpace = x;
                        continue;
                    }
                    if (i2 != this.scanner.getEndOffset() - 1) continue;
                    if (flushIndex != i2 + 1) {
                        newChunk = new Chunk(t.getScanValue(), seg, flushIndex, i2 + 1, fontRenderContext);
                        if (current != null) {
                            current.next = newChunk;
                        }
                        current = newChunk;
                        x += newChunk.width;
                        seenNonWhiteSpace = true;
                        lastWasSpace = false;
                    }
                    if (i2 == seg.count - 1 && wrapMargin != 0.0f && x > wrapMargin && addedNonWhiteSpace && end != null) {
                        if (first != null) {
                            out.add(first);
                        }
                        first = new Chunk(firstNonWhiteSpace, end.offset + 1);
                        first.next = end.next;
                        end.next = null;
                        x = x + firstNonWhiteSpace - endX;
                    }
                    if (first == null) {
                        first = current;
                    }
                    addedNonWhiteSpace = seenNonWhiteSpace;
                }
                tokenListOffset = this.scanner.getEndOffset();
                this.scanner.getNextToken();
            }
        }
        catch (IOException iox) {
            iox.printStackTrace();
        }
        if (first != null) {
            out.add(first);
        }
    }

    public float paintChunkList(Chunk chunks, Graphics2D gfx, float x, float y, boolean glyphVector) {
        FontMetrics forBackground = gfx.getFontMetrics();
        float _x = 0.0f;
        Chunk first = chunks;
        Object lastFont = null;
        Object lastColor = null;
        while (chunks != null) {
            if (!chunks.inaccessable && chunks.str != null) {
                gfx.setFont(chunks.font);
                gfx.setColor(chunks.foreground);
                if (glyphVector) {
                    gfx.drawGlyphVector(chunks.text, x + _x, y);
                } else {
                    gfx.drawString(chunks.str, x + _x, y);
                }
            }
            float width = chunks.width;
            _x += width;
            chunks = chunks.next;
        }
        return _x;
    }

    public Font getFont() {
        return this._$4493;
    }

    public class Chunk {
        public boolean inaccessable;
        public float width;
        public Style style;
        public Color foreground;
        public Font font;
        public int offset;
        public int length;
        public String str;
        public GlyphVector text;
        public float[] positions;
        public Chunk next;

        Chunk(float width, int offset) {
            this.inaccessable = true;
            this.width = width;
            this.offset = offset;
        }

        Chunk(int tokenType, Segment seg, int offset, int end, FontRenderContext fontRenderContext) {
            if (SmiTextPrintable.this.styles != null) {
                this.style = SmiTextPrintable.this.styles.getStyleForScanValue(tokenType);
                Font f2 = SmiTextPrintable.this.styles.getFont(tokenType);
                this.font = f2.isBold() ? new Font(SmiTextPrintable.this.getFont().getName(), 1, SmiTextPrintable.this.getFont().getSize()) : (f2.isItalic() ? new Font(SmiTextPrintable.this.getFont().getName(), 2, SmiTextPrintable.this.getFont().getSize()) : new Font(SmiTextPrintable.this.getFont().getName(), 0, SmiTextPrintable.this.getFont().getSize()));
                this.foreground = SmiTextPrintable.this._$18141 ? SmiTextPrintable.this.styles.getForeground(tokenType) : Color.black;
            } else {
                this.foreground = Color.black;
                this.font = SmiTextPrintable.this.getFont();
            }
            if (offset != end) {
                this.length = end - offset;
                this.str = new String(seg.array, offset, this.length);
                this.text = this.font.createGlyphVector(fontRenderContext, this.str);
                this.width = (float)this.text.getLogicalBounds().getWidth();
                this.positions = this.text.getGlyphPositions(0, this.length, null);
            }
            this.offset = offset;
        }
    }

    static class PrintTabExpander
    implements TabExpander {
        private double _$18175;

        public PrintTabExpander(double tabWidth) {
            this._$18175 = tabWidth;
        }

        public float nextTabStop(float x, int tabOffset) {
            int ntabs = (int)((double)(x + 1.0f) / this._$18175);
            return (float)((double)(ntabs + 1) * this._$18175);
        }
    }
}

