/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.common.smi.editor;

import com.agentpp.common.smi.editor.Token;
import com.agentpp.smiparser.SMIParserConstants;
import com.agentpp.smiparser.SMIParserTokenManager;
import com.agentpp.smiparser.SimpleCharStream;
import com.agentpp.smiparser.TokenMgrError;
import java.io.IOException;
import java.io.InputStream;
import java.util.TreeSet;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.GapContent;
import javax.swing.text.PlainDocument;
import javax.swing.text.Segment;

public class SmiDocument
extends PlainDocument {
    private boolean _$18883;

    public SmiDocument() {
        super(new GapContent(65535));
    }

    public Scanner createScanner() {
        Scanner s;
        try {
            s = new Scanner();
        }
        catch (IOException e2) {
            s = null;
        }
        return s;
    }

    public int getLineOfOffset(int offset) {
        return super.getDefaultRootElement().getElementIndex(offset);
    }

    public int getLineLength(int line) {
        Element l2 = super.getDefaultRootElement().getElement(line);
        return l2.getEndOffset() - l2.getStartOffset();
    }

    public int getLineCount() {
        return super.getDefaultRootElement().getElementCount();
    }

    public int getLineStartOffset(int line) {
        return super.getDefaultRootElement().getElement(line).getStartOffset();
    }

    public int getLineEndOffset(int line) {
        return super.getDefaultRootElement().getElement(line).getEndOffset();
    }

    protected void insertUpdate(AbstractDocument.DefaultDocumentEvent chng, AttributeSet attr) {
        super.insertUpdate(chng, attr);
        if (chng.getOffset() + chng.getLength() + 1 < chng.getDocument().getEndPosition().getOffset()) {
            this._$18883 = true;
        }
    }

    protected void removeUpdate(AbstractDocument.DefaultDocumentEvent chng) {
        super.removeUpdate(chng);
        this._$18883 = true;
    }

    public void setUpdated(boolean updated) {
        this._$18883 = updated;
    }

    public boolean isUpdated() {
        return this._$18883;
    }

    class DocumentInputStream
    extends InputStream {
        Segment segment = new Segment();
        int p0;
        int p1;
        int pos;
        int index;

        public DocumentInputStream(int p0, int p1) {
            this.p0 = p0;
            this.p1 = Math.min(SmiDocument.this.getLength(), p1);
            this.pos = p0;
            try {
                this.loadSegment();
            }
            catch (IOException ioe) {
                throw new Error("unexpected: " + ioe);
            }
        }

        public int read() throws IOException {
            if (this.index >= this.segment.offset + this.segment.count) {
                if (this.pos >= this.p1) {
                    return -1;
                }
                this.loadSegment();
            }
            return this.segment.array[this.index++];
        }

        void loadSegment() throws IOException {
            try {
                int n2 = Math.min(4096, this.p1 - this.pos);
                SmiDocument.this.getText(this.pos, n2, this.segment);
                this.pos += n2;
                this.index = this.segment.offset;
            }
            catch (BadLocationException e2) {
                throw new IOException("Bad location");
            }
        }
    }

    public class Scanner {
        private SMIParserTokenManager _$18894;
        private SimpleCharStream _$18895;
        private Token[] _$18896;
        private com.agentpp.smiparser.Token _$18897;
        private com.agentpp.smiparser.Token _$18898;
        private TreeSet<Integer> _$18899 = new TreeSet();
        int p0;

        Scanner() throws IOException {
            this._$18900();
            this._$18895 = new SimpleCharStream(new DocumentInputStream(0, SmiDocument.this.getLength()));
            this._$18894 = new SMIParserTokenManager(this._$18895);
        }

        private void _$18900() {
            this._$18896 = new Token[SMIParserConstants.tokenImage.length];
            block0: for (int i2 = 0; i2 < this._$18896.length; ++i2) {
                for (int j2 = 0; j2 < Token.all.length; ++j2) {
                    if (Token.all[j2].getScanValue() != i2) continue;
                    this._$18896[i2] = Token.all[j2];
                    continue block0;
                }
            }
        }

        public void setRange(int p0, int p1) throws IOException {
            this._$18895 = new SimpleCharStream(new DocumentInputStream(p0, p1), 0, 0, 4096, p0);
            this._$18894.ReInit(this._$18895);
            this._$18897 = null;
            this._$18898 = null;
            this.p0 = p0;
            Integer i0 = new Integer(p0);
            this._$18899.tailSet(i0).clear();
        }

        public final int getEndOffset() {
            if (this._$18897 == null) {
                this.getNextToken();
                if (this._$18897 == null) {
                    return Integer.MAX_VALUE;
                }
            }
            if (this._$18898 != null) {
                return this._$18898.endPos;
            }
            return this._$18897.endPos;
        }

        public int getTokenLength() {
            return this.getEndOffset() - this.getBeginOffset();
        }

        public final int getBeginOffset() {
            if (this._$18897 == null) {
                this.getNextToken();
                if (this._$18897 == null) {
                    return Integer.MAX_VALUE;
                }
            }
            if (this._$18898 != null) {
                return this._$18898.endPos - this._$18898.image.length();
            }
            return this._$18897.endPos - this._$18897.image.length();
        }

        public final Token getToken() {
            if (this._$18897 == null) {
                return this.getNextToken();
            }
            Token t = this._$18898 != null ? this._$18896[this._$18898.kind] : this._$18896[this._$18897.kind];
            if (t == null) {
                return Token.COMMENT;
            }
            return t;
        }

        private void _$18911(int pos) {
            Integer p2 = new Integer(pos);
            this._$18899.add(p2);
        }

        public int getScannerStart(int p2) {
            Integer floor = this._$18899.floor(p2);
            if (floor == null) {
                return 0;
            }
            return floor;
        }

        public int getScannerEnd(int p2) {
            Integer ceiling = this._$18899.ceiling(p2);
            if (ceiling == null) {
                return Math.min(SmiDocument.this.getLength(), p2 + 65535);
            }
            return Math.min(SmiDocument.this.getLength(), ceiling + 65535);
        }

        public final Token getNextToken() {
            Token t = null;
            if (this._$18898 != null) {
                t = this._$18896[this._$18898.kind];
                this._$18898 = this._$18898.next;
                return t;
            }
            try {
                this._$18897 = this._$18894.getNextToken();
                this._$18898 = this._$18897.specialToken;
                if (this._$18898 != null) {
                    while (this._$18898.specialToken != null) {
                        this._$18898 = this._$18898.specialToken;
                    }
                    t = this._$18896[this._$18898.kind];
                } else {
                    t = this._$18896[this._$18897.kind];
                }
                this._$18911(this._$18897.endPos - this._$18897.image.length());
            }
            catch (TokenMgrError error) {
                this._$18897 = null;
                return Token.ERROR;
            }
            if (t == null) {
                return Token.COMMENT;
            }
            return t;
        }
    }
}

