/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.common.log;

import com.agentpp.common.StandardDialog;
import com.agentpp.common.StatusBar;
import com.agentpp.common.log.LogPreferencesPanel;
import com.agentpp.common.log.LoggingListener;
import com.agentpp.common.table.FlexListTable;
import com.agentpp.common.table.TableUtils;
import com.borland.jbcl.layout.VerticalFlowLayout;
import com.klg.jclass.table.JCCellDisplayEvent;
import com.klg.jclass.table.JCCellDisplayListener;
import com.klg.jclass.table.JCCellRange;
import com.klg.jclass.table.JCListTable;
import com.klg.jclass.table.JCTable;
import com.klg.jclass.table.data.JCEditableVectorDataSource;
import com.klg.jclass.table.data.JCVectorDataSource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.apache.log4j.spi.LoggingEvent;

public class LogPanel
extends JPanel
implements JCCellDisplayListener,
LoggingListener,
ActionListener {
    public static final String CFG_EXPORT_PATH = "com.agentpp.log.exportPath";
    public static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss:SSS";
    private static SimpleDateFormat _$5057 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
    private static final String[] _$5058 = new String[]{"Priority", "Category", "Message"};
    public static ImageIcon imageProperties16 = new ImageIcon(Thread.currentThread().getContextClassLoader().getResource("toolbarButtonGraphics/general/Properties16.gif"));
    public static ImageIcon imageSaveAs16 = new ImageIcon(Thread.currentThread().getContextClassLoader().getResource("toolbarButtonGraphics/general/SaveAs16.gif"));
    public static ImageIcon imageDelete16 = new ImageIcon(Thread.currentThread().getContextClassLoader().getResource("toolbarButtonGraphics/general/Delete16.gif"));
    public static ImageIcon imageRemove16 = new ImageIcon(Thread.currentThread().getContextClassLoader().getResource("toolbarButtonGraphics/general/Remove16.gif"));
    public static ImageIcon imageStop16 = new ImageIcon(Thread.currentThread().getContextClassLoader().getResource("toolbarButtonGraphics/general/Stop16.gif"));
    public static final char NEW_LINE_DELIM = '\n';
    public static final char TAB_DELIM = '\t';
    public static final String EMPTY_STRING = "";
    public static final String NEWLINE = "\n";
    public static final String NULL = "null";
    public static final String TAB = "\t";
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanelButtons = new JPanel();
    VerticalFlowLayout verticalFlowLayout1 = new VerticalFlowLayout();
    JButton jButtonPreferences = new JButton();
    JButton jButtonClear = new JButton();
    JButton jButtonSaveAs = new JButton();
    JToggleButton jButtonStop = new JToggleButton();
    JPanel jPanelLogging = new JPanel();
    JCListTable table = new FlexListTable();
    JCEditableVectorDataSource model = new JCEditableVectorDataSource();
    BorderLayout borderLayout2 = new BorderLayout();
    private LogPreferencesPanel _$5083;
    private JFrame _$5084;
    JButton jButtonDelete = new JButton();
    private int _$5086 = 100;
    private StatusBar _$5087;
    private Properties _$5088;
    private LinkedList _$5089 = new LinkedList();
    private LinkedList _$5090 = new LinkedList();
    private boolean _$5091;
    public static final DataFlavor data_flavour = new DataFlavor(String.class, "ExcelTokenizedString");
    private Clipboard _$5093;
    private int _$5094;
    private int _$5095;
    private StringSelection _$5096;
    private Collection _$5097;

    public LogPanel(JFrame f2, StatusBar statusBar, Properties config) {
        this._$5087 = statusBar;
        this._$5088 = config;
        this._$5084 = f2;
        this.model.setColumnLabels(_$5058);
        this.model.setNumRows(0);
        this.model.setNumColumns(_$5058.length);
        this.table.setDataSource(this.model);
        this.table.setColumnLabelDisplay(true);
        this.table.setRowLabelDisplay(true);
        this.table.setVariableEstimateCount(5);
        this.table.setCharWidth(0, 8);
        this.table.setCharWidth(-1, 13);
        this.table.setPixelWidth(1, 33002);
        this.table.setCharWidth(2, 400);
        this.table.addCellDisplayListener(this);
        this.table.setVertSBTrack(1);
        this.table.getSelectionModel().setSelectionPolicy(2);
        this.table.getDefaultCellStyle().setEditable(false);
        KeyStroke copy = KeyStroke.getKeyStroke(67, 2, false);
        this.table.registerKeyboardAction(this, "copy", copy, 0);
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public JCTable getTable() {
        return this.table;
    }

    public void setPreferencesPanel(LogPreferencesPanel prefPanel) {
        this._$5083 = prefPanel;
        this._$5086 = prefPanel.getMaxLogRecords();
        prefPanel.reloadConfiguration();
    }

    public void cellDisplay(JCCellDisplayEvent e2) {
        if (e2.getCellData() != null && e2.getCellData() instanceof Date) {
            String display = _$5057.format((Date)e2.getCellData());
            e2.setDisplayData(display);
        }
    }

    private void _$5136(JCCellRange range) {
        if (range.start_row == -1) {
            range.start_row = 0;
        }
        if (range.start_column == -1) {
            range.start_column = 0;
        }
        if (range.start_row > range.end_row) {
            int temp_row = range.start_row;
            range.start_row = range.end_row;
            range.end_row = temp_row;
        }
        if (range.start_column > range.end_column) {
            int temp_col = range.start_column;
            range.start_column = range.end_column;
            range.end_column = temp_col;
        }
        this._$5094 = range.end_row;
        this._$5095 = range.end_column;
        if (this._$5094 > this.model.getNumRows()) {
            this._$5094 = this.model.getNumRows() - 1;
        }
        if (this._$5095 > this.model.getNumColumns()) {
            this._$5095 = this.model.getNumColumns() - 1;
        }
    }

    public void copySelectionToClipBoard() {
        JCCellRange range2 = null;
        String copy_value = null;
        StringBuffer buffer = new StringBuffer();
        try {
            this._$5097 = this.table.getSelectedCells();
            for (JCCellRange range2 : this._$5097) {
                this._$5136(range2);
                for (int row = range2.start_row; row <= this._$5094; ++row) {
                    for (int column = range2.start_column; column <= this._$5095; ++column) {
                        copy_value = this.table.getDataView().getObject(row, column).toString();
                        if (copy_value == null) {
                            copy_value = EMPTY_STRING;
                        } else {
                            copy_value = copy_value.replace('\t', ' ');
                            copy_value = copy_value.replace('\n', ' ');
                        }
                        if (copy_value == NULL) continue;
                        buffer.append(copy_value);
                        if (column < this._$5095) {
                            buffer.append(TAB);
                        }
                        if (column != this._$5095) continue;
                        buffer.append(NEWLINE);
                    }
                }
            }
            this._$5096 = new StringSelection(buffer.toString());
            this._$5093 = Toolkit.getDefaultToolkit().getSystemClipboard();
            this._$5093.setContents(this._$5096, this._$5096);
        }
        catch (NullPointerException e2) {
            Toolkit.getDefaultToolkit().beep();
        }
        this._$5096 = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(LoggingEvent e2) {
        if (this._$5086 == 0) {
            return;
        }
        if (this._$5091) {
            this._$5089.addLast(e2);
            if (this._$5089.size() > this._$5086) {
                this._$5089.removeFirst();
            }
        } else {
            Vector<Object> row = new Vector<Object>(3);
            row.addElement(e2.getLevel());
            row.addElement(e2.getLoggerName());
            String renderedMessage = e2.getRenderedMessage();
            if (renderedMessage == null) {
                renderedMessage = "Nullpointer Exception";
            }
            String s = renderedMessage.replace('\t', '\n');
            row.addElement(s);
            Date date = new Date(e2.timeStamp);
            if (SwingUtilities.isEventDispatchThread() || !this.table.isRepaintEnabled()) {
                this._$5172(row, date);
            } else {
                LinkedList linkedList = this._$5090;
                synchronized (linkedList) {
                    this._$5090.addLast(new Object[]{row, date});
                    if (this._$5090.size() == 1) {
                        SwingUtilities.invokeLater(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void run() {
                                LinkedList linkedList = LogPanel.this._$5090;
                                synchronized (linkedList) {
                                    boolean isRepaint = LogPanel.this.table.isRepaintEnabled();
                                    while (LogPanel.this._$5090.size() > 0) {
                                        Object[] r2 = (Object[])LogPanel.this._$5090.removeFirst();
                                        LogPanel.this._$5172((Vector)r2[0], (Date)r2[1]);
                                    }
                                    if (isRepaint) {
                                        LogPanel.this.table.traverse(LogPanel.this.model.getNumRows() - 1, 0, false, false);
                                    }
                                }
                            }
                        });
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _$5172(final Vector row, final Date date) {
        if (SwingUtilities.isEventDispatchThread()) {
            LinkedList linkedList = this._$5089;
            synchronized (linkedList) {
                StringTokenizer st;
                int numLines;
                int diff = this.model.getNumRows() - this._$5086;
                if (diff >= 0) {
                    this.model.deleteRows(0, diff);
                }
                if (this.model.addRow(Integer.MAX_VALUE, date, row) && (numLines = (st = new StringTokenizer((String)row.get(2), NEWLINE)).countTokens()) > 1) {
                    this.table.setCharHeight(this.model.getNumRows() - 1, st.countTokens());
                }
                if (this.table.isRepaintEnabled()) {
                    this.table.traverse(this.model.getNumRows() - 1, 0, false, false);
                }
            }
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    LogPanel.this._$5172(row, date);
                }
            });
        }
    }

    public JCVectorDataSource getDataSource() {
        return this.model;
    }

    void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.jPanelButtons.setLayout(this.verticalFlowLayout1);
        this.jButtonPreferences.setIcon(imageProperties16);
        this.jButtonPreferences.setToolTipText("Configure logging priorities and other properties");
        this.jButtonPreferences.setHorizontalAlignment(2);
        this.jButtonPreferences.setText("Properties");
        this.jButtonPreferences.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                LogPanel.this.jButtonPreferences_actionPerformed(e2);
            }
        });
        this.jButtonClear.setIcon(imageDelete16);
        this.jButtonClear.setToolTipText("Clear log");
        this.jButtonClear.setHorizontalAlignment(2);
        this.jButtonClear.setText("Clear");
        this.jButtonClear.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                LogPanel.this.jButtonClear_actionPerformed(e2);
            }
        });
        this.jButtonStop.setIcon(imageStop16);
        this.jButtonStop.setToolTipText("Suspend logging");
        this.jButtonStop.setHorizontalAlignment(2);
        this.jButtonStop.setText("Suspend");
        this.jButtonStop.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                LogPanel.this.jButtonStop_actionPerformed(e2);
            }
        });
        this.jButtonSaveAs.setIcon(imageSaveAs16);
        this.jButtonSaveAs.setToolTipText("Save logging output as text file");
        this.jButtonSaveAs.setHorizontalAlignment(2);
        this.jButtonSaveAs.setText("Save as...");
        this.jButtonSaveAs.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                LogPanel.this.jButtonSaveAs_actionPerformed(e2);
            }
        });
        this.jPanelLogging.setLayout(this.borderLayout2);
        this.jButtonDelete.setIcon(imageRemove16);
        this.jButtonDelete.setToolTipText("Remove selected entries");
        this.jButtonDelete.setHorizontalAlignment(2);
        this.jButtonDelete.setText("Remove");
        this.jButtonDelete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                LogPanel.this.jButtonDelete_actionPerformed(e2);
            }
        });
        this.add((Component)this.jPanelButtons, "West");
        this.jPanelButtons.add((Component)this.jButtonPreferences, null);
        this.jPanelButtons.add((Component)this.jButtonClear, null);
        this.jPanelButtons.add((Component)this.jButtonDelete, null);
        this.jPanelButtons.add((Component)this.jButtonSaveAs, null);
        this.jPanelButtons.add(new JSeparator());
        this.jPanelButtons.add((Component)this.jButtonStop, null);
        this.add((Component)this.jPanelLogging, "Center");
        this.jPanelLogging.add((Component)this.table, "Center");
    }

    void jButtonPreferences_actionPerformed(ActionEvent e2) {
        StandardDialog sd = new StandardDialog(this._$5084, "Logging Properties", true, true){

            public boolean cancel() {
                LogPanel.this._$5083.cancel();
                return true;
            }

            public boolean ok() {
                LogPanel.this._$5083.save();
                return true;
            }
        };
        sd.setCenterPanel(this._$5083);
        sd.setLocationRelativeTo(this._$5084);
        sd.setVisible(true);
        this._$5086 = this._$5083.getMaxLogRecords();
    }

    void jButtonClear_actionPerformed(ActionEvent e2) {
        this.model.setNumRows(0);
    }

    void jButtonStop_actionPerformed(ActionEvent event) {
        boolean old = this._$5091;
        this._$5091 = this.jButtonStop.isSelected();
        if (old && !this._$5091) {
            for (LoggingEvent e2 : this._$5089) {
                this.log(e2);
            }
            this._$5089.clear();
        }
    }

    void jButtonSaveAs_actionPerformed(ActionEvent e2) {
        JFileChooser fc = new JFileChooser();
        fc.setSelectedFile(new File(this._$5088.getProperty(CFG_EXPORT_PATH, EMPTY_STRING)));
        fc.setFileSelectionMode(0);
        if (fc.showSaveDialog(this) == 0) {
            Object[] options;
            int n2;
            this._$5088.put(CFG_EXPORT_PATH, fc.getSelectedFile().getPath());
            if (fc.getSelectedFile().exists() && (n2 = JOptionPane.showOptionDialog(this, "File already exists. Overwrite it?", "Confirm Overwrite", 0, 3, null, options = new Object[]{"Yes", "No"}, options[1])) == 1) {
                return;
            }
            try {
                int n3 = this.saveToFile(fc.getSelectedFile());
                if (n3 != 1) {
                    this._$5087.setMessage(EMPTY_STRING + n3 + " records written to " + fc.getSelectedFile().getPath());
                } else {
                    this._$5087.setMessage("One record written to " + fc.getSelectedFile().getPath());
                }
            }
            catch (IOException iox) {
                this._$5087.setMessage("Cannot write file " + fc.getSelectedFile() + ": " + iox.getMessage());
            }
        }
    }

    public synchronized int saveToFile(File f2) throws IOException {
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(f2));
        for (int i2 = 0; i2 < this.model.getNumRows(); ++i2) {
            StringBuffer buf = new StringBuffer();
            String d2 = _$5057.format((Date)this.model.getTableRowLabel(i2));
            buf.append(d2);
            buf.append(" ");
            buf.append(this.model.getTableDataItem(i2, 0).toString());
            buf.append(" ");
            buf.append(this.model.getTableDataItem(i2, 1).toString());
            buf.append(" ");
            int plen = buf.length();
            buf.append('\t');
            String s = this.model.getTableDataItem(i2, 2).toString();
            StringTokenizer st = new StringTokenizer(s, NEWLINE);
            while (st.hasMoreTokens()) {
                buf.append(st.nextToken());
                buf.append('\n');
                if (!st.hasMoreTokens()) continue;
                for (int j2 = 0; j2 < plen; ++j2) {
                    buf.append(' ');
                }
                buf.append('\t');
            }
            os.write(buf.toString().getBytes());
        }
        os.flush();
        os.close();
        return this.model.getNumRows();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRepaintEnabled(boolean repaint) {
        if (!this.table.isRepaintEnabled() && repaint) {
            LinkedList linkedList = this._$5089;
            synchronized (linkedList) {
                this.table.setRepaintEnabled(repaint);
                if (repaint) {
                    this.table.traverse(this.model.getNumRows() - 1, 0, false, false);
                }
            }
        } else {
            this.table.setRepaintEnabled(repaint);
            if (repaint) {
                this.table.traverse(this.model.getNumRows() - 1, 0, false, false);
            }
        }
    }

    void jButtonDelete_actionPerformed(ActionEvent e2) {
        Collection c2 = this.table.getSelectedCells();
        if (c2 == null) {
            return;
        }
        JCCellRange[] r2 = new JCCellRange[c2.size()];
        c2.toArray(r2);
        for (int i2 = 0; i2 < r2.length; ++i2) {
            TableUtils.setRangeAfterCopy(r2[i2]);
        }
        this.model.deleteRows(r2[0].start_row, r2[0].end_row - r2[0].start_row + 1);
    }

    public void actionPerformed(ActionEvent e2) {
        String cmd = e2.getActionCommand();
        System.out.println("ACRION:" + cmd);
        if (cmd.equals("copy")) {
            this.copySelectionToClipBoard();
        }
    }
}

