/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.common.formula;

import com.agentpp.common.formula.ArithmeticExpressionList;
import com.agentpp.common.formula.BooleanExpression;
import com.agentpp.common.formula.Concatenation;
import com.agentpp.common.formula.ConditionalExpression;
import com.agentpp.common.formula.Delta;
import com.agentpp.common.formula.ExtTableReference;
import com.agentpp.common.formula.FormulaParserConstants;
import com.agentpp.common.formula.FormulaParserTokenManager;
import com.agentpp.common.formula.IFormulaParser;
import com.agentpp.common.formula.NumberFormatExpression;
import com.agentpp.common.formula.OidConstant;
import com.agentpp.common.formula.ParseException;
import com.agentpp.common.formula.SimpleCharStream;
import com.agentpp.common.formula.StringConstant;
import com.agentpp.common.formula.SumWhen;
import com.agentpp.common.formula.Token;
import com.agentpp.common.formula.ValueOf;
import com.agentpp.mib.MIBRepository;
import com.agentpp.snmp.TargetInformation;
import com.agentpp.util.Regex;
import com.klg.jclass.table.TableDataModel;
import com.klg.jclass.util.formulae.Abs;
import com.klg.jclass.util.formulae.Add;
import com.klg.jclass.util.formulae.Average;
import com.klg.jclass.util.formulae.Ceiling;
import com.klg.jclass.util.formulae.Count;
import com.klg.jclass.util.formulae.Divide;
import com.klg.jclass.util.formulae.Expression;
import com.klg.jclass.util.formulae.Floor;
import com.klg.jclass.util.formulae.GeometricMean;
import com.klg.jclass.util.formulae.MathScalar;
import com.klg.jclass.util.formulae.Max;
import com.klg.jclass.util.formulae.Median;
import com.klg.jclass.util.formulae.Min;
import com.klg.jclass.util.formulae.Multiply;
import com.klg.jclass.util.formulae.Power;
import com.klg.jclass.util.formulae.Product;
import com.klg.jclass.util.formulae.Remainder;
import com.klg.jclass.util.formulae.Root;
import com.klg.jclass.util.formulae.Round;
import com.klg.jclass.util.formulae.Sort;
import com.klg.jclass.util.formulae.StdDeviation;
import com.klg.jclass.util.formulae.Subtract;
import com.klg.jclass.util.formulae.Sum;
import com.klg.jclass.util.formulae.Trunc;
import java.awt.Point;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Vector;

public class FormulaParser
implements IFormulaParser,
FormulaParserConstants {
    public static final String ABS = "ABS";
    public static final String MULTIPLY = "MULTIPLY";
    public static final String AVERAGE = "AVERAGE";
    public static final String CEILING = "CEILING";
    public static final String DELTA = "DELTA";
    public static final String DELTA32 = "DELTA32";
    public static final String DELTA64 = "DELTA64";
    public static final String INTERVAL = "INTERVAL";
    public static final String POWER = "POWER";
    public static final String COUNT = "COUNT";
    public static final String PRODUCT = "PRODUCT";
    public static final String REMAINDER = "REMAINDER";
    public static final String ROOT = "ROOT";
    public static final String FLOOR = "FLOOR";
    public static final String ROUND = "ROUND";
    public static final String GEOMETRICMEAN = "GEOMETRICMEAN";
    public static final String SORT = "SORT";
    public static final String STDDEVIATION = "STDDEVIATION";
    public static final String SUBTRACT = "SUBTRACT";
    public static final String SUM = "SUM";
    public static final String MAX = "MAX";
    public static final String MEDIAN = "MEDIAN";
    public static final String TRUNC = "TRUNC";
    public static final String MIN = "MIN";
    public static final int MODE_ARITHMETIC_EXPRESSION = 0;
    public static final int MODE_OID_EXPRESSION = 1;
    public static final int MODE_FORMATTED_ARITHMETIC_EXPRESSION = 2;
    public static final int MODE_BOOLEAN_EXPRESSION = 3;
    public TableDataModel tableModel = null;
    public int currentRow = 0;
    public int currentCol = 0;
    public TargetInformation targetInformation;
    public MIBRepository rep;
    public int interval = 1;
    public FormulaParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int _$20558;
    private Token _$20657;
    private Token _$20656;
    private int _$20655;
    public boolean lookingAhead = false;
    private boolean _$20721;
    private int _$20571;
    private final int[] _$20570 = new int[37];
    private final int[] _$20722 = new int[]{-1006520299, -1006503915, -1004423147, 1729, 0x180000, 0x180000, -1004423148, 0xC00000, 0xC00000, 0x3000000, 0x3000000, 0x30000000, 0x30000000, -1006520300, 0x40000000, -1073741824, -1073741824, 0, 0, 0, -1006520300, 0, 0, 0, 0, 0, 0x8000000, -872302572, 67221524, 65536, 20, 448, 192, 0, 0, 0, 1728};
    private final int[] _$20723 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 4, 0, 8, 16, 16, 16, 16, 16, 0, 0, 0, 0, 0, 0, 16, 16, 16, 0};
    private final JJCalls[] _$20725 = new JJCalls[2];
    private boolean _$20726 = false;
    private int _$20727 = 0;
    private Vector _$20736 = new Vector();
    private int[] _$20737;
    private int _$20731 = -1;
    private int[] _$20738 = new int[100];
    private int _$20739;

    public FormulaParser() {
        this(new StringReader(""));
    }

    public Expression parseStream(Reader reader, int n2) throws ParseException {
        this.ReInit(reader);
        switch (n2) {
            case 1: {
                return this.parseOIDStringExpression();
            }
            case 2: {
                return this.parseFormattedArithmeticExpression();
            }
            case 3: {
                return this.parseBooleanExpression();
            }
        }
        return this.parseArithmeticExpression();
    }

    public Point getLocation(int n2, String string) {
        char c2 = string.toUpperCase().charAt(0);
        int n3 = c2 - 65;
        int n4 = 0;
        if (c2 == 'Z') {
            n3 = this.currentCol;
            if (string.length() < 2) {
                return new Point(n3, n2);
            }
        } else if (c2 == 'T') {
            n3 = -1;
            if (string.length() < 2) {
                return new Point(n3, n2);
            }
        } else if (string.length() < 2) {
            return new Point(n3, n2);
        }
        if (string.charAt(1) == '?') {
            return new Point(n3, 0);
        }
        try {
            n4 = Integer.valueOf(string.substring(1));
        }
        catch (NumberFormatException numberFormatException) {
            throw new NumberFormatException("Bad location " + string);
        }
        return new Point(n3, n2 - n4);
    }

    public final Expression parseArithmeticExpression() throws ParseException {
        switch (this._$20558 == -1 ? this._$20558() : this._$20558) {
            case 2: 
            case 4: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 26: 
            case 30: 
            case 31: {
                Expression expression = this.arithmeticExpression();
                this._$20568(0);
                return expression;
            }
            case 0: {
                this._$20568(0);
                throw new ParseException(this.token, "No expression entered");
            }
        }
        this._$20570[0] = this._$20571;
        this._$20568(-1);
        throw new ParseException();
    }

    public final Expression parseFormattedArithmeticExpression() throws ParseException {
        switch (this._$20558 == -1 ? this._$20558() : this._$20558) {
            case 14: {
                Expression expression = this.formatExpression();
                return expression;
            }
            case 2: 
            case 4: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 26: 
            case 30: 
            case 31: {
                Expression expression = this.arithmeticExpression();
                this._$20568(0);
                return expression;
            }
            case 0: {
                this._$20568(0);
                throw new ParseException(this.token, "No expression entered");
            }
        }
        this._$20570[1] = this._$20571;
        this._$20568(-1);
        throw new ParseException();
    }

    public final Expression parseBooleanExpression() throws ParseException {
        switch (this._$20558 == -1 ? this._$20558() : this._$20558) {
            case 2: 
            case 4: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 21: 
            case 26: 
            case 30: 
            case 31: {
                Expression expression = this.booleanExpression();
                this._$20568(0);
                return expression;
            }
            case 0: {
                this._$20568(0);
                throw new ParseException(this.token, "No expression entered");
            }
        }
        this._$20570[2] = this._$20571;
        this._$20568(-1);
        throw new ParseException();
    }

    public final Expression parseOIDStringExpression() throws ParseException {
        switch (this._$20558 == -1 ? this._$20558() : this._$20558) {
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                Expression expression = this.oidStringConcatExpression();
                this._$20568(0);
                return expression;
            }
            case 0: {
                this._$20568(0);
                throw new ParseException(this.token, "No expression entered");
            }
        }
        this._$20570[3] = this._$20571;
        this._$20568(-1);
        throw new ParseException();
    }

    public final Expression arithmeticExpression() throws ParseException {
        Expression expression = this.additiveExpression();
        return expression;
    }

    public final Expression booleanExpression() throws ParseException {
        Expression expression;
        block8: {
            expression = this.notExpression();
            block7: while (true) {
                switch (this._$20558 == -1 ? this._$20558() : this._$20558) {
                    case 19: 
                    case 20: {
                        break;
                    }
                    default: {
                        this._$20570[4] = this._$20571;
                        break block8;
                    }
                }
                switch (this._$20558 == -1 ? this._$20558() : this._$20558) {
                    case 19: {
                        this._$20568(19);
                        Expression expression2 = this.notExpression();
                        expression = new BooleanExpression(2, expression, expression2);
                        continue block7;
                    }
                    case 20: {
                        this._$20568(20);
                        Expression expression2 = this.notExpression();
                        expression = new BooleanExpression(1, expression, expression2);
                        continue block7;
                    }
                }
                break;
            }
            this._$20570[5] = this._$20571;
            this._$20568(-1);
            throw new ParseException();
        }
        return expression;
    }

    public final Expression notExpression() throws ParseException {
        Expression expression;
        switch (this._$20558 == -1 ? this._$20558() : this._$20558) {
            case 2: 
            case 4: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 26: 
            case 30: 
            case 31: {
                expression = this.relationalExpression();
                break;
            }
            case 21: {
                this._$20568(21);
                expression = this.relationalExpression();
                expression = new BooleanExpression(0, expression);
                break;
            }
            default: {
                this._$20570[6] = this._$20571;
                this._$20568(-1);
                throw new ParseException();
            }
        }
        return expression;
    }

    public final Expression relationalExpression() throws ParseException {
        Expression expression = this.OrEqualExpression();
        switch (this._$20558 == -1 ? this._$20558() : this._$20558) {
            case 22: 
            case 23: {
                switch (this._$20558 == -1 ? this._$20558() : this._$20558) {
                    case 22: {
                        this._$20568(22);
                        Expression expression2 = this.OrEqualExpression();
                        return new BooleanExpression(4, expression, expression2);
                    }
                    case 23: {
                        this._$20568(23);
                        Expression expression3 = this.OrEqualExpression();
                        return new BooleanExpression(3, expression, expression3);
                    }
                }
                this._$20570[7] = this._$20571;
                this._$20568(-1);
                throw new ParseException();
            }
        }
        this._$20570[8] = this._$20571;
        return expression;
    }

    public final Expression OrEqualExpression() throws ParseException {
        Expression expression = this.EqualExpression();
        switch (this._$20558 == -1 ? this._$20558() : this._$20558) {
            case 24: 
            case 25: {
                switch (this._$20558 == -1 ? this._$20558() : this._$20558) {
                    case 24: {
                        this._$20568(24);
                        Expression expression2 = this.additiveExpression();
                        BooleanExpression booleanExpression = new BooleanExpression(4, expression, expression2);
                        BooleanExpression booleanExpression2 = new BooleanExpression(5, expression, expression2);
                        return new BooleanExpression(1, booleanExpression, booleanExpression2);
                    }
                    case 25: {
                        this._$20568(25);
                        Expression expression3 = this.additiveExpression();
                        BooleanExpression booleanExpression = new BooleanExpression(3, expression, expression3);
                        BooleanExpression booleanExpression3 = new BooleanExpression(5, expression, expression3);
                        return new BooleanExpression(1, booleanExpression, booleanExpression3);
                    }
                }
                this._$20570[9] = this._$20571;
                this._$20568(-1);
                throw new ParseException();
            }
        }
        this._$20570[10] = this._$20571;
        return expression;
    }

    public final Expression EqualExpression() throws ParseException {
        Expression expression;
        if (this._$20589(3)) {
            this._$20568(26);
            Expression expression2 = this.booleanExpression();
            this._$20568(27);
            return expression2;
        }
        switch (this._$20558 == -1 ? this._$20558() : this._$20558) {
            case 2: 
            case 4: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 26: 
            case 30: 
            case 31: {
                expression = this.additiveExpression();
                switch (this._$20558 == -1 ? this._$20558() : this._$20558) {
                    case 28: 
                    case 29: {
                        switch (this._$20558 == -1 ? this._$20558() : this._$20558) {
                            case 28: {
                                this._$20568(28);
                                Expression expression3 = this.additiveExpression();
                                BooleanExpression booleanExpression = new BooleanExpression(5, expression, expression3);
                                return new BooleanExpression(0, booleanExpression);
                            }
                            case 29: {
                                this._$20568(29);
                                Expression expression4 = this.additiveExpression();
                                BooleanExpression booleanExpression = new BooleanExpression(5, expression, expression4);
                                return booleanExpression;
                            }
                        }
                        this._$20570[11] = this._$20571;
                        this._$20568(-1);
                        throw new ParseException();
                    }
                }
                this._$20570[12] = this._$20571;
                break;
            }
            default: {
                this._$20570[13] = this._$20571;
                this._$20568(-1);
                throw new ParseException();
            }
        }
        return expression;
    }

    public final Expression oidStringConcatExpression() throws ParseException {
        Expression expression = this.oidStringExpression();
        block3: while (true) {
            switch (this._$20558 == -1 ? this._$20558() : this._$20558) {
                case 30: {
                    break;
                }
                default: {
                    this._$20570[14] = this._$20571;
                    break block3;
                }
            }
            this._$20568(30);
            Expression expression2 = this.oidStringExpression();
            expression = new Concatenation(expression, new Concatenation(new StringConstant("."), expression2));
        }
        return expression;
    }

    public final Expression additiveExpression() throws ParseException {
        Expression expression;
        block8: {
            expression = this.multiplicativeExpression();
            block7: while (true) {
                switch (this._$20558 == -1 ? this._$20558() : this._$20558) {
                    case 30: 
                    case 31: {
                        break;
                    }
                    default: {
                        this._$20570[15] = this._$20571;
                        break block8;
                    }
                }
                switch (this._$20558 == -1 ? this._$20558() : this._$20558) {
                    case 30: {
                        this._$20568(30);
                        Expression expression2 = this.multiplicativeExpression();
                        expression = new Add(expression, expression2);
                        continue block7;
                    }
                    case 31: {
                        this._$20568(31);
                        Expression expression2 = this.multiplicativeExpression();
                        expression = new Subtract(expression, expression2);
                        continue block7;
                    }
                }
                break;
            }
            this._$20570[16] = this._$20571;
            this._$20568(-1);
            throw new ParseException();
        }
        return expression;
    }

    public final Expression multiplicativeExpression() throws ParseException {
        Expression expression = this.divisionExpression();
        block3: while (true) {
            switch (this._$20558 == -1 ? this._$20558() : this._$20558) {
                case 32: {
                    break;
                }
                default: {
                    this._$20570[17] = this._$20571;
                    break block3;
                }
            }
            this._$20568(32);
            Expression expression2 = this.divisionExpression();
            expression = new Multiply(expression, expression2);
        }
        return expression;
    }

    public final Expression divisionExpression() throws ParseException {
        Expression expression = this.modulusExpression();
        block3: while (true) {
            switch (this._$20558 == -1 ? this._$20558() : this._$20558) {
                case 33: {
                    break;
                }
                default: {
                    this._$20570[18] = this._$20571;
                    break block3;
                }
            }
            this._$20568(33);
            Expression expression2 = this.modulusExpression();
            expression = new Divide(expression, expression2);
        }
        return expression;
    }

    public final Expression modulusExpression() throws ParseException {
        Expression expression = this.unaryExpression();
        block3: while (true) {
            switch (this._$20558 == -1 ? this._$20558() : this._$20558) {
                case 34: {
                    break;
                }
                default: {
                    this._$20570[19] = this._$20571;
                    break block3;
                }
            }
            this._$20568(34);
            Expression expression2 = this.unaryExpression();
            expression = new Remainder(expression, expression2);
        }
        return expression;
    }

    public final Expression unaryExpression() throws ParseException {
        Expression expression;
        switch (this._$20558 == -1 ? this._$20558() : this._$20558) {
            case 30: {
                this._$20568(30);
                expression = this.unaryExpression();
                break;
            }
            case 31: {
                this._$20568(31);
                expression = this.unaryExpression();
                expression = new Multiply((Number)new Integer(-1), expression);
                break;
            }
            case 2: 
            case 4: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 26: {
                expression = this.powerExpression();
                break;
            }
            default: {
                this._$20570[20] = this._$20571;
                this._$20568(-1);
                throw new ParseException();
            }
        }
        return expression;
    }

    public final Expression powerExpression() throws ParseException {
        Expression expression = this.unaryExpressionNotPlusMinus();
        switch (this._$20558 == -1 ? this._$20558() : this._$20558) {
            case 35: {
                this._$20568(35);
                Expression expression2 = this.unaryExpression();
                return new Power(expression, expression2);
            }
        }
        this._$20570[21] = this._$20571;
        return expression;
    }

    public final Expression unaryExpressionNotPlusMinus() throws ParseException {
        Expression expression;
        String string = null;
        String string2 = null;
        String string3 = null;
        block2 : switch (this._$20558 == -1 ? this._$20558() : this._$20558) {
            case 2: 
            case 4: {
                expression = this.anyConstant();
                break;
            }
            case 16: {
                expression = this.anyReference();
                break;
            }
            case 26: {
                this._$20568(26);
                expression = this.arithmeticExpression();
                this._$20568(27);
                break;
            }
            case 12: {
                this._$20568(12);
                this._$20568(26);
                String string4 = this.oidConstant();
                block11 : switch (this._$20558 == -1 ? this._$20558() : this._$20558) {
                    case 36: {
                        this._$20568(36);
                        string = this.oidConstant();
                        this._$20568(36);
                        string2 = this.stringConstant();
                        if (!Regex.isRegex(string2)) {
                            throw new ParseException(this.token, "Illegal regular expression: " + string2);
                        }
                        switch (this._$20558 == -1 ? this._$20558() : this._$20558) {
                            case 36: {
                                this._$20568(36);
                                string3 = this.stringConstant();
                                break block11;
                            }
                        }
                        this._$20570[22] = this._$20571;
                        break;
                    }
                    default: {
                        this._$20570[23] = this._$20571;
                    }
                }
                this._$20568(27);
                try {
                    return new SumWhen(this.rep, this.targetInformation, string4, false, string, string2, string3);
                }
                catch (Exception exception) {
                    throw new ParseException(this.token, "Illegal regular expression: " + string2);
                }
            }
            case 13: {
                this._$20568(13);
                this._$20568(26);
                String string5 = this.oidConstant();
                block17 : switch (this._$20558 == -1 ? this._$20558() : this._$20558) {
                    case 36: {
                        this._$20568(36);
                        string = this.oidConstant();
                        this._$20568(36);
                        string2 = this.stringConstant();
                        if (!Regex.isRegex(string2)) {
                            throw new ParseException(this.token, "Illegal regular expression: " + string2);
                        }
                        switch (this._$20558 == -1 ? this._$20558() : this._$20558) {
                            case 36: {
                                this._$20568(36);
                                string3 = this.stringConstant();
                                break block17;
                            }
                        }
                        this._$20570[24] = this._$20571;
                        break;
                    }
                    default: {
                        this._$20570[25] = this._$20571;
                    }
                }
                this._$20568(27);
                try {
                    return new SumWhen(this.rep, this.targetInformation, string5, true, string, string2, string3);
                }
                catch (Exception exception) {
                    throw new ParseException(this.token, "Illegal regular expression: " + string2);
                }
            }
            case 11: {
                this._$20568(11);
                this._$20568(26);
                Expression expression2 = this.booleanExpression();
                this._$20568(36);
                Expression expression3 = this.arithmeticExpression();
                this._$20568(36);
                Expression expression4 = this.arithmeticExpression();
                this._$20568(27);
                return new ConditionalExpression((BooleanExpression)expression2, expression3, expression4);
            }
            case 15: {
                String string6 = this.functionID();
                this._$20568(26);
                switch (this._$20558 == -1 ? this._$20558() : this._$20558) {
                    case 27: {
                        this._$20568(27);
                        if (string6.equalsIgnoreCase(INTERVAL)) {
                            expression = new MathScalar(this.interval);
                            break block2;
                        }
                        throw new ParseException(this.token, "Unknown function: " + string6);
                    }
                    case 2: 
                    case 4: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 15: 
                    case 16: 
                    case 26: 
                    case 30: 
                    case 31: {
                        Expression expression5 = this.arithmeticExpression();
                        switch (this._$20558 == -1 ? this._$20558() : this._$20558) {
                            case 36: {
                                this._$20568(36);
                                Expression expression6 = this.arithmeticExpression();
                                this._$20568(27);
                                if (string6.equalsIgnoreCase(SUM)) {
                                    expression = new Sum(expression5, expression6);
                                    break block2;
                                }
                                if (string6.equalsIgnoreCase(AVERAGE)) {
                                    expression = new Average(expression5, expression6);
                                    break block2;
                                }
                                if (string6.equalsIgnoreCase(COUNT)) {
                                    expression = new Count(expression5, expression6);
                                    break block2;
                                }
                                if (string6.equalsIgnoreCase(GEOMETRICMEAN)) {
                                    expression = new GeometricMean(expression5, expression6);
                                    break block2;
                                }
                                if (string6.equalsIgnoreCase(MEDIAN)) {
                                    expression = new Median(expression5, expression6);
                                    break block2;
                                }
                                if (string6.equalsIgnoreCase(MAX)) {
                                    expression = new Max(expression5, expression6);
                                    break block2;
                                }
                                if (string6.equalsIgnoreCase(MIN)) {
                                    expression = new Min(expression5, expression6);
                                    break block2;
                                }
                                if (string6.equalsIgnoreCase(POWER)) {
                                    expression = new Power(expression5, expression6);
                                    break block2;
                                }
                                if (string6.equalsIgnoreCase(PRODUCT)) {
                                    expression = new Product(expression5, expression6);
                                    break block2;
                                }
                                if (string6.equalsIgnoreCase(REMAINDER)) {
                                    expression = new Remainder(expression5, expression6);
                                    break block2;
                                }
                                if (string6.equalsIgnoreCase(SORT)) {
                                    expression = new Sort(expression5, expression6);
                                    break block2;
                                }
                                if (string6.equalsIgnoreCase(STDDEVIATION)) {
                                    expression = new StdDeviation(expression5, expression6);
                                    break block2;
                                }
                                if (string6.equalsIgnoreCase(SUM)) {
                                    expression = new Sum(expression5, expression6);
                                    break block2;
                                }
                                if (string6.equalsIgnoreCase(DELTA)) {
                                    expression = new Delta(expression5, expression6);
                                    break block2;
                                }
                                if (string6.equalsIgnoreCase(DELTA32)) {
                                    expression = new Delta(expression5, expression6, new MathScalar(4.294967295E9));
                                    break block2;
                                }
                                if (string6.equalsIgnoreCase(DELTA64)) {
                                    expression = new Delta(expression5, expression6, new MathScalar(1.8446744073709552E19));
                                    break block2;
                                }
                                throw new ParseException(this.token, "Unknown function: " + string6);
                            }
                            case 27: {
                                this._$20568(27);
                                if (string6.equalsIgnoreCase(ABS)) {
                                    expression = new Abs(expression5);
                                    break block2;
                                }
                                if (string6.equalsIgnoreCase(AVERAGE)) {
                                    expression = new Average(expression5);
                                    break block2;
                                }
                                if (string6.equalsIgnoreCase(CEILING)) {
                                    expression = new Ceiling(expression5);
                                    break block2;
                                }
                                if (string6.equalsIgnoreCase(COUNT)) {
                                    expression = new Count(expression5);
                                    break block2;
                                }
                                if (string6.equalsIgnoreCase(FLOOR)) {
                                    expression = new Floor(expression5);
                                    break block2;
                                }
                                if (string6.equalsIgnoreCase(MAX)) {
                                    expression = new Max(expression5);
                                    break block2;
                                }
                                if (string6.equalsIgnoreCase(MEDIAN)) {
                                    expression = new Median(expression5);
                                    break block2;
                                }
                                if (string6.equalsIgnoreCase(MIN)) {
                                    expression = new Min(expression5);
                                    break block2;
                                }
                                if (string6.equalsIgnoreCase(PRODUCT)) {
                                    expression = new Product(expression5);
                                    break block2;
                                }
                                if (string6.equalsIgnoreCase(ROOT)) {
                                    expression = new Root(expression5);
                                    break block2;
                                }
                                if (string6.equalsIgnoreCase(SORT)) {
                                    expression = new Sort(expression5);
                                    break block2;
                                }
                                if (string6.equalsIgnoreCase(SUM)) {
                                    expression = new Sum(expression5);
                                    break block2;
                                }
                                if (string6.equalsIgnoreCase(ROUND)) {
                                    expression = new Round(expression5);
                                    break block2;
                                }
                                if (string6.equalsIgnoreCase(STDDEVIATION)) {
                                    expression = new StdDeviation(expression5);
                                    break block2;
                                }
                                if (string6.equalsIgnoreCase(GEOMETRICMEAN)) {
                                    expression = new GeometricMean(expression5);
                                    break block2;
                                }
                                if (string6.equalsIgnoreCase(TRUNC)) {
                                    expression = new Trunc(expression5);
                                    break block2;
                                }
                                if (string6.equalsIgnoreCase(DELTA32)) {
                                    expression = new Delta(expression5, (Expression)new MathScalar(4.294967295E9));
                                    break block2;
                                }
                                if (string6.equalsIgnoreCase(DELTA64)) {
                                    expression = new Delta(expression5, (Expression)new MathScalar(1.8446744073709552E19));
                                    break block2;
                                }
                                throw new ParseException(this.token, "Unknown function: " + string6);
                            }
                        }
                        this._$20570[26] = this._$20571;
                        this._$20568(-1);
                        throw new ParseException();
                    }
                }
                this._$20570[27] = this._$20571;
                this._$20568(-1);
                throw new ParseException();
            }
            default: {
                this._$20570[28] = this._$20571;
                this._$20568(-1);
                throw new ParseException();
            }
        }
        return expression;
    }

    public final String functionID() throws ParseException {
        Token token = this._$20568(15);
        return token.image;
    }

    public final String reference() throws ParseException {
        Token token = this._$20568(16);
        return token.image;
    }

    public final Expression anyReference() throws ParseException {
        Expression expression;
        if (this._$20643(2)) {
            String string = this.reference();
            this._$20568(37);
            String string2 = this.reference();
            Point point = this.getLocation(this.currentRow, string);
            Point point2 = this.getLocation(this.currentRow, string2);
            expression = this.tableModel == null || this.tableModel.getNumRows() == 0 ? new MathScalar(Double.valueOf("0.0")) : new ArithmeticExpressionList(this.tableModel, new MathScalar(point.y), new MathScalar(point2.y), new MathScalar(point.x), new MathScalar(point2.x));
        } else {
            switch (this._$20558 == -1 ? this._$20558() : this._$20558) {
                case 16: {
                    String string = this.reference();
                    Point point = this.getLocation(this.currentRow, string);
                    if (this.tableModel == null || this.tableModel.getNumRows() == 0) {
                        expression = new MathScalar(Double.valueOf("0.0"));
                        break;
                    }
                    expression = new ExtTableReference(this.tableModel, point);
                    break;
                }
                default: {
                    this._$20570[29] = this._$20571;
                    this._$20568(-1);
                    throw new ParseException();
                }
            }
        }
        return expression;
    }

    public final Expression anyConstant() throws ParseException {
        Double d2 = this.realConstant();
        return new MathScalar(d2);
    }

    public final Double realConstant() throws ParseException {
        Token token;
        switch (this._$20558 == -1 ? this._$20558() : this._$20558) {
            case 2: {
                token = this._$20568(2);
                break;
            }
            case 4: {
                token = this._$20568(4);
                break;
            }
            default: {
                this._$20570[30] = this._$20571;
                this._$20568(-1);
                throw new ParseException();
            }
        }
        try {
            return new Double(token.image);
        }
        catch (Exception exception) {
            throw new ParseException(this.token, "Can't parse \"" + token.image + "\"");
        }
    }

    public final Long integerConstant() throws ParseException {
        Token token = this._$20568(2);
        try {
            return new Long(token.image);
        }
        catch (Exception exception) {
            throw new ParseException(this.token, "\"" + token.image + "\" is not an integer");
        }
    }

    public final String stringConstant() throws ParseException {
        Token token;
        switch (this._$20558 == -1 ? this._$20558() : this._$20558) {
            case 8: {
                token = this._$20568(8);
                break;
            }
            case 6: {
                token = this._$20568(6);
                break;
            }
            case 7: {
                token = this._$20568(7);
                break;
            }
            default: {
                this._$20570[31] = this._$20571;
                this._$20568(-1);
                throw new ParseException();
            }
        }
        return token.image.substring(1, token.image.length() - 1);
    }

    public final String oidConstant() throws ParseException {
        Token token;
        switch (this._$20558 == -1 ? this._$20558() : this._$20558) {
            case 6: {
                token = this._$20568(6);
                break;
            }
            case 7: {
                token = this._$20568(7);
                break;
            }
            default: {
                this._$20570[32] = this._$20571;
                this._$20568(-1);
                throw new ParseException();
            }
        }
        return token.image.substring(1, token.image.length() - 1);
    }

    public final Expression formatExpression() throws ParseException {
        Long l2 = null;
        this._$20568(14);
        this._$20568(26);
        Expression expression = this.arithmeticExpression();
        this._$20568(36);
        String string = this.stringConstant();
        switch (this._$20558 == -1 ? this._$20558() : this._$20558) {
            case 36: {
                this._$20568(36);
                l2 = this.integerConstant();
                break;
            }
            default: {
                this._$20570[33] = this._$20571;
            }
        }
        this._$20568(27);
        if (l2 != null) {
            return new NumberFormatExpression(expression, string, l2.intValue());
        }
        return new NumberFormatExpression(expression, string);
    }

    public final Expression valueExpression() throws ParseException {
        this._$20568(9);
        this._$20568(26);
        String string = this.oidConstant();
        this._$20568(27);
        return new ValueOf(this.rep, this.targetInformation, string, false);
    }

    public final Expression oidStringExpression() throws ParseException {
        Token token = null;
        String string = null;
        switch (this._$20558 == -1 ? this._$20558() : this._$20558) {
            case 6: 
            case 7: {
                String string2 = this.oidConstant();
                return new OidConstant(this.rep, string2);
            }
            case 9: {
                this._$20568(9);
                this._$20568(26);
                String string3 = this.oidConstant();
                this._$20568(27);
                return new ValueOf(this.rep, this.targetInformation, string3);
            }
            case 10: {
                this._$20568(10);
                this._$20568(26);
                String string4 = this.oidConstant();
                this._$20568(36);
                String string5 = this.stringConstant();
                block6 : switch (this._$20558 == -1 ? this._$20558() : this._$20558) {
                    case 36: {
                        this._$20568(36);
                        token = this._$20568(2);
                        if (!Regex.isRegex(string5)) {
                            throw new ParseException(this.token, "Illegal regular expression: " + string5);
                        }
                        switch (this._$20558 == -1 ? this._$20558() : this._$20558) {
                            case 36: {
                                this._$20568(36);
                                string = this.stringConstant();
                                break block6;
                            }
                        }
                        this._$20570[34] = this._$20571;
                        break;
                    }
                    default: {
                        this._$20570[35] = this._$20571;
                    }
                }
                this._$20568(27);
                try {
                    if (token == null) {
                        return new ValueOf(this.rep, this.targetInformation, string4, string5);
                    }
                    int n2 = Integer.parseInt(token.image);
                    if (n2 < 1) {
                        throw new ParseException(this.token, "Occurance parameter must be > 0!");
                    }
                    return new ValueOf(this.rep, this.targetInformation, string4, string5, true, n2, string);
                }
                catch (Exception exception) {
                    throw new ParseException(this.token, "Illegal regular expression: " + string5);
                }
            }
        }
        this._$20570[36] = this._$20571;
        this._$20568(-1);
        throw new ParseException();
    }

    private final boolean _$20589(int n2) {
        this._$20655 = n2;
        this._$20656 = this._$20657 = this.token;
        boolean bl = !this._$20659();
        this._$20660(0, n2);
        return bl;
    }

    private final boolean _$20643(int n2) {
        this._$20655 = n2;
        this._$20656 = this._$20657 = this.token;
        boolean bl = !this._$20661();
        this._$20660(1, n2);
        return bl;
    }

    private final boolean _$20662() {
        if (this._$20663()) {
            return true;
        }
        if (this._$20655 == 0 && this._$20657 == this._$20656) {
            return false;
        }
        Token token = this._$20657;
        if (this._$20665()) {
            this._$20657 = token;
        } else if (this._$20655 == 0 && this._$20657 == this._$20656) {
            return false;
        }
        return false;
    }

    private final boolean _$20666() {
        Token token = this._$20657;
        if (this._$20667()) {
            this._$20657 = token;
            if (this._$20668()) {
                return true;
            }
            if (this._$20655 == 0 && this._$20657 == this._$20656) {
                return false;
            }
        } else if (this._$20655 == 0 && this._$20657 == this._$20656) {
            return false;
        }
        return false;
    }

    private final boolean _$20667() {
        if (this._$20669(30)) {
            return true;
        }
        if (this._$20655 == 0 && this._$20657 == this._$20656) {
            return false;
        }
        return false;
    }

    private final boolean _$20670() {
        Token token;
        block3: {
            if (this._$20671()) {
                return true;
            }
            if (this._$20655 == 0 && this._$20657 == this._$20656) {
                return false;
            }
            do {
                token = this._$20657;
                if (this._$20666()) break block3;
            } while (this._$20655 != 0 || this._$20657 != this._$20656);
            return false;
        }
        this._$20657 = token;
        return false;
    }

    private final boolean _$20672() {
        if (this._$20673()) {
            return true;
        }
        if (this._$20655 == 0 && this._$20657 == this._$20656) {
            return false;
        }
        return false;
    }

    private final boolean _$20674() {
        if (this._$20675()) {
            return true;
        }
        if (this._$20655 == 0 && this._$20657 == this._$20656) {
            return false;
        }
        return false;
    }

    private final boolean _$20676() {
        if (this._$20669(31)) {
            return true;
        }
        if (this._$20655 == 0 && this._$20657 == this._$20656) {
            return false;
        }
        if (this._$20677()) {
            return true;
        }
        if (this._$20655 == 0 && this._$20657 == this._$20656) {
            return false;
        }
        return false;
    }

    private final boolean _$20678() {
        if (this._$20669(23)) {
            return true;
        }
        if (this._$20655 == 0 && this._$20657 == this._$20656) {
            return false;
        }
        return false;
    }

    private final boolean _$20679() {
        if (this._$20669(30)) {
            return true;
        }
        if (this._$20655 == 0 && this._$20657 == this._$20656) {
            return false;
        }
        if (this._$20677()) {
            return true;
        }
        if (this._$20655 == 0 && this._$20657 == this._$20656) {
            return false;
        }
        return false;
    }

    private final boolean _$20677() {
        Token token = this._$20657;
        if (this._$20679()) {
            this._$20657 = token;
            if (this._$20676()) {
                this._$20657 = token;
                if (this._$20674()) {
                    return true;
                }
                if (this._$20655 == 0 && this._$20657 == this._$20656) {
                    return false;
                }
            } else if (this._$20655 == 0 && this._$20657 == this._$20656) {
                return false;
            }
        } else if (this._$20655 == 0 && this._$20657 == this._$20656) {
            return false;
        }
        return false;
    }

    private final boolean _$20680() {
        if (this._$20681()) {
            return true;
        }
        if (this._$20655 == 0 && this._$20657 == this._$20656) {
            return false;
        }
        if (this._$20669(26)) {
            return true;
        }
        if (this._$20655 == 0 && this._$20657 == this._$20656) {
            return false;
        }
        return false;
    }

    private final boolean _$20682() {
        if (this._$20669(22)) {
            return true;
        }
        if (this._$20655 == 0 && this._$20657 == this._$20656) {
            return false;
        }
        return false;
    }

    private final boolean _$20683() {
        Token token = this._$20657;
        if (this._$20682()) {
            this._$20657 = token;
            if (this._$20678()) {
                return true;
            }
            if (this._$20655 == 0 && this._$20657 == this._$20656) {
                return false;
            }
        } else if (this._$20655 == 0 && this._$20657 == this._$20656) {
            return false;
        }
        return false;
    }

    private final boolean _$20684() {
        if (this._$20669(11)) {
            return true;
        }
        if (this._$20655 == 0 && this._$20657 == this._$20656) {
            return false;
        }
        if (this._$20669(26)) {
            return true;
        }
        if (this._$20655 == 0 && this._$20657 == this._$20656) {
            return false;
        }
        return false;
    }

    private final boolean _$20685() {
        if (this._$20662()) {
            return true;
        }
        if (this._$20655 == 0 && this._$20657 == this._$20656) {
            return false;
        }
        Token token = this._$20657;
        if (this._$20683()) {
            this._$20657 = token;
        } else if (this._$20655 == 0 && this._$20657 == this._$20656) {
            return false;
        }
        return false;
    }

    private final boolean _$20686() {
        if (this._$20687()) {
            return true;
        }
        if (this._$20655 == 0 && this._$20657 == this._$20656) {
            return false;
        }
        return false;
    }

    private final boolean _$20688() {
        if (this._$20669(34)) {
            return true;
        }
        if (this._$20655 == 0 && this._$20657 == this._$20656) {
            return false;
        }
        return false;
    }

    private final boolean _$20689() {
        Token token;
        block3: {
            if (this._$20677()) {
                return true;
            }
            if (this._$20655 == 0 && this._$20657 == this._$20656) {
                return false;
            }
            do {
                token = this._$20657;
                if (this._$20688()) break block3;
            } while (this._$20655 != 0 || this._$20657 != this._$20656);
            return false;
        }
        this._$20657 = token;
        return false;
    }

    private final boolean _$20690() {
        if (this._$20669(13)) {
            return true;
        }
        if (this._$20655 == 0 && this._$20657 == this._$20656) {
            return false;
        }
        if (this._$20669(26)) {
            return true;
        }
        if (this._$20655 == 0 && this._$20657 == this._$20656) {
            return false;
        }
        return false;
    }

    private final boolean _$20691() {
        if (this._$20669(29)) {
            return true;
        }
        if (this._$20655 == 0 && this._$20657 == this._$20656) {
            return false;
        }
        return false;
    }

    private final boolean _$20692() {
        if (this._$20669(21)) {
            return true;
        }
        if (this._$20655 == 0 && this._$20657 == this._$20656) {
            return false;
        }
        if (this._$20685()) {
            return true;
        }
        if (this._$20655 == 0 && this._$20657 == this._$20656) {
            return false;
        }
        return false;
    }

    private final boolean _$20693() {
        if (this._$20685()) {
            return true;
        }
        if (this._$20655 == 0 && this._$20657 == this._$20656) {
            return false;
        }
        return false;
    }

    private final boolean _$20694() {
        Token token = this._$20657;
        if (this._$20693()) {
            this._$20657 = token;
            if (this._$20692()) {
                return true;
            }
            if (this._$20655 == 0 && this._$20657 == this._$20656) {
                return false;
            }
        } else if (this._$20655 == 0 && this._$20657 == this._$20656) {
            return false;
        }
        return false;
    }

    private final boolean _$20695() {
        Token token = this._$20657;
        if (this._$20696()) {
            this._$20657 = token;
            if (this._$20691()) {
                return true;
            }
            if (this._$20655 == 0 && this._$20657 == this._$20656) {
                return false;
            }
        } else if (this._$20655 == 0 && this._$20657 == this._$20656) {
            return false;
        }
        return false;
    }

    private final boolean _$20696() {
        if (this._$20669(28)) {
            return true;
        }
        if (this._$20655 == 0 && this._$20657 == this._$20656) {
            return false;
        }
        return false;
    }

    private final boolean _$20661() {
        if (this._$20687()) {
            return true;
        }
        if (this._$20655 == 0 && this._$20657 == this._$20656) {
            return false;
        }
        if (this._$20669(37)) {
            return true;
        }
        if (this._$20655 == 0 && this._$20657 == this._$20656) {
            return false;
        }
        return false;
    }

    private final boolean _$20697() {
        Token token = this._$20657;
        if (this._$20661()) {
            this._$20657 = token;
            if (this._$20686()) {
                return true;
            }
            if (this._$20655 == 0 && this._$20657 == this._$20656) {
                return false;
            }
        } else if (this._$20655 == 0 && this._$20657 == this._$20656) {
            return false;
        }
        return false;
    }

    private final boolean _$20698() {
        if (this._$20669(33)) {
            return true;
        }
        if (this._$20655 == 0 && this._$20657 == this._$20656) {
            return false;
        }
        return false;
    }

    private final boolean _$20699() {
        if (this._$20670()) {
            return true;
        }
        if (this._$20655 == 0 && this._$20657 == this._$20656) {
            return false;
        }
        Token token = this._$20657;
        if (this._$20695()) {
            this._$20657 = token;
        } else if (this._$20655 == 0 && this._$20657 == this._$20656) {
            return false;
        }
        return false;
    }

    private final boolean _$20659() {
        if (this._$20669(26)) {
            return true;
        }
        if (this._$20655 == 0 && this._$20657 == this._$20656) {
            return false;
        }
        if (this._$20700()) {
            return true;
        }
        if (this._$20655 == 0 && this._$20657 == this._$20656) {
            return false;
        }
        if (this._$20669(27)) {
            return true;
        }
        if (this._$20655 == 0 && this._$20657 == this._$20656) {
            return false;
        }
        return false;
    }

    private final boolean _$20701() {
        Token token;
        block3: {
            if (this._$20689()) {
                return true;
            }
            if (this._$20655 == 0 && this._$20657 == this._$20656) {
                return false;
            }
            do {
                token = this._$20657;
                if (this._$20698()) break block3;
            } while (this._$20655 != 0 || this._$20657 != this._$20656);
            return false;
        }
        this._$20657 = token;
        return false;
    }

    private final boolean _$20702() {
        if (this._$20669(12)) {
            return true;
        }
        if (this._$20655 == 0 && this._$20657 == this._$20656) {
            return false;
        }
        if (this._$20669(26)) {
            return true;
        }
        if (this._$20655 == 0 && this._$20657 == this._$20656) {
            return false;
        }
        return false;
    }

    private final boolean _$20703() {
        if (this._$20669(20)) {
            return true;
        }
        if (this._$20655 == 0 && this._$20657 == this._$20656) {
            return false;
        }
        return false;
    }

    private final boolean _$20663() {
        Token token = this._$20657;
        if (this._$20659()) {
            this._$20657 = token;
            if (this._$20699()) {
                return true;
            }
            if (this._$20655 == 0 && this._$20657 == this._$20656) {
                return false;
            }
        } else if (this._$20655 == 0 && this._$20657 == this._$20656) {
            return false;
        }
        return false;
    }

    private final boolean _$20704() {
        if (this._$20669(26)) {
            return true;
        }
        if (this._$20655 == 0 && this._$20657 == this._$20656) {
            return false;
        }
        if (this._$20705()) {
            return true;
        }
        if (this._$20655 == 0 && this._$20657 == this._$20656) {
            return false;
        }
        return false;
    }

    private final boolean _$20687() {
        if (this._$20669(16)) {
            return true;
        }
        if (this._$20655 == 0 && this._$20657 == this._$20656) {
            return false;
        }
        return false;
    }

    private final boolean _$20706() {
        if (this._$20697()) {
            return true;
        }
        if (this._$20655 == 0 && this._$20657 == this._$20656) {
            return false;
        }
        return false;
    }

    private final boolean _$20707() {
        if (this._$20669(19)) {
            return true;
        }
        if (this._$20655 == 0 && this._$20657 == this._$20656) {
            return false;
        }
        return false;
    }

    private final boolean _$20708() {
        Token token = this._$20657;
        if (this._$20707()) {
            this._$20657 = token;
            if (this._$20703()) {
                return true;
            }
            if (this._$20655 == 0 && this._$20657 == this._$20656) {
                return false;
            }
        } else if (this._$20655 == 0 && this._$20657 == this._$20656) {
            return false;
        }
        return false;
    }

    private final boolean _$20709() {
        if (this._$20672()) {
            return true;
        }
        if (this._$20655 == 0 && this._$20657 == this._$20656) {
            return false;
        }
        return false;
    }

    private final boolean _$20710() {
        Token token = this._$20657;
        if (this._$20709()) {
            this._$20657 = token;
            if (this._$20706()) {
                this._$20657 = token;
                if (this._$20704()) {
                    this._$20657 = token;
                    if (this._$20702()) {
                        this._$20657 = token;
                        if (this._$20690()) {
                            this._$20657 = token;
                            if (this._$20684()) {
                                this._$20657 = token;
                                if (this._$20680()) {
                                    return true;
                                }
                                if (this._$20655 == 0 && this._$20657 == this._$20656) {
                                    return false;
                                }
                            } else if (this._$20655 == 0 && this._$20657 == this._$20656) {
                                return false;
                            }
                        } else if (this._$20655 == 0 && this._$20657 == this._$20656) {
                            return false;
                        }
                    } else if (this._$20655 == 0 && this._$20657 == this._$20656) {
                        return false;
                    }
                } else if (this._$20655 == 0 && this._$20657 == this._$20656) {
                    return false;
                }
            } else if (this._$20655 == 0 && this._$20657 == this._$20656) {
                return false;
            }
        } else if (this._$20655 == 0 && this._$20657 == this._$20656) {
            return false;
        }
        return false;
    }

    private final boolean _$20700() {
        Token token;
        block3: {
            if (this._$20694()) {
                return true;
            }
            if (this._$20655 == 0 && this._$20657 == this._$20656) {
                return false;
            }
            do {
                token = this._$20657;
                if (this._$20708()) break block3;
            } while (this._$20655 != 0 || this._$20657 != this._$20656);
            return false;
        }
        this._$20657 = token;
        return false;
    }

    private final boolean _$20711() {
        if (this._$20669(32)) {
            return true;
        }
        if (this._$20655 == 0 && this._$20657 == this._$20656) {
            return false;
        }
        return false;
    }

    private final boolean _$20681() {
        if (this._$20669(15)) {
            return true;
        }
        if (this._$20655 == 0 && this._$20657 == this._$20656) {
            return false;
        }
        return false;
    }

    private final boolean _$20671() {
        Token token;
        block3: {
            if (this._$20701()) {
                return true;
            }
            if (this._$20655 == 0 && this._$20657 == this._$20656) {
                return false;
            }
            do {
                token = this._$20657;
                if (this._$20711()) break block3;
            } while (this._$20655 != 0 || this._$20657 != this._$20656);
            return false;
        }
        this._$20657 = token;
        return false;
    }

    private final boolean _$20712() {
        if (this._$20669(25)) {
            return true;
        }
        if (this._$20655 == 0 && this._$20657 == this._$20656) {
            return false;
        }
        return false;
    }

    private final boolean _$20705() {
        if (this._$20670()) {
            return true;
        }
        if (this._$20655 == 0 && this._$20657 == this._$20656) {
            return false;
        }
        return false;
    }

    private final boolean _$20665() {
        Token token = this._$20657;
        if (this._$20713()) {
            this._$20657 = token;
            if (this._$20712()) {
                return true;
            }
            if (this._$20655 == 0 && this._$20657 == this._$20656) {
                return false;
            }
        } else if (this._$20655 == 0 && this._$20657 == this._$20656) {
            return false;
        }
        return false;
    }

    private final boolean _$20713() {
        if (this._$20669(24)) {
            return true;
        }
        if (this._$20655 == 0 && this._$20657 == this._$20656) {
            return false;
        }
        return false;
    }

    private final boolean _$20714() {
        if (this._$20669(35)) {
            return true;
        }
        if (this._$20655 == 0 && this._$20657 == this._$20656) {
            return false;
        }
        return false;
    }

    private final boolean _$20668() {
        if (this._$20669(31)) {
            return true;
        }
        if (this._$20655 == 0 && this._$20657 == this._$20656) {
            return false;
        }
        return false;
    }

    private final boolean _$20715() {
        if (this._$20669(4)) {
            return true;
        }
        if (this._$20655 == 0 && this._$20657 == this._$20656) {
            return false;
        }
        return false;
    }

    private final boolean _$20675() {
        if (this._$20710()) {
            return true;
        }
        if (this._$20655 == 0 && this._$20657 == this._$20656) {
            return false;
        }
        Token token = this._$20657;
        if (this._$20714()) {
            this._$20657 = token;
        } else if (this._$20655 == 0 && this._$20657 == this._$20656) {
            return false;
        }
        return false;
    }

    private final boolean _$20716() {
        if (this._$20669(2)) {
            return true;
        }
        if (this._$20655 == 0 && this._$20657 == this._$20656) {
            return false;
        }
        return false;
    }

    private final boolean _$20673() {
        Token token = this._$20657;
        if (this._$20716()) {
            this._$20657 = token;
            if (this._$20715()) {
                return true;
            }
            if (this._$20655 == 0 && this._$20657 == this._$20656) {
                return false;
            }
        } else if (this._$20655 == 0 && this._$20657 == this._$20656) {
            return false;
        }
        return false;
    }

    public FormulaParser(InputStream inputStream) {
        int n2;
        this.jj_input_stream = new SimpleCharStream(inputStream, 1, 1);
        this.token_source = new FormulaParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this._$20558 = -1;
        this._$20571 = 0;
        for (n2 = 0; n2 < 37; ++n2) {
            this._$20570[n2] = -1;
        }
        for (n2 = 0; n2 < this._$20725.length; ++n2) {
            this._$20725[n2] = new JJCalls();
        }
    }

    public void ReInit(InputStream inputStream) {
        int n2;
        this.jj_input_stream.ReInit(inputStream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this._$20558 = -1;
        this._$20571 = 0;
        for (n2 = 0; n2 < 37; ++n2) {
            this._$20570[n2] = -1;
        }
        for (n2 = 0; n2 < this._$20725.length; ++n2) {
            this._$20725[n2] = new JJCalls();
        }
    }

    public FormulaParser(Reader reader) {
        int n2;
        this.jj_input_stream = new SimpleCharStream(reader, 1, 1);
        this.token_source = new FormulaParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this._$20558 = -1;
        this._$20571 = 0;
        for (n2 = 0; n2 < 37; ++n2) {
            this._$20570[n2] = -1;
        }
        for (n2 = 0; n2 < this._$20725.length; ++n2) {
            this._$20725[n2] = new JJCalls();
        }
    }

    public void ReInit(Reader reader) {
        int n2;
        this.jj_input_stream.ReInit(reader, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this._$20558 = -1;
        this._$20571 = 0;
        for (n2 = 0; n2 < 37; ++n2) {
            this._$20570[n2] = -1;
        }
        for (n2 = 0; n2 < this._$20725.length; ++n2) {
            this._$20725[n2] = new JJCalls();
        }
    }

    public FormulaParser(FormulaParserTokenManager formulaParserTokenManager) {
        int n2;
        this.token_source = formulaParserTokenManager;
        this.token = new Token();
        this._$20558 = -1;
        this._$20571 = 0;
        for (n2 = 0; n2 < 37; ++n2) {
            this._$20570[n2] = -1;
        }
        for (n2 = 0; n2 < this._$20725.length; ++n2) {
            this._$20725[n2] = new JJCalls();
        }
    }

    public void ReInit(FormulaParserTokenManager formulaParserTokenManager) {
        int n2;
        this.token_source = formulaParserTokenManager;
        this.token = new Token();
        this._$20558 = -1;
        this._$20571 = 0;
        for (n2 = 0; n2 < 37; ++n2) {
            this._$20570[n2] = -1;
        }
        for (n2 = 0; n2 < this._$20725.length; ++n2) {
            this._$20725[n2] = new JJCalls();
        }
    }

    private final Token _$20568(int n2) throws ParseException {
        Token token = this.token;
        this.token = token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this._$20558 = -1;
        if (this.token.kind == n2) {
            ++this._$20571;
            if (++this._$20727 > 100) {
                this._$20727 = 0;
                for (int i2 = 0; i2 < this._$20725.length; ++i2) {
                    JJCalls jJCalls = this._$20725[i2];
                    while (jJCalls != null) {
                        if (jJCalls.gen < this._$20571) {
                            jJCalls.first = null;
                        }
                        jJCalls = jJCalls.next;
                    }
                }
            }
            return this.token;
        }
        this.token = token;
        this._$20731 = n2;
        throw this.generateParseException();
    }

    private final boolean _$20669(int n2) {
        if (this._$20657 == this._$20656) {
            --this._$20655;
            if (this._$20657.next == null) {
                this._$20657 = this._$20657.next = this.token_source.getNextToken();
                this._$20656 = this._$20657.next;
            } else {
                this._$20656 = this._$20657 = this._$20657.next;
            }
        } else {
            this._$20657 = this._$20657.next;
        }
        if (this._$20726) {
            int n3 = 0;
            Token token = this.token;
            while (token != null && token != this._$20657) {
                ++n3;
                token = token.next;
            }
            if (token != null) {
                this._$20734(n2, n3);
            }
        }
        return this._$20657.kind != n2;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this._$20558 = -1;
        ++this._$20571;
        return this.token;
    }

    public final Token getToken(int n2) {
        Token token = this.lookingAhead ? this._$20657 : this.token;
        for (int i2 = 0; i2 < n2; ++i2) {
            token = token.next != null ? token.next : (token.next = this.token_source.getNextToken());
        }
        return token;
    }

    private final int _$20558() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this._$20558 = this.token.next.kind;
            return this._$20558;
        }
        this._$20558 = this.jj_nt.kind;
        return this._$20558;
    }

    private void _$20734(int n2, int n3) {
        if (n3 >= 100) {
            return;
        }
        if (n3 == this._$20739 + 1) {
            this._$20738[this._$20739++] = n2;
        } else if (this._$20739 != 0) {
            int n4;
            this._$20737 = new int[this._$20739];
            for (n4 = 0; n4 < this._$20739; ++n4) {
                this._$20737[n4] = this._$20738[n4];
            }
            n4 = 0;
            Enumeration enumeration = this._$20736.elements();
            while (enumeration.hasMoreElements()) {
                int[] nArray = (int[])enumeration.nextElement();
                if (nArray.length != this._$20737.length) continue;
                n4 = 1;
                for (int i2 = 0; i2 < this._$20737.length; ++i2) {
                    if (nArray[i2] == this._$20737[i2]) continue;
                    n4 = 0;
                    break;
                }
                if (n4 == 0) continue;
                break;
            }
            if (n4 == 0) {
                this._$20736.addElement(this._$20737);
            }
            if (n3 != 0) {
                this._$20739 = n3;
                this._$20738[this._$20739 - 1] = n2;
            }
        }
    }

    public final ParseException generateParseException() {
        int n2;
        int n3;
        this._$20736.removeAllElements();
        boolean[] blArray = new boolean[38];
        for (n3 = 0; n3 < 38; ++n3) {
            blArray[n3] = false;
        }
        if (this._$20731 >= 0) {
            blArray[this._$20731] = true;
            this._$20731 = -1;
        }
        for (n3 = 0; n3 < 37; ++n3) {
            if (this._$20570[n3] != this._$20571) continue;
            for (n2 = 0; n2 < 32; ++n2) {
                if ((this._$20722[n3] & 1 << n2) != 0) {
                    blArray[n2] = true;
                }
                if ((this._$20723[n3] & 1 << n2) == 0) continue;
                blArray[32 + n2] = true;
            }
        }
        for (n3 = 0; n3 < 38; ++n3) {
            if (!blArray[n3]) continue;
            this._$20737 = new int[1];
            this._$20737[0] = n3;
            this._$20736.addElement(this._$20737);
        }
        this._$20739 = 0;
        this._$20743();
        this._$20734(0, 0);
        int[][] nArrayArray = new int[this._$20736.size()][];
        for (n2 = 0; n2 < this._$20736.size(); ++n2) {
            nArrayArray[n2] = (int[])this._$20736.elementAt(n2);
        }
        return new ParseException(this.token, nArrayArray, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private final void _$20743() {
        this._$20726 = true;
        for (int i2 = 0; i2 < 2; ++i2) {
            JJCalls jJCalls = this._$20725[i2];
            do {
                if (jJCalls.gen <= this._$20571) continue;
                this._$20655 = jJCalls.arg;
                this._$20656 = this._$20657 = jJCalls.first;
                switch (i2) {
                    case 0: {
                        this._$20659();
                        break;
                    }
                    case 1: {
                        this._$20661();
                    }
                }
            } while ((jJCalls = jJCalls.next) != null);
        }
        this._$20726 = false;
    }

    private final void _$20660(int n2, int n3) {
        JJCalls jJCalls = this._$20725[n2];
        while (jJCalls.gen > this._$20571) {
            if (jJCalls.next == null) {
                jJCalls = jJCalls.next = new JJCalls();
                break;
            }
            jJCalls = jJCalls.next;
        }
        jJCalls.gen = this._$20571 + n3 - this._$20655;
        jJCalls.first = this.token;
        jJCalls.arg = n3;
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }
}

