/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.common;

import com.agentpp.common.SearchConfig;
import com.agentpp.common.table.ExtendedListTable;
import com.agentpp.common.table.TableUtils;
import com.agentpp.mib.MIBAgentCaps;
import com.agentpp.mib.MIBCompliance;
import com.agentpp.mib.MIBComplianceModule;
import com.agentpp.mib.MIBImport;
import com.agentpp.mib.MIBModule;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.MIBSupportedModule;
import com.agentpp.mib.MIBVariation;
import com.agentpp.repository.RepositoryManager;
import com.agentpp.util.Regex;
import com.agentpp.util.ThreadPool;
import com.klg.jclass.table.JCCellDisplayEvent;
import com.klg.jclass.table.JCCellDisplayListener;
import com.klg.jclass.table.data.JCVectorDataSource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.IOException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class SearchMIBRepository
extends JPanel
implements Runnable,
JCCellDisplayListener {
    private static final String[] _$23669 = new String[]{"MIB Module", "Object Name", "OID", "Type"};
    private static final int _$24886 = 2;
    private static final int _$23670 = 1;
    private static final int _$24887 = 0;
    private SearchConfig _$24888;
    private Regex _$18241;
    private String _$24889 = null;
    private JFrame _$656;
    private RepositoryManager _$24890;
    private BorderLayout _$412 = new BorderLayout();
    private JPanel _$24891 = new JPanel();
    private JPanel _$24892 = new JPanel();
    private JProgressBar _$24893 = new JProgressBar();
    private JLabel _$24894 = new JLabel();
    private GridBagLayout _$284 = new GridBagLayout();
    private ExtendedListTable _$406 = new ExtendedListTable();
    private BorderLayout _$636 = new BorderLayout();
    private JCVectorDataSource _$417 = new JCVectorDataSource();
    public volatile boolean cancel = false;
    private JLabel _$18744 = new JLabel();
    private JLabel _$1971 = new JLabel();
    private int _$1972 = 0;
    private JLabel _$24895 = new JLabel();
    private JLabel _$22685 = new JLabel();
    private Runnable _$24896;

    public SearchMIBRepository(JFrame frame, RepositoryManager repMan, Regex searchExpression, SearchConfig searchPanel) {
        this(frame, repMan, searchExpression, searchPanel, null);
    }

    public SearchMIBRepository(JFrame frame, RepositoryManager repMan, Regex searchExpression, SearchConfig searchPanel, String moduleScope) {
        this._$656 = frame;
        this._$24890 = repMan;
        this._$24888 = searchPanel;
        this._$18241 = searchExpression;
        this._$24889 = moduleScope;
        this._$417.setNumColumns(_$23669.length);
        this._$417.setColumnLabels(_$23669);
        this._$417.setNumRows(10);
        this._$406.setDataSource(this._$417);
        this._$406.setPopupMenuEnabled(false);
        this._$406.setCharWidth(-1, 5);
        this._$406.setTraverseCycle(false);
        this._$406.addCellDisplayListener(this);
        try {
            this._$302();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setFinishCallback(Runnable finishCallback) {
        this._$24896 = finishCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        ThreadPool threadPool = ThreadPool.create("SearchMIBRepository", Runtime.getRuntime().availableProcessors());
        this._$1972 = 0;
        this._$417.setNumRows(0);
        Object[] modules = null;
        try {
            modules = this._$24890.getModuleNames();
        }
        catch (IOException ex) {
            this._$1971.setText("Failed to access MIB repository: " + ex.getMessage());
            return;
        }
        this._$24893.setMaximum(0);
        this._$24893.setMaximum(modules.length - 1);
        this._$24893.setStringPainted(true);
        Arrays.sort(modules);
        for (int i2 = 0; i2 < modules.length && !this.cancel; ++i2) {
            this._$1971.setText((String)modules[i2]);
            this._$24893.setValue(i2);
            Object moduleName = modules[i2];
            threadPool.execute(new Runnable((String)moduleName){
                final /* synthetic */ String val$moduleName;
                {
                    this.val$moduleName = string;
                }

                public void run() {
                    try {
                        MIBObject[] objects = SearchMIBRepository.this._$24890.getObjects(this.val$moduleName);
                        MIBRepository rep = new MIBRepository(objects);
                        objects = SearchMIBRepository.this._$24890.getImportedObjects(this.val$moduleName);
                        rep.addAllObjects(objects);
                        SearchMIBRepository.this._$24899(this.val$moduleName, rep);
                    }
                    catch (IOException iox) {
                        iox.printStackTrace();
                    }
                }
            });
        }
        while (!threadPool.isIdle()) {
            try {
                ThreadPool i2 = threadPool;
                synchronized (i2) {
                    threadPool.wait(1000L);
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }
        threadPool.stop();
        this._$1971.setText("Search complete!");
        if (this._$24896 != null) {
            SwingUtilities.invokeLater(this._$24896);
        }
    }

    public TreeMap getSelectedObjects() {
        int[] rows = TableUtils.getSelectedRows(this._$406);
        TreeMap<Object, Object> h2 = new TreeMap<Object, Object>();
        for (int i2 = 0; i2 < rows.length; ++i2) {
            h2.put(this._$417.getTableDataItem(rows[i2], 1), this._$417.getTableDataItem(rows[i2], 0));
        }
        return h2;
    }

    private synchronized boolean _$24900(MIBRepository rep, Regex expression, MIBObject o2, boolean[] flags) {
        MIBModule module;
        if (flags[0] && (module = rep.getModule(o2.getModuleID())) != null && expression.match(o2.toSMI(1, module.getSMIVersion(), rep, "\n"))) {
            return true;
        }
        if ((flags[0] || flags[2]) && o2.getName() != null && expression.match(o2.getName())) {
            return true;
        }
        if ((flags[0] || flags[1]) && o2.getOid() != null && expression.match(o2.getOid().toString())) {
            return true;
        }
        if ((flags[0] || flags[3]) && o2.getDescription() != null && expression.match(o2.getDescription())) {
            return true;
        }
        if (flags[0] || flags.length > 4 && flags[4]) {
            List refs = this._$24904(rep, o2);
            for (String ref : refs) {
                if (!expression.match(ref)) continue;
                return true;
            }
        }
        return false;
    }

    private List _$24904(MIBRepository rep, MIBObject o2) {
        LinkedList<String> refs;
        block10: {
            MIBAgentCaps ac;
            block11: {
                block9: {
                    refs = new LinkedList<String>();
                    if (!(o2 instanceof MIBModule)) break block9;
                    MIBModule m2 = (MIBModule)o2;
                    if (!m2.hasImports()) break block10;
                    for (int i2 = 0; i2 < m2.getImportsVector().size(); ++i2) {
                        MIBImport imp = m2.getImportsVector().get(i2);
                        if (this._$24889 != null && !imp.getSource().equals(this._$24889)) continue;
                        refs.addAll(imp.getImportsVector());
                    }
                    break block10;
                }
                if (!(o2 instanceof MIBCompliance)) break block11;
                MIBCompliance c2 = (MIBCompliance)o2;
                if (c2.getModules() == null) break block10;
                for (MIBComplianceModule cm : c2.getModules()) {
                    String moduleName = cm.getModuleName();
                    if (!cm.hasModuleName()) {
                        moduleName = rep.getModuleName(o2.getModuleID());
                    }
                    if (this._$24889 != null && !moduleName.equals(this._$24889)) continue;
                    if (cm.hasMandatory()) {
                        refs.addAll(cm.getMandatoryVector());
                    }
                    if (!cm.hasVariations()) continue;
                    for (MIBVariation var : cm.getVariationsVector()) {
                        refs.add(var.getVariation());
                        if (!var.hasCreationRequires()) continue;
                        refs.addAll(var.getCreationRequiresVector());
                    }
                }
                break block10;
            }
            if (o2 instanceof MIBAgentCaps && (ac = (MIBAgentCaps)o2).getModules() != null) {
                for (MIBSupportedModule sm : ac.getModules()) {
                    String moduleName = sm.getSupports();
                    if (sm.getSupports() == null) {
                        moduleName = rep.getModuleName(o2.getModuleID());
                    }
                    if (this._$24889 != null && !moduleName.equals(this._$24889) || !sm.hasVariations()) continue;
                    for (MIBVariation var : sm.getVariationsVector()) {
                        refs.add(var.getVariation());
                        if (!var.hasCreationRequires()) continue;
                        refs.addAll(var.getCreationRequiresVector());
                    }
                }
            }
        }
        return refs;
    }

    private void _$24899(String moduleName, MIBRepository rep) {
        Integer moduleID = null;
        if (rep.getModule(moduleName) != null) {
            moduleID = rep.getModule(moduleName).getModuleID();
        }
        Enumeration<? extends MIBObject> en = rep.objectsByName();
        while (en.hasMoreElements()) {
            MIBObject o2 = en.nextElement();
            if (!o2.getModuleID().equals(moduleID) || !this._$24900(rep, this._$18241, o2, this._$24888.getSearchOptions())) continue;
            ++this._$1972;
            if (this._$1972 == 1) {
                this._$22685.setText("" + this._$1972 + " match.");
            } else {
                this._$22685.setText("" + this._$1972 + " matches.");
            }
            final Vector<Object> row = new Vector<Object>();
            row.add(moduleName);
            row.add(o2);
            row.add(o2.getOid());
            row.add(o2.getTypeString());
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SearchMIBRepository.this._$417.addRow(Integer.MAX_VALUE, new Integer(SearchMIBRepository.this._$417.getNumRows() + 1), row);
                }
            });
        }
    }

    public void setRepositoryManager(RepositoryManager repositoryManager) {
        this._$24890 = repositoryManager;
    }

    public RepositoryManager getRepositoryManager() {
        return this._$24890;
    }

    public SearchMIBRepository() {
        try {
            this._$302();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private void _$302() throws Exception {
        this.setLayout(this._$412);
        this._$24894.setText("Progress:");
        this._$24892.setLayout(this._$284);
        this._$24893.setStringPainted(true);
        this._$24891.setLayout(this._$636);
        this._$18744.setText("Searching:");
        this._$24895.setText("Found:");
        this._$22685.setText("0 matches.");
        this.add((Component)this._$24891, "Center");
        this._$24891.add((Component)this._$406, "Center");
        this.add((Component)this._$24892, "North");
        this._$24892.add((Component)this._$24894, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 10), 0, 0));
        this._$24892.add((Component)this._$24893, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 10, 0, 10), 0, 0));
        this._$24892.add((Component)this._$18744, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 5, 10), 0, 0));
        this._$24892.add((Component)this._$1971, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 10, 5, 10), 0, 0));
        this._$24892.add((Component)this._$24895, new GridBagConstraints(0, 2, 1, 2, 0.0, 0.0, 17, 0, new Insets(5, 10, 10, 10), 0, 0));
        this._$24892.add((Component)this._$22685, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 10, 10, 10), 0, 0));
    }

    public void cellDisplay(JCCellDisplayEvent e2) {
        if (e2.getColumn() == 1 && e2.getCellData() instanceof MIBObject) {
            MIBObject o2 = (MIBObject)e2.getDisplayData();
            e2.setDisplayData(o2.getName());
        }
    }
}

