/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.common;

import com.agentpp.common.table.ExtendedListTable;
import com.agentpp.common.table.TableUtils;
import com.klg.jclass.cell.editors.JCStringCellEditor;
import com.klg.jclass.table.JCCellDisplayEvent;
import com.klg.jclass.table.JCCellDisplayListener;
import com.klg.jclass.table.JCCellPosition;
import com.klg.jclass.table.JCCellStyle;
import com.klg.jclass.table.data.JCEditableVectorDataSource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.security.Key;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.crypto.Cipher;
import javax.swing.JPanel;
import javax.swing.ToolTipManager;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesEditor
extends JPanel
implements JCCellDisplayListener {
    private static final String _$23667 = ".Password";
    private static final String _$23668 = ".Password.encrypted";
    public static final String[] COLUMNS = new String[]{"Property", "Value"};
    public static final int COL_NAME = 0;
    public static final int COL_VALUE = 1;
    public static final int[] COLUMN_WIDTHS = new int[]{12, 12};
    boolean encryptedPassword = false;
    BorderLayout borderLayout1 = new BorderLayout();
    private String[] _$23674 = new String[0];
    private String[] _$9553 = new String[0];
    private ExtendedListTable _$406 = new ExtendedListTable(){

        public String getToolTipText(MouseEvent event) {
            JCCellPosition cp = this.XYToCell(event.getX(), event.getY());
            if (cp.column < 0 || cp.row < 0) {
                return null;
            }
            try {
                if (cp.column == 1) {
                    return PropertiesEditor.this._$23675[cp.row - 1];
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
    };
    private JCEditableVectorDataSource _$417 = new JCEditableVectorDataSource();
    private String[] _$23676;
    private String[] _$23675;
    private JCCellStyle _$23677;

    public PropertiesEditor() {
        this(false);
    }

    public PropertiesEditor(boolean nameEditable) {
        this._$417.setNumColumns(COLUMNS.length);
        this._$417.setColumnLabels(COLUMNS);
        this._$417.setNumRows(1);
        this._$406.setDataSource(this._$417);
        this._$406.setRowHidden(0, true);
        this._$406.setRowLabelDisplay(false);
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this._$16185(nameEditable);
        ToolTipManager.sharedInstance().registerComponent(this._$406);
        this._$406.addCellDisplayListener(this);
    }

    private void _$16185(boolean nameEditable) {
        if (!nameEditable) {
            this._$23677 = new JCCellStyle(this._$406.getDefaultCellStyle());
            this._$23677.setEditable(nameEditable);
            this._$406.setCellStyle(-997, 0, this._$23677);
        } else {
            this._$406.setCellEditor(String.class, new JCStringCellEditor());
        }
        for (int i2 = 0; i2 < COLUMNS.length; ++i2) {
            this._$406.setCharWidth(i2, COLUMN_WIDTHS[i2]);
        }
    }

    void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.add((Component)this._$406, "Center");
    }

    public void setKeys(String[] keys) {
        if (keys == null) {
            throw new NullPointerException();
        }
        this._$9553 = keys;
    }

    public String[] getKeys() {
        return this._$9553;
    }

    public void setTitles(String[] titles) {
        if (titles == null) {
            throw new NullPointerException();
        }
        this._$23674 = titles;
    }

    public String[] getTitles() {
        return this._$23674;
    }

    public void setProperties(Properties props) {
        this.setProperties(props, true);
    }

    public void setProperties(Properties props, boolean withTitles) {
        this._$417.setNumRows(1);
        int passwordRow = -1;
        this.encryptedPassword = false;
        for (int i2 = 0; i2 < this._$9553.length; ++i2) {
            Vector<String> row = new Vector<String>(COLUMNS.length);
            if (withTitles) {
                row.add(this._$23674 != null && i2 < this._$23674.length ? this._$23674[i2] : null);
            }
            row.add(props.getProperty(this._$9553[i2], this._$23676[i2]));
            if (this._$9553[i2].endsWith(_$23668)) {
                this.encryptedPassword = Boolean.valueOf(props.getProperty(this._$9553[i2], this._$23676[i2]));
            }
            if (this._$9553[i2].endsWith(_$23667)) {
                passwordRow = i2 + 1;
            }
            this._$417.addRow(Integer.MAX_VALUE, null, row);
            if (this._$23674[i2] == null) {
                this._$406.setRowHidden(i2 + 1, true);
                continue;
            }
            this._$406.setRowHidden(i2 + 1, false);
        }
        if (this.encryptedPassword && passwordRow >= 0) {
            try {
                String encrpyted = this._$417.getTableDataItem(passwordRow, 1).toString();
                this._$417.setTableDataItem(PropertiesEditor._$23685(encrpyted), passwordRow, 1);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void setProperties(Map<String, String> props) {
        for (Map.Entry<String, String> entry : props.entrySet()) {
            Vector<String> row = new Vector<String>(COLUMNS.length);
            row.add(entry.getKey());
            row.add(entry.getValue());
            this._$417.addRow(Integer.MAX_VALUE, null, row);
        }
    }

    public String getSelectedPropertyKey() {
        int row = TableUtils.getFirstSelectedRow(this._$406);
        if (row > 0 && row < this._$406.getNumRows()) {
            return (String)this._$406.getDataView().getTableDataItem(row, 0);
        }
        return null;
    }

    public String getSelectedPropertyValue() {
        int row = TableUtils.getFirstSelectedRow(this._$406);
        if (row > 0 && row < this._$406.getNumRows()) {
            return (String)this._$406.getDataView().getTableDataItem(row, 1);
        }
        return null;
    }

    public void setSelectedPropertyKey(String key) {
        int row = TableUtils.getFirstSelectedRow(this._$406);
        if (row > 0 && row < this._$406.getNumRows()) {
            this._$406.getDataView().setTableDataItem(key, row, 0);
        }
    }

    public void setSelectedPropertyValue(String value) {
        int row = TableUtils.getFirstSelectedRow(this._$406);
        if (row > 0 && row < this._$406.getNumRows()) {
            this._$406.getDataView().setTableDataItem(value, row, 1);
        }
    }

    public void addProperty(String key, String value) {
        Vector<String> row = new Vector<String>(COLUMNS.length);
        row.add(key);
        row.add(value);
        this._$417.addRow(Integer.MAX_VALUE, null, row);
    }

    public void removeSelectedRows() {
        int[] selectedRows = TableUtils.getSelectedRows(this._$406);
        for (int i2 = selectedRows.length - 1; i2 >= 0; --i2) {
            this._$417.deleteRows(selectedRows[i2], 1);
        }
    }

    private static String _$23692(String password) throws Exception {
        Key key;
        try {
            ObjectInputStream in = new ObjectInputStream(PropertiesEditor.class.getResourceAsStream("PropertyHelper.properties"));
            key = (Key)in.readObject();
            in.close();
        }
        catch (IOException fnfe) {
            return password;
        }
        Cipher cipher = Cipher.getInstance("DES/ECB/PKCS5Padding");
        cipher.init(1, key);
        byte[] stringBytes = password.getBytes("UTF8");
        byte[] raw = cipher.doFinal(stringBytes);
        BASE64Encoder encoder = new BASE64Encoder();
        String base64 = encoder.encode(raw);
        return base64;
    }

    private static String _$23685(String password) throws Exception {
        Key key;
        try {
            InputStream is = PropertiesEditor.class.getResourceAsStream("PropertyHelper.properties");
            ObjectInputStream in = new ObjectInputStream(is);
            key = (Key)in.readObject();
            in.close();
        }
        catch (IOException fnfe) {
            return password;
        }
        Cipher cipher = Cipher.getInstance("DES/ECB/PKCS5Padding");
        cipher.init(2, key);
        BASE64Decoder decoder = new BASE64Decoder();
        byte[] raw = decoder.decodeBuffer(password);
        byte[] stringBytes = cipher.doFinal(raw);
        String result = new String(stringBytes, "UTF8");
        return result;
    }

    public static Hashtable filterProperties(Properties props) {
        Hashtable<String, String> originalValues = new Hashtable<String, String>(10, 10.0f);
        Enumeration<?> en = props.propertyNames();
        while (en.hasMoreElements()) {
            String pwdName;
            String pwd;
            String name = (String)en.nextElement();
            if (!name.endsWith(_$23668) || !Boolean.valueOf(props.getProperty(name, "false")).booleanValue() || (pwd = props.getProperty(pwdName = name.substring(0, name.length() - _$23668.length()) + _$23667)) == null) continue;
            originalValues.put(pwdName, pwd);
            try {
                pwd = PropertiesEditor._$23685(pwd);
                props.put(pwdName, pwd);
            }
            catch (Exception ex) {}
        }
        return originalValues;
    }

    public void getProperties(Properties props) {
        int i2;
        this._$406.commitEdit(true);
        for (i2 = 0; i2 < this._$9553.length; ++i2) {
            String val = (String)this._$417.getTableDataItem(i2 + 1, 1);
            if (this.encryptedPassword && this._$9553[i2].endsWith(_$23667)) {
                try {
                    val = PropertiesEditor._$23692(val);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            props.setProperty(this._$9553[i2], val);
        }
        for (i2 = this._$9553.length + 1; i2 < this._$417.getNumRows(); ++i2) {
            props.setProperty((String)this._$417.getTableDataItem(i2, 0), (String)this._$417.getTableDataItem(i2, 1));
        }
    }

    public LinkedHashMap<String, String> getProperties() {
        LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
        this._$406.commitEdit(true);
        for (int i2 = 1; i2 < this._$417.getNumRows(); ++i2) {
            String key = (String)this._$417.getTableDataItem(i2, 0);
            if (key == null || key.length() == 0) continue;
            String val = (String)this._$417.getTableDataItem(i2, 1);
            props.put(key, val);
        }
        return props;
    }

    public void setDefaultValues(String[] defaultValues) {
        this._$23676 = defaultValues;
    }

    public String[] getDefaultValues() {
        return this._$23676;
    }

    public void setToolTips(String[] toolTips) {
        if (toolTips == null) {
            throw new NullPointerException();
        }
        this._$23675 = toolTips;
    }

    public String[] getToolTips() {
        return this._$23675;
    }

    public void addHiddenProperty(String key, String value) {
        Vector<String> r2 = new Vector<String>(2);
        r2.add(key);
        r2.add(value);
        this._$417.addRow(Integer.MAX_VALUE, null, r2);
        this._$406.setRowHidden(this._$417.getNumRows() - 1, true);
    }

    @Override
    public void cellDisplay(JCCellDisplayEvent e2) {
        Object o2;
        if (e2.getColumn() == 1 && e2.getRow() > 0 && e2.getRow() < this._$417.getNumRows() && (o2 = this._$417.getTableDataItem(e2.getRow(), 0)) != null && o2.toString().equalsIgnoreCase("Password")) {
            StringBuffer s = new StringBuffer(o2.toString().length());
            for (int i2 = 0; i2 < o2.toString().length(); ++i2) {
                s.append("*");
            }
            e2.setDisplayData(s.toString());
        }
    }
}

