/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.common;

import com.agentpp.common.ExportPanel;
import com.agentpp.common.StatusBar;
import com.agentpp.common.smi.editor.SmiContext;
import com.agentpp.mib.MIBModule;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.pdf.MIBModule2PDF;
import com.agentpp.mib.pdf.PDFPageSetupPanel;
import com.agentpp.mib.xml.MIBModule2XML;
import com.agentpp.mib.xsd.MIBModule2XSD;
import com.agentpp.repository.RepositoryManager;
import com.agentpp.util.UserConfigFile;
import com.agentpp.util.gui.ShowHtmlDialog;
import com.lowagie.text.DocumentException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;

public class ExportThread
extends Thread {
    private JFrame _$1266;
    private MIBRepository _$419;
    private ExportPanel _$28749;
    private StatusBar _$2176;
    private String _$2448;
    private String _$28365;
    private RepositoryManager _$1245;
    private boolean _$28750 = false;
    private UserConfigFile _$2173;
    private String _$28751 = "http://www.mibexplorer.com/xsd/mibs/";

    public ExportThread(JFrame f2, StatusBar statusBar, UserConfigFile config, MIBRepository rep, ExportPanel exportPanel, String header, String dtdURL) {
        this._$1266 = f2;
        this._$419 = rep;
        this._$28749 = exportPanel;
        this._$2176 = statusBar;
        this._$2448 = header;
        this._$28365 = dtdURL;
        this._$2173 = config;
        this._$1245 = null;
    }

    public ExportThread(JFrame f2, StatusBar statusBar, UserConfigFile config, RepositoryManager repMan, ExportPanel exportPanel, String header, String dtdURL) {
        this._$1266 = f2;
        this._$1245 = repMan;
        this._$2173 = config;
        this._$28749 = exportPanel;
        this._$2176 = statusBar;
        this._$2448 = header;
        this._$28365 = dtdURL;
    }

    public void run() {
        try {
            if (this._$28749.isPDF()) {
                PDFPageSetupPanel p2 = new PDFPageSetupPanel();
                p2.load(this._$2173);
                Object[] options = new String[]{"OK", "Cancel"};
                if (JOptionPane.showOptionDialog(this._$28749.getDialog(), p2, "PDF Settings", 2, -1, null, options, options[0]) == 0) {
                    p2.save(this._$2173);
                } else {
                    this._$2176.setMessage("Export canceled by user");
                    return;
                }
            }
            Vector modules = this._$28749.getModules();
            ProgressMonitor pm = new ProgressMonitor(this._$1266, "Exporting...", "", 0, modules.size());
            boolean html = this._$28749.isHTML();
            boolean xml = this._$28749.isXML();
            boolean pdf = this._$28749.isPDF();
            boolean xsd = this._$28749.isXSD();
            boolean oidMapping = this._$28749.isOIDMapping();
            boolean appendOrigFileName = this._$28749.isAppendOrigFilename();
            String origFileNameSeparator = this._$28749.getOrigFileNameSeparator();
            int tabSize = this._$28749.getTabSize();
            this.exportMIBs(this._$28749.getExportPath(), modules, pm, html, xml, pdf, xsd, oidMapping, tabSize, this._$28749.isUseSpaces(), appendOrigFileName, origFileNameSeparator);
            if (pm.isCanceled()) {
                return;
            }
            SwingUtilities.invokeLater(new EventTrigger(pm));
            this._$2176.setMessage("" + modules.size() + " MIB module" + (modules.size() == 1 ? "" : "s") + " exported to '" + this._$28749.getExportPath() + "'");
        }
        catch (Exception ix) {
            this._$2176.setMessage("Export failed: " + ix.getMessage());
            ix.printStackTrace();
        }
    }

    public String exportMIBs(String path, Vector modules, ProgressMonitor pm, boolean html, boolean xml, boolean pdf, boolean xsd, boolean oidMapping, int tabSize, boolean useSpaces, boolean appendOrigFileName, String origFileNameSeparator) throws FileNotFoundException, IOException, DocumentException {
        StringBuffer buf = new StringBuffer();
        for (int i2 = 0; !(i2 >= modules.size() || pm != null && pm.isCanceled()); ++i2) {
            FileOutputStream fos;
            File file;
            MIBModule module;
            if (pm != null) {
                if (pm.isCanceled()) {
                    SwingUtilities.invokeLater(new EventTrigger(pm));
                    return null;
                }
                pm.setProgress(i2);
            }
            if (this._$1245 == null) {
                module = this._$419.getModule(modules.get(i2).toString());
            } else {
                String m2 = modules.get(i2).toString();
                try {
                    this._$419 = null;
                    MIBObject[] objs = this._$1245.getObjects(m2);
                    MIBObject[] imp = this._$1245.getImportedObjects(m2);
                    this._$419 = new MIBRepository(objs);
                    for (int j2 = 0; j2 < imp.length; ++j2) {
                        this._$419.addObject(imp[j2]);
                    }
                    this._$419.structureChanged();
                    module = this._$419.getModule(m2);
                }
                catch (Exception ex) {
                    continue;
                }
            }
            if (module == null) continue;
            if (this._$28750) {
                module.convertToSMIv1(this._$419);
            }
            if (pm != null) {
                pm.setNote(module.getModuleName());
            }
            if (xml) {
                file = this._$2470(path, module, ".xml", appendOrigFileName, origFileNameSeparator);
                fos = new FileOutputStream(file);
                MIBModule2XML mxml = new MIBModule2XML(this._$419);
                mxml.output(fos, mxml.createXML(module, this._$2448, this._$28365), this._$28749.getTabSize());
                fos.close();
            } else if (pdf) {
                PDFPageSetupPanel p2 = new PDFPageSetupPanel();
                p2.load(this._$2173);
                file = this._$2470(path, module, ".pdf", appendOrigFileName, origFileNameSeparator);
                FileOutputStream fos2 = new FileOutputStream(file);
                MIBModule2PDF mpdf = new MIBModule2PDF(this._$419, SmiContext.getDefaultStyles(), tabSize);
                mpdf.setMode(this._$19247(mpdf.getMode()));
                mpdf.setFontSize(p2.getFontSize());
                mpdf.setKeepTogether(p2.isKeepTogether());
                mpdf.setOutlineAsTree(p2.isOutlineAsTree());
                mpdf.setDisplayPageNumbers(p2.isDisplayPageNumbers());
                mpdf.setDisplayCurrentDate(p2.isDisplayCurrentDate());
                mpdf.writePDF(module, fos2, this._$2448, p2.getPageSizeRectangle());
                fos2.close();
            } else if (html) {
                file = this._$2470(path, module, ".html", appendOrigFileName, origFileNameSeparator);
                fos = new FileOutputStream(file);
                int mode = 6;
                mode = this._$19247(mode);
                String s = "<body  link=\"#808080\"><pre>" + ShowHtmlDialog.replaceTabs(module.toSMI(mode, this._$419, MIBObject.getLineSeparator()), tabSize) + "</pre></body>";
                fos.write(s.getBytes());
                fos.close();
            } else if (xsd) {
                file = this._$2470(path, module, ".xsd", appendOrigFileName, origFileNameSeparator);
                fos = new FileOutputStream(file);
                MIBModule2XSD mxsd = new MIBModule2XSD(this._$419);
                mxsd.setURLPrefix(this._$28751);
                mxsd.output(fos, mxsd.createXML(module, this._$2448, this._$28365), this._$28749.getTabSize());
                fos.close();
            } else if (oidMapping) {
                file = this._$2470(path, module, ".txt", appendOrigFileName, origFileNameSeparator);
                fos = new FileOutputStream(file);
                Enumeration it = module.objectsByOid().elements();
                while (it.hasMoreElements()) {
                    MIBObject mibObject = (MIBObject)it.nextElement();
                    String s = mibObject.getPrintableOid() + "=" + mibObject.getName();
                    fos.write(s.getBytes());
                    fos.write(MIBObject.getLineSeparator().getBytes());
                }
                fos.close();
            } else {
                file = this._$2470(path, module, ".txt", appendOrigFileName, origFileNameSeparator);
                fos = new FileOutputStream(file);
                int mode = 1;
                mode = this._$19247(mode);
                if (useSpaces) {
                    String s = module.toSMI(mode, this._$419, MIBObject.getLineSeparator());
                    s = ShowHtmlDialog.replaceTabs(s, tabSize);
                    fos.write(s.getBytes());
                } else {
                    fos.write(module.toSMI(mode, this._$419, MIBObject.getLineSeparator()).getBytes());
                }
                fos.close();
            }
            buf.append(file.getPath());
            buf.append(" ");
        }
        return buf.toString();
    }

    private File _$2470(String path, MIBModule module, String suffix, boolean appendOrigFilename, String separator) throws IOException {
        String name = module.getModuleName();
        if (appendOrigFilename && module.getFileName() != null && module.getFileName().trim().length() > 0) {
            int dotpos;
            String fileName = new File(module.getFileName()).getName();
            if (fileName.startsWith(name)) {
                fileName = fileName.substring(name.length());
                if (separator.length() > 0 && fileName.startsWith(separator)) {
                    fileName = fileName.substring(separator.length());
                }
            }
            if ((dotpos = fileName.lastIndexOf(46)) >= 0) {
                fileName = fileName.substring(0, dotpos);
            }
            if (fileName.trim().length() > 0) {
                name = name + separator + fileName;
            }
        }
        if (path == null) {
            return File.createTempFile(name, suffix);
        }
        return new File(path, name + suffix);
    }

    private int _$19247(int mode) {
        mode |= this._$2173.getBoolean("OrderByType", true) ? 256 : 0;
        mode |= this._$2173.getBoolean("PreserveOrder", true) ? 128 : 0;
        mode |= this._$2173.getBoolean("GenerateComments", true) ? 32 : 0;
        return mode |= this._$2173.getBoolean("GenerateCommentsInline", false) ? 1024 : 0;
    }

    public void setConvertV2ToV1(boolean convertV2ToV1) {
        this._$28750 = convertV2ToV1;
    }

    public boolean isConvertV2ToV1() {
        return this._$28750;
    }

    public void setURLPrefixXSD(String urlPrefix) {
        this._$28751 = urlPrefix;
    }

    class EventTrigger
    implements Runnable {
        private ProgressMonitor _$2188;

        public EventTrigger(ProgressMonitor pm) {
            this._$2188 = pm;
        }

        public void run() {
            this._$2188.close();
        }
    }
}

