/*
 * Decompiled with CFR 0.152.
 */
package com.objectspace.jgl.algorithms;

import com.objectspace.jgl.BinaryFunction;
import com.objectspace.jgl.Container;
import com.objectspace.jgl.ForwardIterator;
import com.objectspace.jgl.InputIterator;
import com.objectspace.jgl.OutputIterator;
import com.objectspace.jgl.UnaryFunction;
import com.objectspace.jgl.util.InsertIterator;

public final class Transforming {
    private Transforming() {
    }

    public static OutputIterator transform(InputIterator inputIterator, InputIterator inputIterator2, OutputIterator outputIterator, UnaryFunction unaryFunction) {
        if (!inputIterator.isCompatibleWith(inputIterator2)) {
            throw new IllegalArgumentException("iterators not compatible");
        }
        InputIterator inputIterator3 = (InputIterator)inputIterator.clone();
        OutputIterator outputIterator2 = (OutputIterator)outputIterator.clone();
        while (!inputIterator3.equals(inputIterator2)) {
            outputIterator2.put(unaryFunction.execute(inputIterator3.nextElement()));
            outputIterator2.advance();
        }
        return outputIterator2;
    }

    public static OutputIterator transform(Container container, OutputIterator outputIterator, UnaryFunction unaryFunction) {
        return Transforming.transform(container.start(), container.finish(), outputIterator, unaryFunction);
    }

    public static void transform(Container container, Container container2, UnaryFunction unaryFunction) {
        Transforming.transform(container.start(), container.finish(), (OutputIterator)new InsertIterator(container2), unaryFunction);
    }

    public static OutputIterator transform(InputIterator inputIterator, InputIterator inputIterator2, InputIterator inputIterator3, OutputIterator outputIterator, BinaryFunction binaryFunction) {
        if (!inputIterator.isCompatibleWith(inputIterator2)) {
            throw new IllegalArgumentException("iterators not compatible");
        }
        InputIterator inputIterator4 = (InputIterator)inputIterator.clone();
        InputIterator inputIterator5 = (InputIterator)inputIterator3.clone();
        OutputIterator outputIterator2 = (OutputIterator)outputIterator.clone();
        while (!inputIterator4.equals(inputIterator2)) {
            outputIterator2.put(binaryFunction.execute(inputIterator4.nextElement(), inputIterator5.nextElement()));
            outputIterator2.advance();
        }
        return outputIterator2;
    }

    public static OutputIterator transform(Container container, Container container2, OutputIterator outputIterator, BinaryFunction binaryFunction) {
        return Transforming.transform(container.start(), container.finish(), container2.start(), outputIterator, binaryFunction);
    }

    public static void transform(Container container, Container container2, Container container3, BinaryFunction binaryFunction) {
        Transforming.transform(container.start(), container.finish(), container2.start(), new InsertIterator(container3), binaryFunction);
    }

    public static Container collect(ForwardIterator forwardIterator, ForwardIterator forwardIterator2, UnaryFunction unaryFunction) {
        if (!forwardIterator.isCompatibleWith(forwardIterator2)) {
            throw new IllegalArgumentException("iterators not compatible");
        }
        return Transforming.collect(forwardIterator, forwardIterator2, unaryFunction, (Container)forwardIterator.getContainer().clone());
    }

    public static Container collect(Container container, UnaryFunction unaryFunction) {
        return Transforming.collect(container.start(), container.finish(), unaryFunction, (Container)container.clone());
    }

    private static Container collect(ForwardIterator forwardIterator, ForwardIterator forwardIterator2, UnaryFunction unaryFunction, Container container) {
        container.clear();
        ForwardIterator forwardIterator3 = (ForwardIterator)forwardIterator.clone();
        while (!forwardIterator3.equals(forwardIterator2)) {
            container.add(unaryFunction.execute(forwardIterator3.nextElement()));
        }
        return container;
    }
}

