/*
 * Decompiled with CFR 0.152.
 */
package com.objectspace.jgl.algorithms;

import com.objectspace.jgl.BinaryPredicate;
import com.objectspace.jgl.Container;
import com.objectspace.jgl.InputIterator;
import com.objectspace.jgl.algorithms.Predicates;

public final class MinMax {
    private MinMax() {
    }

    public static InputIterator maxElement(InputIterator inputIterator, InputIterator inputIterator2) {
        return MinMax.maxElement(inputIterator, inputIterator2, new Predicates.HashComparator());
    }

    public static InputIterator maxElement(Container container) {
        return MinMax.maxElement(container.start(), container.finish(), new Predicates.HashComparator());
    }

    public static InputIterator maxElement(InputIterator inputIterator, InputIterator inputIterator2, BinaryPredicate binaryPredicate) {
        if (!inputIterator.isCompatibleWith(inputIterator2)) {
            throw new IllegalArgumentException("iterators not compatible");
        }
        InputIterator inputIterator3 = (InputIterator)inputIterator.clone();
        if (inputIterator3.equals(inputIterator2)) {
            return inputIterator3;
        }
        InputIterator inputIterator4 = (InputIterator)inputIterator3.clone();
        inputIterator3.advance();
        while (!inputIterator3.equals(inputIterator2)) {
            if (binaryPredicate.execute(inputIterator4.get(), inputIterator3.get())) {
                inputIterator4 = (InputIterator)inputIterator3.clone();
            }
            inputIterator3.advance();
        }
        return inputIterator4;
    }

    public static InputIterator maxElement(Container container, BinaryPredicate binaryPredicate) {
        return MinMax.maxElement(container.start(), container.finish(), binaryPredicate);
    }

    public static InputIterator minElement(InputIterator inputIterator, InputIterator inputIterator2) {
        return MinMax.minElement(inputIterator, inputIterator2, new Predicates.HashComparator());
    }

    public static InputIterator minElement(Container container) {
        return MinMax.minElement(container.start(), container.finish(), new Predicates.HashComparator());
    }

    public static InputIterator minElement(InputIterator inputIterator, InputIterator inputIterator2, BinaryPredicate binaryPredicate) {
        if (!inputIterator.isCompatibleWith(inputIterator2)) {
            throw new IllegalArgumentException("iterators not compatible");
        }
        InputIterator inputIterator3 = (InputIterator)inputIterator.clone();
        if (inputIterator3.equals(inputIterator2)) {
            return inputIterator3;
        }
        InputIterator inputIterator4 = (InputIterator)inputIterator3.clone();
        inputIterator3.advance();
        while (!inputIterator3.equals(inputIterator2)) {
            if (binaryPredicate.execute(inputIterator3.get(), inputIterator4.get())) {
                inputIterator4 = (InputIterator)inputIterator3.clone();
            }
            inputIterator3.advance();
        }
        return inputIterator4;
    }

    public static InputIterator minElement(Container container, BinaryPredicate binaryPredicate) {
        return MinMax.minElement(container.start(), container.finish(), binaryPredicate);
    }
}

