/*
 * Decompiled with CFR 0.152.
 */
package com.objectspace.jgl.adapters;

import com.objectspace.jgl.Container;
import com.objectspace.jgl.ForwardIterator;
import com.objectspace.jgl.InputIterator;
import com.objectspace.jgl.RandomAccessIterator;
import com.objectspace.jgl.adapters.ShortArray;
import com.objectspace.jgl.adapters.ShortBuffer;
import java.io.Serializable;
import java.util.NoSuchElementException;

public final class ShortIterator
implements RandomAccessIterator,
Serializable {
    short[] buffer;
    Container original;
    int index;
    static final long serialVersionUID = -9054943108350905562L;

    public static ShortIterator begin(short[] sArray) {
        return new ShortIterator(sArray, 0);
    }

    public static ShortIterator end(short[] sArray) {
        return new ShortIterator(sArray, sArray.length);
    }

    public ShortIterator() {
        this(new ShortArray(), 0);
    }

    public ShortIterator(ShortIterator shortIterator) {
        this.buffer = shortIterator.buffer;
        this.original = shortIterator.original;
        this.index = shortIterator.index;
    }

    public ShortIterator(short[] sArray, int n) {
        this(new ShortArray(sArray), n);
    }

    public ShortIterator(ShortArray shortArray, int n) {
        this.buffer = shortArray.array;
        this.original = shortArray;
        this.index = n;
    }

    public ShortIterator(ShortBuffer shortBuffer, int n) {
        this.buffer = shortBuffer.storage;
        this.original = shortBuffer;
        this.index = n;
    }

    public Object clone() {
        return new ShortIterator(this);
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (!(object instanceof ShortIterator)) break block2;
                ShortIterator shortIterator = (ShortIterator)object;
                if (shortIterator.index == this.index && (shortIterator.buffer == this.buffer || false)) break block3;
            }
            return false;
        }
        return true;
    }

    public boolean equals(ShortIterator shortIterator) {
        return shortIterator.index == this.index && shortIterator.buffer == this.buffer;
    }

    public boolean less(RandomAccessIterator randomAccessIterator) {
        return this.index < ((ShortIterator)randomAccessIterator).index;
    }

    public boolean atBegin() {
        return this.index == 0;
    }

    public boolean atEnd() {
        return this.index == this.original.size();
    }

    public boolean hasMoreElements() {
        return this.index < this.original.size();
    }

    public void advance() {
        ++this.index;
    }

    public void advance(int n) {
        this.index += n;
    }

    public void retreat() {
        --this.index;
    }

    public void retreat(int n) {
        this.index -= n;
    }

    public Object nextElement() {
        try {
            Short s = new Short(this.buffer[this.index]);
            ++this.index;
            return s;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new NoSuchElementException("ShortIterator");
        }
    }

    public Object get() {
        return new Short(this.buffer[this.index]);
    }

    public short getShort() {
        return this.buffer[this.index];
    }

    public Object get(int n) {
        return new Short(this.buffer[this.index + n]);
    }

    public short getShort(int n) {
        return this.buffer[this.index + n];
    }

    public void put(Object object) {
        short s;
        this.buffer[this.index] = s = ((Number)object).shortValue();
    }

    public void put(short s) {
        this.buffer[this.index] = s;
    }

    public void put(int n, Object object) {
        short s;
        this.buffer[this.index + n] = s = ((Number)object).shortValue();
    }

    public void put(int n, short s) {
        this.buffer[this.index + n] = s;
    }

    public int distance(ForwardIterator forwardIterator) {
        ForwardIterator forwardIterator2 = forwardIterator;
        if (!(forwardIterator2 instanceof ShortIterator) || this.buffer != ((ShortIterator)forwardIterator2).buffer && !false) {
            throw new IllegalArgumentException("iterators not compatible");
        }
        return ((ShortIterator)forwardIterator).index - this.index;
    }

    public int index() {
        return this.index;
    }

    public Container getContainer() {
        return this.original;
    }

    public boolean isCompatibleWith(InputIterator inputIterator) {
        return inputIterator instanceof ShortIterator && this.buffer == ((ShortIterator)inputIterator).buffer;
    }
}

