/*
 * Decompiled with CFR 0.152.
 */
package com.objectspace.jgl.adapters;

import com.objectspace.jgl.Container;
import com.objectspace.jgl.ForwardIterator;
import com.objectspace.jgl.InputIterator;
import com.objectspace.jgl.RandomAccessIterator;
import com.objectspace.jgl.adapters.IntArray;
import com.objectspace.jgl.adapters.IntBuffer;
import java.io.Serializable;
import java.util.NoSuchElementException;

public final class IntIterator
implements RandomAccessIterator,
Serializable {
    int[] buffer;
    Container original;
    int index;
    static final long serialVersionUID = 2299607292735098234L;

    public static IntIterator begin(int[] nArray) {
        return new IntIterator(nArray, 0);
    }

    public static IntIterator end(int[] nArray) {
        return new IntIterator(nArray, nArray.length);
    }

    public IntIterator() {
        this(new IntArray(), 0);
    }

    public IntIterator(IntIterator intIterator) {
        this.buffer = intIterator.buffer;
        this.original = intIterator.original;
        this.index = intIterator.index;
    }

    public IntIterator(int[] nArray, int n) {
        this(new IntArray(nArray), n);
    }

    public IntIterator(IntArray intArray, int n) {
        this.buffer = intArray.array;
        this.original = intArray;
        this.index = n;
    }

    public IntIterator(IntBuffer intBuffer, int n) {
        this.buffer = intBuffer.storage;
        this.original = intBuffer;
        this.index = n;
    }

    public Object clone() {
        return new IntIterator(this);
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (!(object instanceof IntIterator)) break block2;
                IntIterator intIterator = (IntIterator)object;
                if (intIterator.index == this.index && (intIterator.buffer == this.buffer || false)) break block3;
            }
            return false;
        }
        return true;
    }

    public boolean equals(IntIterator intIterator) {
        return intIterator.index == this.index && intIterator.buffer == this.buffer;
    }

    public boolean less(RandomAccessIterator randomAccessIterator) {
        return this.index < ((IntIterator)randomAccessIterator).index;
    }

    public boolean atBegin() {
        return this.index == 0;
    }

    public boolean atEnd() {
        return this.index == this.original.size();
    }

    public boolean hasMoreElements() {
        return this.index < this.original.size();
    }

    public void advance() {
        ++this.index;
    }

    public void advance(int n) {
        this.index += n;
    }

    public void retreat() {
        --this.index;
    }

    public void retreat(int n) {
        this.index -= n;
    }

    public Object nextElement() {
        try {
            Integer n = new Integer(this.buffer[this.index]);
            ++this.index;
            return n;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new NoSuchElementException("IntIterator");
        }
    }

    public Object get() {
        return new Integer(this.buffer[this.index]);
    }

    public int getInt() {
        return this.buffer[this.index];
    }

    public Object get(int n) {
        return new Integer(this.buffer[this.index + n]);
    }

    public int getInt(int n) {
        return this.buffer[this.index + n];
    }

    public void put(Object object) {
        int n;
        this.buffer[this.index] = n = ((Number)object).intValue();
    }

    public void put(int n) {
        this.buffer[this.index] = n;
    }

    public void put(int n, Object object) {
        int n2;
        this.buffer[this.index + n] = n2 = ((Number)object).intValue();
    }

    public void put(int n, int n2) {
        this.buffer[this.index + n] = n2;
    }

    public int distance(ForwardIterator forwardIterator) {
        ForwardIterator forwardIterator2 = forwardIterator;
        if (!(forwardIterator2 instanceof IntIterator) || this.buffer != ((IntIterator)forwardIterator2).buffer && !false) {
            throw new IllegalArgumentException("iterators not compatible");
        }
        return ((IntIterator)forwardIterator).index - this.index;
    }

    public int index() {
        return this.index;
    }

    public Container getContainer() {
        return this.original;
    }

    public boolean isCompatibleWith(InputIterator inputIterator) {
        return inputIterator instanceof IntIterator && this.buffer == ((IntIterator)inputIterator).buffer;
    }
}

