/*
 * Decompiled with CFR 0.152.
 */
package com.objectspace.jgl.adapters;

import com.objectspace.jgl.ForwardIterator;
import com.objectspace.jgl.InvalidOperationException;
import com.objectspace.jgl.Sequence;
import com.objectspace.jgl.adapters.Algorithms;
import com.objectspace.jgl.adapters.ArrayAdapter;
import com.objectspace.jgl.adapters.CharArray;
import com.objectspace.jgl.adapters.CharIterator;
import java.io.Serializable;
import java.util.Enumeration;

public class CharBuffer
implements Sequence {
    static final char defaultValue = '\u0000';
    char[] storage;
    int length;
    static final long serialVersionUID = -772607664012752530L;

    public CharBuffer() {
        this.clear();
    }

    public CharBuffer(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Attempt to create an CharBuffer with a negative size");
        }
        this.length = n;
        this.storage = new char[this.length];
    }

    public CharBuffer(int n, char c) {
        this(n);
        int n2 = 0;
        while (n2 < this.length) {
            this.storage[n2] = c;
            ++n2;
        }
    }

    public CharBuffer(char[] cArray) {
        this(cArray, true);
    }

    CharBuffer(char[] cArray, boolean bl) {
        char[] cArray2 = cArray;
        synchronized (cArray2) {
            this.length = cArray.length;
            if (bl) {
                this.storage = new char[this.length];
                System.arraycopy(cArray, 0, this.storage, 0, this.length);
            } else {
                this.storage = cArray;
            }
            return;
        }
    }

    public CharBuffer(CharBuffer charBuffer) {
        this(charBuffer.storage);
    }

    public synchronized Object clone() {
        return new CharBuffer(this);
    }

    public boolean equals(Object object) {
        return object instanceof CharBuffer && this.equals((CharBuffer)object) || object instanceof CharArray && this.equals((CharArray)object);
    }

    public boolean equals(CharBuffer charBuffer) {
        return this.equals(new CharArray(charBuffer.storage));
    }

    public synchronized boolean equals(CharArray charArray) {
        return charArray.equals(this.storage);
    }

    public boolean equals(char[] cArray) {
        return this.equals(new CharArray(cArray));
    }

    public synchronized String toString() {
        return Algorithms.Printing.toString(this, "CharBuffer");
    }

    public synchronized void copy(CharBuffer charBuffer) {
        if (this == charBuffer) {
            return;
        }
        CharBuffer charBuffer2 = charBuffer;
        synchronized (charBuffer2) {
            if (charBuffer.length > this.storage.length) {
                this.storage = charBuffer.get();
            } else {
                System.arraycopy(charBuffer.storage, 0, this.storage, 0, charBuffer.length);
                int n = charBuffer.length;
                while (n < this.length) {
                    this.storage[n] = '\u0000';
                    ++n;
                }
            }
            this.length = charBuffer.length;
            return;
        }
    }

    public synchronized void copyTo(char[] cArray) {
        char[] cArray2 = cArray;
        synchronized (cArray2) {
            System.arraycopy(this.storage, 0, cArray, 0, Math.min(this.length, cArray.length));
            return;
        }
    }

    public synchronized char[] get() {
        char[] cArray = new char[this.length];
        this.copyTo(cArray);
        return cArray;
    }

    public synchronized int hashCode() {
        return Algorithms.Hashing.orderedHash(this.begin(), this.length);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Object back() {
        return this.at(this.size() - 1);
    }

    public Object front() {
        return this.at(0);
    }

    public int size() {
        return this.length;
    }

    public int capacity() {
        return this.storage.length;
    }

    public int maxSize() {
        return Integer.MAX_VALUE;
    }

    public Object at(int n) {
        return new Character(this.charAt(n));
    }

    public synchronized char charAt(int n) {
        ArrayAdapter.checkIndex(n, this.length);
        return this.storage[n];
    }

    public synchronized void put(int n, Object object) {
        this.put(n, ((Character)object).charValue());
    }

    public synchronized void put(int n, char c) {
        ArrayAdapter.checkIndex(n, this.length);
        this.storage[n] = c;
    }

    public synchronized void clear() {
        this.storage = new char[10];
        this.length = 0;
    }

    public Object remove(Enumeration enumeration) {
        if (!(enumeration instanceof CharIterator)) {
            throw new IllegalArgumentException("Enumeration not an CharIterator");
        }
        if (((CharIterator)enumeration).buffer != this.storage) {
            throw new IllegalArgumentException("Enumeration not for this CharBuffer ");
        }
        Serializable serializable = (CharIterator)enumeration;
        serializable = new Character(serializable.buffer[serializable.index]);
        this.remove(((CharIterator)enumeration).index);
        return serializable;
    }

    public synchronized Object remove(int n) {
        ArrayAdapter.checkIndex(n, this.length);
        Character c = new Character(this.storage[n]);
        System.arraycopy(this.storage, n + 1, this.storage, n, this.length - n - 1);
        this.storage[--this.length] = '\u0000';
        return c;
    }

    public int remove(Enumeration enumeration, Enumeration enumeration2) {
        block5: {
            block4: {
                if (!(enumeration instanceof CharIterator) || !(enumeration2 instanceof CharIterator)) {
                    throw new IllegalArgumentException("Enumeration not an CharIterator");
                }
                if (((CharIterator)enumeration).buffer != this.storage) break block4;
                CharIterator charIterator = (CharIterator)enumeration;
                CharIterator charIterator2 = (CharIterator)enumeration2;
                if (!(charIterator2 instanceof CharIterator) || charIterator.buffer != charIterator2.buffer && !false) break block5;
            }
            throw new IllegalArgumentException("Enumeration not compatible");
        }
        return this.remove(((CharIterator)enumeration).index, ((CharIterator)enumeration2).index - 1);
    }

    public synchronized int remove(int n, int n2) {
        if (n2 < n) {
            return 0;
        }
        int n3 = this.length;
        ArrayAdapter.checkIndex(n, n3);
        ArrayAdapter.checkIndex(n2, n3);
        n3 = n2 - n + 1;
        System.arraycopy(this.storage, n2 + 1, this.storage, n, this.length - n2 - 1);
        int n4 = this.length - n3;
        while (n4 < this.length) {
            this.storage[n4] = '\u0000';
            ++n4;
        }
        this.length -= n3;
        return n3;
    }

    public synchronized Object popBack() {
        if (this.length == 0) {
            throw new InvalidOperationException("CharBuffer is empty");
        }
        Character c = new Character(this.storage[--this.length]);
        this.storage[this.length] = '\u0000';
        return c;
    }

    public synchronized Object add(Object object) {
        this.add(((Character)object).charValue());
        return null;
    }

    public synchronized void add(char c) {
        if (this.length == this.storage.length) {
            char[] cArray = this.getNextStorage(1);
            this.copyTo(cArray);
            this.storage = cArray;
        }
        this.storage[this.length++] = c;
    }

    public void pushBack(Object object) {
        this.add(((Character)object).charValue());
    }

    public void pushBack(char c) {
        this.add(c);
    }

    public CharIterator insert(CharIterator charIterator, Object object) {
        return this.insert(charIterator, ((Character)object).charValue());
    }

    public CharIterator insert(CharIterator charIterator, char c) {
        this.insert(charIterator.index, c);
        return new CharIterator(this, charIterator.index);
    }

    public void insert(int n, Object object) {
        this.insert(n, ((Character)object).charValue());
    }

    public synchronized void insert(int n, char c) {
        ArrayAdapter.checkIndex(n, this.length + 1);
        if (this.length != this.storage.length) {
            if (n != this.length) {
                System.arraycopy(this.storage, n, this.storage, n + 1, this.length - n);
            }
        } else {
            char[] cArray = this.getNextStorage(1);
            System.arraycopy(this.storage, 0, cArray, 0, n);
            System.arraycopy(this.storage, n, cArray, n + 1, this.length - n);
            this.storage = cArray;
        }
        this.storage[n] = c;
        ++this.length;
    }

    public void insert(CharIterator charIterator, int n, Object object) {
        this.insert(charIterator, n, ((Character)object).charValue());
    }

    public void insert(CharIterator charIterator, int n, char c) {
        this.insert(charIterator.index, n, c);
    }

    public void insert(int n, int n2, Object object) {
        this.insert(n, n2, ((Character)object).charValue());
    }

    public synchronized void insert(int n, int n2, char c) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Attempt to insert a negative number of objects.");
        }
        if (n2 == 0) {
            return;
        }
        ArrayAdapter.checkIndex(n, this.length + 1);
        if (this.storage.length - this.length >= n2) {
            System.arraycopy(this.storage, n, this.storage, n + n2, this.length - n);
        } else {
            char[] cArray = this.getNextStorage(n2);
            System.arraycopy(this.storage, 0, cArray, 0, n);
            System.arraycopy(this.storage, n, cArray, n + n2, this.length - n);
            this.storage = cArray;
        }
        int n3 = n;
        while (n3 < n + n2) {
            this.storage[n3] = c;
            ++n3;
        }
        this.length += n2;
    }

    public void insert(CharIterator charIterator, ForwardIterator forwardIterator, ForwardIterator forwardIterator2) {
        this.insert(charIterator.index, forwardIterator, forwardIterator2);
    }

    public synchronized void insert(int n, ForwardIterator forwardIterator, ForwardIterator forwardIterator2) {
        int n2 = forwardIterator.distance(forwardIterator2);
        if (n2 == 0) {
            return;
        }
        ForwardIterator forwardIterator3 = (ForwardIterator)forwardIterator.clone();
        if (this.storage.length - this.length >= n2) {
            System.arraycopy(this.storage, n, this.storage, n + n2, this.length - n);
        } else {
            char[] cArray = this.getNextStorage(n2);
            System.arraycopy(this.storage, 0, cArray, 0, n);
            System.arraycopy(this.storage, n, cArray, n + n2, this.length - n);
            this.storage = cArray;
        }
        this.length += n2;
        int n3 = n;
        while (n3 < n + n2) {
            this.put(n3, forwardIterator3.nextElement());
            ++n3;
        }
    }

    public synchronized void swap(CharBuffer charBuffer) {
        CharBuffer charBuffer2 = charBuffer;
        synchronized (charBuffer2) {
            int n = this.length;
            char[] cArray = this.storage;
            this.length = charBuffer.length;
            this.storage = charBuffer.storage;
            charBuffer.length = n;
            charBuffer.storage = cArray;
            return;
        }
    }

    public Enumeration elements() {
        return this.begin();
    }

    public ForwardIterator start() {
        return this.begin();
    }

    public ForwardIterator finish() {
        return this.end();
    }

    public synchronized CharIterator begin() {
        return new CharIterator(this, 0);
    }

    public synchronized CharIterator end() {
        return new CharIterator(this, this.length);
    }

    public synchronized void trimToSize() {
        if (this.length < this.storage.length) {
            this.storage = this.get();
        }
    }

    public synchronized void ensureCapacity(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Attempt to reserve a negative size.");
        }
        if (this.storage.length < n) {
            char[] cArray = new char[n];
            if (this.length > 0) {
                System.arraycopy(this.storage, 0, cArray, 0, this.length);
            }
            this.storage = cArray;
        }
    }

    public synchronized Object popFront() {
        if (this.length == 0) {
            throw new InvalidOperationException("CharBuffer is empty");
        }
        Character c = new Character(this.storage[0]);
        this.remove(0);
        return c;
    }

    public void pushFront(Object object) {
        this.insert(0, object);
    }

    public void pushFront(char c) {
        this.insert(0, c);
    }

    public int remove(Object object) {
        return this.remove(object, this.length);
    }

    public synchronized int remove(Object object, int n) {
        char c = ((Character)object).charValue();
        int n2 = 0;
        while (n > 0) {
            int n3 = this.indexOf(c);
            if (n3 < 0) break;
            --n;
            ++n2;
            this.remove(n3);
        }
        return n2;
    }

    public synchronized int remove(int n, int n2, Object object) {
        ((Character)object).charValue();
        if (n2 < n) {
            return 0;
        }
        int n3 = this.length;
        ArrayAdapter.checkIndex(n, n3);
        ArrayAdapter.checkIndex(n2, n3);
        CharIterator charIterator = new CharIterator(this, n);
        CharIterator charIterator2 = new CharIterator(this, n2 + 1);
        CharIterator charIterator3 = (CharIterator)Algorithms.Removing.remove(charIterator, charIterator2, object);
        return this.remove(charIterator3.index, n2);
    }

    public int replace(Object object, Object object2) {
        return this.replace(((Character)object).charValue(), ((Character)object2).charValue());
    }

    public int replace(char c, char c2) {
        return this.replace(0, this.length - 1, c, c2);
    }

    public int replace(int n, int n2, Object object, Object object2) {
        return this.replace(n, n2, ((Character)object).charValue(), ((Character)object2).charValue());
    }

    public synchronized int replace(int n, int n2, char c, char c2) {
        int n3 = this.length;
        ArrayAdapter.checkIndex(n, n3);
        ArrayAdapter.checkIndex(n2, n3);
        n3 = 0;
        while (n < n2) {
            if (this.storage[n] == c) {
                this.storage[n] = c2;
                ++n3;
            }
            ++n;
        }
        return n3;
    }

    public int count(Object object) {
        return this.count(((Character)object).charValue());
    }

    public int count(char c) {
        return this.count(0, this.length - 1, c);
    }

    public int count(int n, int n2, Object object) {
        return this.count(n, n2, ((Character)object).charValue());
    }

    public synchronized int count(int n, int n2, char c) {
        int n3 = this.length;
        ArrayAdapter.checkIndex(n, n3);
        ArrayAdapter.checkIndex(n2, n3);
        n3 = 0;
        while (n < n2) {
            if (this.storage[n] == c) {
                ++n3;
            }
            ++n;
        }
        return n3;
    }

    public int indexOf(Object object) {
        return this.indexOf(((Character)object).charValue());
    }

    public int indexOf(char c) {
        return this.indexOf(0, this.length - 1, c);
    }

    public int indexOf(int n, int n2, Object object) {
        return this.indexOf(n, n2, ((Character)object).charValue());
    }

    public synchronized int indexOf(int n, int n2, char c) {
        if (n2 < n) {
            return -1;
        }
        int n3 = this.length;
        ArrayAdapter.checkIndex(n, n3);
        ArrayAdapter.checkIndex(n2, n3);
        while (n < n2) {
            if (this.storage[n] == c) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public synchronized void setSize(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Attempt to become a negative size.");
        }
        if (this.length > n) {
            this.remove(n, this.length - 1);
            return;
        }
        if (this.length < n) {
            this.insert(this.length, n - this.length, '\u0000');
        }
    }

    public boolean contains(Object object) {
        return this.contains(((Character)object).charValue());
    }

    public boolean contains(char c) {
        return this.indexOf(c) != -1;
    }

    private char[] getNextStorage(int n) {
        int n2 = Math.max(ArrayAdapter.getNextSize(this.length), this.length + n);
        char[] cArray = new char[n2];
        return cArray;
    }

    static char asChar(Object object) {
        return ((Character)object).charValue();
    }
}

