/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.treetable;

import com.klg.jclass.util.JCIntComparator;
import com.klg.jclass.util.JCListenerList;
import com.klg.jclass.util.JCMappingSort;
import com.klg.jclass.util.swing.DefaultRowComparator;
import com.klg.jclass.util.swing.JCComparableRow;
import com.klg.jclass.util.swing.JCRowComparator;
import com.klg.jclass.util.swing.JCRowSortModel;
import com.klg.jclass.util.treetable.JCTreeTableModel;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.Enumeration;
import java.util.HashMap;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;

public class TreeWithSortableChildren
implements JCTreeTableModel,
JCRowSortModel,
Serializable {
    protected JCTreeTableModel treetable = null;
    protected int sortColumn = -1;
    protected int sortOrder = 1;
    protected JCRowComparator rowComparator = new DefaultRowComparator(1);
    protected int[][] keyColumnsArray;
    protected RowIntComparator rowIntComparator = new RowIntComparator();
    protected HashMap nodeChildIndexMaps = null;
    protected boolean autoSort = true;
    protected boolean needsResorting = true;
    protected boolean needsReordering = false;
    protected JCListenerList listeners = null;
    protected Listener l = new Listener();

    public TreeWithSortableChildren(JCTreeTableModel jCTreeTableModel, JCRowComparator jCRowComparator) {
        this(jCTreeTableModel);
        this.rowComparator = jCRowComparator;
    }

    public TreeWithSortableChildren(JCTreeTableModel jCTreeTableModel) {
        this.setModel(jCTreeTableModel);
    }

    public JCTreeTableModel getModel() {
        return this.treetable;
    }

    public void setModel(JCTreeTableModel jCTreeTableModel) {
        if (jCTreeTableModel == this.treetable) {
            return;
        }
        if (this.treetable != null) {
            this.treetable.removeTreeModelListener(this.l);
        }
        this.treetable = jCTreeTableModel;
        this.treetable.addTreeModelListener(this.l);
        this.needsResorting = true;
        this.needsReordering = false;
        this.nodeChildIndexMaps = this.autoSort ? new HashMap() : null;
        this.sortColumn = -1;
        if (this.treetable == null) {
            this.keyColumnsArray = null;
        } else {
            int n;
            int n2 = this.treetable.getColumnCount();
            int n3 = n = this.keyColumnsArray == null ? 0 : this.keyColumnsArray.length;
            if (n != n2) {
                int[][] nArrayArray = new int[n2][];
                int n4 = 0;
                while (n4 < Math.min(n2, n)) {
                    nArrayArray[n4] = this.keyColumnsArray[n4];
                    ++n4;
                }
                this.keyColumnsArray = nArrayArray;
            }
        }
    }

    public boolean getAutoSort() {
        return this.autoSort;
    }

    public void setAutoSort(boolean bl) {
        if (this.autoSort == bl) {
            return;
        }
        this.autoSort = bl;
        if (bl) {
            this.setDataSorted(true);
        }
    }

    public void setKeyColumns(int n, int[] nArray) {
        if (this.keyColumnsArray == null) {
            this.keyColumnsArray = new int[this.treetable.getColumnCount()][];
        }
        this.keyColumnsArray[n] = nArray;
        this.needsResorting = true;
    }

    public int[] getKeyColumns(int n) {
        return this.keyColumnsArray[n];
    }

    public boolean isDataSorted() {
        return this.nodeChildIndexMaps != null;
    }

    public void setDataSorted(boolean bl) {
        if (bl && this.sortColumn == -1) {
            return;
        }
        if (!bl && this.isDataSorted()) {
            this.needsReordering = true;
            this.sortColumn = -1;
        }
        if (this.needsResorting || this.needsReordering) {
            if (this.needsResorting) {
                this.nodeChildIndexMaps = new HashMap();
                this.needsReordering = false;
            }
            this.postTreeStructureChanged(null, false);
            this.needsResorting = false;
        }
    }

    public int getSortColumn() {
        return this.sortColumn;
    }

    public void setSortColumn(int n) {
        if (this.sortColumn == n) {
            return;
        }
        if (this.treetable != null && this.treetable.getColumnCount() <= n) {
            throw new IllegalArgumentException("index value greater than number of columns");
        }
        this.sortColumn = n;
        this.needsResorting = true;
        if (this.autoSort) {
            this.setDataSorted(true);
        }
    }

    public int getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(int n) {
        this.sortOrder = n;
        this.needsReordering = true;
        if (this.autoSort) {
            this.setDataSorted(true);
        }
    }

    public void toggleSortOrder() {
        this.sortOrder = this.sortOrder == 1 ? -1 : 1;
        this.needsReordering = true;
        if (this.autoSort) {
            this.setDataSorted(true);
        }
    }

    protected int[] getIndices(Object object) {
        int n = this.treetable.getChildCount(object);
        if (this.sortColumn == -1 || n == 0) {
            return null;
        }
        if (this.nodeChildIndexMaps == null) {
            return null;
        }
        HashObject hashObject = new HashObject(object);
        int[] nArray = (int[])this.nodeChildIndexMaps.get(hashObject);
        if (nArray == null) {
            nArray = new int[n];
            int n2 = 0;
            while (n2 < nArray.length) {
                nArray[n2] = n2;
                ++n2;
            }
            this.rowIntComparator.parent = object;
            if (this.keyColumnsArray == null) {
                this.keyColumnsArray = new int[this.treetable.getColumnCount()][];
            }
            int[] nArray2 = new int[]{this.sortColumn};
            this.rowComparator.setKeyColumns(this.keyColumnsArray[this.sortColumn] != null ? this.keyColumnsArray[this.sortColumn] : nArray2);
            JCMappingSort.sort(this.rowIntComparator, nArray);
            this.nodeChildIndexMaps.put(hashObject, nArray);
        }
        return nArray;
    }

    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this.listeners = JCListenerList.add(this.listeners, treeModelListener);
    }

    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.listeners = JCListenerList.remove(this.listeners, treeModelListener);
    }

    public Object getChild(Object object, int n) {
        int[] nArray = this.getIndices(object);
        if (nArray != null) {
            n = this.sortOrder == 1 ? nArray[n] : nArray[nArray.length - n - 1];
        }
        return this.treetable.getChild(object, n);
    }

    public int getChildCount(Object object) {
        return this.treetable.getChildCount(object);
    }

    public int getIndexOfChild(Object object, Object object2) {
        int n = this.treetable.getIndexOfChild(object, object2);
        if (n < 0) {
            return n;
        }
        int[] nArray = this.getIndices(object);
        if (nArray == null) {
            return n;
        }
        int n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] == n) {
                if (this.sortOrder == 1) {
                    return n2;
                }
                return nArray.length - n2 - 1;
            }
            ++n2;
        }
        throw new IllegalArgumentException("Node not child of specified parent");
    }

    public Object getRoot() {
        return this.treetable.getRoot();
    }

    public boolean isLeaf(Object object) {
        return this.treetable.isLeaf(object);
    }

    public void valueForPathChanged(TreePath treePath, Object object) {
        this.treetable.valueForPathChanged(treePath, object);
    }

    public Object getValueAt(Object object, int n) {
        return this.treetable.getValueAt(object, n);
    }

    public boolean isCellEditable(Object object, int n) {
        return this.treetable.isCellEditable(object, n);
    }

    public void setValueAt(Object object, Object object2, int n) {
        this.treetable.setValueAt(object, object2, n);
    }

    public Class getColumnClass(int n) {
        return this.treetable.getColumnClass(n);
    }

    public int getColumnCount() {
        return this.treetable.getColumnCount();
    }

    public String getColumnName(int n) {
        return this.treetable.getColumnName(n);
    }

    protected static Object getNode(TreePath treePath) {
        return treePath.getLastPathComponent();
    }

    protected void postTreeStructureChanged(TreeModelEvent treeModelEvent) {
        this.postTreeStructureChanged(treeModelEvent, true);
    }

    protected void postTreeStructureChanged(TreeModelEvent treeModelEvent, boolean bl) {
        if (treeModelEvent == null) {
            treeModelEvent = new TreeModelEvent((Object)this, new TreePath(this.treetable.getRoot()), null, null);
        }
        if (bl) {
            this.nodeChildIndexMaps = this.autoSort ? new HashMap() : null;
            this.needsResorting = true;
        }
        Enumeration enumeration = JCListenerList.elements(this.listeners);
        while (enumeration.hasMoreElements()) {
            TreeModelListener treeModelListener = (TreeModelListener)enumeration.nextElement();
            treeModelListener.treeStructureChanged(treeModelEvent);
        }
    }

    class RowIntComparator
    implements JCIntComparator {
        protected ComparableRow r1;
        protected ComparableRow r2;
        public Object parent;

        RowIntComparator() {
            this.r1 = new ComparableRow();
            this.r2 = new ComparableRow();
            this.parent = null;
        }

        public int compare(int n, int n2) {
            this.r1.row = n;
            this.r1.node = TreeWithSortableChildren.this.treetable.getChild(this.parent, n);
            this.r2.row = n2;
            this.r2.node = TreeWithSortableChildren.this.treetable.getChild(this.parent, n2);
            return TreeWithSortableChildren.this.rowComparator.compare(this.r1, this.r2);
        }
    }

    class ComparableRow
    implements JCComparableRow {
        public Object node = null;
        public int row;

        ComparableRow() {
        }

        public Object getValueAt(int n) {
            return TreeWithSortableChildren.this.treetable.getValueAt(this.node, n);
        }

        public int getRowIndex() {
            return this.row;
        }
    }

    public static class HashObject {
        WeakReference weak;

        public HashObject(Object object) {
            this.weak = new WeakReference<Object>(object);
        }

        public boolean equals(Object object) {
            Object t = this.weak.get();
            Object var3_3 = null;
            if (object != null) {
                var3_3 = ((HashObject)object).weak.get();
            }
            if (t == null) {
                return false;
            }
            return t == var3_3;
        }

        public int hashCode() {
            Object t = this.weak.get();
            if (t == null) {
                return 0;
            }
            return t.hashCode();
        }
    }

    class Listener
    implements TreeModelListener {
        Listener() {
        }

        protected TreeModelEvent convertTreeEvent(TreeModelEvent treeModelEvent) {
            if (treeModelEvent == null) {
                return null;
            }
            return new TreeModelEvent((Object)TreeWithSortableChildren.this, treeModelEvent.getTreePath(), treeModelEvent.getChildIndices(), treeModelEvent.getChildren());
        }

        public void treeNodesChanged(TreeModelEvent treeModelEvent) {
            TreeModelEvent treeModelEvent2 = null;
            if (treeModelEvent == null) {
                treeModelEvent2 = new TreeModelEvent((Object)TreeWithSortableChildren.this, new TreePath(TreeWithSortableChildren.this.treetable.getRoot()), null, null);
            }
            if (TreeWithSortableChildren.this.nodeChildIndexMaps == null && (treeModelEvent2 = this.convertTreeEvent(treeModelEvent)) == null) {
                return;
            }
            if (treeModelEvent2 != null) {
                Enumeration enumeration = JCListenerList.elements(TreeWithSortableChildren.this.listeners);
                while (enumeration.hasMoreElements()) {
                    TreeModelListener treeModelListener = (TreeModelListener)enumeration.nextElement();
                    treeModelListener.treeNodesChanged(treeModelEvent2);
                }
            } else {
                TreeWithSortableChildren.this.nodeChildIndexMaps = TreeWithSortableChildren.this.autoSort ? new HashMap() : null;
                TreeWithSortableChildren.this.needsResorting = true;
                this.treeNodesChanged(null);
            }
        }

        public void treeNodesInserted(TreeModelEvent treeModelEvent) {
            TreeModelEvent treeModelEvent2 = this.convertTreeEvent(treeModelEvent);
            if (treeModelEvent2 == null) {
                return;
            }
            TreeWithSortableChildren.this.nodeChildIndexMaps = TreeWithSortableChildren.this.autoSort ? new HashMap() : null;
            TreeWithSortableChildren.this.needsResorting = true;
            Enumeration enumeration = JCListenerList.elements(TreeWithSortableChildren.this.listeners);
            while (enumeration.hasMoreElements()) {
                TreeModelListener treeModelListener = (TreeModelListener)enumeration.nextElement();
                treeModelListener.treeNodesInserted(treeModelEvent2);
            }
        }

        public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
            TreeModelEvent treeModelEvent2 = this.convertTreeEvent(treeModelEvent);
            if (treeModelEvent2 == null) {
                return;
            }
            TreeWithSortableChildren.this.nodeChildIndexMaps = TreeWithSortableChildren.this.autoSort ? new HashMap() : null;
            TreeWithSortableChildren.this.needsResorting = true;
            Enumeration enumeration = JCListenerList.elements(TreeWithSortableChildren.this.listeners);
            while (enumeration.hasMoreElements()) {
                TreeModelListener treeModelListener = (TreeModelListener)enumeration.nextElement();
                treeModelListener.treeNodesRemoved(treeModelEvent2);
            }
        }

        public void treeStructureChanged(TreeModelEvent treeModelEvent) {
            TreeWithSortableChildren.this.postTreeStructureChanged(treeModelEvent);
        }
    }
}

