/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.swing.encode;

import com.klg.jclass.util.JCLocaleManager;
import com.klg.jclass.util.swing.JCMessageHelper;
import com.klg.jclass.util.swing.encode.Encoder;
import com.klg.jclass.util.swing.encode.EncoderException;
import java.awt.Component;
import java.awt.Image;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class JCEncodeComponent {
    public static final Encoding GIF = new Encoding("GIF", "CompuServe Graphic Interchange File", "com.klg.jclass.util.swing.encode.GIFEncoder", "ENCODE_NEEDS_GIFLICENSE");
    public static final Encoding PNG = new Encoding("PNG", "Portable Network Graphics", "com.klg.jclass.util.swing.encode.PNGEncoder", "ENCODER_LOAD_ERROR");
    public static final Encoding SVG = new Encoding("SVG", "Scalable Vector Graphics", "com.klg.jclass.util.swing.encode.SVGEncoder", "ENCODER_LOAD_ERROR");
    public static final Encoding SWF = new Encoding("SWF", "Shockwave Flash", "com.klg.jclass.util.swing.encode.swf.SWFEncoder", "ENCODER_LOAD_ERROR");
    public static final Encoding JPEG = new Encoding("JPEG", "Joint Photographic Experts Group", "com.klg.jclass.util.swing.encode.JPEGEncoder", "ENCODER_LOAD_ERROR");
    public static final Encoding EPS = new Encoding("EPS", "Encapsulated PostScript", "com.klg.jclass.util.swing.encode.page.EPSEncoder", "ENCODE_NEEDS_JCLASSPAGELAYOUT");
    public static final Encoding PCL = new Encoding("PCL", "HP Page Control Language Version 5", "com.klg.jclass.util.swing.encode.page.PCLEncoder", "ENCODE_NEEDS_JCLASSPAGELAYOUT");
    public static final Encoding PDF = new Encoding("PDF", "Adobe Acrobat Portable Document File", "com.klg.jclass.util.swing.encode.page.PDFEncoder", "ENCODE_NEEDS_JCLASSPAGELAYOUT");
    public static final Encoding PS = new Encoding("PS", "Adobe PostScript Level 2", "com.klg.jclass.util.swing.encode.page.PSEncoder", "ENCODE_NEEDS_JCLASSPAGELAYOUT");
    public static final Encoding[] ENCODINGS = new Encoding[]{PNG, GIF, JPEG, EPS, PCL, PDF, PS};
    public static final Encoding[] SERVER_ENCODINGS = new Encoding[]{PNG, GIF, JPEG, SWF, SVG, PDF};
    public static final Encoding[] IMAGE_ENCODINGS = new Encoding[]{PNG, GIF, JPEG};
    protected static String bundleName = "com.klg.jclass.util.swing.encode.resources.LocaleInfo";

    public static void encode(Encoding encoding, Component component, OutputStream outputStream) throws IOException, EncoderException {
        Encoder encoder = JCEncodeComponent.findEncoder(encoding, component.isShowing());
        if (encoder != null) {
            encoder.encode(component, outputStream);
        }
    }

    public static void encode(Encoding encoding, Component component, File file) throws IOException, EncoderException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        JCEncodeComponent.encode(encoding, component, (OutputStream)fileOutputStream);
        ((OutputStream)fileOutputStream).close();
    }

    public static void encode(Encoding encoding, Image image, OutputStream outputStream) throws IOException, EncoderException {
        Encoder encoder = JCEncodeComponent.findEncoder(encoding, false);
        if (encoder != null) {
            encoder.encode(image, outputStream);
        }
    }

    public static void encode(Encoding encoding, Image image, File file) throws IOException, EncoderException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        JCEncodeComponent.encode(encoding, image, (OutputStream)fileOutputStream);
        ((OutputStream)fileOutputStream).close();
    }

    public static Encoder findEncoder(Encoding encoding, boolean bl) throws IOException, EncoderException {
        Encoder encoder = encoding.getEncoder();
        if (encoder == null) {
            JCLocaleManager.getDefault().add(bundleName);
            String string = "ENCODE_DIALOG_TITLE";
            String string2 = JCLocaleManager.getDefault().getString(string);
            if (string2 == null) {
                string2 = "ENCODE_DIALOG_TITLE";
            }
            if (bl) {
                JCMessageHelper.showError(string2, encoding.getFailureMessage());
            }
            throw new EncoderException(encoding.getFailureMessage());
        }
        return encoder;
    }

    public static boolean isImageBasedEncoding(Encoding encoding) {
        int n = 0;
        while (n < IMAGE_ENCODINGS.length) {
            if (IMAGE_ENCODINGS[n] == encoding) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static class Encoding {
        private String shortName;
        private String longName;
        private String encoderClass;
        private String failureMessage;

        public Encoding(String string, String string2, String string3, String string4) {
            this.shortName = string;
            this.longName = string2;
            this.encoderClass = string3;
            this.failureMessage = string4;
        }

        public String getShortName() {
            return this.shortName;
        }

        public String getLongName() {
            return this.longName;
        }

        public String toString() {
            return this.getLongName() + " (" + this.getShortName() + ")";
        }

        public String getFailureMessage() {
            JCLocaleManager.getDefault().add(bundleName);
            String string = JCLocaleManager.getDefault().getString(this.failureMessage);
            if (string == null) {
                string = this.failureMessage;
            }
            return string;
        }

        public Encoder getEncoder() {
            Encoder encoder = null;
            Class<?> clazz = null;
            try {
                clazz = Class.forName(this.encoderClass);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (clazz != null) {
                try {
                    encoder = (Encoder)clazz.newInstance();
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
            return encoder;
        }
    }
}

