/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.swing;

import com.klg.jclass.util.JCEnvironment;
import com.klg.jclass.util.JCStringTokenizer;
import com.klg.jclass.util.JCTypeConverter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.lang.reflect.Method;
import javax.swing.BorderFactory;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.MatteBorder;
import javax.swing.border.SoftBevelBorder;
import javax.swing.border.TitledBorder;

public class JCSwingTypeConverter {
    public static final Color lightBlue = new Color(173, 216, 230);
    public static final int[] positionValues = new int[]{0, 1, 2, 3, 4, 5, 6};
    public static final String[] positionStrings = new String[]{"Default", "Above_Top", "Top", "Below_Top", "Above_Bottom", "Bottom", "Below_Bottom"};
    public static final int[] justificationValues = new int[]{0, 1, 2, 3, 4, 5};
    public static final String[] justificationStrings = new String[]{"Default", "Left", "Center", "Right", "Leading", "Trailing"};
    public static final int[] horizontalAlignmentValues = new int[]{2, 0, 4, 10, 11};
    public static final String[] horizontalAlignmentStrings = new String[]{"Left", "Center", "Right", "Leading", "Trailing"};
    public static final int[] verticalAlignmentValues = new int[]{1, 0, 3};
    public static final String[] verticalAlignmentStrings = new String[]{"Top", "Center", "Bottom"};

    public static Color[] toColorList(String string, Color[] colorArray) {
        Color[] colorArray2 = JCSwingTypeConverter.toColorList(string);
        return string != null ? colorArray2 : colorArray;
    }

    public static Color[] toColorList(String string) {
        if (string == null) {
            return null;
        }
        JCStringTokenizer jCStringTokenizer = new JCStringTokenizer(string);
        Color[] colorArray = new Color[jCStringTokenizer.countTokens(',')];
        int n = 0;
        while (jCStringTokenizer.hasMoreTokens()) {
            String string2 = jCStringTokenizer.nextToken(',').trim();
            colorArray[n] = JCSwingTypeConverter.toColor(string2);
            if (colorArray[n] == null) {
                JCTypeConverter.error(string, string2);
            }
            ++n;
        }
        return colorArray;
    }

    public static Color toColor(String string, Color color) {
        Color color2 = JCSwingTypeConverter.toColor(string);
        return string != null ? color2 : color;
    }

    public static Color toColor(String string) {
        if (string == null) {
            return null;
        }
        JCStringTokenizer jCStringTokenizer = new JCStringTokenizer(string);
        String string2 = jCStringTokenizer.nextToken('-');
        if (string2 == null) {
            return null;
        }
        if ((string2 = string2.trim()).equalsIgnoreCase("black")) {
            return Color.black;
        }
        if (string2.equalsIgnoreCase("blue")) {
            return Color.blue;
        }
        if (string2.equalsIgnoreCase("cyan")) {
            return Color.cyan;
        }
        if (string2.equalsIgnoreCase("darkGray")) {
            return Color.darkGray;
        }
        if (string2.equalsIgnoreCase("darkGrey")) {
            return Color.darkGray;
        }
        if (string2.equalsIgnoreCase("gray")) {
            return Color.gray;
        }
        if (string2.equalsIgnoreCase("grey")) {
            return Color.gray;
        }
        if (string2.equalsIgnoreCase("green")) {
            return Color.green;
        }
        if (string2.equalsIgnoreCase("lightGray")) {
            return Color.lightGray;
        }
        if (string2.equalsIgnoreCase("lightGrey")) {
            return Color.lightGray;
        }
        if (string2.equalsIgnoreCase("lightBlue")) {
            return lightBlue;
        }
        if (string2.equalsIgnoreCase("magenta")) {
            return Color.magenta;
        }
        if (string2.equalsIgnoreCase("orange")) {
            return Color.orange;
        }
        if (string2.equalsIgnoreCase("pink")) {
            return Color.pink;
        }
        if (string2.equalsIgnoreCase("red")) {
            return Color.red;
        }
        if (string2.equalsIgnoreCase("white")) {
            return Color.white;
        }
        if (string2.equalsIgnoreCase("yellow")) {
            return Color.yellow;
        }
        try {
            if (string2.startsWith("#")) {
                if (string2.length() >= 13) {
                    return new Color(Integer.valueOf(string2.substring(1, 5), 16) / 256, Integer.valueOf(string2.substring(5, 9), 16) / 256, Integer.valueOf(string2.substring(9, 13), 16) / 256);
                }
                if (string2.length() >= 7) {
                    return new Color(Integer.valueOf(string2.substring(1, 3), 16), Integer.valueOf(string2.substring(3, 5), 16), Integer.valueOf(string2.substring(5, 7), 16));
                }
                return new Color(Integer.valueOf(string2.substring(1), 16));
            }
            int n = Integer.parseInt(string2);
            int n2 = Integer.parseInt(jCStringTokenizer.nextToken('-'));
            int n3 = Integer.parseInt(jCStringTokenizer.nextToken('-'));
            return new Color(n, n2, n3);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String fromColorList(Color[] colorArray) {
        if (colorArray == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < colorArray.length) {
            if (n > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(JCSwingTypeConverter.fromColor(colorArray[n]));
            ++n;
        }
        return new String(stringBuffer);
    }

    public static String fromColor(Color color) {
        if (color == null) {
            return null;
        }
        if (color.equals(Color.black)) {
            return "black";
        }
        if (color.equals(Color.blue)) {
            return "blue";
        }
        if (color.equals(Color.cyan)) {
            return "cyan";
        }
        if (color.equals(Color.darkGray)) {
            return "darkGray";
        }
        if (color.equals(Color.gray)) {
            return "gray";
        }
        if (color.equals(Color.green)) {
            return "green";
        }
        if (color.equals(lightBlue)) {
            return "lightBlue";
        }
        if (color.equals(Color.lightGray)) {
            return "lightGray";
        }
        if (color.equals(Color.magenta)) {
            return "magenta";
        }
        if (color.equals(Color.orange)) {
            return "orange";
        }
        if (color.equals(Color.pink)) {
            return "pink";
        }
        if (color.equals(Color.red)) {
            return "red";
        }
        if (color.equals(Color.white)) {
            return "white";
        }
        if (color.equals(Color.yellow)) {
            return "yellow";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(color.getRed());
        stringBuffer.append("-");
        stringBuffer.append(color.getGreen());
        stringBuffer.append("-");
        stringBuffer.append(color.getBlue());
        return stringBuffer.toString();
    }

    public static Font toFont(String string, Font font) {
        Font font2 = JCSwingTypeConverter.toFont(string);
        return font2 != null ? font2 : font;
    }

    public static Font toFont(String string) {
        if (string == null) {
            return null;
        }
        int n = 0;
        JCStringTokenizer jCStringTokenizer = new JCStringTokenizer(string);
        if (jCStringTokenizer.countTokens('-') != 3) {
            return null;
        }
        String string2 = jCStringTokenizer.nextToken('-');
        if (string2 == null) {
            return null;
        }
        string2 = string2.trim();
        String string3 = jCStringTokenizer.nextToken('-');
        if (string3 == null) {
            n = 0;
        } else {
            if ((string3 = string3.trim()).equalsIgnoreCase("PLAIN")) {
                n = 0;
            }
            if (string3.equalsIgnoreCase("ITALIC")) {
                n = 2;
            }
            if (string3.equalsIgnoreCase("BOLD")) {
                n = 1;
            }
            if (string3.equalsIgnoreCase("BOLDITALIC")) {
                n = 3;
            }
        }
        String string4 = jCStringTokenizer.nextToken('-');
        int n2 = 8;
        if (string4 != null) {
            n2 = Integer.parseInt(string4.trim());
        }
        return new Font(string2, n, n2);
    }

    public static String fromFont(Font font) {
        if (font == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(font.getName());
        stringBuffer.append("-");
        switch (font.getStyle()) {
            case 2: {
                stringBuffer.append("ITALIC");
                break;
            }
            case 1: {
                stringBuffer.append("BOLD");
                break;
            }
            case 3: {
                stringBuffer.append("BOLDITALIC");
                break;
            }
            default: {
                stringBuffer.append("PLAIN");
            }
        }
        stringBuffer.append("-");
        stringBuffer.append(font.getSize());
        return stringBuffer.toString();
    }

    public static Insets toInsets(String string, Insets insets) {
        if (string == null) {
            return insets;
        }
        int[] nArray = JCTypeConverter.toIntList(string, ',', null);
        if (nArray != null && nArray.length == 4) {
            return new Insets(nArray[0], nArray[1], nArray[2], nArray[3]);
        }
        return insets;
    }

    public static String fromInsets(Insets insets) {
        return insets.top + "," + insets.left + "," + insets.bottom + "," + insets.right;
    }

    public static Dimension toDimension(String string, Dimension dimension) {
        int[] nArray = JCTypeConverter.toIntList(string, 'x', null);
        if (nArray != null && nArray.length == 2) {
            return new Dimension(nArray[0], nArray[1]);
        }
        return dimension;
    }

    public static Point toPoint(String string, Point point) {
        int[] nArray = JCTypeConverter.toIntList(string, ',', null);
        if (nArray != null && nArray.length == 2) {
            return new Point(nArray[0], nArray[1]);
        }
        return point;
    }

    public static String fromInsetsToIntList(Insets insets) {
        return JCSwingTypeConverter.fromInsetsToIntList(insets, ", ");
    }

    public static String fromInsetsToIntList(Insets insets, String string) {
        if (insets == null) {
            return "0" + string + "0" + string + "0" + string + "0";
        }
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(insets.top);
        stringBuffer.append(string);
        stringBuffer.append(insets.left);
        stringBuffer.append(string);
        stringBuffer.append(insets.bottom);
        stringBuffer.append(string);
        stringBuffer.append(insets.right);
        return stringBuffer.toString();
    }

    public static Border toBorder(String string) {
        Border border = null;
        char c = '|';
        if (string == null) {
            return null;
        }
        JCStringTokenizer jCStringTokenizer = new JCStringTokenizer(string);
        String string2 = jCStringTokenizer.nextToken(c);
        if (string2 == null) {
            return null;
        }
        if ((string2 = string2.trim()).equalsIgnoreCase("empty")) {
            String string3 = jCStringTokenizer.nextToken(c);
            String string4 = jCStringTokenizer.nextToken(c);
            String string5 = jCStringTokenizer.nextToken(c);
            String string6 = jCStringTokenizer.nextToken(c);
            if (string3 == null || string4 == null || string5 == null || string6 == null) {
                return null;
            }
            border = BorderFactory.createEmptyBorder(new Integer(string3), new Integer(string4), new Integer(string5), new Integer(string6));
        } else if (string2.equalsIgnoreCase("bevel")) {
            String string7 = jCStringTokenizer.nextToken(c);
            String string8 = jCStringTokenizer.nextToken(c);
            String string9 = jCStringTokenizer.nextToken(c);
            if (string7 != null) {
                int n;
                int n2 = n = string7.equalsIgnoreCase("raised") ? 0 : 1;
                border = string8 == null || string9 == null ? new BevelBorder(n) : new BevelBorder(n, JCSwingTypeConverter.toColor(string8), JCSwingTypeConverter.toColor(string9));
            }
        } else if (string2.equalsIgnoreCase("softbevel")) {
            String string10 = jCStringTokenizer.nextToken(c);
            String string11 = jCStringTokenizer.nextToken(c);
            String string12 = jCStringTokenizer.nextToken(c);
            if (string10 != null) {
                int n;
                int n3 = n = string10.equalsIgnoreCase("raised") ? 0 : 1;
                border = string11 == null || string12 == null ? new SoftBevelBorder(n) : new SoftBevelBorder(n, JCSwingTypeConverter.toColor(string11), JCSwingTypeConverter.toColor(string12));
            }
        } else if (string2.equalsIgnoreCase("etched")) {
            String string13 = jCStringTokenizer.nextToken(c);
            String string14 = jCStringTokenizer.nextToken(c);
            String string15 = jCStringTokenizer.nextToken(c);
            if (string13 != null) {
                int n;
                int n4 = n = string13.equalsIgnoreCase("raised") ? 0 : 1;
                border = string14 == null || string15 == null ? new EtchedBorder(n) : new EtchedBorder(n, JCSwingTypeConverter.toColor(string14), JCSwingTypeConverter.toColor(string15));
            }
        } else if (string2.equalsIgnoreCase("matte")) {
            String string16 = jCStringTokenizer.nextToken(c);
            String string17 = jCStringTokenizer.nextToken(c);
            String string18 = jCStringTokenizer.nextToken(c);
            String string19 = jCStringTokenizer.nextToken(c);
            if (string16 == null || string17 == null || string18 == null || string19 == null) {
                return null;
            }
            String string20 = jCStringTokenizer.nextToken(c);
            border = BorderFactory.createMatteBorder((int)new Integer(string16), (int)new Integer(string17), (int)new Integer(string18), (int)new Integer(string19), JCSwingTypeConverter.toColor(string20));
        } else if (string2.equals("line")) {
            String string21 = jCStringTokenizer.nextToken(c);
            String string22 = jCStringTokenizer.nextToken(c);
            Color color = JCSwingTypeConverter.toColor(string21, Color.black);
            int n = string22 == null ? 1 : new Integer(string22);
            n = Math.max(n, 1);
            if (JCEnvironment.getJavaVersion() < 130) {
                border = new LineBorder(color, n);
            } else {
                String string23 = jCStringTokenizer.nextToken(c);
                boolean bl = JCTypeConverter.toBoolean(string23, false);
                border = new LineBorder(color, n, bl);
            }
        } else if (string2.equals("titled")) {
            String string24 = jCStringTokenizer.nextToken(c);
            String string25 = jCStringTokenizer.nextToken(c);
            String string26 = jCStringTokenizer.nextToken(c);
            String string27 = jCStringTokenizer.nextToken(c);
            String string28 = jCStringTokenizer.nextToken(c);
            if (string24 == null) {
                return null;
            }
            int n = JCTypeConverter.toEnum(string25, positionStrings, positionValues, 0);
            int n5 = JCTypeConverter.toEnum(string26, justificationStrings, justificationValues, 0);
            if (JCEnvironment.getJavaVersion() < 130 && n5 > 3) {
                n5 = 0;
            }
            Color color = JCSwingTypeConverter.toColor(string27);
            Font font = JCSwingTypeConverter.toFont(string28);
            border = BorderFactory.createTitledBorder(null, string24, n5, n, font, color);
        }
        return border;
    }

    public static String fromBorder(Border border, Component component) {
        if (border == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string = "|";
        if (border instanceof MatteBorder) {
            stringBuffer.append("matte");
        } else if (border instanceof EmptyBorder) {
            stringBuffer.append("empty");
        } else if (border instanceof SoftBevelBorder) {
            stringBuffer.append("softbevel");
        } else if (border instanceof BevelBorder) {
            stringBuffer.append("bevel");
        } else if (border instanceof EtchedBorder) {
            stringBuffer.append("etched");
        } else if (border instanceof LineBorder) {
            stringBuffer.append("line");
        } else if (border instanceof TitledBorder) {
            stringBuffer.append("titled");
        } else {
            return null;
        }
        stringBuffer.append(string);
        if (border instanceof MatteBorder) {
            MatteBorder matteBorder = (MatteBorder)border;
            stringBuffer.append(JCSwingTypeConverter.fromInsetsToIntList(matteBorder.getBorderInsets(component), string));
            stringBuffer.append(string);
            Color color = JCSwingTypeConverter.getMatteBorderColor(matteBorder, component);
            stringBuffer.append(JCSwingTypeConverter.fromColor(color));
        } else if (border instanceof EmptyBorder) {
            EmptyBorder emptyBorder = (EmptyBorder)border;
            stringBuffer.append(JCSwingTypeConverter.fromInsetsToIntList(emptyBorder.getBorderInsets(component), string));
        } else if (border instanceof BevelBorder) {
            BevelBorder bevelBorder = (BevelBorder)border;
            int n = bevelBorder.getBevelType();
            if (n == 0) {
                stringBuffer.append("raised");
            } else {
                stringBuffer.append("lowered");
            }
            Color color = bevelBorder.getHighlightInnerColor();
            Color color2 = bevelBorder.getShadowOuterColor();
            if (color != null || color2 != null) {
                String string2;
                stringBuffer.append(string);
                if (color == null) {
                    color = bevelBorder.getHighlightInnerColor(component);
                }
                stringBuffer.append((string2 = JCSwingTypeConverter.fromColor(color)) == null ? "" : string2);
                if (color2 == null) {
                    color2 = bevelBorder.getShadowOuterColor(component);
                }
                String string3 = JCSwingTypeConverter.fromColor(color2);
                stringBuffer.append(string);
                stringBuffer.append(string3 == null ? "" : string3);
            }
        } else if (border instanceof EtchedBorder) {
            EtchedBorder etchedBorder = (EtchedBorder)border;
            int n = etchedBorder.getEtchType();
            if (n == 0) {
                stringBuffer.append("raised");
            } else {
                stringBuffer.append("lowered");
            }
            stringBuffer.append(string);
            stringBuffer.append(JCSwingTypeConverter.fromColor(etchedBorder.getHighlightColor(component)));
            stringBuffer.append(string);
            stringBuffer.append(JCSwingTypeConverter.fromColor(etchedBorder.getShadowColor(component)));
        } else if (border instanceof LineBorder) {
            LineBorder lineBorder = (LineBorder)border;
            stringBuffer.append(JCSwingTypeConverter.fromColor(lineBorder.getLineColor()));
            stringBuffer.append(string);
            stringBuffer.append(lineBorder.getThickness());
            if (JCEnvironment.getJavaVersion() >= 130) {
                stringBuffer.append(string);
                stringBuffer.append("" + lineBorder.getRoundedCorners());
            }
        } else if (border instanceof TitledBorder) {
            TitledBorder titledBorder = (TitledBorder)border;
            stringBuffer.append(titledBorder.getTitle());
            stringBuffer.append(string);
            stringBuffer.append(JCTypeConverter.fromEnum(titledBorder.getTitlePosition(), positionStrings, positionValues));
            stringBuffer.append(string);
            stringBuffer.append(JCTypeConverter.fromEnum(titledBorder.getTitleJustification(), justificationStrings, justificationValues));
            stringBuffer.append(string);
            stringBuffer.append(JCSwingTypeConverter.fromColor(titledBorder.getTitleColor()));
            stringBuffer.append(string);
            stringBuffer.append(JCSwingTypeConverter.fromFont(titledBorder.getTitleFont()));
        }
        return stringBuffer.toString();
    }

    public static Color getMatteBorderColor(MatteBorder matteBorder, Component component) {
        Color color;
        Color color2 = color = component == null ? Color.black : component.getBackground();
        if (matteBorder == null) {
            return color;
        }
        Class<?> clazz = matteBorder.getClass();
        Method[] methodArray = clazz.getMethods();
        int n = 0;
        while (n < methodArray.length) {
            if (methodArray[n] != null && methodArray[n].getName().equals("getMatteColor")) {
                try {
                    color = (Color)methodArray[n].invoke((Object)matteBorder, null);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            ++n;
        }
        return color;
    }

    public static int getVerticalSwingConstantFromAWT(float f, int n) {
        if (f == 1.0f) {
            return 3;
        }
        if (f == 0.5f) {
            return 0;
        }
        if (f == 0.0f) {
            return 1;
        }
        return n;
    }

    public static int getHorizontalSwingConstantFromAWT(float f, int n) {
        if (f == 0.5f) {
            return 0;
        }
        if (f == 0.0f) {
            return 2;
        }
        if (f == 1.0f) {
            return 4;
        }
        return n;
    }

    public static float getVerticalAWTFromSwingConstant(int n, float f) {
        if (n == 3) {
            return 1.0f;
        }
        if (n == 0) {
            return 0.5f;
        }
        if (n == 1) {
            return 0.0f;
        }
        return f;
    }

    public static float getHorizontalAWTFromSwingConstant(int n, float f, boolean bl) {
        if (n == 0) {
            return 0.5f;
        }
        if (n == 2) {
            return 0.0f;
        }
        if (n == 4) {
            return 1.0f;
        }
        if (n == 11) {
            if (bl) {
                return 1.0f;
            }
            return 0.0f;
        }
        if (n == 10) {
            if (bl) {
                return 0.0f;
            }
            return 1.0f;
        }
        return f;
    }
}

