/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.swing;

import com.klg.jclass.util.swing.JCComparableRow;
import com.klg.jclass.util.swing.JCRowComparator;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Date;

public class DefaultRowComparator
implements JCRowComparator,
Serializable {
    public static final int FORWARD = 1;
    public static final int REVERSE = -1;
    protected int order = 1;
    protected int[] keyColumns = new int[]{0};

    public DefaultRowComparator(int n) {
        this.setSortOrder(n);
    }

    public DefaultRowComparator(int n, int[] nArray) {
        this.setSortOrder(n);
        this.setKeyColumns(nArray);
    }

    public void setKeyColumns(int[] nArray) {
        if (nArray == null || nArray.length == 0) {
            throw new IllegalArgumentException("KeyColumns must by non-null and non-empty");
        }
        this.keyColumns = nArray;
    }

    public int[] getKeyColumns() {
        return this.keyColumns;
    }

    public void setSortOrder(int n) {
        if (n != 1 && n != -1) {
            throw new IllegalArgumentException("SortOrder must be one of FORWARD or REVERSE");
        }
        this.order = n;
    }

    public int getSortOrder() {
        return this.order;
    }

    public int compare(JCComparableRow jCComparableRow, JCComparableRow jCComparableRow2) {
        int n = 0;
        int n2 = 0;
        while (n2 < this.keyColumns.length && n == 0) {
            Object object;
            Object object2 = jCComparableRow.getValueAt(this.keyColumns[n2]);
            if (object2 != (object = jCComparableRow2.getValueAt(this.keyColumns[n2]))) {
                int n3;
                if (object2 == null) {
                    n = -1;
                } else if (object == null) {
                    n = 1;
                } else if (object2 instanceof String && object instanceof String) {
                    n = ((String)object2).compareTo((String)object);
                } else if (object2 instanceof Boolean && object instanceof Boolean) {
                    int n4 = ((Boolean)object2).booleanValue();
                    n = n4 == (n3 = ((Boolean)object).booleanValue()) ? 0 : (n3 != 0 ? -1 : 1);
                } else if (object2 instanceof Date && object instanceof Date) {
                    long l;
                    long l2 = ((Date)object2).getTime();
                    n = l2 < (l = ((Date)object).getTime()) ? -1 : (l2 == l ? 0 : 1);
                } else if (object2 instanceof Float && object instanceof Float) {
                    float f;
                    float f2 = ((Float)object2).floatValue();
                    n = f2 < (f = ((Float)object).floatValue()) ? -1 : (f2 == f ? 0 : 1);
                } else if (object2 instanceof Double && object instanceof Double) {
                    double d;
                    double d2 = (Double)object2;
                    n = d2 < (d = ((Double)object).doubleValue()) ? -1 : (d2 == d ? 0 : 1);
                } else if (object2 instanceof Integer && object instanceof Integer) {
                    int n5 = (Integer)object2;
                    n = n5 < (n3 = ((Integer)object).intValue()) ? -1 : (n5 == n3 ? 0 : 1);
                } else if (object2 instanceof Long && object instanceof Long) {
                    long l;
                    long l3 = (Long)object2;
                    n = l3 < (l = ((Long)object).longValue()) ? -1 : (l3 == l ? 0 : 1);
                } else if (object2 instanceof BigInteger && object instanceof BigInteger) {
                    n = ((BigInteger)object2).compareTo((BigInteger)object);
                } else if (object2 instanceof Number && object instanceof Number) {
                    double d;
                    double d3 = ((Number)object2).doubleValue();
                    n = d3 < (d = ((Number)object).doubleValue()) ? -1 : (d3 == d ? 0 : 1);
                } else if (object2 instanceof Comparable && object instanceof Comparable) {
                    n = ((Comparable)object2).compareTo(object);
                }
            }
            ++n2;
        }
        return this.order * n;
    }
}

