/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.graphics;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.io.IOException;
import java.io.OutputStream;
import java.text.AttributedCharacterIterator;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class Graphics2DBase
extends Graphics2D
implements Cloneable {
    protected OutputStream os;
    protected boolean finished = false;
    protected Shape clip = new Rectangle2D.Double();
    protected boolean clipSet = false;
    protected AffineTransform transform = new AffineTransform();
    protected Point translation = new Point(0, 0);
    protected boolean underline = false;
    protected boolean subscript = false;
    protected Font currentFont;
    protected Color currentColor;
    protected Stroke currentStroke = new BasicStroke();
    protected boolean dashMode = false;
    protected int windingRule = 1;
    protected boolean fontChanged = true;
    protected boolean colorChanged = true;
    protected boolean strokeChanged = true;
    protected Hashtable loadedFonts = new Hashtable();
    protected Buffer out = new Buffer();
    protected int maxDecimalDigits = 4;
    protected DecimalFormat decimalFormat = new DecimalFormat();
    protected boolean isFrameGraphics = false;
    protected Graphics parent = null;
    protected static Map contextMap = new Hashtable();
    protected boolean isLive = true;

    public Graphics2DBase(OutputStream outputStream) {
        this.os = outputStream;
        this.setColor(new Color(0, 0, 0));
        DecimalFormatSymbols decimalFormatSymbols = this.decimalFormat.getDecimalFormatSymbols();
        decimalFormatSymbols.setDecimalSeparator('.');
        this.decimalFormat.setDecimalFormatSymbols(decimalFormatSymbols);
        this.decimalFormat.setDecimalSeparatorAlwaysShown(true);
        this.decimalFormat.setGroupingUsed(false);
    }

    public void draw3DRect(int n, int n2, int n3, int n4, boolean bl) {
        Paint paint = this.getPaint();
        Color color = this.getColor();
        Color color2 = color.brighter();
        Color color3 = color.darker();
        this.setColor(bl ? color2 : color3);
        this.fillRect(n, n2, 1, n4 + 1);
        this.fillRect(n + 1, n2, n3 - 1, 1);
        this.setColor(bl ? color3 : color2);
        this.fillRect(n + 1, n2 + n4, n3, 1);
        this.fillRect(n + n3, n2, 1, n4);
        this.setPaint(paint);
    }

    public void fill3DRect(int n, int n2, int n3, int n4, boolean bl) {
        Paint paint = this.getPaint();
        Color color = this.getColor();
        Color color2 = color.brighter();
        Color color3 = color.darker();
        if (!bl) {
            this.setColor(color3);
        } else if (paint != color) {
            this.setColor(color);
        }
        this.fillRect(n + 1, n2 + 1, n3 - 2, n4 - 2);
        this.setColor(bl ? color2 : color3);
        this.fillRect(n, n2, 1, n4);
        this.fillRect(n + 1, n2, n3 - 2, 1);
        this.setColor(bl ? color3 : color2);
        this.fillRect(n + 1, n2 + n4 - 1, n3 - 1, 1);
        this.fillRect(n + n3 - 1, n2, 1, n4 - 1);
        this.setPaint(paint);
    }

    public void draw(Shape shape) {
        if (shape instanceof GeneralPath || shape instanceof Line2D) {
            PathIterator pathIterator = shape.getPathIterator(new AffineTransform());
            this.drawLine(pathIterator);
        } else if (shape instanceof Rectangle2D) {
            this.drawRect((Rectangle2D)shape);
        } else if (shape instanceof RoundRectangle2D) {
            this.drawRoundRect((RoundRectangle2D)shape);
        } else if (shape instanceof Polygon) {
            this.drawPolygon((Polygon)shape);
        } else if (shape instanceof Arc2D) {
            this.drawArc((Arc2D)shape);
        } else if (shape instanceof Ellipse2D) {
            this.drawOval((Ellipse2D)shape);
        }
    }

    public void fill(Shape shape) {
        if (shape instanceof GeneralPath || shape instanceof Line2D) {
            this.fillShape(shape);
        } else if (shape instanceof Rectangle2D) {
            this.fillRect((Rectangle2D)shape);
        } else if (shape instanceof RoundRectangle2D) {
            this.fillRoundRect((RoundRectangle2D)shape);
        } else if (shape instanceof Polygon) {
            this.fillPolygon((Polygon)shape);
        } else if (shape instanceof Arc2D) {
            this.fillArc((Arc2D)shape);
        } else if (shape instanceof Ellipse2D) {
            this.fillOval((Ellipse2D)shape);
        }
    }

    public void fillShape(Shape shape) {
        PathIterator pathIterator = shape.getPathIterator(new AffineTransform());
        double d = Double.MAX_VALUE;
        double d2 = Double.MAX_VALUE;
        Polygon polygon = new Polygon();
        while (!pathIterator.isDone()) {
            float[] fArray = new float[6];
            switch (pathIterator.currentSegment(fArray)) {
                case 0: {
                    polygon.addPoint((int)fArray[0], (int)fArray[1]);
                    d = fArray[0];
                    d2 = fArray[1];
                    break;
                }
                case 1: {
                    polygon.addPoint((int)fArray[0], (int)fArray[1]);
                    break;
                }
                case 3: {
                    polygon.addPoint((int)fArray[4], (int)fArray[5]);
                    break;
                }
                case 2: {
                    polygon.addPoint((int)fArray[2], (int)fArray[3]);
                    break;
                }
                case 4: {
                    if (d == Double.MAX_VALUE || d2 == Double.MAX_VALUE) break;
                    polygon.addPoint((int)d, (int)d2);
                    break;
                }
            }
            pathIterator.next();
        }
        this.windingRule = ((GeneralPath)shape).getWindingRule();
        this.fillPolygon(polygon);
    }

    public boolean drawImage(Image image, AffineTransform affineTransform, ImageObserver imageObserver) {
        return true;
    }

    public void drawImage(BufferedImage bufferedImage, BufferedImageOp bufferedImageOp, int n, int n2) {
    }

    public void drawRenderedImage(RenderedImage renderedImage, AffineTransform affineTransform) {
    }

    public void drawRenderableImage(RenderableImage renderableImage, AffineTransform affineTransform) {
    }

    public void drawString(AttributedCharacterIterator attributedCharacterIterator, int n, int n2) {
        this.drawString(attributedCharacterIterator, (float)n, (float)n2);
    }

    public void drawString(AttributedCharacterIterator attributedCharacterIterator, float f, float f2) {
        this.doString(attributedCharacterIterator, f, f2);
    }

    public void drawGlyphVector(GlyphVector glyphVector, float f, float f2) {
        this.fill(glyphVector.getOutline(f, f2));
    }

    public boolean hit(Rectangle rectangle, Shape shape, boolean bl) {
        return true;
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        return null;
    }

    public void setComposite(Composite composite) {
    }

    public void setPaint(Paint paint) {
        if (paint instanceof Color) {
            this.setColor((Color)paint);
        } else if (paint instanceof GradientPaint) {
            this.setColor(((GradientPaint)paint).getColor1());
        }
    }

    public void setStroke(Stroke stroke) {
        if (!this.currentStroke.equals(stroke)) {
            this.currentStroke = stroke;
            this.strokeChanged = true;
        }
    }

    public void setRenderingHint(RenderingHints.Key key, Object object) {
    }

    public Object getRenderingHint(RenderingHints.Key key) {
        return null;
    }

    public void setRenderingHints(Map map) {
    }

    public void addRenderingHints(Map map) {
    }

    public RenderingHints getRenderingHints() {
        return null;
    }

    public void translate(int n, int n2) {
    }

    public void translate(double d, double d2) {
    }

    public void rotate(double d) {
    }

    public void rotate(double d, double d2, double d3) {
    }

    public void scale(double d, double d2) {
    }

    public void shear(double d, double d2) {
    }

    public void transform(AffineTransform affineTransform) {
    }

    public void setTransform(AffineTransform affineTransform) {
        this.transform = affineTransform;
    }

    public AffineTransform getTransform() {
        return this.transform;
    }

    public AffineTransform getCumulativeTransform() {
        AffineTransform affineTransform = null;
        Graphics2DBase graphics2DBase = this;
        while (graphics2DBase != null) {
            if (graphics2DBase.isFrameGraphics) {
                if (affineTransform == null) {
                    affineTransform = (AffineTransform)graphics2DBase.getTransform().clone();
                } else {
                    affineTransform.preConcatenate(graphics2DBase.getTransform());
                }
            }
            graphics2DBase = (Graphics2DBase)graphics2DBase.parent;
        }
        return affineTransform;
    }

    public Paint getPaint() {
        return this.getColor();
    }

    public Composite getComposite() {
        return null;
    }

    public void setBackground(Color color) {
    }

    public Color getBackground() {
        return null;
    }

    public Stroke getStroke() {
        return this.currentStroke;
    }

    public void clip(Shape shape) {
    }

    public FontRenderContext getFontRenderContext() {
        return new FontRenderContext(new AffineTransform(), false, false);
    }

    public void drawRect(int n, int n2, int n3, int n4) {
        this.draw(new Rectangle2D.Double(n, n2, n3, n4));
    }

    public void fillRect(int n, int n2, int n3, int n4) {
        this.fill(new Rectangle2D.Double(n, n2, n3, n4));
    }

    public void fillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.fill(new RoundRectangle2D.Double(n, n2, n3, n4, n5, n6));
    }

    public void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.draw(new RoundRectangle2D.Double(n, n2, n3, n4, n5, n6));
    }

    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.draw(new Arc2D.Double(n, n2, n3, n4, n5, n6, 2));
    }

    public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.fill(new Arc2D.Double(n, n2, n3, n4, n5, n6, 2));
    }

    public Graphics create() {
        Graphics2DBase graphics2DBase;
        try {
            graphics2DBase = (Graphics2DBase)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
        graphics2DBase.transform = this.isFrameGraphics ? new AffineTransform() : new AffineTransform(this.transform);
        graphics2DBase.clip = this.clip instanceof GeneralPath ? (Shape)((GeneralPath)this.clip).clone() : (this.clip instanceof Rectangle2D ? (Shape)((Rectangle2D)this.clip).clone() : this.clip);
        graphics2DBase.fontChanged = true;
        graphics2DBase.colorChanged = true;
        graphics2DBase.strokeChanged = true;
        graphics2DBase.parent = this;
        graphics2DBase.isFrameGraphics = false;
        return graphics2DBase;
    }

    public Graphics create(int n, int n2, int n3, int n4) {
        Graphics graphics = this.create();
        graphics.translate(n, n2);
        graphics.clipRect(0, 0, n3, n4);
        return graphics;
    }

    public Color getColor() {
        return this.currentColor;
    }

    public void setColor(Color color) {
        if (color == null || !color.equals(this.currentColor)) {
            this.currentColor = color;
            this.colorChanged = true;
        }
    }

    public void setPaintMode() {
    }

    public void setXORMode(Color color) {
    }

    public Font getFont() {
        if (this.currentFont == null) {
            this.currentFont = Font.decode("TimesRoman-12");
            this.setFont(this.currentFont);
        }
        return this.currentFont;
    }

    public FontMetrics getFontMetrics() {
        return this.getFontMetrics(this.getFont());
    }

    public Rectangle getClipBounds() {
        return this.clip.getBounds();
    }

    public void clipRect(int n, int n2, int n3, int n4) {
    }

    public Shape getClip() {
        return this.clip;
    }

    public void setClip(int n, int n2, int n3, int n4) {
        this.setClip(new Rectangle2D.Double(n, n2, n3, n4));
    }

    public void setClip(Shape shape) {
        if (!(shape instanceof Rectangle2D)) {
            throw new IllegalArgumentException("setClip:  only Rectangles are supported");
        }
        Rectangle2D rectangle2D = (Rectangle2D)shape;
        this.setClipPW(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
    }

    public void clearRect(int n, int n2, int n3, int n4) {
    }

    public void drawOval(int n, int n2, int n3, int n4) {
        this.draw(new Arc2D.Double(n, n2, n3, n4, 0.0, 360.0, 1));
    }

    protected void drawOval(Ellipse2D ellipse2D) {
        this.draw(new Arc2D.Double(ellipse2D.getX(), ellipse2D.getY(), ellipse2D.getWidth(), ellipse2D.getHeight(), 0.0, 360.0, 1));
    }

    public void fillOval(int n, int n2, int n3, int n4) {
        this.fill(new Arc2D.Double(n, n2, n3, n4, 0.0, 360.0, 1));
    }

    protected void fillOval(Ellipse2D ellipse2D) {
        this.fill(new Arc2D.Double(ellipse2D.getX(), ellipse2D.getY(), ellipse2D.getWidth(), ellipse2D.getHeight(), 0.0, 360.0, 1));
    }

    public void drawPolygon(Polygon polygon) {
        this.drawPolygon(polygon.xpoints, polygon.ypoints, polygon.npoints);
    }

    public void fillPolygon(Polygon polygon) {
        this.fillPolygon(polygon.xpoints, polygon.ypoints, polygon.npoints);
    }

    public void drawChars(char[] cArray, int n, int n2, int n3, int n4) {
        this.drawString(new String(cArray, n, n2), n3, n4);
    }

    public void drawBytes(byte[] byArray, int n, int n2, int n3, int n4) {
        this.drawString(new String(byArray, n, n2), n3, n4);
    }

    public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, image.getWidth(imageObserver), image.getHeight(imageObserver), null, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, n3, n4, null, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, Color color, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, image.getWidth(imageObserver), image.getHeight(imageObserver), color, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver) {
        return true;
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
        return true;
    }

    public void dispose() {
        Graphics graphics = null;
        Graphics graphics2 = null;
        if (!this.isLive) {
            return;
        }
        Graphics graphics3 = this.getPageRoot();
        Graphics graphics4 = this.getFrameRoot();
        if (contextMap.containsKey(graphics3)) {
            graphics = (Graphics)contextMap.get(graphics3);
        }
        if (graphics == graphics4) {
            if (graphics3 != graphics && contextMap.containsKey(graphics)) {
                graphics2 = (Graphics)contextMap.get(graphics);
            }
            if (this == graphics) {
                if (graphics2 != null && graphics2 != graphics4) {
                    ((Graphics2DBase)graphics2).endContext();
                }
                this.endContext();
                this.removeContext(graphics);
                if (this != graphics3) {
                    contextMap.put(graphics3, this.parent);
                }
            } else if (graphics2 == this) {
                this.endContext();
                contextMap.put(graphics4, graphics4);
            }
        }
        this.isLive = false;
    }

    private void removeContext(Graphics graphics) {
        Graphics graphics2;
        if (contextMap.containsKey(graphics) && (graphics2 = (Graphics)contextMap.get(graphics)) != null && graphics2 != graphics) {
            this.removeContext(graphics2);
        }
        contextMap.remove(graphics);
    }

    public void finalize() {
        this.dispose();
    }

    public String toString() {
        return this.getClass().getName() + "[font=" + this.getFont() + ",color=" + this.getColor() + "]";
    }

    public boolean hitClip(int n, int n2, int n3, int n4) {
        return true;
    }

    public Rectangle getClipBounds(Rectangle rectangle) {
        Rectangle2D rectangle2D = this.clip.getBounds2D();
        rectangle.x = (int)rectangle2D.getX();
        rectangle.y = (int)rectangle2D.getY();
        rectangle.width = (int)rectangle2D.getWidth();
        rectangle.height = (int)rectangle2D.getHeight();
        return rectangle;
    }

    public void drawString(String string, int n, int n2) {
        this.drawString(string, (float)n, (float)n2);
    }

    public void drawLine(int n, int n2, int n3, int n4) {
        this.draw(new Line2D.Double(n, n2, n3, n4));
    }

    protected void initializeOutString(float f, float f2) {
        this.out.x = f;
        this.out.y = f2;
        this.out.text.delete(0, this.out.text.length());
    }

    protected void output(String string) throws IOException {
        if (this.finished) {
            return;
        }
        this.os.write(string.getBytes());
        this.os.write(10);
    }

    protected void drawLine(PathIterator pathIterator) {
        Point2D.Double double_ = new Point2D.Double();
        while (!pathIterator.isDone()) {
            float[] fArray = new float[6];
            switch (pathIterator.currentSegment(fArray)) {
                case 0: {
                    double_.setLocation(fArray[0], fArray[1]);
                    break;
                }
                case 1: {
                    this.drawLinePW(double_.getX(), double_.getY(), fArray[0], fArray[1]);
                    double_.setLocation(fArray[0], fArray[1]);
                    break;
                }
                case 3: {
                    break;
                }
                case 2: {
                    this.drawQuadraticPW(double_.getX(), double_.getY(), fArray[0], fArray[1], fArray[2], fArray[3]);
                    double_.setLocation(fArray[2], fArray[3]);
                }
            }
            pathIterator.next();
        }
    }

    protected void drawRect(Rectangle2D rectangle2D) {
        this.drawRectPW(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    protected void drawArc(Arc2D arc2D) {
        this.drawArcPW(arc2D.getX(), arc2D.getY(), arc2D.getWidth(), arc2D.getHeight(), arc2D.getAngleStart(), arc2D.getAngleExtent(), arc2D.getArcType());
    }

    protected void drawRoundRect(RoundRectangle2D roundRectangle2D) {
        this.drawRoundRectPW(roundRectangle2D.getX(), roundRectangle2D.getY(), roundRectangle2D.getWidth(), roundRectangle2D.getHeight(), roundRectangle2D.getArcWidth(), roundRectangle2D.getArcHeight());
    }

    protected void fillArc(Arc2D arc2D) {
        this.fillArcPW(arc2D.getX(), arc2D.getY(), arc2D.getWidth(), arc2D.getHeight(), arc2D.getAngleStart(), arc2D.getAngleExtent(), arc2D.getArcType());
    }

    protected void fillRect(Rectangle2D rectangle2D) {
        this.fillRectPW(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    protected void fillRoundRect(RoundRectangle2D roundRectangle2D) {
        this.fillRoundRectPW(roundRectangle2D.getX(), roundRectangle2D.getY(), roundRectangle2D.getWidth(), roundRectangle2D.getHeight(), roundRectangle2D.getArcWidth(), roundRectangle2D.getArcHeight());
    }

    protected void doAttributes(AttributedCharacterIterator attributedCharacterIterator) {
        this.underline = false;
        this.subscript = false;
        Set<AttributedCharacterIterator.Attribute> set = attributedCharacterIterator.getAttributes().keySet();
        Iterator<AttributedCharacterIterator.Attribute> iterator = set.iterator();
        while (iterator.hasNext()) {
            Object object;
            TextAttribute textAttribute = (TextAttribute)iterator.next();
            if (textAttribute.equals(TextAttribute.FONT)) {
                object = (Font)attributedCharacterIterator.getAttributes().get(textAttribute);
                this.setFont((Font)object);
                continue;
            }
            if (textAttribute.equals(TextAttribute.UNDERLINE)) {
                object = attributedCharacterIterator.getAttributes().get(textAttribute);
                if (object != TextAttribute.UNDERLINE_ON) continue;
                this.underline = true;
                continue;
            }
            if (textAttribute.equals(TextAttribute.SUPERSCRIPT)) {
                object = attributedCharacterIterator.getAttributes().get(textAttribute);
                if (object == TextAttribute.SUPERSCRIPT_SUPER) {
                    // empty if block
                }
                this.subscript = true;
                continue;
            }
            if (textAttribute.equals(TextAttribute.SIZE)) {
                object = attributedCharacterIterator.getAttributes().get(textAttribute);
                Font font = null;
                if (object instanceof Integer) {
                    int n = (Integer)object;
                    font = this.getFont().deriveFont(this.getFont().getStyle(), n);
                } else if (object instanceof Float) {
                    float f = ((Float)object).floatValue();
                    font = this.getFont().deriveFont(this.getFont().getStyle(), f);
                } else {
                    System.out.println("Unknown type for attribute SIZE");
                    return;
                }
                this.setFont(font);
                continue;
            }
            object = "only FONT/SIZE/UNDERLINE/SUPERSCRIPT supported";
            throw new RuntimeException((String)object);
        }
    }

    protected void doString(AttributedCharacterIterator attributedCharacterIterator, float f, float f2) {
        StringBuffer stringBuffer = new StringBuffer(attributedCharacterIterator.getEndIndex());
        char c = attributedCharacterIterator.first();
        while (c != '\uffff') {
            if (attributedCharacterIterator.getIndex() == attributedCharacterIterator.getRunStart()) {
                if (stringBuffer.length() > 0) {
                    this.drawString(stringBuffer.toString(), f, f2);
                    FontMetrics fontMetrics = this.getFontMetrics();
                    f = (float)((double)f + fontMetrics.getStringBounds(stringBuffer.toString(), this).getWidth());
                    stringBuffer.delete(0, stringBuffer.length());
                }
                this.doAttributes(attributedCharacterIterator);
            }
            stringBuffer.append(c);
            c = attributedCharacterIterator.next();
        }
        this.drawString(stringBuffer.toString(), f, f2);
        this.underline = false;
        this.subscript = false;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.os = outputStream;
    }

    public OutputStream getOutputStream() {
        return this.os;
    }

    public void setMaxDecimalDigits(int n) {
        this.maxDecimalDigits = n;
    }

    public int getMaxDecimalDigits() {
        return this.maxDecimalDigits;
    }

    public double truncateDecimalDigits(double d) {
        this.decimalFormat.setMaximumFractionDigits(this.maxDecimalDigits);
        double d2 = Double.valueOf(this.decimalFormat.format(d));
        if (d2 == -0.0) {
            d2 = 0.0;
        }
        return d2;
    }

    public double truncateDecimalDigits(float f) {
        this.decimalFormat.setMaximumFractionDigits(this.maxDecimalDigits);
        double d = Double.valueOf(this.decimalFormat.format(f));
        return d;
    }

    protected void setWindingRule(int n) {
        this.windingRule = n;
    }

    protected int getWindingRule() {
        return this.windingRule;
    }

    protected Graphics getPageRoot() {
        if (this.parent == null) {
            return this;
        }
        return ((Graphics2DBase)this.parent).getPageRoot();
    }

    protected Graphics getFrameRoot() {
        if (this.isFrameGraphics) {
            return this;
        }
        if (this.parent == null) {
            throw new IllegalArgumentException("no frame root for graphics");
        }
        return ((Graphics2DBase)this.parent).getFrameRoot();
    }

    public void setFrameRoot() {
        this.isFrameGraphics = true;
    }

    public boolean isFrameRoot() {
        return this.isFrameGraphics;
    }

    protected boolean isContextCurrent() {
        Graphics graphics = this.getPageRoot();
        Graphics graphics2 = this.getFrameRoot();
        if (!contextMap.containsKey(graphics)) {
            return false;
        }
        if (!contextMap.containsKey(graphics2)) {
            return false;
        }
        Graphics graphics3 = (Graphics)contextMap.get(graphics2);
        Graphics graphics4 = (Graphics)contextMap.get(graphics);
        return graphics3 == this && graphics4 == graphics2;
    }

    protected void updateContext() {
        Graphics graphics = null;
        Graphics graphics2 = null;
        Graphics graphics3 = this.getPageRoot();
        Graphics graphics4 = this.getFrameRoot();
        if (contextMap.containsKey(graphics3) && graphics3 != (graphics = (Graphics)contextMap.get(graphics3)) && contextMap.containsKey(graphics)) {
            graphics2 = (Graphics)contextMap.get(graphics);
        }
        if (this == graphics2 && graphics4 == graphics) {
            return;
        }
        if (graphics == null) {
            contextMap.put(graphics3, graphics4);
            if (this != graphics4) {
                ((Graphics2DBase)graphics4).startContext();
            }
        } else if (graphics4 == graphics) {
            if (graphics2 != graphics && graphics2 != null) {
                ((Graphics2DBase)graphics2).endContext();
            }
        } else {
            if (graphics != graphics3) {
                Graphics[] graphicsArray = ((Graphics2DBase)graphics4).buildParentArray();
                Graphics[] graphicsArray2 = ((Graphics2DBase)graphics).buildParentArray();
                int n = 0;
                while (n < graphicsArray.length && n < graphicsArray2.length && graphicsArray[n] == graphicsArray2[n]) {
                    ++n;
                }
                --n;
                if (graphics2 != graphics && graphics2 != null) {
                    ((Graphics2DBase)graphics2).endContext();
                }
                int n2 = graphicsArray2.length - 1;
                while (n2 > n) {
                    ((Graphics2DBase)graphicsArray2[n2]).endContext();
                    --n2;
                }
                int n3 = n + 1;
                while (n3 < graphicsArray.length - 1) {
                    ((Graphics2DBase)graphicsArray[n3]).startContext();
                    ++n3;
                }
            }
            contextMap.put(graphics3, graphics4);
        }
        contextMap.put(graphics4, this);
        this.startContext();
        this.colorChanged = true;
        this.fontChanged = true;
        this.strokeChanged = true;
    }

    protected Graphics[] buildParentArray() {
        return this.buildParentArray(1);
    }

    protected Graphics[] buildParentArray(int n) {
        Graphics[] graphicsArray;
        if (this.parent != null) {
            graphicsArray = ((Graphics2DBase)this.parent).buildParentArray(n + 1);
            graphicsArray[graphicsArray.length - n] = this;
        } else {
            graphicsArray = new Graphics[n];
            graphicsArray[0] = this;
        }
        return graphicsArray;
    }

    public boolean isFinishedOutput() {
        return this.finished;
    }

    public void setFinishedOutput(boolean bl) {
        this.finished = bl;
    }

    public abstract Graphics newGraphics();

    public abstract void setClipPW(double var1, double var3, double var5, double var7);

    public abstract void drawLinePW(double var1, double var3, double var5, double var7);

    public void drawQuadraticPW(double d, double d2, double d3, double d4, double d5, double d6) {
        this.drawLinePW(d, d2, d5, d6);
    }

    public abstract void drawRectPW(double var1, double var3, double var5, double var7);

    public abstract void fillRectPW(double var1, double var3, double var5, double var7);

    public abstract void drawRoundRectPW(double var1, double var3, double var5, double var7, double var9, double var11);

    public abstract void fillRoundRectPW(double var1, double var3, double var5, double var7, double var9, double var11);

    public abstract void fillArcPW(double var1, double var3, double var5, double var7, double var9, double var11, int var13);

    public abstract void drawArcPW(double var1, double var3, double var5, double var7, double var9, double var11, int var13);

    public abstract void startContext();

    public abstract void endContext();

    protected class Buffer {
        public StringBuffer text = new StringBuffer();
        public int size;
        public double width;
        public double x;
        public double y;

        protected Buffer() {
        }
    }
}

