/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.formulae;

import com.klg.jclass.util.formulae.Expression;
import com.klg.jclass.util.formulae.ExpressionList;
import com.klg.jclass.util.formulae.ExpressionReference;
import com.klg.jclass.util.formulae.MathMatrix;
import com.klg.jclass.util.formulae.MathScalar;
import com.klg.jclass.util.formulae.MathValue;
import com.klg.jclass.util.formulae.MathVector;
import com.klg.jclass.util.formulae.Operation;
import com.klg.jclass.util.formulae.Result;
import java.util.Iterator;

public class Min
extends Operation {
    public Min(Expression expression) {
        super(expression);
    }

    public Min(Expression expression, Expression expression2) {
        super(expression, expression2);
    }

    public Min(Expression expression, Number number) {
        super(expression, number);
    }

    public Min(Number number, Expression expression) {
        super(number, expression);
    }

    public Min(Number number, Number number2) {
        super(number, number2);
    }

    public Result evaluate() {
        if (this.leftOperand == null && this.rightOperand == null) {
            throw new IllegalArgumentException("Min is not defined on zero operands");
        }
        MathValue mathValue = null;
        MathValue mathValue2 = null;
        if (this.leftOperand != null) {
            mathValue = this.evaluateOperand(this.leftOperand);
        }
        if (this.rightOperand != null) {
            mathValue2 = this.evaluateOperand(this.rightOperand);
        }
        if (this.leftOperand == null) {
            return mathValue2;
        }
        if (this.rightOperand == null) {
            return mathValue;
        }
        return this.doMin(mathValue, mathValue2);
    }

    private MathValue evaluateOperand(Expression expression) {
        if (expression instanceof MathValue) {
            return (MathValue)expression;
        }
        if (expression instanceof Operation || expression instanceof ExpressionReference) {
            return this.evaluateOperand(expression.evaluate());
        }
        if (expression instanceof ExpressionList) {
            MathValue mathValue = null;
            Iterator iterator = ((ExpressionList)expression).iterator();
            while (iterator.hasNext()) {
                MathValue mathValue2 = this.evaluateOperand((Expression)iterator.next());
                mathValue = mathValue == null ? mathValue2 : this.doMin(mathValue, mathValue2);
            }
            return mathValue;
        }
        throw new IllegalArgumentException("Unrecognized operand type to Min");
    }

    private MathValue doMin(MathValue mathValue, MathValue mathValue2) {
        if (mathValue instanceof MathVector || mathValue instanceof MathMatrix || mathValue2 instanceof MathVector || mathValue2 instanceof MathMatrix) {
            throw new IllegalArgumentException("Cannot determine min of a vector or matrix.");
        }
        MathScalar mathScalar = (MathScalar)mathValue;
        MathScalar mathScalar2 = (MathScalar)mathValue2;
        Number number = this.minSimple(mathScalar.realValue, mathScalar2.realValue);
        return new MathScalar(number);
    }

    private Number minSimple(Number number, Number number2) {
        if (number instanceof Double || number2 instanceof Double) {
            return new Double(Math.min(number.doubleValue(), number2.doubleValue()));
        }
        return new Integer(Math.min(number.intValue(), number2.intValue()));
    }
}

